/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.state.server;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.datamodel.custom.CustomScript;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.logic.ejb.dataIn.event.EventFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.event.history.IHistoryEntity;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocal;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationParameterNotFoundException;
import de.proveo.wwt.logic.ejb.general.custom.CustomScriptFacadeLocal;
import de.proveo.wwt.logic.ejb.general.custom.ScriptLoader;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import de.proveo.wwt.logic.ejb.state.CurrentStateFacadeLocal;
import de.proveo.wwt.logic.ejb.state.server.GeneratedStateEvent;
import de.proveo.wwt.logic.ejb.state.server.ServerDrivenStateModel;
import de.proveo.wwt.logic.ejb.state.server.ServerDrivenStateModelLocal;
import de.proveo.wwt.logic.ejb.state.server.ServerDrivenStateModelRemote;
import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import javax.annotation.Resource;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RunAs;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.PoolClass;
import org.jboss.annotation.ejb.TransactionTimeout;
import org.jboss.ejb3.StrictMaxPool;

@Stateless(name="ServerDrivenStateModel")
@Remote(value={ServerDrivenStateModelRemote.class})
@Local(value={ServerDrivenStateModelLocal.class})
@JndiLocalBinding(localJndiBinding="rts/ServerDrivenStateModel")
@JndiRemoteBinding(remoteJndiBinding="rts/ServerDrivenStateModel")
@RunAs(value="nobody")
@PoolClass(value=StrictMaxPool.class, maxSize=30, timeout=10000L)
public class ServerDrivenStateModelBean
implements ServerDrivenStateModelLocal,
ServerDrivenStateModelRemote,
TimedObject {
    private static final Log log = LogFactory.getLog(ServerDrivenStateModelBean.class);
    private static final ScriptLoader<ServerDrivenStateModel> stateModelScriptLoader = new ScriptLoader();
    private static final String SERVER_DRIVEN_STATE_MODEL_ENTRY_POINT = "server.statemodel";
    @Resource
    SessionContext sessionContext;
    @EJB
    EventFacadeLocal eventFacade;
    @EJB
    CustomScriptFacadeLocal customScript;
    @EJB
    CurrentStateFacadeLocal currentStateFacade;
    @EJB
    UnitFacadeLocal unitFacade;
    @EJB
    ConfigurationLocal configuration;
    private boolean featureEnabled;

    @Override
    @Business(viewType="both")
    public void initialize() throws ConfigurationParameterNotFoundException {
        this.featureEnabled = this.configuration.getBoolean("server.statemodels");
        if (this.featureEnabled) {
            long interval = this.configuration.getLong("server.statemodels.update.interval");
            TimerService timerService = this.sessionContext.getTimerService();
            timerService.createTimer(0L, interval, (Serializable)((Object)"ServerDrivenStateModelTimerTrigger"));
        }
    }

    @Override
    @Business(viewType="local")
    public void onMessage(Message msg) {
        if (!this.featureEnabled) {
            return;
        }
        try {
            Serializable obj = ((ObjectMessage)msg).getObject();
            SerializableEventWrapper wrapper = (SerializableEventWrapper)obj;
            IHistoryEntity history = (IHistoryEntity)wrapper.get_historyValue();
            if (log.isTraceEnabled()) {
                log.trace((Object)("onMessage() " + history.getClass().getName() + " unitId:" + history.getUnitId() + " beginTime:" + history.getBeginTime() + " historyId:" + history.getHistoryId()));
            }
            List<CustomScript> scripts = this.getActiveScriptsByEntryPointAndUnit(SERVER_DRIVEN_STATE_MODEL_ENTRY_POINT, history.getUnitId());
            for (CustomScript script : scripts) {
                try {
                    ServerDrivenStateModel stateModel = stateModelScriptLoader.loadScript(script);
                    GeneratedStateEvent newStateEvent = stateModel.onMessage(wrapper, this.currentStateFacade);
                    if (newStateEvent == null) continue;
                    this.checkTimestampOfGeneratedEvent(history.getUnitId(), newStateEvent, history.getBeginTime());
                    this.createAndSendStateEvent(history.getUnitId(), newStateEvent.timestamp, stateModel, newStateEvent.newStateId);
                }
                catch (Exception ex) {
                    if (!log.isErrorEnabled()) continue;
                    log.error((Object)("runs for " + script + " into"), (Throwable)ex);
                }
            }
        }
        catch (JMSException ex) {
            log.error((Object)"runs into", (Throwable)ex);
        }
    }

    @PermitAll
    @TransactionTimeout(value=1200)
    public void ejbTimeout(Timer timer) {
        log.trace((Object)"ejbTimeout()");
        try {
            this.onTimeTrigger();
        }
        catch (RuntimeException ex) {
            log.error((Object)"ejbTimeout() runs into", (Throwable)ex);
            throw ex;
        }
    }

    protected void onTimeTrigger() {
        List<UnitModel> basicUnits = this.unitFacade.findyByIsBasic(true);
        for (UnitModel basicUnit : basicUnits) {
            List<CustomScript> scripts = this.getActiveScriptsByEntryPointAndUnit(SERVER_DRIVEN_STATE_MODEL_ENTRY_POINT, basicUnit.getUnitId());
            if (scripts.isEmpty()) continue;
            long lastEventTimestamp = this.unitFacade.getLastEventTimestamp(basicUnit.getUnitId());
            if (log.isTraceEnabled()) {
                log.trace((Object)("onTimeTrigger() unitId:" + basicUnit.getUnitId() + " lastEventTimestamp:" + lastEventTimestamp));
            }
            if (lastEventTimestamp >= 0L) {
                for (CustomScript script : scripts) {
                    try {
                        ServerDrivenStateModel stateModel = stateModelScriptLoader.loadScript(script);
                        GeneratedStateEvent newStateEvent = stateModel.onTimeTrigger(basicUnit.getUnitId(), lastEventTimestamp, this.currentStateFacade);
                        if (newStateEvent == null) continue;
                        this.checkTimestampOfGeneratedEvent(basicUnit.getUnitId(), newStateEvent, lastEventTimestamp);
                        this.createAndSendStateEvent(basicUnit.getUnitId(), newStateEvent.timestamp, stateModel, newStateEvent.newStateId);
                    }
                    catch (Exception ex) {
                        if (!log.isErrorEnabled()) continue;
                        log.error((Object)("runs for " + script + " unitId: " + basicUnit.getUnitId() + " lastEventTimestamp: " + lastEventTimestamp + " into"), (Throwable)ex);
                    }
                }
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("no events received from unitId:" + basicUnit.getUnitId()));
        }
    }

    protected void checkTimestampOfGeneratedEvent(long unitId, GeneratedStateEvent newStateEvent, long lastEventTimestamp) {
        if (newStateEvent.timestamp > lastEventTimestamp) {
            throw new IllegalArgumentException("predictions about the future are not allowed. unitId: " + unitId + " timestamp: " + newStateEvent.timestamp + ", lastEventTimestamp: " + lastEventTimestamp);
        }
    }

    protected List<CustomScript> getActiveScriptsByEntryPointAndUnit(String entryPoint, long unitId) {
        List<CustomScript> scripts = this.customScript.getActiveScriptsByEntryPointAndUnit(entryPoint, unitId);
        if (log.isTraceEnabled()) {
            log.trace((Object)("getActiveScriptsByEntryPointAndUnit() unitId:" + unitId + " scripts:" + scripts.size()));
        }
        return scripts;
    }

    protected void createAndSendStateEvent(long unitId, long timestamp, ServerDrivenStateModel stateModel, Integer newStateId) {
        Properties event = new Properties();
        event.setProperty("t", Long.toString(timestamp));
        event.setProperty("u", Long.toString(unitId));
        event.setProperty("m", Integer.toString(stateModel.getStateModelId()));
        event.setProperty("s", newStateId.toString());
        this.eventFacade.handleEvent(event);
    }
}

