/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.state;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.util.jpa.dao.QueryType;
import de.proveo.wwt.datamodel.state.StateCache;
import de.proveo.wwt.datamodel.state.StateHistory;
import de.proveo.wwt.logic.ejb.dataOut.raw.StateStamp;
import de.proveo.wwt.logic.ejb.state.CurrentStateCacheDAO;
import de.proveo.wwt.logic.ejb.state.StateHistoryDAO;
import de.proveo.wwt.logic.ejb.state.StateOutFacadeLocal;
import de.proveo.wwt.logic.ejb.state.StateOutFacadeRemote;
import de.proveo.wwt.logic.ejb.state.exception.NoStateFoundException;
import de.proveo.wwt.logic.web.data.enumerations.ExtendedDTOData;
import de.proveo.wwt.logic.web.data.fastlanereader.base.FastLaneBase;
import de.proveo.wwt.logic.web.data.fastlanereader.report.StateFastLaneReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.PoolClass;
import org.jboss.ejb3.StrictMaxPool;

@Stateless(name="StateOutFacade")
@Remote(value={StateOutFacadeRemote.class})
@Local(value={StateOutFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/StateOutFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/StateOutFacade")
@PoolClass(value=StrictMaxPool.class, maxSize=100, timeout=10000L)
public class StateOutFacadeBean
implements StateOutFacadeLocal,
StateOutFacadeRemote {
    private static final Log log = LogFactory.getLog(StateOutFacadeBean.class);
    @PersistenceContext(unitName="rts")
    private EntityManager entityManager = null;
    private CurrentStateCacheDAO currentStateCacheDAO = null;
    private StateHistoryDAO stateHistoryDAO = null;

    @PostConstruct
    private void initImpl() {
        this.currentStateCacheDAO = CurrentStateCacheDAO.newInstance(this.entityManager);
        this.stateHistoryDAO = StateHistoryDAO.newInstance(this.entityManager);
    }

    @Override
    @Business(viewType="both")
    public Set<StateStamp> getUnitEvents(long basicUnitId, long requestedBeginTime, long requestedEndTime) throws NoStateFoundException {
        HashSet<StateStamp> allStamps = new StateFastLaneReader().getRawStateHistory(basicUnitId, null, null, requestedBeginTime, requestedEndTime, false, new ExtendedDTOData[0]);
        if (allStamps.size() < 1) {
            log.debug((Object)("nothing found in cache and history for unit '" + basicUnitId + "'."));
        }
        return allStamps;
    }

    @Override
    @Business(viewType="both")
    public Set<StateStamp> getUnitEvents(long basicUnitId, int stateModelId, long requestedBeginTime, long requestedEndTime) throws NoStateFoundException {
        String sMethodName = "getUnitEvents()";
        HashSet<StateStamp> allStamps = new StateFastLaneReader().getRawStateHistory(basicUnitId, stateModelId, null, requestedBeginTime, requestedEndTime, false, new ExtendedDTOData[0]);
        if (allStamps.size() < 1) {
            log.debug((Object)(sMethodName + ": nothing found in cache and history for unit '" + basicUnitId + "', state model '" + stateModelId + "'."));
        }
        return allStamps;
    }

    @Override
    @Business(viewType="both")
    public ArrayList<StateCache> getAllUnitEventsFromCacheSortedByPreviousPk() {
        ArrayList<StateCache> values = new ArrayList<StateCache>();
        values.addAll(this.currentStateCacheDAO.findAllOrderByHistoryId());
        return values;
    }

    @Override
    @Business(viewType="both")
    public StateHistory getStateHistory(long pk) {
        return (StateHistory)this.stateHistoryDAO.findByPrimaryKey(pk);
    }

    @Override
    @Business(viewType="both")
    public List<StateCache> findAllCaches() {
        return this.currentStateCacheDAO.findAll();
    }

    @Override
    @Business(viewType="both")
    public List<StateCache> findByUnitId(long unitId) {
        return this.currentStateCacheDAO.findByUnitId(unitId);
    }

    @Override
    @Business(viewType="both")
    public long getMaxStateHistoryId() {
        return this.stateHistoryDAO.getMaxStateHistoryId();
    }

    @Override
    @Business(viewType="both")
    public List<StateHistory> findByUnitPeriod(long unitId, long since, long until) {
        return this.stateHistoryDAO.findByUnitPeriod(unitId, since, until);
    }

    @Override
    @Business(viewType="both")
    public boolean isStateModelDataInHistory(int stateModelId) {
        String statement = null;
        switch (new FastLaneBase().getDatabaseType()) {
            case MySQL: {
                statement = "SELECT id FROM state_history h WHERE h.state_model_id = " + stateModelId + " LIMIT 1";
                break;
            }
            case Oracle: {
                statement = "SELECT id FROM state_history h WHERE h.state_model_id = " + stateModelId + " AND ROWNUM = 1";
                break;
            }
            case MSSQL: {
                statement = "SELECT TOP 1 id FROM state_history h WHERE h.state_model_id = " + stateModelId;
                break;
            }
            default: {
                statement = "SELECT SELECT COUNT(*) > 0 FROM state_history h WHERE h.state_model_id = " + stateModelId;
            }
        }
        Object rs = this.stateHistoryDAO.query(statement, QueryType.Select, true, true);
        return rs != null;
    }

    @Override
    @Business(viewType="both")
    public boolean isStateDataInHistory(int stateId) {
        String statement = null;
        switch (new FastLaneBase().getDatabaseType()) {
            case MySQL: {
                statement = "SELECT id FROM state_history h WHERE h.state_id = " + stateId + " LIMIT 1";
                break;
            }
            case Oracle: {
                statement = "SELECT id FROM state_history h WHERE h.state_id = " + stateId + " AND ROWNUM = 1";
                break;
            }
            case MSSQL: {
                statement = "SELECT TOP 1 id FROM state_history h WHERE h.state_id = " + stateId;
                break;
            }
            default: {
                statement = "SELECT SELECT COUNT(*) > 0 FROM state_history h WHERE h.state_id = " + stateId;
            }
        }
        Object rs = this.stateHistoryDAO.query(statement, QueryType.Select, true, true);
        return rs != null;
    }
}

