/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.state;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.util.jpa.dao.QueryType;
import de.proveo.util.jpa.entity.EntityBase;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.datamodel.area.Area;
import de.proveo.wwt.datamodel.state.StateCache;
import de.proveo.wwt.datamodel.state.StateHistory;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.datamodel.use.user.UseUser;
import de.proveo.wwt.logic.app.state.event.StateEvent;
import de.proveo.wwt.logic.ejb.dataIn.event.history.EventPersisterFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.event.history.EventPersisterResult;
import de.proveo.wwt.logic.ejb.general.area.AreaInFacadeLocal;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import de.proveo.wwt.logic.ejb.state.CurrentStateCacheDAO;
import de.proveo.wwt.logic.ejb.state.CurrentStateFacadeLocal;
import de.proveo.wwt.logic.ejb.state.CurrentStateFacadeRemote;
import de.proveo.wwt.logic.ejb.state.CurrentStateFacadeStruct;
import de.proveo.wwt.logic.ejb.state.StateHistoryDAO;
import de.proveo.wwt.logic.ejb.state.exception.StatesForUnitNotFoundException;
import de.proveo.wwt.logic.ejb.state.exception.WriteStateException;
import de.proveo.wwt.logic.ejb.transaction.ImplicitRollbackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.PoolClass;
import org.jboss.ejb3.StrictMaxPool;

@Stateless(name="CurrentStateFacade")
@Remote(value={CurrentStateFacadeRemote.class})
@Local(value={CurrentStateFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/CurrentStateFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/CurrentStateFacade")
@PoolClass(value=StrictMaxPool.class, maxSize=100, timeout=10000L)
public class CurrentStateFacadeBean
implements CurrentStateFacadeLocal,
CurrentStateFacadeRemote {
    private static final Log log = LogFactory.getLog(CurrentStateFacadeBean.class);
    @PersistenceContext(unitName="rts")
    private EntityManager entityManager;
    private UnitFacadeLocal unitFacade = null;
    @EJB
    private AreaInFacadeLocal areaInFacade = null;
    @EJB
    private EventPersisterFacadeLocal eventPersisterFacade;
    private CurrentStateCacheDAO currentStateCacheDAO = null;
    private StateHistoryDAO stateHistoryDAO = null;
    private static final int DEFAULT_MAX_REMARK_LENGTH = 100;
    private int maxRemarkLength = 100;

    @PostConstruct
    public void initImpl() {
        this.currentStateCacheDAO = CurrentStateCacheDAO.newInstance(this.entityManager);
        this.stateHistoryDAO = StateHistoryDAO.newInstance(this.entityManager);
        this.maxRemarkLength = 100;
    }

    protected StateHistory generateHistory(StateEvent stateEvent) {
        StateHistory stateHistory = new StateHistory();
        stateHistory.setUnitId(stateEvent.getUnitId());
        stateHistory.setStateModelId(stateEvent.getStateModelId());
        stateHistory.setStateId(stateEvent.getStateId());
        stateHistory.setBeginTime(stateEvent.getTimestamp());
        stateHistory.setBeginReceiveTime(stateEvent.getReceiveTime());
        stateHistory.setRemark(this.getRemark(stateEvent.getRemark()));
        stateHistory.setGdataHistoryId(stateEvent.getGdataHistoryId());
        UseUser userUser = stateEvent.getUser();
        if (userUser != null) {
            stateHistory.setUseUserId(userUser.getId());
        }
        stateHistory.setAreaId(stateEvent.getAreaId());
        stateHistory.setAreaTrusted(stateEvent.isAreaTrusted());
        return stateHistory;
    }

    protected EventPersisterResult<StateCache, StateHistory> persistHistory(StateEvent stateEvent) {
        StateHistory stateHistory = this.generateHistory(stateEvent);
        EventPersisterResult<StateCache, StateHistory> result = this.eventPersisterFacade.persist(stateHistory);
        return result;
    }

    private UnitFacadeLocal getUnitFacade() {
        if (this.unitFacade == null) {
            try {
                InitialContext context = new InitialContext();
                this.unitFacade = (UnitFacadeLocal)context.lookup("rts/UnitFacade/local");
            }
            catch (NamingException e) {
                log.error((Object)"runs into ", (Throwable)e);
            }
        }
        return this.unitFacade;
    }

    @Override
    @Business(viewType="both")
    public CurrentStateFacadeStruct getCurrentState(long unitId, int stateModelId) {
        CurrentStateFacadeStruct currentState = this.getCurrentStateFromCache(unitId, stateModelId);
        if (currentState == null) {
            currentState = this.getCurrentStateFromHistory(unitId, stateModelId);
        }
        return currentState;
    }

    @Override
    @Business(viewType="both")
    public Map<Integer, CurrentStateFacadeStruct> getCurrentState(long unitId) throws StatesForUnitNotFoundException {
        Map<Integer, CurrentStateFacadeStruct> stateMap;
        try {
            stateMap = this.getCurrentStateFromCache(unitId);
        }
        catch (StatesForUnitNotFoundException ex) {
            log.debug((Object)"getCurrentState(unitId) Nothing found in Cache. Try stateHistory");
            stateMap = this.getCurrentStateFromHistory(unitId);
        }
        return stateMap;
    }

    public String getRemark(String uncheckedRemark) {
        if (uncheckedRemark == null) {
            return null;
        }
        if (uncheckedRemark.length() > this.maxRemarkLength) {
            String remark = uncheckedRemark.substring(0, this.maxRemarkLength);
            if (log.isWarnEnabled()) {
                log.warn((Object)("getRemark() remark exceeded maximum length of " + this.maxRemarkLength + " cutted off. orignal: " + uncheckedRemark + " cutted to: " + remark));
            }
            return remark;
        }
        return uncheckedRemark;
    }

    @Override
    @Business(viewType="both")
    public SerializableEventWrapper changeState(StateEvent stateEvent) throws ImplicitRollbackException {
        EventPersisterResult<StateCache, StateHistory> result = null;
        StateCache stateCache = (StateCache)this.currentStateCacheDAO.findByPrimaryKey(new StateCache.PK(stateEvent.getUnitId(), stateEvent.getStateModelId()));
        if (stateCache != null) {
            if (stateCache.getBeginTime() > stateEvent.getTimestamp() || stateCache.getBeginTime() == stateEvent.getTimestamp() || stateEvent.getStateId() == stateCache.getStateId()) {
                if (stateCache.getBeginTime() > stateEvent.getTimestamp()) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("incoming event '" + stateEvent + "' older than current state '" + stateCache + "', don't move current state to history!"));
                    }
                } else if (stateCache.getBeginTime() == stateEvent.getTimestamp()) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("incoming event '" + stateEvent + "' equals current state '" + stateCache + "', don't move current state to history!"));
                    }
                } else if (stateEvent.getStateId() == stateCache.getStateId()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("incoming event '" + stateEvent + "' has the same stateId as curent state '" + stateCache + "', update REMARK only..."));
                    }
                    if (stateEvent.getRemark() != null && !stateEvent.getRemark().equals(stateCache.getRemark())) {
                        stateCache.setRemark(stateEvent.getRemark());
                        stateCache.getHistory().setRemark(stateEvent.getRemark());
                        List<StateHistory> stateHistoryList = this.stateHistoryDAO.findByUnitStateModelEndTime(stateEvent.getUnitId(), stateEvent.getStateModelId(), stateCache.getBeginTime());
                        if (stateHistoryList.size() == 1) {
                            result = new EventPersisterResult<StateCache, EntityBase>(stateCache, stateHistoryList.get(0));
                        }
                    }
                }
            } else {
                result = this.persistHistory(stateEvent);
            }
        } else {
            StateHistory newestStateHistory = this.getNewestStateHistory(stateEvent.getUnitId(), stateEvent.getStateModelId());
            if (newestStateHistory != null && newestStateHistory.getStateIdNext() == null) {
                newestStateHistory.setStateIdNext(stateEvent.getStateId());
            }
            result = this.persistHistory(stateEvent);
        }
        if (result == null) {
            return null;
        }
        SerializableEventWrapper wrapper = new SerializableEventWrapper(result.cache, result.history);
        if (log.isDebugEnabled()) {
            log.debug((Object)("h: " + wrapper.get_historyValue()));
            log.debug((Object)("c: " + wrapper.get_cacheValue()));
        }
        return wrapper;
    }

    protected CurrentStateFacadeStruct getCurrentStateFromCache(long unitId, int stateModelId) {
        StateCache.PK pk = new StateCache.PK(unitId, stateModelId);
        StateCache cachedState = (StateCache)this.currentStateCacheDAO.findByPrimaryKey(pk);
        CurrentStateFacadeStruct currentState = null;
        if (cachedState != null) {
            currentState = new CurrentStateFacadeStruct();
            currentState.setUnitId(unitId);
            currentState.setStateModelId(stateModelId);
            currentState.setStateId(cachedState.getStateId());
            currentState.setEntryTime(cachedState.getBeginTime());
            currentState.setEntryReceiveTime(cachedState.getBeginReceiveTime());
            currentState.setHistoryId(cachedState.getHistoryId());
            currentState.setRemark(cachedState.getRemark());
        }
        return currentState;
    }

    protected Map<Integer, CurrentStateFacadeStruct> getCurrentStateFromCache(long unitId) throws StatesForUnitNotFoundException {
        List<StateCache> states = this.currentStateCacheDAO.findByUnitId(unitId);
        if (states == null || states.isEmpty()) {
            return new HashMap<Integer, CurrentStateFacadeStruct>();
        }
        HashMap<Integer, CurrentStateFacadeStruct> stateMap = new HashMap<Integer, CurrentStateFacadeStruct>(states.size());
        for (StateCache stateCache : states) {
            CurrentStateFacadeStruct struct = new CurrentStateFacadeStruct();
            struct.setUnitId(unitId);
            struct.setStateModelId(stateCache.getPk().getStateModelId());
            struct.setStateId(stateCache.getStateId());
            struct.setEntryTime(stateCache.getBeginTime());
            struct.setEntryReceiveTime(stateCache.getBeginReceiveTime());
            struct.setHistoryId(stateCache.getHistoryId());
            struct.setRemark(stateCache.getRemark());
            stateMap.put(stateCache.getPk().getStateModelId(), struct);
        }
        return stateMap;
    }

    protected Map<Integer, CurrentStateFacadeStruct> getCurrentStateFromHistory(long unitId) throws StatesForUnitNotFoundException {
        log.trace((Object)("getCurrentStateFromHistory(" + unitId + ")"));
        List<StateHistory> stateStubs = this.stateHistoryDAO.findByUnitSorted(unitId);
        if (stateStubs == null || stateStubs.isEmpty()) {
            return new HashMap<Integer, CurrentStateFacadeStruct>();
        }
        Iterator it = stateStubs.iterator();
        HashMap<Integer, CurrentStateFacadeStruct> stateStructMap = new HashMap<Integer, CurrentStateFacadeStruct>();
        while (it.hasNext()) {
            StateHistory stateHistory = (StateHistory)it.next();
            CurrentStateFacadeStruct struct = new CurrentStateFacadeStruct();
            struct.setUnitId(unitId);
            struct.setStateModelId(stateHistory.getStateModelId());
            struct.setStateId(stateHistory.getStateIdNext());
            struct.setEntryTime(stateHistory.getEndTime());
            struct.setEntryReceiveTime(stateHistory.getEndReceiveTime());
            struct.setDontValidateNext(false);
            struct.setStateIdPrevious(stateHistory.getStateId());
            struct.setHistoryId(stateHistory.getId());
            stateStructMap.remove(stateHistory.getStateModelId());
            stateStructMap.put(stateHistory.getStateModelId(), struct);
        }
        HashMap<Integer, CurrentStateFacadeStruct> stateMap = new HashMap<Integer, CurrentStateFacadeStruct>(stateStructMap.size());
        for (Integer stateModelId : stateStructMap.keySet()) {
            CurrentStateFacadeStruct struct = (CurrentStateFacadeStruct)stateStructMap.get(stateModelId);
            stateMap.put(stateModelId, struct);
        }
        return stateMap;
    }

    protected StateHistory getNewestStateHistory(long unitId, int stateModelId) {
        List<StateHistory> stateHistories = this.stateHistoryDAO.findByUnitStateModelSorted(unitId, stateModelId);
        Iterator it = stateHistories.iterator();
        Object last = null;
        while (it.hasNext()) {
            last = it.next();
        }
        return last;
    }

    protected CurrentStateFacadeStruct getCurrentStateFromHistory(long unitId, int stateModelId) {
        log.trace((Object)"getCurrentStateFromHistory(long,long)");
        StateHistory stateHistory = this.getNewestStateHistory(unitId, stateModelId);
        if (stateHistory == null || stateHistory.getStateIdNext() == null) {
            return null;
        }
        try {
            this.writeIntoCache(stateHistory);
        }
        catch (WriteStateException ex) {
            return null;
        }
        CurrentStateFacadeStruct currentState = new CurrentStateFacadeStruct();
        currentState.setUnitId(unitId);
        currentState.setStateModelId(stateModelId);
        currentState.setStateId(stateHistory.getStateIdNext());
        currentState.setEntryTime(stateHistory.getEndTime());
        currentState.setEntryReceiveTime(stateHistory.getEndReceiveTime());
        currentState.setDontValidateNext(false);
        currentState.setStateIdPrevious(stateHistory.getStateId());
        currentState.setHistoryId(stateHistory.getId());
        return currentState;
    }

    protected void writeIntoCache(StateCache currentStateCacheValue, StateEvent stateEvent) throws WriteStateException {
        String method = "writeIntoCache(): ";
        StateCache.PK pk = new StateCache.PK();
        pk.setUnitId(currentStateCacheValue.getPk().getUnitId());
        pk.setStateModelId(currentStateCacheValue.getPk().getStateModelId());
        StateCache cachedState = (StateCache)this.currentStateCacheDAO.findByPrimaryKey(pk);
        if (cachedState != null) {
            StateCache oldCacheStruct = cachedState;
            if (currentStateCacheValue.getBeginTime() >= oldCacheStruct.getBeginTime()) {
                if (currentStateCacheValue.getStateId() != oldCacheStruct.getStateId()) {
                    Long grouphistoryId = this.getUnitFacade().getGrouphistoryId(currentStateCacheValue.getPk().getUnitId(), currentStateCacheValue.getBeginTime());
                    currentStateCacheValue.setGroupHistoryId(grouphistoryId);
                    currentStateCacheValue = (StateCache)this.currentStateCacheDAO.updateEntity(currentStateCacheValue);
                    if (stateEvent != null) {
                        if (stateEvent.getAreaId() != 0) {
                            Integer areaId = stateEvent.getAreaId();
                            cachedState.setAreaId(areaId);
                            cachedState.setAreaTrusted(stateEvent.isAreaTrusted());
                            if (log.isTraceEnabled()) {
                                log.trace((Object)(method + "set area to " + cachedState.getArea()));
                            }
                        } else {
                            cachedState.setAreaId(null);
                            cachedState.setAreaTrusted(false);
                            log.debug((Object)(method + "no area in event"));
                        }
                        if (stateEvent.getUser() != null) {
                            Long useUserId = stateEvent.getUser().getId();
                            cachedState.setUseUserId(useUserId);
                            if (log.isTraceEnabled()) {
                                log.trace((Object)(method + "set to useUser: " + useUserId));
                            }
                        } else {
                            cachedState.setUseUserId(null);
                            log.trace((Object)(method + "no useUser in event"));
                        }
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)(method + "nothing new. cache: " + oldCacheStruct + " new: " + currentStateCacheValue));
                }
            } else if (log.isErrorEnabled()) {
                log.error((Object)(method + "we have already a newer entry. database value: " + oldCacheStruct + " received event: " + currentStateCacheValue));
            }
        } else {
            try {
                this.currentStateCacheDAO.createEntity(currentStateCacheValue);
                cachedState = currentStateCacheValue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)(method + "create currentState for unitId: " + currentStateCacheValue.getPk().getUnitId() + " stateModelId: " + currentStateCacheValue.getPk().getStateModelId() + " stateId: " + currentStateCacheValue.getStateId() + " (persistent)"));
                }
                if (stateEvent != null) {
                    if (stateEvent.getAreaId() != 0) {
                        cachedState.setAreaId(stateEvent.getAreaId());
                        cachedState.setAreaTrusted(stateEvent.isAreaTrusted());
                        if (log.isTraceEnabled()) {
                            Area areaLocal = this.areaInFacade.getAreaValue(stateEvent.getAreaId());
                            log.trace((Object)(method + "set area to " + areaLocal.getArea()));
                        }
                    } else {
                        log.debug((Object)(method + "no area in event"));
                    }
                    if (stateEvent.getUser() != null) {
                        cachedState.setUseUserId(stateEvent.getUser().getId());
                        if (log.isTraceEnabled()) {
                            log.trace((Object)(method + "set to useUser: " + cachedState.getUseUserId()));
                        }
                    } else {
                        log.trace((Object)(method + "no useUser in event"));
                    }
                }
            }
            catch (Exception ex) {
                String msg = method + "runs during currentStateCacheHome.create into Exception";
                log.error((Object)msg, (Throwable)ex);
                throw new WriteStateException(currentStateCacheValue.getPk().getUnitId(), currentStateCacheValue.getPk().getStateModelId(), currentStateCacheValue.getStateId(), msg, ex);
            }
        }
    }

    protected void writeIntoCache(StateHistory stateHistoryValue) throws WriteStateException {
        StateCache cachedStruct = new StateCache();
        cachedStruct.getPk().setUnitId(stateHistoryValue.getUnitId());
        cachedStruct.getPk().setStateModelId(stateHistoryValue.getStateModelId());
        cachedStruct.setStateId(stateHistoryValue.getStateIdNext());
        cachedStruct.setBeginTime(stateHistoryValue.getEndTime());
        cachedStruct.setBeginReceiveTime(stateHistoryValue.getEndReceiveTime());
        cachedStruct.setHistoryId(stateHistoryValue.getId());
        cachedStruct.setRemark(stateHistoryValue.getRemark());
        this.writeIntoCache(cachedStruct, null);
    }

    @Override
    @Business(viewType="both")
    public void deleteCache(UnitModel unitModel) {
        List<StateCache> currentStateCaches = unitModel.getCurrentStateCaches();
        for (StateCache currentState : currentStateCaches) {
            if (currentState == null) continue;
            long endTime = System.currentTimeMillis();
            StateHistory history = currentState.getHistory();
            history.setEndTime(endTime);
            history.setEndReceiveTime(endTime);
            this.eventPersisterFacade.writeHistoryHelperEntries(history);
            history.setCache(null);
            this.currentStateCacheDAO.removeEntity(currentState);
        }
    }

    private boolean fixDuplicateHistoryEntry(StateHistory stateHistoryValue) {
        log.debug((Object)("Check duplicate HistoryEntry() with " + stateHistoryValue));
        try {
            List<StateHistory> duplicates = this.stateHistoryDAO.findByUnitStateModelBeginTime(stateHistoryValue.getUnitId(), stateHistoryValue.getStateModelId(), stateHistoryValue.getBeginTime());
            if (duplicates != null) {
                for (StateHistory stateHistoryLocal : duplicates) {
                    if (stateHistoryLocal == null) continue;
                    log.debug((Object)("remove: " + stateHistoryLocal));
                    this.stateHistoryDAO.removeEntity(stateHistoryLocal);
                    this.entityManager.flush();
                    log.info((Object)("Removed duplicate StateHistory entry!" + stateHistoryValue));
                    return true;
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"fixDuplicateHistoryEntry runs into", (Throwable)e);
        }
        return false;
    }

    @Override
    @Business(viewType="both")
    public void createNewStateCacheEntry(StateCache currentStateCache) {
        this.currentStateCacheDAO.createEntity(currentStateCache);
    }

    @Override
    @Business(viewType="both")
    public void removeCacheEntry(long unitId, int stateModelId) {
        this.currentStateCacheDAO.removeEntity(this.getCacheEntry(unitId, stateModelId));
    }

    @Override
    @Business(viewType="both")
    public StateCache getCacheEntry(long unitId, int stateModelId) {
        StateCache.PK pk = new StateCache.PK();
        pk.setStateModelId(stateModelId);
        pk.setUnitId(unitId);
        return (StateCache)this.currentStateCacheDAO.findByPrimaryKey(pk);
    }

    @Override
    @Business(viewType="both")
    public List<StateCache> findAllByStateModelId(int stateModelId, Integer stateIdFilter) {
        if (stateIdFilter == null) {
            return this.currentStateCacheDAO.findAllByStateModelId(stateModelId);
        }
        return this.currentStateCacheDAO.findAllByStateModelIdAndStateId(stateModelId, stateIdFilter);
    }

    @Override
    @Business(viewType="both")
    public List<StateHistory> findHistoryByRotationAssignment(String rkey, int stateModelId, int stateId) {
        return this.stateHistoryDAO.findByRotationAssignment(rkey, stateModelId, stateId);
    }

    @Override
    @Business(viewType="both")
    public List<StateCache> findCacheByRotationAssignment(String rkey, int stateModelId, int stateId) {
        return this.currentStateCacheDAO.findByRotationAssignment(rkey, stateModelId, stateId);
    }

    @Override
    @Business(viewType="both")
    public List<StateCache> findByUnitGroupIdStateModelId(long unitIdGroupId, int stateModelId, Integer stateFilterId) {
        if (stateFilterId == null) {
            return this.currentStateCacheDAO.findByUnitGroupIdStateModelId(unitIdGroupId, stateModelId);
        }
        return this.currentStateCacheDAO.findByUnitGroupIdStateModelIdAndStateId(unitIdGroupId, stateModelId, stateFilterId);
    }

    @Override
    @Business(viewType="both")
    public List<StateCache> findByUnitModelId(long unitId, int stateModelId, Integer stateFilterId) {
        if (stateFilterId == null) {
            return this.currentStateCacheDAO.findByUnitModelId(unitId, stateModelId);
        }
        return this.currentStateCacheDAO.findByUnitModelIdStateId(unitId, stateModelId, stateFilterId);
    }

    @Override
    @Business(viewType="both")
    public List<StateCache> findByUnitId(long unitId) {
        return this.currentStateCacheDAO.findByUnitId(unitId);
    }

    @Override
    @Business(viewType="both")
    public List<StateCache> findByUnitGroupId(long unitGroupId) {
        return this.currentStateCacheDAO.findByUnitGroupId(unitGroupId);
    }

    @Override
    @Business(viewType="both")
    public StateCache findByPrimaryKey(StateCache.PK pk) {
        return (StateCache)this.currentStateCacheDAO.findByPrimaryKey(pk);
    }

    @Override
    @Business(viewType="both")
    public StateHistory findByPrimaryKey(long stateHistoryId) {
        return (StateHistory)this.stateHistoryDAO.findByPrimaryKey(stateHistoryId);
    }

    @Override
    @Business(viewType="both")
    public List<StateCache> findAllCurrentStateCaches() {
        return this.currentStateCacheDAO.findAll();
    }

    @Override
    @Business(viewType="both")
    public void removeCurrentStateCacheFromUnit(long unitId) {
        List<StateCache> list = this.currentStateCacheDAO.findByUnitId(unitId);
        for (StateCache currentStateCache : list) {
            this.currentStateCacheDAO.removeEntity(currentStateCache);
        }
    }

    @Override
    @Business(viewType="both")
    public boolean isStateModelDataInCache(int stateModelId) {
        String statement = "SELECT COUNT(*) FROM state_cache c WHERE c.state_model_id = " + stateModelId;
        return ((Number)this.currentStateCacheDAO.query(statement, QueryType.Select, true, true)).intValue() != 0;
    }

    @Override
    @Business(viewType="both")
    public boolean isStateDataInCache(int stateId) {
        String statement = "SELECT COUNT(*) FROM state_cache c WHERE c.state_id = " + stateId;
        return ((Number)this.currentStateCacheDAO.query(statement, QueryType.Select, true, true)).intValue() != 0;
    }
}

