/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml;

import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.UnknownErrorException;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.TDIConfiguration;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.TDITimestamp;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.xml.sax.InputSource;

public class XMLDocument {
    private static final Log log = LogFactory.getLog(XMLDocument.class);
    private TDIConfiguration config = TDIConfiguration.getInstance();
    protected Document doc;

    public XMLDocument() {
        this.doc = new Document();
        this.setDocType();
    }

    public XMLDocument(Document doc) {
        this.doc = doc;
        this.setDocType();
    }

    public XMLDocument(Element element) {
        this.doc = new Document();
        this.setDocType();
        this.doc.setRootElement(element);
    }

    public XMLDocument(String xmlText) throws JDOMException, UnknownErrorException {
        this.doc = this.parseByJDom(xmlText);
        this.setDocType();
    }

    protected void setAttribute(Element element, String name, Object value) {
        if (value != null) {
            if (this.config.getBoolean("xml.sendEmptyAttributes") || value.toString().length() > 0) {
                element.setAttribute(name, value.toString());
            }
        } else if (this.config.getBoolean("xml.sendEmptyAttributes")) {
            element.setAttribute(name, "");
        }
    }

    public Document parseByJDom(String xmlText) throws JDOMException, UnknownErrorException {
        SAXBuilder builder = new SAXBuilder();
        builder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        log.debug((Object)("parseByJDom: " + xmlText));
        Document doc = new Document();
        if (xmlText.length() > 0) {
            StringReader reader = new StringReader(xmlText);
            try {
                doc = builder.build((Reader)reader);
                return doc;
            }
            catch (JDOMException e) {
                log.error((Object)"runs into", (Throwable)e);
                throw e;
            }
            catch (IOException e) {
                log.error((Object)"runs into", (Throwable)e);
                throw new UnknownErrorException(e.getMessage());
            }
            catch (Exception e) {
                log.error((Object)"runs into", (Throwable)e);
                throw new UnknownErrorException(e.getMessage());
            }
        }
        return doc;
    }

    private InputSource createInputSource(String xmlText) {
        StringReader reader = new StringReader(xmlText);
        return new InputSource(reader);
    }

    protected void setDocType() {
        if (this.config.getBoolean("xml.doctype.active")) {
            DocType docType = new DocType(this.config.getString("xml.doctype.name"));
            docType.setElementName(this.config.getString("xml.doctype.name"));
            docType.setPublicID(this.config.getString("xml.doctype.publicId"));
            docType.setSystemID(this.config.getString("xml.doctype.systemId"));
            this.doc.setDocType(docType);
        }
    }

    public String toString() {
        XMLOutputter xmlOut = new XMLOutputter();
        Format format = this.config.getBoolean("xml.formatted") ? Format.getPrettyFormat() : Format.getCompactFormat();
        format.setEncoding("ISO-8859-1");
        xmlOut.setFormat(format);
        String xmlData = xmlOut.outputString(this.doc);
        return xmlData;
    }

    protected String getTimeString(long timestamp) {
        TDITimestamp ts = new TDITimestamp(timestamp);
        return ts.getTimeString();
    }

    public Document getDoc() {
        return this.doc;
    }

    public void setDoc(Document doc) {
        this.doc = doc;
    }
}

