/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml;

import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.Enums;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.Range;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.TDIConfiguration;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.TelemetryDataMessage;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.XMLDocument;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class TelemetryDataMessages
extends XMLDocument {
    private static final Log log = LogFactory.getLog(TelemetryDataMessages.class);
    private TDIConfiguration config = TDIConfiguration.getInstance();
    private boolean empty = true;
    private long from = 0L;
    private long until = 0L;
    private String includedData = "-1";
    private Enums.EventType eventType = null;

    public TelemetryDataMessages(Enums.EventType eventType) {
        this.doc = new Document();
        this.setDocType();
        Element basisMessages = new Element(this.config.getString("xml.telemetryDataMessages.xmlName"));
        this.doc.setRootElement(basisMessages);
        this.empty = true;
        this.setEventType(eventType);
    }

    public void add(TelemetryDataMessage message) {
        if (this.eventType == null) {
            this.eventType = message.getEventType();
        } else if (this.eventType != message.getEventType()) {
            log.warn((Object)("added TelemetryDataMessage of type " + (Object)((Object)message.getEventType()) + " to TelemetryDataMessages of type " + (Object)((Object)this.eventType)));
        }
        Element rootElement = message.getDoc().getRootElement();
        rootElement.detach();
        this.doc.getRootElement().addContent((Content)rootElement);
        this.empty = false;
    }

    private void parseIncludedData() {
        if (this.includedData.equals("-1")) {
            this.setFrom(-1L);
            this.setUntil(-1L);
            return;
        }
        try {
            Range range = new Range(this.includedData);
            this.setFrom(range.getFrom());
            this.setUntil(range.getUntil());
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)(this.includedData + " is no valid range"));
            this.setFrom(-1L);
            this.setUntil(-1L);
        }
        Element root = this.doc.getRootElement();
        root.setAttribute(this.config.getString("xml.telemetryDataMessages.from.xmlName"), Long.toString(this.from));
        root.setAttribute(this.config.getString("xml.telemetryDataMessages.until.xmlName"), Long.toString(this.until));
    }

    public long getFrom() {
        return this.from;
    }

    public void setFrom(long from) {
        this.from = from;
        Range range = new Range(from, this.until);
        this.includedData = range.getRangeString();
        if (this.config.getBoolean("xml.telemetryDataMessages.from.active")) {
            Element root = this.doc.getRootElement();
            root.setAttribute(this.config.getString("xml.telemetryDataMessages.from.xmlName"), Long.toString(from));
        }
    }

    public long getUntil() {
        return this.until;
    }

    public void setUntil(long until) {
        this.until = until;
        Range range = new Range(this.from, until);
        this.includedData = range.getRangeString();
        if (this.config.getBoolean("xml.telemetryDataMessages.until.active")) {
            Element root = this.doc.getRootElement();
            root.setAttribute(this.config.getString("xml.telemetryDataMessages.until.xmlName"), Long.toString(until));
        }
    }

    public String getIncludedData() {
        return this.includedData;
    }

    public void setIncludedData(String includedData) {
        this.includedData = includedData;
        this.parseIncludedData();
    }

    public Enums.EventType getEventType() {
        return this.eventType;
    }

    public void setEventType(Enums.EventType eventType) {
        this.eventType = eventType;
        if (this.config.getBoolean("xml.telemetryDataMessages.eventType.active")) {
            this.doc.getRootElement().setAttribute(this.config.getString("xml.telemetryDataMessages.eventType.xmlName"), eventType.toString());
        }
    }

    public boolean isEmpty() {
        return this.empty;
    }
}

