/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml;

import de.proveo.util.geo.GPSPosition;
import de.proveo.util.math.Point;
import de.proveo.util.math.PointImpl;
import de.proveo.wwt.datamodel.geo.GdataCache;
import de.proveo.wwt.datamodel.notify.NotifyHistory;
import de.proveo.wwt.logic.app.util.Stopwatch;
import de.proveo.wwt.logic.ejb.dataIn.notify.NotifyFacadeLocal;
import de.proveo.wwt.logic.ejb.general.area.AreaInFacadeLocal;
import de.proveo.wwt.logic.ejb.geo.GeoStruct;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.UnknownNotifyException;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.UnknownStateException;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.UnknownStateModelException;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.handler.StateHandler;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.tto.StateTTO;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.tto.TTO;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.Enums;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.TDIConfiguration;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.TDITimestamp;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.UnitHelper;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.XMLDocument;
import de.proveo.wwt.logic.web.historyData.dto.NotificationDTO;
import de.proveo.wwt.logic.web.historyData.dto.PositionDTO;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class TelemetryDataMessage
extends XMLDocument {
    private static final Log log = LogFactory.getLog(TelemetryDataMessage.class);
    private static final int MSEC_PER_DEGREE = 3600000;
    private TDIConfiguration config = TDIConfiguration.getInstance();
    private Enums.EventType eventType = Enums.EventType.UNKNOWN;
    private static NotifyFacadeLocal notifyFacade = null;
    private static AreaInFacadeLocal areaInFacade = null;

    public TelemetryDataMessage() {
    }

    private static void lookupFacades() {
        Stopwatch stopwatch = new Stopwatch(TelemetryDataMessage.class, "lookupFacades");
        stopwatch.start("lookupFacades");
        try {
            InitialContext ctx = new InitialContext();
            notifyFacade = (NotifyFacadeLocal)ctx.lookup("rts/NotifyFacade/local");
            areaInFacade = (AreaInFacadeLocal)ctx.lookup("rts/AreaInFacade/local");
        }
        catch (NamingException e) {
            log.error((Object)"lookupFacades runs into", (Throwable)e);
        }
        stopwatch.stop("lookupFacades", true);
    }

    public TelemetryDataMessage(Document doc) {
        super(doc);
    }

    public TelemetryDataMessage(Element element) {
        super(element);
    }

    public TelemetryDataMessage(StateTTO stateTTO, ResourceBundle resourceBundle) throws UnknownStateModelException, UnknownStateException {
        this.eventType = Enums.EventType.STATE;
        if (resourceBundle == null) {
            resourceBundle = StateHandler.getInstance().readResourceBundle();
        }
        Element telemetryDataMessage = this.buildTelemetryDataMessage(stateTTO);
        Element statusField = this.buildStatusField(stateTTO, resourceBundle);
        telemetryDataMessage.addContent((Content)statusField);
        this.doc = new Document();
        this.setDocType();
        this.doc.setRootElement(telemetryDataMessage);
    }

    private Element buildStatusField(StateTTO stateTTO, ResourceBundle resourceBundle) throws UnknownStateModelException, UnknownStateException {
        String area;
        Double latitude;
        Double longitude;
        long stateModelID = stateTTO.getStateModelId();
        long prevStateID = stateTTO.getPrevStateId();
        long currStateID = stateTTO.getCurrStateId();
        String prevTime = this.getTimeString(stateTTO.getPrevBeginTime());
        String currTime = this.getTimeString(stateTTO.getCurrBeginTime());
        String stateModel = this.getStateModelById(stateModelID, resourceBundle);
        String currState = this.getStateById(currStateID, resourceBundle);
        String prevState = "";
        try {
            prevState = this.getStateById(prevStateID, resourceBundle);
        }
        catch (UnknownStateException e) {
            prevState = this.config.containsKey("stateId.9999") ? this.config.getString("stateId.9999") : "unknown";
        }
        Element statusField = new Element(this.config.getString("xml.telemetryDataMessage.stateField.xmlName"));
        if (this.config.getBoolean("xml.telemetryDataMessage.stateModelName.active")) {
            if (stateModel == null) {
                stateModel = "";
            }
            this.setAttribute(statusField, this.config.getString("xml.telemetryDataMessage.stateModelName.xmlName"), stateModel);
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.oldState.active")) {
            if (prevState == null) {
                prevState = "";
            }
            this.setAttribute(statusField, this.config.getString("xml.telemetryDataMessage.oldState.xmlName"), prevState);
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.beginTime.active")) {
            if (prevTime == null) {
                prevTime = "";
            }
            this.setAttribute(statusField, this.config.getString("xml.telemetryDataMessage.beginTime.xmlName"), prevTime);
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.endTime.active")) {
            if (currTime == null) {
                currTime = "";
            }
            this.setAttribute(statusField, this.config.getString("xml.telemetryDataMessage.endTime.xmlName"), currTime);
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.currState.active")) {
            if (currState == null) {
                currState = "";
            }
            this.setAttribute(statusField, this.config.getString("xml.telemetryDataMessage.currState.xmlName"), currState);
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.stateField.currCoords.active")) {
            longitude = stateTTO.getCurrLongitude();
            latitude = stateTTO.getCurrLatitude();
            if (latitude != null) {
                latitude = this.round(latitude, 6);
            }
            if (longitude != null) {
                longitude = this.round(longitude, 6);
            }
            this.setAttribute(statusField, this.config.getString("xml.telemetryDataMessage.stateField.currLong.xmlName"), longitude);
            this.setAttribute(statusField, this.config.getString("xml.telemetryDataMessage.stateField.currLat.xmlName"), latitude);
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.stateField.currArea.active")) {
            area = stateTTO.getCurrArea();
            this.setAttribute(statusField, this.config.getString("xml.telemetryDataMessage.stateField.currArea.xmlName"), area);
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.stateField.prevCoords.active")) {
            longitude = stateTTO.getPrevLongitude();
            latitude = stateTTO.getPrevLatitude();
            if (latitude != null) {
                latitude = this.round(latitude, 6);
            }
            if (longitude != null) {
                longitude = this.round(longitude, 6);
            }
            this.setAttribute(statusField, this.config.getString("xml.telemetryDataMessage.stateField.prevLong.xmlName"), longitude);
            this.setAttribute(statusField, this.config.getString("xml.telemetryDataMessage.stateField.prevLat.xmlName"), latitude);
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.stateField.prevArea.active")) {
            area = stateTTO.getPrevArea();
            this.setAttribute(statusField, this.config.getString("xml.telemetryDataMessage.stateField.prevArea.xmlName"), area);
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.stateField.prevFlights.active")) {
            String prevInb = stateTTO.getPrevFLNInb();
            String prevOutb = stateTTO.getPrevFLNOutb();
            this.setAttribute(statusField, this.config.getString("xml.telemetryDataMessage.stateField.prevFLNInb.xmlName"), prevInb);
            this.setAttribute(statusField, this.config.getString("xml.telemetryDataMessage.stateField.prevFLNOutb.xmlName"), prevOutb);
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.stateField.currFlights.active")) {
            String currInb = stateTTO.getCurrFLNInb();
            String currOutb = stateTTO.getCurrFLNOutb();
            this.setAttribute(statusField, this.config.getString("xml.telemetryDataMessage.stateField.currFLNInb.xmlName"), currInb);
            this.setAttribute(statusField, this.config.getString("xml.telemetryDataMessage.stateField.currFLNOutb.xmlName"), currOutb);
        }
        return statusField;
    }

    private Element buildTelemetryDataMessage(TTO tto) {
        long unitId = tto.getUnitId();
        String customerUnitId = tto.getCustomerUnitId();
        String unitName = tto.getUnitName();
        String modelType = tto.getModelType();
        long historyId = tto.getHistoryId();
        Element telemetryDataMessage = new Element(this.config.getString("xml.telemetryDataMessage.xmlName"));
        this.setAttribute(telemetryDataMessage, this.config.getString("xml.telemetryDataMessage.messageId.xmlName"), historyId);
        if (this.config.getBoolean("xml.telemetryDataMessage.customerUnitId.active")) {
            if (customerUnitId != null) {
                this.setAttribute(telemetryDataMessage, this.config.getString("xml.telemetryDataMessage.customerUnitId.xmlName"), customerUnitId);
            } else if (unitId != 0L) {
                log.debug((Object)("unit " + unitId + " has no customer unit id"));
            }
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.proveoUnitID.active")) {
            this.setAttribute(telemetryDataMessage, this.config.getString("xml.telemetryDataMessage.proveoUnitID.xmlName"), unitId);
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.unitName.active")) {
            this.setAttribute(telemetryDataMessage, this.config.getString("xml.telemetryDataMessage.unitName.xmlName"), unitName);
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.modelType.active")) {
            this.setAttribute(telemetryDataMessage, this.config.getString("xml.telemetryDataMessage.modelType.xmlName"), modelType);
        }
        if (this.config.getBoolean("xml.telemetryDataMessages.eventType.active")) {
            this.setAttribute(telemetryDataMessage, this.config.getString("xml.telemetryDataMessages.eventType.xmlName"), this.config.getString("xml.telemetryDataMessages.eventTypes.state"));
        }
        return telemetryDataMessage;
    }

    @Deprecated
    public TelemetryDataMessage(GeoStruct geo) {
        this.eventType = Enums.EventType.GEO;
        String area = geo.getArea();
        long historyId = geo.getHistoryId();
        GPSPosition gps = new GPSPosition(geo.getRmcRec(), geo.getGgaRec(), geo.isTrusted());
        double latitude = (double)gps.getLatitudeMSec() / 3600000.0;
        double longitude = (double)gps.getLongitudeMSec() / 3600000.0;
        latitude = this.round(latitude, 6);
        longitude = this.round(longitude, 6);
        String timestamp = this.getTimeString(geo.getBeginTime());
        long unitId = geo.getUnitId();
        String customerUnitId = UnitHelper.getCustomerUnitId(unitId);
        String unitName = UnitHelper.getUnitName(unitId);
        String modelType = UnitHelper.getModelType(unitId);
        PointImpl gk = new PointImpl();
        double x = 0.0;
        double y = 0.0;
        if (this.config.getBoolean("xml.telemetryDataMessage.gkCoords.active")) {
            gk = this.calculateGaussKrueger(latitude, longitude);
            x = this.round(gk.getX(), 3);
            y = this.round(gk.getY(), 3);
        }
        Element telemetryDataMessage = new Element(this.config.getString("xml.telemetryDataMessage.xmlName"));
        this.setAttribute(telemetryDataMessage, this.config.getString("xml.telemetryDataMessage.messageId.xmlName"), Long.toString(historyId));
        if (this.config.getBoolean("xml.telemetryDataMessage.customerUnitId.active")) {
            this.setAttribute(telemetryDataMessage, this.config.getString("xml.telemetryDataMessage.customerUnitId.xmlName"), customerUnitId);
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.proveoUnitID.active")) {
            this.setAttribute(telemetryDataMessage, this.config.getString("xml.telemetryDataMessage.proveoUnitID.xmlName"), Long.toString(unitId));
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.unitName.active")) {
            this.setAttribute(telemetryDataMessage, this.config.getString("xml.telemetryDataMessage.unitName.xmlName"), unitName);
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.modelType.active")) {
            this.setAttribute(telemetryDataMessage, this.config.getString("xml.telemetryDataMessage.modelType.xmlName"), modelType);
        }
        if (this.config.getBoolean("xml.telemetryDataMessages.eventType.active")) {
            this.setAttribute(telemetryDataMessage, this.config.getString("xml.telemetryDataMessages.eventType.xmlName"), this.config.getString("xml.telemetryDataMessages.eventTypes.geo"));
        }
        Element geoField = new Element(this.config.getString("xml.telemetryDataMessage.geoField.xmlName"));
        if (this.config.getBoolean("xml.telemetryDataMessage.gpsCoords.active")) {
            this.setAttribute(geoField, this.config.getString("xml.telemetryDataMessage.gpsCoords.longitude.xmlName"), Double.toString(longitude));
            this.setAttribute(geoField, this.config.getString("xml.telemetryDataMessage.gpsCoords.latitude.xmlName"), Double.toString(latitude));
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.gkCoords.active")) {
            this.setAttribute(geoField, this.config.getString("xml.telemetryDataMessage.gkCoords.x.xmlName"), Double.toString(x));
            this.setAttribute(geoField, this.config.getString("xml.telemetryDataMessage.gkCoords.y.xmlName"), Double.toString(y));
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.rmc.active")) {
            this.setAttribute(geoField, this.config.getString("xml.telemetryDataMessage.rmc.xmlName"), geo.getRmcRec());
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.area.active")) {
            if (area == null) {
                area = "";
            }
            this.setAttribute(geoField, this.config.getString("xml.telemetryDataMessage.area.xmlName"), area);
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.timestamp.active")) {
            if (timestamp == null) {
                timestamp = "";
            }
            this.setAttribute(geoField, this.config.getString("xml.telemetryDataMessage.timestamp.xmlName"), timestamp);
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.receiveTimestamp.active")) {
            if (timestamp == null) {
                timestamp = "";
            }
            this.setAttribute(geoField, this.config.getString("xml.telemetryDataMessage.receiveTimestamp.xmlName"), this.getTimeString(geo.getBeginReceiveTime()));
        }
        telemetryDataMessage.addContent((Content)geoField);
        this.setDocType();
        this.doc.setRootElement(telemetryDataMessage);
    }

    public TelemetryDataMessage(GdataCache geo) {
        this.eventType = Enums.EventType.GEO;
        String area = null;
        area = geo.getArea() != null && geo.getArea() != null ? geo.getArea().getArea() : this.getAreaName(geo.getAreaId());
        long historyId = geo.getHistoryId();
        GPSPosition gps = new GPSPosition(geo.getRmcRec(), geo.getGgaRec(), geo.getTrusted());
        double latitude = (double)gps.getLatitudeMSec() / 3600000.0;
        double longitude = (double)gps.getLongitudeMSec() / 3600000.0;
        latitude = this.round(latitude, 6);
        longitude = this.round(longitude, 6);
        String timestamp = this.getTimeString(geo.getBeginTime());
        long unitId = geo.getUnitId();
        String customerUnitId = UnitHelper.getCustomerUnitId(unitId);
        String unitName = UnitHelper.getUnitName(unitId);
        String modelType = UnitHelper.getModelType(unitId);
        PointImpl gk = new PointImpl();
        double x = 0.0;
        double y = 0.0;
        if (this.config.getBoolean("xml.telemetryDataMessage.gkCoords.active")) {
            gk = this.calculateGaussKrueger(latitude, longitude);
            x = this.round(gk.getX(), 3);
            y = this.round(gk.getY(), 3);
        }
        Element telemetryDataMessage = new Element(this.config.getString("xml.telemetryDataMessage.xmlName"));
        this.setAttribute(telemetryDataMessage, this.config.getString("xml.telemetryDataMessage.messageId.xmlName"), Long.toString(historyId));
        if (this.config.getBoolean("xml.telemetryDataMessage.customerUnitId.active")) {
            this.setAttribute(telemetryDataMessage, this.config.getString("xml.telemetryDataMessage.customerUnitId.xmlName"), customerUnitId);
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.proveoUnitID.active")) {
            this.setAttribute(telemetryDataMessage, this.config.getString("xml.telemetryDataMessage.proveoUnitID.xmlName"), Long.toString(unitId));
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.unitName.active")) {
            this.setAttribute(telemetryDataMessage, this.config.getString("xml.telemetryDataMessage.unitName.xmlName"), unitName);
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.modelType.active")) {
            this.setAttribute(telemetryDataMessage, this.config.getString("xml.telemetryDataMessage.modelType.xmlName"), modelType);
        }
        if (this.config.getBoolean("xml.telemetryDataMessages.eventType.active")) {
            this.setAttribute(telemetryDataMessage, this.config.getString("xml.telemetryDataMessages.eventType.xmlName"), this.config.getString("xml.telemetryDataMessages.eventTypes.geo"));
        }
        Element geoField = new Element(this.config.getString("xml.telemetryDataMessage.geoField.xmlName"));
        if (this.config.getBoolean("xml.telemetryDataMessage.gpsCoords.active")) {
            this.setAttribute(geoField, this.config.getString("xml.telemetryDataMessage.gpsCoords.longitude.xmlName"), Double.toString(longitude));
            this.setAttribute(geoField, this.config.getString("xml.telemetryDataMessage.gpsCoords.latitude.xmlName"), Double.toString(latitude));
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.gkCoords.active")) {
            this.setAttribute(geoField, this.config.getString("xml.telemetryDataMessage.gkCoords.x.xmlName"), Double.toString(x));
            this.setAttribute(geoField, this.config.getString("xml.telemetryDataMessage.gkCoords.y.xmlName"), Double.toString(y));
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.rmc.active")) {
            this.setAttribute(geoField, this.config.getString("xml.telemetryDataMessage.rmc.xmlName"), geo.getRmcRec());
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.area.active")) {
            if (area == null) {
                area = "";
            }
            this.setAttribute(geoField, this.config.getString("xml.telemetryDataMessage.area.xmlName"), area);
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.timestamp.active")) {
            if (timestamp == null) {
                timestamp = "";
            }
            this.setAttribute(geoField, this.config.getString("xml.telemetryDataMessage.timestamp.xmlName"), timestamp);
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.receiveTimestamp.active")) {
            if (timestamp == null) {
                timestamp = "";
            }
            this.setAttribute(geoField, this.config.getString("xml.telemetryDataMessage.receiveTimestamp.xmlName"), this.getTimeString(geo.getBeginReceiveTime()));
        }
        telemetryDataMessage.addContent((Content)geoField);
        this.setDocType();
        this.doc.setRootElement(telemetryDataMessage);
    }

    private String getAreaName(Integer areaId) {
        if (areaInFacade == null) {
            try {
                InitialContext ctx = new InitialContext();
                areaInFacade = (AreaInFacadeLocal)ctx.lookup("rts/AreaInFacade/local");
            }
            catch (NamingException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
        }
        if (areaInFacade != null && areaId != null && areaInFacade.getAreaValue(areaId) != null) {
            return areaInFacade.getAreaValue(areaId).getArea();
        }
        return null;
    }

    public TelemetryDataMessage(PositionDTO position) {
        this.eventType = Enums.EventType.GEO;
        String area = position.getAreaName();
        long historyID = position.getId();
        GPSPosition gps = new GPSPosition(position.getRmcRec(), position.getGgaRec(), position.isTrusted());
        double latitude = (double)gps.getLatitudeMSec() / 3600000.0;
        double longitude = (double)gps.getLongitudeMSec() / 3600000.0;
        latitude = this.round(latitude, 6);
        longitude = this.round(longitude, 6);
        String timestamp = this.getTimeString(position.getBeginTime());
        long unitId = position.getUnitId();
        String customerUnitId = position.getUnitModel().getCustomerUnitId();
        String unitName = position.getUnitName();
        String modelType = position.getUnitModel().getModelType();
        PointImpl gk = new PointImpl();
        double x = 0.0;
        double y = 0.0;
        if (this.config.getBoolean("xml.telemetryDataMessage.gkCoords.active")) {
            gk = this.calculateGaussKrueger(latitude, longitude);
            x = this.round(gk.getX(), 3);
            y = this.round(gk.getY(), 3);
        }
        Element telemetryDataMessage = new Element(this.config.getString("xml.telemetryDataMessage.xmlName"));
        this.setAttribute(telemetryDataMessage, this.config.getString("xml.telemetryDataMessage.messageId.xmlName"), Long.toString(historyID));
        if (this.config.getBoolean("xml.telemetryDataMessage.customerUnitId.active")) {
            this.setAttribute(telemetryDataMessage, this.config.getString("xml.telemetryDataMessage.customerUnitId.xmlName"), customerUnitId);
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.proveoUnitID.active")) {
            this.setAttribute(telemetryDataMessage, this.config.getString("xml.telemetryDataMessage.proveoUnitID.xmlName"), Long.toString(unitId));
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.unitName.active")) {
            this.setAttribute(telemetryDataMessage, this.config.getString("xml.telemetryDataMessage.unitName.xmlName"), unitName);
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.modelType.active")) {
            this.setAttribute(telemetryDataMessage, this.config.getString("xml.telemetryDataMessage.modelType.xmlName"), modelType);
        }
        if (this.config.getBoolean("xml.telemetryDataMessages.eventType.active")) {
            this.setAttribute(telemetryDataMessage, this.config.getString("xml.telemetryDataMessages.eventType.xmlName"), this.config.getString("xml.telemetryDataMessages.eventTypes.geo"));
        }
        Element geoField = new Element(this.config.getString("xml.telemetryDataMessage.geoField.xmlName"));
        if (this.config.getBoolean("xml.telemetryDataMessage.gpsCoords.active")) {
            this.setAttribute(geoField, this.config.getString("xml.telemetryDataMessage.gpsCoords.longitude.xmlName"), Double.toString(longitude));
            this.setAttribute(geoField, this.config.getString("xml.telemetryDataMessage.gpsCoords.latitude.xmlName"), Double.toString(latitude));
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.gkCoords.active")) {
            this.setAttribute(geoField, this.config.getString("xml.telemetryDataMessage.gkCoords.x.xmlName"), Double.toString(x));
            this.setAttribute(geoField, this.config.getString("xml.telemetryDataMessage.gkCoords.y.xmlName"), Double.toString(y));
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.area.active")) {
            if (area == null) {
                area = "";
            }
            this.setAttribute(geoField, this.config.getString("xml.telemetryDataMessage.area.xmlName"), area);
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.timestamp.active")) {
            if (timestamp == null) {
                timestamp = "";
            }
            this.setAttribute(geoField, this.config.getString("xml.telemetryDataMessage.timestamp.xmlName"), timestamp);
        }
        telemetryDataMessage.addContent((Content)geoField);
        this.setDocType();
        this.doc.setRootElement(telemetryDataMessage);
    }

    public TelemetryDataMessage(NotifyHistory notifyHistory) throws UnknownNotifyException {
        this.eventType = Enums.EventType.NOTIFY;
        long historyId = notifyHistory.getId();
        long notifyTypeId = notifyHistory.getMessageId();
        TDITimestamp timestamp = new TDITimestamp(notifyHistory.getReceiveTime());
        String remark = notifyHistory.getRemark();
        long unitId = notifyHistory.getUnitId();
        String customerUnitId = UnitHelper.getCustomerUnitId(unitId);
        String unitName = UnitHelper.getUnitName(unitId);
        String modelType = UnitHelper.getModelType(unitId);
        Element telemetryDataMessage = new Element(this.config.getString("xml.telemetryDataMessage.xmlName"));
        this.setAttribute(telemetryDataMessage, this.config.getString("xml.telemetryDataMessage.messageId.xmlName"), Long.toString(historyId));
        if (this.config.getBoolean("xml.telemetryDataMessage.customerUnitId.active")) {
            if (customerUnitId != null) {
                this.setAttribute(telemetryDataMessage, this.config.getString("xml.telemetryDataMessage.customerUnitId.xmlName"), customerUnitId);
            } else if (unitId != 0L) {
                log.debug((Object)("unit " + unitId + " has no customer unit id"));
            }
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.proveoUnitID.active")) {
            this.setAttribute(telemetryDataMessage, this.config.getString("xml.telemetryDataMessage.proveoUnitID.xmlName"), Long.toString(unitId));
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.unitName.active")) {
            this.setAttribute(telemetryDataMessage, this.config.getString("xml.telemetryDataMessage.unitName.xmlName"), unitName);
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.modelType.active")) {
            this.setAttribute(telemetryDataMessage, this.config.getString("xml.telemetryDataMessage.modelType.xmlName"), modelType);
        }
        if (this.config.getBoolean("xml.telemetryDataMessages.eventType.active")) {
            this.setAttribute(telemetryDataMessage, this.config.getString("xml.telemetryDataMessages.eventType.xmlName"), this.config.getString("xml.telemetryDataMessages.eventTypes.notify"));
        }
        Element notifyField = new Element(this.config.getString("xml.telemetryDataMessage.notifyField.xmlName"));
        if (this.sendNotifyWithId(notifyTypeId)) {
            if (notifyFacade == null) {
                TelemetryDataMessage.lookupFacades();
            }
            if (notifyFacade != null) {
                String notificationText = notifyFacade.getNotificationTextById(notifyTypeId);
                if (notificationText != null) {
                    this.setAttribute(notifyField, this.config.getString("xml.telemetryDataMessage.notificationText.xmlName"), notificationText);
                } else {
                    this.setAttribute(notifyField, this.config.getString("xml.telemetryDataMessage.notificationText.xmlName"), this.config.getString("notify.unknown.text") + " " + notifyTypeId);
                }
            }
        } else {
            throw new UnknownNotifyException(notifyTypeId);
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.timestamp.active")) {
            this.setAttribute(notifyField, this.config.getString("xml.telemetryDataMessage.timestamp.xmlName"), timestamp.getTimeString());
        }
        if (remark != null && this.config.getBoolean("xml.telemetryDataMessage.remark.active")) {
            this.setAttribute(notifyField, this.config.getString("xml.telemetryDataMessage.remark.xmlName"), remark);
        }
        telemetryDataMessage.addContent((Content)notifyField);
        this.setDocType();
        this.doc.setRootElement(telemetryDataMessage);
    }

    public TelemetryDataMessage(NotificationDTO notificationDTO) throws UnknownNotifyException {
        this.eventType = Enums.EventType.NOTIFY;
        long historyId = notificationDTO.getId();
        long notifyTypeId = notificationDTO.getMessageId();
        TDITimestamp timestamp = new TDITimestamp(notificationDTO.getReceiveTime());
        String remark = notificationDTO.getRemark();
        long unitId = notificationDTO.getUnitId();
        String customerUnitId = notificationDTO.getUnitModel().getCustomerUnitId();
        String unitName = notificationDTO.getUnitName();
        String modelType = notificationDTO.getUnitModel().getModelType();
        Element telemetryDataMessage = new Element(this.config.getString("xml.telemetryDataMessage.xmlName"));
        this.setAttribute(telemetryDataMessage, this.config.getString("xml.telemetryDataMessage.messageId.xmlName"), Long.toString(historyId));
        if (this.config.getBoolean("xml.telemetryDataMessage.customerUnitId.active")) {
            if (customerUnitId != null) {
                this.setAttribute(telemetryDataMessage, this.config.getString("xml.telemetryDataMessage.customerUnitId.xmlName"), customerUnitId);
            } else if (unitId != 0L) {
                log.debug((Object)("unit " + unitId + " has no customer unit id"));
            }
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.proveoUnitID.active")) {
            this.setAttribute(telemetryDataMessage, this.config.getString("xml.telemetryDataMessage.proveoUnitID.xmlName"), Long.toString(unitId));
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.unitName.active")) {
            this.setAttribute(telemetryDataMessage, this.config.getString("xml.telemetryDataMessage.unitName.xmlName"), unitName);
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.modelType.active")) {
            this.setAttribute(telemetryDataMessage, this.config.getString("xml.telemetryDataMessage.modelType.xmlName"), modelType);
        }
        if (this.config.getBoolean("xml.telemetryDataMessages.eventType.active")) {
            this.setAttribute(telemetryDataMessage, this.config.getString("xml.telemetryDataMessages.eventType.xmlName"), this.config.getString("xml.telemetryDataMessages.eventTypes.notify"));
        }
        Element notifyField = new Element(this.config.getString("xml.telemetryDataMessage.notifyField.xmlName"));
        if (this.sendNotifyWithId(notifyTypeId)) {
            if (notifyFacade == null) {
                TelemetryDataMessage.lookupFacades();
            }
            if (notifyFacade != null) {
                String notificationText = notifyFacade.getNotificationTextById(notifyTypeId);
                if (notificationText != null) {
                    this.setAttribute(notifyField, this.config.getString("xml.telemetryDataMessage.notificationText.xmlName"), notificationText);
                } else {
                    this.setAttribute(notifyField, this.config.getString("xml.telemetryDataMessage.notificationText.xmlName"), this.config.getString("notify.unknown.text") + " " + notifyTypeId);
                }
            }
        } else {
            throw new UnknownNotifyException(notifyTypeId);
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.timestamp.active")) {
            this.setAttribute(notifyField, this.config.getString("xml.telemetryDataMessage.timestamp.xmlName"), timestamp.getTimeString());
        }
        if (remark != null && this.config.getBoolean("xml.telemetryDataMessage.remark.active")) {
            this.setAttribute(notifyField, this.config.getString("xml.telemetryDataMessage.remark.xmlName"), remark);
        }
        telemetryDataMessage.addContent((Content)notifyField);
        this.setDocType();
        this.doc.setRootElement(telemetryDataMessage);
    }

    private boolean sendNotifyWithId(long id) {
        long[] ids = this.config.getLongArray("notify.messageIdList");
        if (ids.length == 1) {
            if (ids[0] == -1L) {
                return false;
            }
            if (ids[0] == 0L) {
                return true;
            }
        }
        for (long l : ids) {
            if (l != id) continue;
            return true;
        }
        return false;
    }

    private Point calculateGaussKrueger(double b, double l) {
        double metersPerDegreeX = this.config.getDouble("gausskrueger.metersPerDegreeX");
        double metersPerDegreeY = this.config.getDouble("gausskrueger.metersPerDegreeY");
        double b0 = this.config.getDouble("gausskrueger.b0");
        double l0 = this.config.getDouble("gausskrueger.l0");
        double x0 = this.config.getDouble("gausskrueger.x0");
        double y0 = this.config.getDouble("gausskrueger.y0");
        double x = metersPerDegreeX * (b - b0) + x0;
        double y = metersPerDegreeY * (l - l0) + y0;
        return new PointImpl(x, y);
    }

    private double round(double number, int decimals) {
        return (double)Math.round(number * Math.pow(10.0, decimals)) / Math.pow(10.0, decimals);
    }

    public void add(Element element) {
        this.doc.getRootElement().getChildren().add(element);
    }

    public void add(Document doc) {
        doc.getRootElement().getChildren().add(doc.getRootElement());
    }

    private String getStateModelById(long stateModelID, ResourceBundle resourceBundle) throws UnknownStateModelException {
        try {
            return resourceBundle.getString(this.config.getString("resource.stateModelString") + stateModelID);
        }
        catch (MissingResourceException e) {
            throw new UnknownStateModelException("state model " + stateModelID + " is unknown");
        }
    }

    private String getStateById(long stateID, ResourceBundle resourceBundle) throws UnknownStateException {
        try {
            String stateString = resourceBundle.getString(this.config.getString("resource.stateString") + stateID);
            return stateString;
        }
        catch (MissingResourceException e) {
            throw new UnknownStateException("state " + stateID + " is unknown");
        }
    }

    public static void main(String[] args) {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        double b = 0.0;
        double l = 0.0;
        TelemetryDataMessage msg = new TelemetryDataMessage();
        do {
            try {
                System.out.println("l: ");
                String input_l = br.readLine();
                if (input_l != null && input_l.trim().length() > 0) {
                    l = Double.parseDouble(input_l);
                }
                System.out.println("b: ");
                String input_b = br.readLine();
                if (input_b != null && input_b.trim().length() > 0) {
                    b = Double.parseDouble(input_b);
                }
                Point gk = msg.calculateGaussKrueger(b, l);
                System.out.println("x = " + gk.getX());
                System.out.println("y = " + gk.getY());
                System.out.println();
            }
            catch (NumberFormatException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
        } while (b != 0.0 && l != 0.0);
    }

    public Enums.EventType getEventType() {
        return this.eventType;
    }

    static {
        TelemetryDataMessage.lookupFacades();
    }
}

