/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.telemetryData.handler;

import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.datamodel.notify.NotifyCache;
import de.proveo.wwt.datamodel.notify.NotifyHistory;
import de.proveo.wwt.logic.ejb.dataIn.notify.NotifyFacadeLocal;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.MessageNotSentException;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.TOWhileSyncException;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.TooMuchDataException;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.UnknownNotifyException;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.handler.AbstractHandler;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.Enums;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.Range;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.TDIConfiguration;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.TDITimestamp;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.UnitHelper;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.BeginStockPart;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.EndStockPart;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.TelemetryDataMessage;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.TelemetryDataMessages;
import de.proveo.wwt.logic.web.data.fastlanereader.TelemetryFastLaneReader;
import de.proveo.wwt.logic.web.historyData.dto.NotificationDTO;
import java.util.Iterator;
import java.util.List;
import javax.ejb.FinderException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NotifyHandler
extends AbstractHandler {
    private static final Log log = LogFactory.getLog(NotifyHandler.class);
    private TDIConfiguration config = TDIConfiguration.getInstance();
    private static NotifyHandler notifyHandler = null;
    private boolean discardOldMessages = false;
    private boolean synchronizing = false;
    private long lastSentMessageId = -1L;
    private NotifyFacadeLocal notifyFacade;
    private TelemetryFastLaneReader fastLaneTelemetry = new TelemetryFastLaneReader();

    private NotifyHandler() {
        try {
            InitialContext ctx = new InitialContext();
            this.notifyFacade = (NotifyFacadeLocal)ctx.lookup("rts/NotifyFacade/local");
        }
        catch (NamingException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
    }

    public static NotifyHandler getInstance() {
        if (notifyHandler == null) {
            notifyHandler = new NotifyHandler();
        }
        return notifyHandler;
    }

    @Override
    public void handleEvent(SerializableEventWrapper wrapper) throws MessageNotSentException {
        log.debug((Object)"handle event");
        NotifyHistory notifyHistory = null;
        if (wrapper.get_historyValue() instanceof NotifyHistory) {
            notifyHistory = (NotifyHistory)wrapper.get_historyValue();
        }
        if (notifyHistory != null) {
            boolean sendData = UnitHelper.isSendData(notifyHistory.getUnitId());
            if (sendData) {
                try {
                    TelemetryDataMessage xmlMsg = new TelemetryDataMessage(notifyHistory);
                    long messageID = notifyHistory.getId();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("handleEvent() - messageId: " + messageID + " unitId: " + notifyHistory.getUnitId()));
                    }
                    this.sendTextMessage(xmlMsg.toString());
                }
                catch (UnknownNotifyException e) {
                    log.debug((Object)("don't send unknown notify:" + e.getNotifyMessageID()));
                }
                catch (Exception e) {
                    log.error((Object)"runs into", (Throwable)e);
                    throw new MessageNotSentException();
                }
            } else if (log.isTraceEnabled()) {
                log.trace((Object)("status event " + notifyHistory.getId() + " not sent for unit: " + notifyHistory.getUnitId()));
            }
        } else {
            log.error((Object)"notifyHistoryValue is null");
        }
    }

    public void pushCache(long minId) throws TOWhileSyncException {
        block11: {
            try {
                List<NotifyCache> col = this.notifyFacade.getAllUnitEventsFromCacheSortedByHistoryId();
                Iterator it = col.iterator();
                long maxId = 0L;
                while (it.hasNext()) {
                    boolean sendData;
                    NotifyCache notifyCacheValue = (NotifyCache)it.next();
                    Long pk = notifyCacheValue.getHistoryId();
                    if (pk == null || pk <= 0L || !(sendData = UnitHelper.isSendData(notifyCacheValue.getPk().getUnitId()))) continue;
                    if (pk < minId) {
                        minId = pk;
                    }
                    if (pk <= maxId) continue;
                    maxId = pk;
                }
                Range includedData = new Range(minId, maxId);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"beginNotifyStock");
                }
                BeginStockPart beginStockPart = new BeginStockPart(Enums.EventType.NOTIFY);
                this.sendTextMessage(beginStockPart.toString());
                it = col.iterator();
                int maxMessageCount = this.config.getInt("telemetryDataMessage.maxMessageCount");
                while (it.hasNext()) {
                    TelemetryDataMessages xmlMsgs = new TelemetryDataMessages(Enums.EventType.NOTIFY);
                    int count = 0;
                    while (count < maxMessageCount && it.hasNext()) {
                        NotifyCache notifyCacheValue = (NotifyCache)it.next();
                        boolean sendData = UnitHelper.isSendData(notifyCacheValue.getUnitId());
                        if (sendData) {
                            NotifyHistory notifyHistoryValue;
                            Long id = notifyCacheValue.getHistoryId();
                            if (id == null || id <= 0L || (notifyHistoryValue = this.notifyFacade.getNotifyHistoryValue(id)) == null) continue;
                            try {
                                TelemetryDataMessage basicDataMessage = new TelemetryDataMessage(notifyHistoryValue);
                                xmlMsgs.add(basicDataMessage);
                                ++count;
                                this.lastSentMessageId = id;
                            }
                            catch (UnknownNotifyException e) {
                                log.debug((Object)("don't send unknown notify:" + e.getNotifyMessageID()));
                            }
                            continue;
                        }
                        if (!log.isTraceEnabled()) continue;
                        log.trace((Object)("notify event " + notifyCacheValue.getHistoryId() + " not sent for unit: " + notifyCacheValue.getUnitId()));
                    }
                    if (xmlMsgs.isEmpty()) continue;
                    this.sendTextMessage(xmlMsgs.toString());
                }
                this.setSynchronizing(false);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("endNotifyStock: " + includedData));
                }
                EndStockPart endStockPart = new EndStockPart(Enums.EventType.NOTIFY, includedData.getFrom(), includedData.getUntil());
                this.sendTextMessage(endStockPart.toString());
            }
            catch (Exception e) {
                log.error((Object)"runs into", (Throwable)e);
                if (!this.isTimeoutException(e)) break block11;
                throw new TOWhileSyncException("Transaction timed out while synchronization. Synchronization aborted.");
            }
        }
    }

    public long getMaxHistoryId() throws TOWhileSyncException {
        try {
            log.debug((Object)"try getMaxHistoryId...");
            return this.notifyFacade.findNotifyHistoryMaxHistoryId();
        }
        catch (Exception e) {
            if (this.isTimeoutException(e)) {
                throw new TOWhileSyncException("Transaction timed out while syncronize.Syncronize aborded.");
            }
            log.error((Object)"getMaxHistoryId runs into", (Throwable)e);
            return -1L;
        }
    }

    public NotifyHistory getNotifyHistory(long id) throws TOWhileSyncException {
        return this.notifyFacade.findByPrimaryKey(id);
    }

    public TelemetryDataMessages getStockPart(long from, long until) throws TOWhileSyncException {
        long requestedUntil = until;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getNotifyStockPart from " + from + " until " + until));
        }
        long maxHistoryId = this.getMaxHistoryId();
        TelemetryDataMessages xmlMsgs = new TelemetryDataMessages(Enums.EventType.NOTIFY);
        until = requestedUntil;
        int maxMessageCount = this.config.getInt("telemetryDataMessage.maxMessageCount");
        if (until > from + (long)maxMessageCount - 1L) {
            until = from + (long)maxMessageCount - 1L;
        }
        if (until > maxHistoryId) {
            until = maxHistoryId;
        }
        List<NotificationDTO> list = this.fastLaneTelemetry.getNotifyHistory(from, until);
        for (NotificationDTO notificationDTO : list) {
            if (notificationDTO == null) continue;
            try {
                boolean sendData = UnitHelper.isSendData(notificationDTO.getUnitId());
                if (sendData) {
                    xmlMsgs.add(new TelemetryDataMessage(notificationDTO));
                    continue;
                }
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("notify event " + notificationDTO.getId() + " not sent for unit: " + notificationDTO.getUnitId()));
            }
            catch (UnknownNotifyException e) {
                log.debug((Object)("don't send unknown notify:" + e.getNotifyMessageID()));
            }
            catch (Exception e) {
                log.error((Object)"runs into", (Throwable)e);
                if (this.isTimeoutException(e)) {
                    throw new TOWhileSyncException("Transaction timed out while syncronize.Syncronize aborded.");
                }
                log.error((Object)"runs into", (Throwable)e);
            }
        }
        xmlMsgs.setFrom(from);
        xmlMsgs.setUntil(until);
        return xmlMsgs;
    }

    public TelemetryDataMessages getNotifiesForUnit(String unitName, TDITimestamp startTime, TDITimestamp endTime) throws TOWhileSyncException, TooMuchDataException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getNotifiesForUnit for unit " + unitName + " from " + startTime.getTimestamp() + " until " + endTime.getTimestamp()));
        }
        TelemetryDataMessages xmlMsgs = new TelemetryDataMessages(Enums.EventType.NOTIFY);
        try {
            long unitId = UnitHelper.getUnitId(unitName);
            log.debug((Object)("unitId: " + unitId));
            List<NotifyHistory> notifyHistoryCol = this.notifyFacade.findByUnitIdSorted(unitId, startTime.getTimestamp(), endTime.getTimestamp(), true);
            int size = notifyHistoryCol.size();
            log.debug((Object)("notifyHistoryCol.size: " + size));
            int maxMessageCount = this.config.getInt("telemetryDataMessage.maxMessageCount");
            if (size > maxMessageCount) {
                throw new TooMuchDataException();
            }
            for (NotifyHistory notifyHistory : notifyHistoryCol) {
                if (notifyHistory == null) continue;
                try {
                    boolean sendData;
                    if (notifyHistory == null || !(sendData = UnitHelper.isSendData(notifyHistory.getUnitId()))) continue;
                    xmlMsgs.add(new TelemetryDataMessage(notifyHistory));
                }
                catch (Exception e) {
                    log.error((Object)"runs into", (Throwable)e);
                    if (this.isTimeoutException(e)) {
                        throw new TOWhileSyncException("Transaction timed out while synchronization. Synchronization aborted.");
                    }
                    log.error((Object)"runs into", (Throwable)e);
                }
            }
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return xmlMsgs;
    }

    @Override
    public boolean isDiscardOldMessages() {
        return this.discardOldMessages;
    }

    @Override
    public void setDiscardOldMessages(boolean discardOldMessages) {
        this.discardOldMessages = discardOldMessages;
    }

    public boolean isSynchronizing() {
        return this.synchronizing;
    }

    public void setSynchronizing(boolean synchronizing) {
        this.synchronizing = synchronizing;
    }

    @Override
    public long getLastSentMessageId() {
        return this.lastSentMessageId;
    }

    public void setLastSentMessageId(long lastSentMessageId) {
        this.lastSentMessageId = lastSentMessageId;
    }

    public static void undeploy() {
        if (notifyHandler != null) {
            notifyHandler.shutDownQueue();
            notifyHandler = null;
        }
    }
}

