/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.telemetryData;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.MessageDistributor;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.TelemetryDataMessageSenderLocal;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.TelemetryPingTimerLocal;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.TelemetryPingTimerRemote;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.TDIConfiguration;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.Ping;
import java.io.Serializable;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RunAs;
import javax.ejb.CreateException;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.Remote;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.PoolClass;
import org.jboss.ejb3.StrictMaxPool;

@Stateless(name="TelemetryPingTimer")
@Remote(value={TelemetryPingTimerRemote.class})
@Local(value={TelemetryPingTimerLocal.class})
@JndiLocalBinding(localJndiBinding="rts/TelemetryPingTimer")
@JndiRemoteBinding(remoteJndiBinding="rts/TelemetryPingTimer")
@RunAs(value="nobody")
@PoolClass(value=StrictMaxPool.class, maxSize=30, timeout=10000L)
public class TelemetryPingTimerBean
implements TelemetryPingTimerLocal,
TelemetryPingTimerRemote,
TimedObject {
    private static final Log log = LogFactory.getLog(TelemetryPingTimerBean.class);
    private TDIConfiguration config = TDIConfiguration.getInstance();
    private static final String INFO = "PingTimer TelemetryData";
    private Timer timer = null;
    private TimerService timerService;
    @EJB
    private TelemetryDataMessageSenderLocal messageSender = null;
    @Resource
    private SessionContext sessionContext;
    private final int MAX_ERROR_COUNT = 3;

    @PostConstruct
    public void ejbCreate() throws CreateException {
        this.timerService = this.sessionContext.getTimerService();
    }

    @Override
    @Business(viewType="local")
    public void ejbRemove() {
        log.info((Object)"ejbReomve() invoked in BasicDataPingTimerBean");
    }

    @Override
    @Business(viewType="both")
    public void createTimer(int interval) {
        log.debug((Object)"createTimer() in BasicDataPingTimerBean");
        try {
            this.timer = this.timerService.createTimer(1000L * (long)interval, 1000L * (long)interval, (Serializable)((Object)INFO));
        }
        catch (Exception ex) {
            log.error((Object)"runs into", (Throwable)ex);
        }
    }

    @Override
    @Business(viewType="both")
    public void cancelOldTimers() {
        log.debug((Object)"cancelOldTimers()s in BasicDataPingTimerBean");
        Collection timers = this.timerService.getTimers();
        for (Timer tempTimer : timers) {
            if (!INFO.equals(tempTimer.getInfo())) continue;
            tempTimer.cancel();
        }
    }

    @Override
    @Business(viewType="both")
    public void stop() {
        if (this.timer != null) {
            try {
                this.timer.cancel();
                log.debug((Object)"pingTimer of TelemetryData stopped");
            }
            catch (NoSuchObjectLocalException e) {
                log.debug((Object)"timer is already canceled");
            }
        }
        this.cancelOldTimers();
    }

    @Override
    @Business(viewType="local")
    @PermitAll
    public void ejbTimeout(Timer timer) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("ejbTimeout() in TelemetryData. " + this));
            if (this.timer != timer) {
                log.debug((Object)("timer:      " + timer));
                log.debug((Object)("Client.getTimer(): " + timer));
            }
        }
        this.sendPingMessage();
    }

    @PermitAll
    protected void sendPingMessage() {
        Ping ping = new Ping();
        this.messageSender.sendTextMessage(ping.toString());
        log.debug((Object)"ping message sent");
        log.debug((Object)"check if telemetryData has received ping");
        if (!this.config.isPingReceived()) {
            this.config.incPingErrorCount();
            log.debug((Object)("sendPingMessage() - errorCount: " + this.config.getPingErrorCount()));
        } else {
            this.config.setPingErrorCount(0);
        }
        if (this.config.getPingErrorCount() >= 3) {
            log.debug((Object)"errorCount >= MAX_ERROR_COUNT -> reconnect");
            this.unregisterClient();
        }
        this.config.setPingReceived(false);
    }

    @Override
    @Business(viewType="both")
    public void ping() {
        log.debug((Object)"received ping");
        this.config.setPingReceived(true);
    }

    @Override
    @Business(viewType="both")
    public void unregisterClient() {
        log.info((Object)"unregisterClient()");
        MessageDistributor.getInstance().setIgnoreMessages(true);
        this.stop();
        this.config.setPingErrorCount(0);
        this.messageSender.removeAllMessages();
        this.config.setClientRegistered(false);
        log.debug((Object)"Client is un-registered.");
    }
}

