/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.telemetryData;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.wwt.logic.app.util.Stopwatch;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.MessageDistributor;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.TelemetryDataMessageSenderLocal;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.TelemetryDataRegistrationLocal;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.TelemetryDataRegistrationRemote;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.TelemetryDataStockLocal;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.TelemetryPingTimerLocal;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.TOWhileSyncException;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.TDIConfiguration;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.Registered;
import javax.annotation.PostConstruct;
import javax.ejb.CreateException;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Stateless(name="TelemetryDataRegistration")
@Remote(value={TelemetryDataRegistrationRemote.class})
@Local(value={TelemetryDataRegistrationLocal.class})
@JndiLocalBinding(localJndiBinding="rts/TelemetryDataRegistration")
@JndiRemoteBinding(remoteJndiBinding="rts/TelemetryDataRegistration")
public class TelemetryDataRegistrationBean
implements TelemetryDataRegistrationLocal,
TelemetryDataRegistrationRemote {
    private static final Log log = LogFactory.getLog(TelemetryDataRegistrationBean.class);
    private TDIConfiguration config = TDIConfiguration.getInstance();
    @EJB
    private TelemetryDataStockLocal stockBean = null;
    @EJB
    private TelemetryDataMessageSenderLocal messageSender = null;
    private static boolean registrationRunning = false;
    @EJB
    private TelemetryPingTimerLocal pingTimer = null;

    @PostConstruct
    public void ejbCreate() throws CreateException {
    }

    @Override
    @Business(viewType="both")
    public void register(long lastGeo, long lastState, long lastNotify) throws TOWhileSyncException {
        Stopwatch stopwatch = new Stopwatch(this.getClass(), "register");
        stopwatch.start("register");
        if (!registrationRunning) {
            registrationRunning = true;
            if (this.config.isTelemetryDataActive()) {
                if (this.config.isClientRegistered()) {
                    log.debug((Object)"Already a client registered! call unregister()!!!");
                    this.unregister();
                }
                if (!MessageDistributor.getInstance().isStopped()) {
                    log.debug((Object)"MessageDistributor is started! Stop it before synchronizing!");
                    MessageDistributor.getInstance().stop();
                }
                this.messageSender.sendTextMessage(new Registered().toString());
                if (log.isInfoEnabled()) {
                    StringBuilder buf = new StringBuilder("register() -");
                    if (this.config.getBoolean("geo.active")) {
                        buf.append(" lastGeo=");
                        buf.append(lastGeo);
                    }
                    if (this.config.getBoolean("state.active")) {
                        buf.append(" lastState=");
                        buf.append(lastState);
                    }
                    if (this.config.getBoolean("notify.active")) {
                        buf.append(" lastNotify=");
                        buf.append(lastNotify);
                    }
                    log.info((Object)buf.toString());
                }
                if (this.config.getBoolean("geo.active") && lastGeo != -2L) {
                    stopwatch.start("synchronizeGeo");
                    this.stockBean.synchronizeGeo(lastGeo);
                    stopwatch.stop("synchronizeGeo", true);
                }
                if (this.config.getBoolean("state.active") && lastState != -2L) {
                    stopwatch.start("synchronizeState");
                    this.stockBean.synchronizeState(lastState);
                    stopwatch.stop("synchronizeState", true);
                }
                if (this.config.getBoolean("notify.active") && lastNotify != -2L) {
                    stopwatch.start("synchronizeNotify");
                    this.stockBean.synchronizeNotify(lastNotify);
                    stopwatch.stop("synchronizeNotify", true);
                }
                MessageDistributor.getInstance().setIgnoreMessages(false);
                MessageDistributor.getInstance().start();
                log.debug((Object)"start ping timer");
                this.pingTimer.createTimer(this.config.getInt("ping.interval"));
                this.config.setClientRegistered(true);
                log.info((Object)"Client is registered.");
            } else {
                log.warn((Object)"Client tried to register, but telemetry data interface is not active!");
            }
            registrationRunning = false;
        } else {
            log.debug((Object)"registration is already running");
        }
        stopwatch.stop("register", true);
    }

    @Override
    @Business(viewType="both")
    public void unregister() {
        log.info((Object)"unregister()");
        registrationRunning = false;
        MessageDistributor.getInstance().setIgnoreMessages(true);
        this.pingTimer.stop();
        this.messageSender.removeAllMessages();
        this.config.setClientRegistered(false);
        log.debug((Object)"Client is un-registered.");
    }

    @Override
    @Business(viewType="both")
    public boolean isRegistered() {
        return this.config.isClientRegistered();
    }
}

