/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.telemetryData;

import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.MessageDistributor;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.MessageHelper;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.TDIConfiguration;
import javax.annotation.PostConstruct;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.EJBException;
import javax.ejb.MessageDriven;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@MessageDriven(name="TelemetryDataMessageReceiverBean", activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="destination", propertyValue="topic/proveoDataProviderTopic"), @ActivationConfigProperty(propertyName="messageSelector", propertyValue="TypeOfInterest='GeoStructHistoryAndCache' or TypeOfInterest='StateEventHistoryAndCache' or TypeOfInterest='InfomanNotifyMessages'"), @ActivationConfigProperty(propertyName="acknowledgeMode", propertyValue="Auto-acknowledge")})
public class TelemetryDataMessageReceiverBean
implements MessageDrivenBean,
MessageListener {
    private static final long serialVersionUID = 4065457407541305560L;
    private static final Log log = LogFactory.getLog(TelemetryDataMessageReceiverBean.class);
    private TDIConfiguration config = TDIConfiguration.getInstance();
    public static final String QUEUE_NAME = "queue/telemetryDataBufferQueue";
    private transient QueueConnectionFactory queueConnectionFactory;
    private transient QueueConnection queueConnection;
    private transient QueueSender queueSender;
    private static long lastPkGdataHistory;

    @PostConstruct
    public void ejbCreate() {
        log.debug((Object)("ejbCreate() -> " + this));
        this.initialize();
    }

    public void ejbRemove() throws EJBException {
        log.debug((Object)("ejbRemove() -> " + this));
        try {
            if (this.queueConnection != null) {
                this.queueConnection.close();
            }
        }
        catch (JMSException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
    }

    public void setMessageDrivenContext(MessageDrivenContext ctx) throws EJBException {
        log.debug((Object)("setMessageDrivenContext() -> " + this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean initialize() {
        if (this.config.isTelemetryDataActive()) {
            MessageDistributor.getInstance();
            try {
                Queue queue;
                InitialContext ctx = new InitialContext();
                this.queueConnectionFactory = (QueueConnectionFactory)ctx.lookup("java:/ConnectionFactory");
                this.queueConnection = this.queueConnectionFactory.createQueueConnection();
                QueueSession queueSession = this.queueConnection.createQueueSession(false, 2);
                try {
                    queue = (Queue)ctx.lookup(QUEUE_NAME);
                }
                catch (NameNotFoundException ex) {
                    log.debug((Object)"queue not found, create new");
                    queue = queueSession.createQueue(QUEUE_NAME);
                    ctx.bind(QUEUE_NAME, (Object)queue);
                }
                try {
                    this.queueConnection.setExceptionListener((ExceptionListener)new ExceptionListenerImpl());
                    this.queueSender = queueSession.createSender(queue);
                    return true;
                }
                catch (Exception e) {
                    log.error((Object)"runs into", (Throwable)e);
                    try {
                        this.queueConnection.close();
                    }
                    catch (JMSException ignored) {
                    }
                    finally {
                        ctx.close();
                    }
                }
            }
            catch (NamingException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
            catch (JMSException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
        }
        return false;
    }

    public void onMessage(Message msg) {
        if (this.config.isTelemetryDataActive()) {
            log.debug((Object)"onMessage()");
            SerializableEventWrapper wrapper = MessageHelper.getSerializableEventWrapper(msg);
            if (MessageHelper.isSendData(msg)) {
                long startTime = System.currentTimeMillis();
                try {
                    if (wrapper.get_typeOfEvent().equals("StateEventHistoryAndCache") && this.config.getBoolean("state.active") || wrapper.get_typeOfEvent().equals("GeoStructHistoryAndCache") && this.config.getBoolean("geo.active") || wrapper.get_typeOfEvent().equals("InfomanNotifyMessages") && this.config.getBoolean("notify.active")) {
                        log.debug((Object)"send message to queue");
                        this.queueSender.send(msg);
                    }
                }
                catch (JMSException e) {
                    log.error((Object)"runs into", (Throwable)e);
                    throw new RuntimeException(e);
                }
                long duration = System.currentTimeMillis() - startTime;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("onMessage() - duration: " + duration + " ms"));
                }
            }
        }
    }

    private class ExceptionListenerImpl
    implements ExceptionListener {
        public static final int NUM_RETRIES = 3;

        private ExceptionListenerImpl() {
        }

        public void onException(JMSException e) {
            for (int i = 0; i < 3; ++i) {
                log.warn((Object)("Connection has problems, trying to re-create it, attempt " + (i + 1) + " ..."));
                try {
                    TelemetryDataMessageReceiverBean.this.queueConnection.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                boolean setupOK = TelemetryDataMessageReceiverBean.this.initialize();
                if (setupOK) {
                    log.info((Object)"Connection re-established");
                    return;
                }
                log.warn((Object)"Re-creating connection failed, retrying ...");
            }
            log.error((Object)"Cannot re-establish connection, giving up ...");
        }
    }
}

