/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.telemetryData;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.TelemetryDataErrorLocal;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.TelemetryDataErrorRemote;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.TelemetryDataMessageSenderLocal;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.TDIConfiguration;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.TDITimestamp;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.ErrorMessage;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.ejb.CreateException;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.PoolClass;
import org.jboss.ejb3.StrictMaxPool;

@Stateless(name="TelemetryDataError")
@Remote(value={TelemetryDataErrorRemote.class})
@Local(value={TelemetryDataErrorLocal.class})
@JndiLocalBinding(localJndiBinding="rts/TelemetryDataError")
@JndiRemoteBinding(remoteJndiBinding="rts/TelemetryDataError")
@PoolClass(value=StrictMaxPool.class, maxSize=30, timeout=10000L)
public class TelemetryDataErrorBean
implements TelemetryDataErrorLocal,
TelemetryDataErrorRemote {
    private static final Log log = LogFactory.getLog(TelemetryDataErrorBean.class);
    private TDIConfiguration config = TDIConfiguration.getInstance();
    @EJB
    private TelemetryDataMessageSenderLocal messageSender = null;
    private HashMap<String, Integer> stateErrors = new HashMap();
    private HashMap<String, Integer> geoErrors = new HashMap();
    private HashMap<String, Integer> notifyErrors = new HashMap();

    @PostConstruct
    public void ejbCreate() throws CreateException {
    }

    @Override
    @Business(viewType="both")
    public void sendErrorMessage(ErrorMessage errMsg) {
        log.debug((Object)("sendErrorMessage: " + errMsg.toString()));
        this.messageSender.sendTextMessage(errMsg.toString());
    }

    @Override
    @Business(viewType="local")
    public int errStateStock(String whichData, String errorText) {
        log.debug((Object)("errStateStock - whichData: " + whichData + " errorText: " + errorText));
        this.stateErrors = this.incValue(this.stateErrors, whichData);
        int count = this.stateErrors.get(whichData);
        return count;
    }

    @Override
    @Business(viewType="local")
    public int errGeoStock(String whichData, String errorText) {
        log.debug((Object)("errGeoStock - whichData: " + whichData + " errorText: " + errorText));
        this.geoErrors = this.incValue(this.geoErrors, whichData);
        int count = this.geoErrors.get(whichData);
        return count;
    }

    @Override
    @Business(viewType="local")
    public int errNotifyStock(String whichData, String errorText) {
        log.debug((Object)("errNotifyStock - whichData: " + whichData + " errorText: " + errorText));
        this.notifyErrors = this.incValue(this.notifyErrors, whichData);
        int count = this.notifyErrors.get(whichData);
        return count;
    }

    @Override
    @Business(viewType="local")
    public int errStatesForUnit(String unitId, TDITimestamp startTime, TDITimestamp endTime, String errorText) {
        log.debug((Object)("errStatesForUnit - unitId: " + unitId + " startTime: " + startTime + " endTime: " + endTime + " errorText: " + errorText));
        String whichData = unitId + "/" + startTime + "-" + endTime;
        this.stateErrors = this.incValue(this.stateErrors, whichData);
        int count = this.stateErrors.get(whichData);
        return count;
    }

    @Override
    @Business(viewType="local")
    public int errGeosForUnit(String unitId, TDITimestamp startTime, TDITimestamp endTime, String errorText) {
        log.debug((Object)("errGeosForUnit - unitId: " + unitId + " startTime: " + startTime + " endTime: " + endTime + " errorText: " + errorText));
        String whichData = unitId + "/" + startTime + "-" + endTime;
        this.geoErrors = this.incValue(this.geoErrors, whichData);
        int count = this.geoErrors.get(whichData);
        return count;
    }

    @Override
    @Business(viewType="local")
    public int errNotifiesForUnit(String unitId, TDITimestamp startTime, TDITimestamp endTime, String errorText) {
        log.debug((Object)("errNotifiesForUnit - unitId: " + unitId + " startTime: " + startTime + " endTime: " + endTime + " errorText: " + errorText));
        String whichData = unitId + "/" + startTime + "-" + endTime;
        this.notifyErrors = this.incValue(this.notifyErrors, whichData);
        int count = this.notifyErrors.get(whichData);
        return count;
    }

    private HashMap<String, Integer> incValue(HashMap<String, Integer> hashMap, String whichData) {
        if (!hashMap.containsKey(whichData)) {
            hashMap.put(whichData, 0);
        }
        hashMap.put(whichData, new Integer(hashMap.get(whichData) + 1));
        return hashMap;
    }
}

