/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.scheduledjob;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.wwt.datamodel.custom.CustomScript;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocal;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationParameterNotFoundException;
import de.proveo.wwt.logic.ejb.general.custom.CustomScriptFacadeLocal;
import de.proveo.wwt.logic.ejb.general.custom.ScriptLoader;
import de.proveo.wwt.logic.ejb.interfaces.scheduledjob.ScheduledJob;
import de.proveo.wwt.logic.ejb.interfaces.scheduledjob.ScheduledJobInfo;
import de.proveo.wwt.logic.ejb.interfaces.scheduledjob.ScheduledJobTimerLocal;
import de.proveo.wwt.logic.ejb.interfaces.scheduledjob.ScheduledJobTimerRemote;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RunAs;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronExpression;

@Stateless(name="ScheduledJobTimer")
@Remote(value={ScheduledJobTimerRemote.class})
@Local(value={ScheduledJobTimerLocal.class})
@JndiLocalBinding(localJndiBinding="rts/ScheduledJobTimer")
@JndiRemoteBinding(remoteJndiBinding="rts/ScheduledJobTimer")
@RunAs(value="nobody")
public class ScheduledJobTimerBean
implements ScheduledJobTimerLocal,
ScheduledJobTimerRemote {
    private static final Log log = LogFactory.getLog(ScheduledJobTimerBean.class);
    private static final String CONF_PARAM_PREFIX = "de.proveo.scheduledjob.";
    private static final String CONF_PARAM_JOBS = "jobs";
    private static final String CONF_PARAM_NAME = ".name";
    private static final String CONF_PARAM_EXPR = ".cronexpr";
    private static final ScriptLoader<ScheduledJob> scriptLoader = new ScriptLoader();
    @EJB
    private ConfigurationLocal configurationLocal;
    @EJB
    private CustomScriptFacadeLocal customScriptFacade;
    @Resource
    TimerService timerService;

    @PostConstruct
    public void init() {
        log.info((Object)"init()");
    }

    @Override
    @Business(viewType="both")
    public void createJobs() {
        log.info((Object)"createJobs");
        try {
            if (this.configurationLocal.isConfigured("de.proveo.scheduledjob.jobs")) {
                String[] jobs = this.configurationLocal.getParameterArray("de.proveo.scheduledjob.jobs");
                log.info((Object)("found " + jobs.length + " jobs"));
                for (int i = 0; i < jobs.length; ++i) {
                    String job = jobs[i];
                    log.info((Object)("job: " + job));
                    String jobName = this.configurationLocal.getParameter(CONF_PARAM_PREFIX + job + CONF_PARAM_NAME);
                    log.info((Object)("jobName: " + jobName));
                    String cronExpr = this.configurationLocal.getParameter(CONF_PARAM_PREFIX + job + CONF_PARAM_EXPR);
                    log.info((Object)("cronExpr: " + cronExpr));
                    ScheduledJobInfo jobInfo = new ScheduledJobInfo(jobName, cronExpr);
                    log.info((Object)("jobInfo: " + jobInfo));
                    this.createTimer(jobInfo);
                }
            }
        }
        catch (ConfigurationParameterNotFoundException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
    }

    @Timeout
    @PermitAll
    public void executeJob(Timer timer) {
        log.info((Object)("executeJob() " + timer));
        Serializable obj = timer.getInfo();
        if (!(obj instanceof ScheduledJobInfo)) {
            throw new IllegalArgumentException("No ScheduledJobInfo: " + obj.getClass());
        }
        ScheduledJobInfo jobInfo = (ScheduledJobInfo)obj;
        log.info((Object)("got ScheduledJobInfo: " + jobInfo));
        this.runScript(jobInfo.getName());
        this.createTimer(jobInfo);
    }

    private void createTimer(ScheduledJobInfo jobInfo) {
        log.info((Object)("createTimer() " + jobInfo));
        Date now = new Date();
        Date date = this.getNextValidDate(jobInfo.getCronExpression());
        log.info((Object)("curr date: " + now));
        log.info((Object)("exec date: " + date));
        if (date != null) {
            log.info((Object)"timerService.createTimer(date, jobInfo);");
            this.timerService.createTimer(date, (Serializable)jobInfo);
        } else {
            log.info((Object)"don't create timer! no valid date");
        }
    }

    private void runScript(String scriptName) {
        log.info((Object)("runScript('" + scriptName + "')"));
        List<CustomScript> customScripts = this.customScriptFacade.getActiveScriptsByEntryPointForAllUnits(scriptName);
        log.debug((Object)("found " + customScripts.size() + " active custom scripts for entry point " + scriptName));
        for (CustomScript customScript : customScripts) {
            try {
                ScheduledJob scheduledJob = scriptLoader.loadScript(customScript);
                scheduledJob.executeJob();
            }
            catch (Exception e) {
                log.error((Object)"runs into", (Throwable)e);
            }
        }
        log.info((Object)("runScript('" + scriptName + "') finished"));
    }

    public Date getNextValidDate(String cronExpression) {
        try {
            CronExpression cronExpr = new CronExpression(cronExpression);
            Date nextValidTime = cronExpr.getNextValidTimeAfter(new Date());
            return nextValidTime;
        }
        catch (ParseException e) {
            log.debug((Object)"runs into", (Throwable)e);
            throw new IllegalArgumentException("invalid cron expression: " + cronExpression);
        }
    }
}

