/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.maintenance.xml;

import de.proveo.wwt.datamodel.notify.NotifyHistory;
import de.proveo.wwt.logic.ejb.dataIn.notify.NotifyFacadeLocal;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.MIConfiguration;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.MITimestamp;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.exceptions.UnknownNotifyException;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.jaxb.server.MaintServerMsg;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.xml.ServerMsgWrapper;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.UnitHelper;
import de.proveo.wwt.logic.web.historyData.dto.NotificationDTO;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NotifyMessageWrapper
extends ServerMsgWrapper {
    private static final Log log = LogFactory.getLog(NotifyMessageWrapper.class);
    private MIConfiguration config = MIConfiguration.getInstance();

    public NotifyMessageWrapper() {
    }

    public NotifyMessageWrapper(NotifyHistory notifyHistoryValue) throws UnknownNotifyException {
        NotifyFacadeLocal notifyFacade = null;
        try {
            InitialContext ctx = new InitialContext();
            notifyFacade = (NotifyFacadeLocal)ctx.lookup("rts/NotifyFacade/local");
        }
        catch (NamingException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        long historyId = notifyHistoryValue.getId();
        long notifyTypeId = notifyHistoryValue.getMessageId();
        MITimestamp timestamp = new MITimestamp(notifyHistoryValue.getReceiveTime());
        String remark = notifyHistoryValue.getRemark();
        long unitId = notifyHistoryValue.getUnitId();
        String customerUnitId = UnitHelper.getCustomerUnitId(unitId);
        String unitName = UnitHelper.getUnitName(unitId);
        MaintServerMsg.NotifyMessage.NotifyField notifyField = this.objectFactory.createMaintServerMsgNotifyMessageNotifyField();
        if (this.sendNotifyWithId(notifyTypeId)) {
            if (notifyFacade != null) {
                String notificationText = notifyFacade.getNotificationTextById(notifyTypeId);
                if (notificationText != null) {
                    notifyField.setNotificationText(notificationText);
                } else {
                    notifyField.setNotificationText(this.config.getString("notify.unknown.text") + " " + notifyTypeId);
                }
            }
        } else {
            throw new UnknownNotifyException(notifyTypeId);
        }
        notifyField.setTimestamp(timestamp.toString());
        notifyField.setRemark(remark);
        MaintServerMsg.NotifyMessage notifyMessage = this.objectFactory.createMaintServerMsgNotifyMessage();
        notifyMessage.setMessageID(historyId);
        notifyMessage.setCustomerID(customerUnitId);
        if (this.config.getBoolean("units.unitId.active")) {
            notifyMessage.setProveoID(unitId);
        }
        if (this.config.getBoolean("units.unitName.active")) {
            notifyMessage.setUnitName(unitName);
        }
        notifyMessage.setNotifyField(notifyField);
        List<MaintServerMsg.NotifyMessage> notifyMessageList = this.serverMsg.getNotifyMessage();
        notifyMessageList.add(notifyMessage);
    }

    public NotifyMessageWrapper(NotificationDTO notificationDTO) throws UnknownNotifyException {
        NotifyFacadeLocal notifyFacade = null;
        try {
            InitialContext ctx = new InitialContext();
            notifyFacade = (NotifyFacadeLocal)ctx.lookup("rts/NotifyFacade/local");
        }
        catch (NamingException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        long historyId = notificationDTO.getId();
        long notifyTypeId = notificationDTO.getMessageId();
        MITimestamp timestamp = new MITimestamp(notificationDTO.getReceiveTime());
        String remark = notificationDTO.getRemark();
        long unitId = notificationDTO.getUnitId();
        String customerUnitId = notificationDTO.getUnitModel().getCustomerUnitId();
        String unitName = notificationDTO.getUnitName();
        MaintServerMsg.NotifyMessage.NotifyField notifyField = this.objectFactory.createMaintServerMsgNotifyMessageNotifyField();
        if (this.sendNotifyWithId(notifyTypeId)) {
            if (notifyFacade != null) {
                String notificationText = notifyFacade.getNotificationTextById(notifyTypeId);
                if (notificationText != null) {
                    notifyField.setNotificationText(notificationText);
                } else {
                    notifyField.setNotificationText(this.config.getString("notify.unknown.text") + " " + notifyTypeId);
                }
            }
        } else {
            throw new UnknownNotifyException(notifyTypeId);
        }
        notifyField.setTimestamp(timestamp.toString());
        notifyField.setRemark(remark);
        MaintServerMsg.NotifyMessage notifyMessage = this.objectFactory.createMaintServerMsgNotifyMessage();
        notifyMessage.setMessageID(historyId);
        notifyMessage.setCustomerID(customerUnitId);
        if (this.config.getBoolean("units.unitId.active")) {
            notifyMessage.setProveoID(unitId);
        }
        if (this.config.getBoolean("units.unitName.active")) {
            notifyMessage.setUnitName(unitName);
        }
        notifyMessage.setNotifyField(notifyField);
        List<MaintServerMsg.NotifyMessage> notifyMessageList = this.serverMsg.getNotifyMessage();
        notifyMessageList.add(notifyMessage);
    }

    private boolean sendNotifyWithId(long id) {
        long[] ids = this.config.getLongArray("notify.messageIdList");
        if (ids.length == 1) {
            if (ids[0] == -1L) {
                return false;
            }
            if (ids[0] == 0L) {
                return true;
            }
        }
        for (long l : ids) {
            if (l != id) continue;
            return true;
        }
        return false;
    }

    public void add(NotifyMessageWrapper wrapper) {
        List<MaintServerMsg.NotifyMessage> notifyMessageList = this.serverMsg.getNotifyMessage();
        List<MaintServerMsg.NotifyMessage> notifyMessagesToAdd = wrapper.getRoot().getNotifyMessage();
        for (MaintServerMsg.NotifyMessage msg : notifyMessagesToAdd) {
            notifyMessageList.add(msg);
        }
    }

    public MaintServerMsg getRoot() {
        return this.serverMsg;
    }

    public boolean isEmpty() {
        return this.serverMsg.getNotifyMessage().isEmpty();
    }

    public long getFrom() {
        return this.serverMsg.getFrom();
    }

    public void setFrom(long from) {
        this.serverMsg.setFrom(from);
    }

    public long getUntil() {
        return this.serverMsg.getUntil();
    }

    public void setUntil(long until) {
        this.serverMsg.setUntil(until);
    }
}

