/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.maintenance.notify;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.wwt.logic.ejb.geo.GdataFacadeLocal;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.MIConfiguration;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.MITimestamp;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.MaintenanceErrorLocal;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.MaintenanceMessageSenderLocal;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.exceptions.TOWhileSyncException;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.exceptions.TooMuchDataException;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.jaxb.server.MaintServerMsg;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.notify.MaintenanceStockLocal;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.notify.MaintenanceStockRemote;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.notify.MessageDistributor;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.notify.NotifyHandler;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.xml.BeginStockPartWrapper;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.xml.EndStockPartWrapper;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.xml.ErrorCodes;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.xml.NotifyMessageWrapper;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.Range;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.SAXDocument;
import javax.annotation.PostConstruct;
import javax.ejb.CreateException;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Stateless(name="MaintenanceStock")
@Remote(value={MaintenanceStockRemote.class})
@Local(value={MaintenanceStockLocal.class})
@JndiLocalBinding(localJndiBinding="rts/MaintenanceStock")
@JndiRemoteBinding(remoteJndiBinding="rts/MaintenanceStock")
public class MaintenanceStockBean
implements MaintenanceStockLocal,
MaintenanceStockRemote {
    private static final Log log = LogFactory.getLog(MaintenanceStockBean.class);
    private MIConfiguration config = MIConfiguration.getInstance();
    @EJB
    private MaintenanceMessageSenderLocal messageSender = null;
    @EJB
    private MaintenanceErrorLocal maintenanceErrorBean = null;
    private GdataFacadeLocal gdataFacadeLocal;

    @PostConstruct
    public void ejbCreate() throws CreateException {
        try {
            InitialContext context = new InitialContext();
            this.gdataFacadeLocal = (GdataFacadeLocal)context.lookup("rts/GdataFacade/local");
        }
        catch (NamingException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
    }

    @Override
    @Business(viewType="both")
    public void requestNotifyStock(String whichData) {
        Range range = new Range(whichData);
        this.requestNotifyStock(range.getFrom(), range.getUntil());
    }

    @Override
    @Business(viewType="both")
    public void requestNotifyStock(long from, long until) {
        log.debug((Object)("requestNotifyStock " + from + "," + until));
        NotifyHandler notifyHandler = NotifyHandler.getInstance();
        try {
            NotifyMessageWrapper stockPart = notifyHandler.getStockPart(from, until);
            this.messageSender.sendTextMessage(stockPart.toString());
        }
        catch (TOWhileSyncException e) {
            log.error((Object)"runs into", (Throwable)e);
            this.maintenanceErrorBean.sendErrorMessage(ErrorCodes.SynchronizationTimeout, "%1s", new SAXDocument(""));
        }
    }

    @Override
    @Business(viewType="both")
    public void requestNotifiesForUnit(String unitName, MITimestamp startTime, MITimestamp endTime) throws TooMuchDataException {
        log.debug((Object)("requestNotifiesForUnit for unit " + unitName + " from " + startTime.getTimestamp() + " until " + endTime.getTimestamp()));
        NotifyHandler notifyHandler = NotifyHandler.getInstance();
        try {
            MaintServerMsg maintServerMsg = notifyHandler.getNotifiesForUnit(unitName, startTime, endTime);
            this.messageSender.sendTextMessage(maintServerMsg.toString());
        }
        catch (TOWhileSyncException e) {
            log.error((Object)"runs into", (Throwable)e);
            this.maintenanceErrorBean.sendErrorMessage(ErrorCodes.SynchronizationTimeout, "%1s", new SAXDocument(""));
        }
    }

    @Override
    @Business(viewType="both")
    public void synchronizeNotify(long lastNotifyId) throws TOWhileSyncException {
        if (log.isInfoEnabled()) {
            log.info((Object)("synchronizeNotify(" + lastNotifyId + ")"));
        }
        MessageDistributor messageDistributor = MessageDistributor.getInstance();
        NotifyHandler notifyHandler = NotifyHandler.getInstance();
        messageDistributor.stop();
        notifyHandler.setSynchronizing(true);
        notifyHandler.setDiscardOldMessages(true);
        String whichData = "";
        long maxHistoryId = notifyHandler.getMaxHistoryId();
        log.debug((Object)("lastMessageId=" + lastNotifyId));
        log.debug((Object)("maxHistoryId=" + maxHistoryId));
        if (lastNotifyId == 0L) {
            log.error((Object)"lastMessageId = 0");
            notifyHandler.pushCache(maxHistoryId);
        } else if (lastNotifyId > -1L) {
            Range includedData = lastNotifyId < maxHistoryId ? new Range(lastNotifyId + 1L, maxHistoryId) : new Range("-1");
            if (log.isDebugEnabled()) {
                log.debug((Object)"beginNotifyStock");
            }
            BeginStockPartWrapper beginStockPart = new BeginStockPartWrapper();
            this.messageSender.sendTextMessage(beginStockPart.toString());
            int maxMessageCount = this.config.getInt("notify.maxMessageCount");
            for (long i = lastNotifyId + 1L; i <= maxHistoryId; i += (long)maxMessageCount) {
                long until = i + (long)maxMessageCount < maxHistoryId ? i + (long)maxMessageCount : maxHistoryId;
                NotifyMessageWrapper stockPart = notifyHandler.getStockPart(i, until);
                String xml = stockPart.toString();
                if (xml.length() > 0 && stockPart.getFrom() != -1L && stockPart.getUntil() != -1L) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("pushTeilBestandNotify: " + xml));
                    }
                    this.messageSender.sendTextMessage(xml);
                    notifyHandler.setLastSentMessageId(stockPart.getUntil());
                    continue;
                }
                log.debug((Object)"TeilBestand is empty");
            }
            notifyHandler.setSynchronizing(false);
            log.info((Object)"notify synchronization completed");
            if (log.isDebugEnabled()) {
                log.debug((Object)("endNotifyStock: " + whichData));
            }
            EndStockPartWrapper endStockPart = new EndStockPartWrapper(includedData.getFrom(), includedData.getUntil());
            this.messageSender.sendTextMessage(endStockPart.toString());
        } else {
            notifyHandler.pushCache(maxHistoryId);
        }
    }
}

