/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.maintenance;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.MIConfiguration;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.MaintenanceMessageSenderLocal;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.MaintenancePingTimerLocal;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.MaintenanceRegistrationLocal;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.MaintenanceRegistrationRemote;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.exceptions.TOWhileSyncException;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.notify.MaintenanceStockLocal;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.notify.MessageDistributor;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.xml.RegisteredWrapper;
import javax.annotation.PostConstruct;
import javax.ejb.CreateException;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Stateless(name="MaintenanceRegistration")
@Remote(value={MaintenanceRegistrationRemote.class})
@Local(value={MaintenanceRegistrationLocal.class})
@JndiLocalBinding(localJndiBinding="rts/MaintenanceRegistration")
@JndiRemoteBinding(remoteJndiBinding="rts/MaintenanceRegistration")
public class MaintenanceRegistrationBean
implements MaintenanceRegistrationLocal,
MaintenanceRegistrationRemote {
    private static final Log log = LogFactory.getLog(MaintenanceRegistrationBean.class);
    private MIConfiguration config = MIConfiguration.getInstance();
    @EJB
    private MaintenanceStockLocal stockBean = null;
    @EJB
    private MaintenanceMessageSenderLocal messageSender = null;
    private static boolean registrationRunning = false;
    @EJB
    private MaintenancePingTimerLocal pingTimer = null;

    @PostConstruct
    public void ejbCreate() throws CreateException {
    }

    @Override
    @Business(viewType="both")
    public void register(long lastNotify) throws TOWhileSyncException {
        if (!registrationRunning) {
            registrationRunning = true;
            if (this.config.isMaintenanceActive()) {
                if (this.config.isClientRegistered()) {
                    log.debug((Object)"Already a client registered! call unregister()!!!");
                    this.unregister();
                }
                if (!this.config.isMessageSenderStopped()) {
                    log.debug((Object)"MessageDistributor is started! Stop it before synchronizing!");
                    MessageDistributor.getInstance().stop();
                }
                RegisteredWrapper registered = new RegisteredWrapper();
                this.messageSender.sendTextMessage(registered.toString());
                if (log.isInfoEnabled()) {
                    StringBuilder buf = new StringBuilder("register() -");
                    if (this.config.getBoolean("notify.active")) {
                        buf.append(" lastNotify=");
                        buf.append(lastNotify);
                    }
                    log.info((Object)buf.toString());
                }
                if (this.config.getBoolean("notify.active") && lastNotify != -2L) {
                    this.stockBean.synchronizeNotify(lastNotify);
                }
                this.config.setIgnoreMessages(false);
                MessageDistributor.getInstance().start();
                log.debug((Object)"start ping timer");
                this.pingTimer.createTimer(this.config.getInt("ping.interval"));
                this.config.setClientRegistered(true);
                log.debug((Object)"Client is registered.");
            } else {
                log.warn((Object)"Client tried to register, but maintenance interface is not active!");
            }
            registrationRunning = false;
        } else {
            log.debug((Object)"registration is already running");
        }
    }

    @Override
    @Business(viewType="both")
    public void unregister() {
        log.info((Object)"unregister()");
        this.config.setIgnoreMessages(true);
        this.pingTimer.stop();
        this.messageSender.removeAllMessages();
        this.config.setClientRegistered(false);
        log.debug((Object)"Client is un-registered.");
    }

    @Override
    @Business(viewType="both")
    public boolean isRegistered() {
        return this.config.isClientRegistered();
    }
}

