/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.maintenance;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.MIConfiguration;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.MITimestamp;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.MaintenanceErrorLocal;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.MaintenanceErrorRemote;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.MaintenanceMessageSenderLocal;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.xml.ErrorCodes;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.xml.ErrorWrapper;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.SAXDocument;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.ejb.CreateException;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.PoolClass;
import org.jboss.ejb3.StrictMaxPool;

@Stateless(name="MaintenanceError")
@Remote(value={MaintenanceErrorRemote.class})
@Local(value={MaintenanceErrorLocal.class})
@JndiLocalBinding(localJndiBinding="rts/MaintenanceError")
@JndiRemoteBinding(remoteJndiBinding="rts/MaintenanceError")
@PoolClass(value=StrictMaxPool.class, maxSize=30, timeout=10000L)
public class MaintenanceErrorBean
implements MaintenanceErrorLocal,
MaintenanceErrorRemote {
    private static final Log log = LogFactory.getLog(MaintenanceErrorBean.class);
    private MIConfiguration config = MIConfiguration.getInstance();
    @EJB
    private MaintenanceMessageSenderLocal messageSender = null;
    private HashMap<String, Integer> notifyErrors = new HashMap();

    @PostConstruct
    public void ejbCreate() throws CreateException {
    }

    @Override
    @Business(viewType="both")
    public void sendErrorMessage(ErrorCodes errorCode, String errorMessageText, SAXDocument originalXMLDoc) {
        Long msgId = null;
        ErrorWrapper error = new ErrorWrapper(msgId, errorCode, errorMessageText);
        this.messageSender.sendTextMessage(error.toString());
    }

    @Override
    @Business(viewType="both")
    public String getErrorMessage(ErrorCodes errorCode, String errorMessageText, SAXDocument originalXMLDoc) {
        Long msgId = null;
        ErrorWrapper error = new ErrorWrapper(msgId, errorCode, errorMessageText);
        return error.toString();
    }

    @Override
    @Business(viewType="local")
    public int errNotifyStock(String whichData, String errorText) {
        log.debug((Object)("errNotifyStock - whichData: " + whichData + " errorText: " + errorText));
        this.notifyErrors = this.incValue(this.notifyErrors, whichData);
        int count = this.notifyErrors.get(whichData);
        return count;
    }

    @Override
    @Business(viewType="local")
    public int errNotifiesForUnit(String unitId, MITimestamp startTime, MITimestamp endTime, String errorText) {
        log.debug((Object)("errNotifiesForUnit - unitId: " + unitId + " startTime: " + startTime + " endTime: " + endTime + " errorText: " + errorText));
        String whichData = unitId + "/" + startTime + "-" + endTime;
        this.notifyErrors = this.incValue(this.notifyErrors, whichData);
        int count = this.notifyErrors.get(whichData);
        return count;
    }

    private HashMap<String, Integer> incValue(HashMap<String, Integer> hashMap, String whichData) {
        if (!hashMap.containsKey(whichData)) {
            hashMap.put(whichData, 0);
        }
        hashMap.put(whichData, new Integer(hashMap.get(whichData) + 1));
        return hashMap;
    }
}

