/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.fis.standState;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.wwt.datamodel.fis.FISFlight;
import de.proveo.wwt.datamodel.fis.StandStateCache;
import de.proveo.wwt.datamodel.fis.StandStateHistory;
import de.proveo.wwt.logic.ejb.interfaces.fis.FISFacadeLocal;
import de.proveo.wwt.logic.ejb.interfaces.fis.standState.StandStateCacheDAO;
import de.proveo.wwt.logic.ejb.interfaces.fis.standState.StandStateCacheValue;
import de.proveo.wwt.logic.ejb.interfaces.fis.standState.StandStateFacadeLocal;
import de.proveo.wwt.logic.ejb.interfaces.fis.standState.StandStateFacadeRemote;
import de.proveo.wwt.logic.ejb.interfaces.fis.standState.StandStateHistoryDAO;
import de.proveo.wwt.logic.ejb.interfaces.fis.standState.UnknownStandStateException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.ejb.CreateException;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dozer.DozerBeanMapperSingletonWrapper;
import org.dozer.Mapper;

@Stateless(name="StandStateFacade")
@Remote(value={StandStateFacadeRemote.class})
@Local(value={StandStateFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="wwt/StandStateFacade")
@JndiRemoteBinding(remoteJndiBinding="wwt/StandStateFacade")
public class StandStateFacadeBean
implements StandStateFacadeLocal,
StandStateFacadeRemote {
    private static final Log log = LogFactory.getLog(StandStateFacadeBean.class);
    private StandStateCacheDAO standStateCacheDAO;
    private StandStateHistoryDAO standStateHistoryDAO;
    @PersistenceContext(unitName="rts")
    private EntityManager em;
    @EJB
    private FISFacadeLocal fisFacade;
    private Mapper mapper;

    @PostConstruct
    public void ejbCreate() throws CreateException {
        this.standStateCacheDAO = StandStateCacheDAO.newInstance(this.em);
        this.standStateHistoryDAO = StandStateHistoryDAO.newInstance(this.em);
        this.mapper = DozerBeanMapperSingletonWrapper.getInstance();
    }

    @Override
    @Business(viewType="both")
    public StandStateCacheValue setOccupied(String stand, boolean occupied, long beginTime, FISFlight inbFlight, FISFlight outbFlight) {
        log.debug((Object)("setOccupied " + stand + ":" + occupied));
        if (occupied) {
            return this.setStandState(stand, 1010L, 1011L, beginTime, inbFlight, outbFlight);
        }
        return this.setStandState(stand, 1010L, 1012L, beginTime, inbFlight, outbFlight);
    }

    @Override
    @Business(viewType="both")
    public StandStateCacheValue setPlanned(String stand, boolean planned, long beginTime, FISFlight inbFlight, FISFlight outbFlight) {
        log.debug((Object)("setPlanned " + stand + ":" + planned));
        if (planned) {
            return this.setStandState(stand, 1020L, 1021L, beginTime, inbFlight, outbFlight);
        }
        return this.setStandState(stand, 1020L, 1022L, beginTime, inbFlight, outbFlight);
    }

    private StandStateCacheValue setStandState(String stand, long stateModelId, long stateId, long beginTime, FISFlight inbFlight, FISFlight outbFlight) {
        if (stand != null) {
            List<StandStateCache> standStates = this.findStandStatesForStandAndStateModelCache(stand, stateModelId);
            if (standStates.size() == 0) {
                StandStateCache standState = new StandStateCache();
                StandStateCache.PK pk = new StandStateCache.PK(stand, stateModelId);
                standState.setPk(pk);
                standState.setStateId(stateId);
                standState.setBeginTime(beginTime);
                standState.setInbFlight(inbFlight);
                standState.setOutbFlight(outbFlight);
                return this.updateStandState(standState);
            }
            if (standStates.size() == 1) {
                StandStateCache standState = standStates.get(0);
                FISFlight currentFlight = standState.getInbFlight();
                if (this.isUpdateForActualTime(currentFlight, inbFlight, standState)) {
                    standState.setBeginTime(beginTime);
                }
                if (this.isUpdateForActualTime(currentFlight, outbFlight, standState)) {
                    standState.setBeginTime(beginTime);
                }
                if (standState.getStateId() != stateId) {
                    standState.setStateId(stateId);
                    standState.setBeginTime(beginTime);
                }
                standState.setInbFlight(inbFlight);
                standState.setOutbFlight(outbFlight);
                return this.updateStandState(standState);
            }
            log.debug((Object)("stand state for stand " + stand + " and model " + stateModelId + " is ambiguous"));
        }
        return null;
    }

    private StandStateCacheValue updateStandState(StandStateCache standStateCache) {
        StandStateHistory standStateHistory = this.findLatestStandStateHistoryForStandAndStateModel(standStateCache.getPk().getStand(), standStateCache.getPk().getStateModelId());
        if (standStateHistory != null) {
            standStateHistory.setEndTime(standStateCache.getBeginTime());
            this.standStateHistoryDAO.updateEntity(standStateHistory);
        }
        StandStateHistory newStandStateHistory = new StandStateHistory();
        newStandStateHistory.setStand(standStateCache.getPk().getStand());
        newStandStateHistory.setStateModelId(standStateCache.getPk().getStateModelId());
        newStandStateHistory.setStateId(standStateCache.getStateId());
        newStandStateHistory.setBeginTime(standStateCache.getBeginTime());
        newStandStateHistory.setInbFlight(standStateCache.getInbFlight());
        newStandStateHistory.setOutbFlight(standStateCache.getOutbFlight());
        this.standStateHistoryDAO.createEntity(newStandStateHistory);
        standStateCache.setHistoryId(newStandStateHistory.getId());
        this.standStateCacheDAO.updateEntity(standStateCache);
        StandStateCacheValue standStateCacheValue = (StandStateCacheValue)this.mapper.map((Object)standStateCache, StandStateCacheValue.class);
        return standStateCacheValue;
    }

    @Override
    @Business(viewType="both")
    public boolean isStandOccupied(String stand) throws UnknownStandStateException {
        List<StandStateCache> standStates = this.findStandStatesForStandAndStateModelCache(stand, 1010L);
        if (standStates.size() == 0) {
            log.debug((Object)("occupied stand state for stand " + stand + " could not be found"));
            throw new UnknownStandStateException(stand, 1010L);
        }
        if (standStates.size() == 1) {
            StandStateCache standState = standStates.get(0);
            return standState.getStateId() == 1011L;
        }
        log.debug((Object)("occupied stand state for stand " + stand + " is ambiguous"));
        throw new UnknownStandStateException(stand, 1010L);
    }

    @Override
    @Business(viewType="both")
    public boolean isStandPlanned(String stand) throws UnknownStandStateException {
        List<StandStateCache> standStates = this.findStandStatesForStandAndStateModelCache(stand, 1020L);
        if (standStates.size() == 0) {
            log.debug((Object)("planned stand state for stand " + stand + " could not be found"));
            throw new UnknownStandStateException(stand, 1020L);
        }
        if (standStates.size() == 1) {
            StandStateCache standState = standStates.get(0);
            return standState.getStateId() == 1021L;
        }
        log.debug((Object)("planned stand state for stand " + stand + " is ambiguous"));
        throw new UnknownStandStateException(stand, 1020L);
    }

    @Override
    @Business(viewType="both")
    public List<StandStateCache> findAllStandStatesCache() {
        List<StandStateCache> standStates = this.standStateCacheDAO.findAllStandStates();
        return standStates;
    }

    @Override
    @Business(viewType="both")
    public List<StandStateCache> findAllStandStatesWithFlight() {
        List<StandStateCache> standStates = this.standStateCacheDAO.findAllStandStatesWithFlight();
        return standStates;
    }

    @Override
    @Business(viewType="both")
    public List<StandStateHistory> findStandStateHistoryForBeginTimeAndEndTimeAndStateWithFlight(long beginTime, long endTime, long stateId) {
        List<StandStateHistory> standStates = this.standStateHistoryDAO.findStandStateHistoryForBeginTimeAndEndTimeAndStateWithFlight(beginTime, endTime, stateId);
        return standStates;
    }

    @Override
    @Business(viewType="both")
    public List<StandStateCache> findStandStatesForStandCache(String stand) {
        List<StandStateCache> standStates = this.standStateCacheDAO.findStandStatesForStand(stand);
        return standStates;
    }

    @Override
    @Business(viewType="both")
    public List<StandStateCache> findStandStatesForStandAndStateModelCache(String stand, long stateModelId) {
        List<StandStateCache> standStates = this.standStateCacheDAO.findStandStatesForStandAndStateModel(stand, stateModelId);
        return standStates;
    }

    @Override
    @Business(viewType="both")
    public StandStateHistory findLatestStandStateHistoryForStandAndStateModel(String stand, long stateModelId) {
        StandStateHistory standStateHistory = null;
        StandStateCache standStateCache = (StandStateCache)this.standStateCacheDAO.findByPrimaryKey(new StandStateCache.PK(stand, stateModelId));
        if (standStateCache != null) {
            standStateHistory = (StandStateHistory)this.standStateHistoryDAO.findByPrimaryKey(standStateCache.getHistoryId());
        }
        return standStateHistory;
    }

    @Override
    @Business(viewType="both")
    public List<StandStateHistory> findStandStateHistoryForStandAndStateModelTimestamp(String stand, long stateModelId, long timestamp) {
        return this.standStateHistoryDAO.findStandStateHistoryForStandAndStateModelTimestamp(stand, stateModelId, timestamp);
    }

    @Override
    @Business(viewType="both")
    public boolean isUpdateForActualTime(FISFlight currentFlight, FISFlight flight, StandStateCache standState) {
        if (standState == null) {
            return false;
        }
        if (currentFlight != null && flight != null && flight.getUniqueFlightNumber().equals(currentFlight.getUniqueFlightNumber()) && flight.getParkingStand().equals(currentFlight.getParkingStand()) && flight.getParkingStand().equals(standState.getPk().getStand()) && flight.getOnOffBlockTime() != standState.getBeginTime() && flight.getOnOffBlockTime() > 0L) {
            log.debug((Object)("update of the actual time for flight " + flight.getUniqueFlightNumber() + " on stand " + flight.getParkingStand() + " returns true"));
            return true;
        }
        return false;
    }

    @Override
    @Business(viewType="both")
    public boolean isUpdateForActualTime(FISFlight currentFlight, FISFlight flight, StandStateCacheValue standState) {
        if (standState == null) {
            return false;
        }
        if (currentFlight != null && flight != null && flight.getUniqueFlightNumber().equals(currentFlight.getUniqueFlightNumber()) && flight.getParkingStand().equals(currentFlight.getParkingStand()) && flight.getParkingStand().equals(standState.getPk().getStand()) && flight.getOnOffBlockTime() != standState.getBeginTime() && flight.getOnOffBlockTime() > 0L) {
            log.debug((Object)("update of the actual time for flight " + flight.getUniqueFlightNumber() + " on stand " + flight.getParkingStand() + " returns true"));
            return true;
        }
        return false;
    }

    @Override
    @Business(viewType="both")
    public StandStateCacheValue convertToValue(StandStateCache standStateCache) {
        return (StandStateCacheValue)this.mapper.map((Object)standStateCache, StandStateCacheValue.class);
    }

    @Override
    @Business(viewType="both")
    public List<StandStateCacheValue> findStandStateCacheValuesForStand(String stand) {
        ArrayList<StandStateCacheValue> standStateCacheValues = new ArrayList<StandStateCacheValue>();
        List<StandStateCache> standStateCaches = this.findStandStatesForStandCache(stand);
        for (StandStateCache ssc : standStateCaches) {
            standStateCacheValues.add(this.convertToValue(ssc));
        }
        return standStateCacheValues;
    }
}

