/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.fis;

import de.proveo.wwt.datamodel.custom.CustomScript;
import de.proveo.wwt.logic.ejb.general.custom.CustomScriptFacadeLocal;
import de.proveo.wwt.logic.ejb.general.custom.ScriptLoader;
import de.proveo.wwt.logic.ejb.interfaces.ServiceLocator;
import de.proveo.wwt.logic.ejb.interfaces.fis.FISMessageProcessor;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.PropertyConfigurator;

public class FISMessageService {
    private static final Log log = LogFactory.getLog(FISMessageService.class);
    private static final String FIS_MESSAGE_SERVICE_ENTRY_POINT = "interfaces.fis.FISMessageService";
    private static final ScriptLoader<FISMessageProcessor> fisMessageProcessorScriptLoader = new ScriptLoader();
    private static FISMessageService INSTANCE = new FISMessageService();
    private CustomScriptFacadeLocal customScriptFacade = null;
    private List<FISMessageProcessor> fisMessageProcessors;
    private boolean initialized = false;

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    private FISMessageService() {
    }

    public static FISMessageService getINSTANCE() {
        return INSTANCE;
    }

    public void init() {
        log.info((Object)"init()");
        this.customScriptFacade = ServiceLocator.getCustomScriptFacade();
        List<CustomScript> customScripts = this.customScriptFacade.getActiveScriptsByEntryPointForAllUnits(FIS_MESSAGE_SERVICE_ENTRY_POINT);
        log.info((Object)("found " + customScripts.size() + " active scripts for entry point " + FIS_MESSAGE_SERVICE_ENTRY_POINT));
        this.fisMessageProcessors = new ArrayList<FISMessageProcessor>();
        for (CustomScript customScript : customScripts) {
            try {
                FISMessageProcessor fisMessageProcessor = fisMessageProcessorScriptLoader.loadScript(customScript);
                fisMessageProcessor.init();
                this.fisMessageProcessors.add(fisMessageProcessor);
            }
            catch (Exception e) {
                log.error((Object)"runs into ", (Throwable)e);
            }
        }
        this.setInitialized(true);
    }

    public String processFISMessage(String xml) {
        log.debug((Object)"processFISMessage(String xml)");
        long startTime = System.currentTimeMillis();
        String result = null;
        if (!this.isInitialized()) {
            this.init();
        }
        for (FISMessageProcessor fisMessageProcessor : this.fisMessageProcessors) {
            result = fisMessageProcessor.processXML(xml);
        }
        long duration = System.currentTimeMillis() - startTime;
        log.debug((Object)("processFISMessage(String xml) - duration: " + duration + " ms"));
        return result;
    }

    public static void main(String[] args) throws Exception {
        int c;
        PropertyConfigurator.configure((String)"log4j.properties");
        FISMessageService service = FISMessageService.getINSTANCE();
        service.init();
        File file = new File("fis.xml");
        FileReader f = new FileReader(file);
        StringBuffer buffer = new StringBuffer();
        while ((c = ((Reader)f).read()) != -1) {
            buffer.append((char)c);
        }
        service.processFISMessage(buffer.toString());
    }
}

