/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.assignment;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.eventbase.EventResponse;
import de.proveo.wwt.logic.app.unit.exception.UnitNotFoundException;
import de.proveo.wwt.logic.ejb.dataIn.event.EventFacadeLocal;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import de.proveo.wwt.logic.ejb.interfaces.assignment.AIConfiguration;
import de.proveo.wwt.logic.ejb.interfaces.assignment.AssignmentSessionLocal;
import de.proveo.wwt.logic.ejb.interfaces.assignment.AssignmentSessionRemote;
import de.proveo.wwt.logic.ejb.interfaces.assignment.exceptions.AlreadyAssignedException;
import de.proveo.wwt.logic.ejb.interfaces.assignment.jaxb.msg.AssignmentMsg;
import de.proveo.wwt.logic.ejb.interfaces.assignment.jaxb.response.AssignmentResponse;
import de.proveo.wwt.logic.ejb.interfaces.assignment.util.AITimestamp;
import de.proveo.wwt.logic.ejb.state.CurrentStateFacadeLocal;
import de.proveo.wwt.logic.ejb.state.CurrentStateFacadeStruct;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.ParseException;
import java.util.NoSuchElementException;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.ejb.CreateException;
import javax.ejb.EJB;
import javax.ejb.FinderException;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.PoolClass;
import org.jboss.ejb3.StrictMaxPool;

@Stateless(name="AssignmentSession")
@Remote(value={AssignmentSessionRemote.class})
@Local(value={AssignmentSessionLocal.class})
@JndiLocalBinding(localJndiBinding="rts/AssignmentSession")
@JndiRemoteBinding(remoteJndiBinding="rts/AssignmentSession")
@PoolClass(value=StrictMaxPool.class, maxSize=30, timeout=10000L)
public class AssignmentSessionBean
implements AssignmentSessionLocal,
AssignmentSessionRemote {
    private static final Log log = LogFactory.getLog(AssignmentSessionBean.class);
    private static AIConfiguration config = AIConfiguration.getInstance();
    @EJB
    private UnitFacadeLocal unitFacade = null;
    @EJB
    private EventFacadeLocal eventFacade = null;
    @EJB
    private CurrentStateFacadeLocal currentStateFacade;

    @PostConstruct
    public void ejbCreate() throws CreateException {
        log.debug((Object)"ejbCreate()");
    }

    @Override
    @Business(viewType="both")
    public String parseXML(String xml) {
        log.debug((Object)("parse xml:" + xml));
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"de.proveo.wwt.logic.ejb.interfaces.assignment.jaxb.msg", (ClassLoader)this.getClass().getClassLoader());
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            AssignmentMsg assMsg = (AssignmentMsg)unmarshaller.unmarshal((Reader)new StringReader(xml));
            long msgId = -1L;
            if (assMsg.getId() == null) {
                log.warn((Object)"message id is missing");
            } else {
                msgId = assMsg.getId();
            }
            if (!config.isAssignmentActive()) {
                return this.createErrorMessage(msgId, "Assignment interface is not active!", null, null);
            }
            Long unitId = assMsg.getUnitId();
            String unitName = assMsg.getUnitName();
            if (unitId == null) {
                try {
                    unitId = this.getUnitId(unitName);
                }
                catch (FinderException e) {
                    return this.createErrorMessage(msgId, "unit not found: " + assMsg.getUnitName(), unitId, unitName);
                }
            }
            if (unitId == null) {
                return this.createErrorMessage(msgId, "no unit id or name given", null, null);
            }
            boolean assigned = assMsg.isAssigned();
            String remark = assMsg.getRemark();
            String timeString = assMsg.getTimestamp();
            try {
                boolean successful = this.setAssignmentStatus(unitId, assigned, timeString, remark);
                return this.createResponse(msgId, successful, assigned, unitId, unitName);
            }
            catch (UnitNotFoundException e) {
                log.debug((Object)("unit not found: " + e.getUnitId()));
                return this.createErrorMessage(msgId, "unit not found: " + e.getUnitId(), unitId, unitName);
            }
            catch (AlreadyAssignedException e) {
                log.debug((Object)("unit is already (un)assigned: " + unitId));
                return this.createErrorMessage(msgId, e.getMessage(), unitId, unitName);
            }
        }
        catch (JAXBException e) {
            log.error((Object)("could not parse xml: " + xml));
            return this.createErrorMessage(-1L, "could not parse xml: " + xml, null, null);
        }
    }

    @Override
    @Business(viewType="both")
    public Long getUnitId(String unitName) throws FinderException {
        UnitDTO unitDTO = this.unitFacade.getUnitDTO(unitName);
        Long unitId = unitDTO.getUnitId();
        return unitId;
    }

    @Override
    @Business(viewType="both")
    public String getUnitName(Long unitId) throws FinderException {
        if (unitId == null) {
            throw new FinderException("cannot find unit name for unit id null");
        }
        UnitDTO unitDTO = this.unitFacade.getUnitDTO(unitId);
        if (unitDTO != null) {
            return unitDTO.getUnitName();
        }
        throw new FinderException("could not find unit " + unitId);
    }

    @Override
    @Business(viewType="both")
    public boolean setAssignmentStatus(Long unitId, boolean assigned, String timestring, String remark) throws UnitNotFoundException, AlreadyAssignedException {
        AITimestamp timestamp;
        if (timestring == null || timestring.length() == 0) {
            timestamp = new AITimestamp(System.currentTimeMillis());
        } else {
            try {
                timestamp = new AITimestamp(timestring);
            }
            catch (ParseException e) {
                log.warn((Object)"setAssignmentStatus runs into ", (Throwable)e);
                timestamp = new AITimestamp(System.currentTimeMillis());
            }
        }
        return this.setAssignmentStatus(unitId, assigned, timestamp, remark);
    }

    @Override
    @Business(viewType="both")
    public boolean setAssignmentStatus(Long unitId, boolean assigned, AITimestamp timestamp, String remark) throws UnitNotFoundException, AlreadyAssignedException {
        if (config.isAssignmentActive()) {
            if (unitId == null) {
                throw new UnitNotFoundException("");
            }
            if (this.unitFacade.getUnitDTO(unitId) == null) {
                throw new UnitNotFoundException(unitId);
            }
            int stateModelId = config.getInt("assignedStateModel");
            CurrentStateFacadeStruct currentState = this.currentStateFacade.getCurrentState(unitId, stateModelId);
            if (currentState != null) {
                long currentStateId = currentState.getStateId();
                if (assigned && currentStateId == (long)config.getInt("assigned") || !assigned && currentStateId == (long)config.getInt("notAssigned")) {
                    if (config.getBoolean("tempSwitch.enabled")) {
                        AITimestamp timestampTemp = new AITimestamp(timestamp.getTimestamp() - (long)config.getInt("tempSwitch.time"));
                        this.setAssignmentStatus(unitId, !assigned, timestampTemp, config.getString("tempSwitch.remark"));
                    } else {
                        throw new AlreadyAssignedException(assigned);
                    }
                }
            }
            Properties event = new Properties();
            event.setProperty("t", Long.toString(timestamp.getTimestamp()));
            log.debug((Object)("timestamp: " + timestamp.getTimestamp()));
            event.setProperty("u", Long.toString(unitId));
            log.debug((Object)("unitId: " + unitId));
            event.setProperty("m", Integer.toString(stateModelId));
            log.debug((Object)("stateModel: " + stateModelId));
            int assignedStateId = assigned ? config.getInt("assigned") : config.getInt("notAssigned");
            event.setProperty("s", Integer.toString(assignedStateId));
            log.debug((Object)("stateId: " + assignedStateId));
            if (remark != null && !remark.trim().equals("")) {
                event.setProperty("c", remark);
            }
            try {
                EventResponse eventResponse = this.eventFacade.handleEvent(event);
                log.debug((Object)("event response: " + eventResponse));
                return eventResponse.isEventResponse();
            }
            catch (NoSuchElementException e) {
                log.error((Object)"runs into", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    private String createResponse(long msgId, boolean successful, boolean assigned, Long unitId, String unitName) {
        StringWriter writer = new StringWriter();
        AssignmentResponse response = new AssignmentResponse();
        response.setSuccessful(successful);
        response.setId(msgId);
        if (successful) {
            response.setAssigned(assigned);
        }
        this.addUnitToResponse(response, unitId, unitName, successful);
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"de.proveo.wwt.logic.ejb.interfaces.assignment.jaxb.response", (ClassLoader)this.getClass().getClassLoader());
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)config.getBoolean("xml.formatted"));
            marshaller.marshal((Object)response, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException e) {
            return this.createErrorMessage(msgId, "Could not create response: " + e.getMessage(), unitId, null);
        }
    }

    private String createErrorMessage(long msgId, String message, Long unitId, String unitName) {
        StringWriter writer = new StringWriter();
        AssignmentResponse response = new AssignmentResponse();
        response.setSuccessful(false);
        response.setErrorMsg(message);
        response.setId(msgId);
        this.addUnitToResponse(response, unitId, unitName, false);
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"de.proveo.wwt.logic.ejb.interfaces.assignment.jaxb.response", (ClassLoader)this.getClass().getClassLoader());
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)config.getBoolean("xml.formatted"));
            marshaller.marshal((Object)response, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException e) {
            log.error((Object)"runs into", (Throwable)e);
            return this.createJDomErrorMessage(msgId, ErrorCodes.XMLResponse, "Could not create response: " + e.getMessage());
        }
    }

    private void addUnitToResponse(AssignmentResponse response, Long unitId, String unitName, boolean successful) {
        if (successful && config.getBoolean("units.addToPositiveResponse") || !successful && config.getBoolean("units.addToNegativeResponse")) {
            if (config.getBoolean("units.unitName.active") && unitName == null) {
                try {
                    unitName = this.getUnitName(unitId);
                    response.setUnitName(unitName);
                }
                catch (FinderException e) {
                    log.debug((Object)("could not find name for unit " + unitId));
                }
            }
            if (config.getBoolean("units.unitId.active")) {
                if (unitId == null && unitName != null) {
                    try {
                        unitId = this.getUnitId(unitName);
                    }
                    catch (FinderException e) {
                        // empty catch block
                    }
                }
                response.setUnitId(unitId);
            }
        }
    }

    private String createJDomErrorMessage(long msgId, ErrorCodes response, String string) {
        return null;
    }

    @Override
    @Business(viewType="both")
    public boolean isAssignmentActive() {
        return config.isAssignmentActive();
    }

    private static enum ErrorCodes {
        UnitNotFound,
        UnknownReason,
        TimeFormat,
        MissingMethod,
        MissingParameter,
        XMLParse,
        XMLResponse,
        Unknown;

    }
}

