/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.geo;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.wwt.datamodel.area.Area;
import de.proveo.wwt.datamodel.geo.GdataCache;
import de.proveo.wwt.datamodel.geo.GdataHistory;
import de.proveo.wwt.datamodel.unit.identity.UnitIdentity;
import de.proveo.wwt.logic.ejb.dataOut.raw.GeoStamp;
import de.proveo.wwt.logic.ejb.general.area.AreaInFacadeLocal;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import de.proveo.wwt.logic.ejb.geo.CurrentGdataCacheDAO;
import de.proveo.wwt.logic.ejb.geo.GdataHistoryDAO;
import de.proveo.wwt.logic.ejb.geo.GeoOutFacadeLocal;
import de.proveo.wwt.logic.ejb.geo.GeoOutFacadeRemote;
import de.proveo.wwt.logic.ejb.geo.GeoStruct;
import de.proveo.wwt.logic.ejb.geo.exception.NoGeoFoundException;
import de.proveo.wwt.logic.ejb.state.CurrentStateFacadeLocal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Stateless(name="GeoOutFacade")
@Remote(value={GeoOutFacadeRemote.class})
@Local(value={GeoOutFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/GeoOutFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/GeoOutFacade")
public class GeoOutFacadeBean
implements GeoOutFacadeLocal,
GeoOutFacadeRemote {
    @EJB
    private CurrentStateFacadeLocal currentStateFacadeLocal = null;
    private static final Log log = LogFactory.getLog(GeoOutFacadeBean.class);
    @EJB
    private UnitFacadeLocal unitFacade = null;
    @PersistenceContext(unitName="rts")
    private EntityManager entityManager = null;
    @EJB
    private AreaInFacadeLocal areaInFacadeLocal = null;
    private GdataHistoryDAO gdataHistoryDAO = null;
    private CurrentGdataCacheDAO currentGdataCacheDAO = null;

    @PostConstruct
    public void initImpl() {
        this.gdataHistoryDAO = GdataHistoryDAO.newInstance(this.entityManager);
        this.currentGdataCacheDAO = CurrentGdataCacheDAO.newInstance(this.entityManager);
    }

    @Override
    @Business(viewType="both")
    public ArrayList getAllUnitEventsFromCacheSortedByPreviousPk() {
        ArrayList<GeoStruct> values = new ArrayList<GeoStruct>();
        List<GdataCache> col = this.currentGdataCacheDAO.findAllOrderByHistoryId();
        for (GdataCache cache : col) {
            GeoStruct value = cache.getStruct();
            values.add(value);
        }
        return values;
    }

    @Override
    @Business(viewType="both")
    public ArrayList<GeoStruct> getAllGeoEventsFromCacheSortedbyUnitID() {
        ArrayList<GeoStruct> values = new ArrayList<GeoStruct>();
        List<GdataCache> col = this.currentGdataCacheDAO.findAllSortedByUnitID();
        for (GdataCache currentGdataCache : col) {
            GeoStruct data = currentGdataCache.getStruct();
            values.add(data);
        }
        return values;
    }

    @Override
    @Business(viewType="both")
    public GeoStruct getNewestGeoEventFromCache(long unitID) {
        GeoStruct geoStruct = null;
        GdataCache geoCache = (GdataCache)this.currentGdataCacheDAO.findByPrimaryKey(unitID);
        geoStruct = geoCache.getStruct();
        return geoStruct;
    }

    protected GeoStamp getUnitEventsFromCache(long basicUnitId, long requestedBeginTime, long requestedEndTime) throws NoGeoFoundException {
        String sMethodName = "getUnitEventsFromCache()";
        GdataCache geoCache = (GdataCache)this.currentGdataCacheDAO.findByPrimaryKey(basicUnitId);
        GeoStruct geoStruct = geoCache.getStruct();
        Area areaStruct = this.getArea(geoStruct.getAreaId());
        UnitIdentity unitIdentityData = this.getUnitIdentity(geoStruct.getUnitId());
        return new GeoStamp(geoStruct, areaStruct, unitIdentityData, requestedBeginTime, requestedEndTime);
    }

    protected HashSet getUnitEventsFromHistory(long basicUnitId, long requestedBeginTime, long requestedEndTime) throws NoGeoFoundException {
        String sMethodName = "getUnitEventsFromHistory()";
        List<GdataHistory> entries = this.gdataHistoryDAO.findByUnit(requestedBeginTime, requestedEndTime, basicUnitId);
        HashSet<GeoStamp> geoStamps = new HashSet<GeoStamp>();
        for (GdataHistory geoHistory : entries) {
            GeoStruct geoStruct = geoHistory.getStruct();
            Area areaStruct = this.getArea(geoStruct.getAreaId());
            UnitIdentity unitIdentityData = this.getUnitIdentity(geoStruct.getUnitId());
            GeoStamp stamp = new GeoStamp(geoStruct, areaStruct, unitIdentityData, requestedBeginTime, requestedEndTime);
            geoStamps.add(stamp);
        }
        return geoStamps;
    }

    protected Area getArea(int areaId) {
        if (areaId < 0) {
            Area area = new Area();
            area.setDescription("");
            area.setArea("");
            area.setPriority(0);
            area.setMaxLatMsec(0);
            area.setMinLatMsec(0);
            area.setMaxLongMsec(0);
            area.setMinLongMsec(0);
            area.setDeleted(false);
            area.setGeofencing(false);
            return area;
        }
        try {
            Area areaLocal = this.areaInFacadeLocal.getAreaValue(areaId);
            return areaLocal;
        }
        catch (Exception ex) {
            String msg = "getArea() for areaId '" + areaId + "' runs into '" + ex.getMessage() + "'";
            log.error((Object)msg, (Throwable)ex);
            Area area = new Area();
            area.setDescription("[unknown]");
            area.setArea("[unknown]");
            area.setAreaId(areaId);
            area.setPriority(0);
            area.setMaxLatMsec(0);
            area.setMinLatMsec(0);
            area.setMaxLongMsec(0);
            area.setMinLongMsec(0);
            area.setDeleted(false);
            area.setGeofencing(false);
            return area;
        }
    }

    protected UnitIdentity getUnitIdentity(long unitId) {
        UnitIdentity unit = this.unitFacade.getUnitIdentity(unitId);
        if (unit != null) {
            return unit;
        }
        UnitIdentity value = new UnitIdentity();
        value.setUnitId(unitId);
        value.setName("(n/a)");
        return value;
    }
}

