/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.unit.facade;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.eventbase.EventPayload;
import de.proveo.util.container.ContainerUtil;
import de.proveo.util.jpa.JpaUtil;
import de.proveo.util.jpa.entity.EntityBase;
import de.proveo.wwt.datamodel.AuditEntityBase;
import de.proveo.wwt.datamodel.account.Account;
import de.proveo.wwt.datamodel.groupIdent.GroupIdent;
import de.proveo.wwt.datamodel.grouphistory.Grouphistory;
import de.proveo.wwt.datamodel.module.ModuleType;
import de.proveo.wwt.datamodel.role.Role;
import de.proveo.wwt.datamodel.state.StateCache;
import de.proveo.wwt.datamodel.state.StateHistory;
import de.proveo.wwt.datamodel.unit.identity.UnitIdentity;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.datamodel.unit.permission.IUnitPermissionOwner;
import de.proveo.wwt.datamodel.unit.permission.UnitPermission;
import de.proveo.wwt.datamodel.unit.typeIdentity.UnitTypeIdentity;
import de.proveo.wwt.datamodel.use.group.UseGroup;
import de.proveo.wwt.datamodel.use.user.UseUser;
import de.proveo.wwt.logic.app.unit.exception.UnitNotFoundException;
import de.proveo.wwt.logic.ejb.dataIn.event.history.IBeginTime;
import de.proveo.wwt.logic.ejb.dataIn.informant.InformantClient;
import de.proveo.wwt.logic.ejb.dataIn.notify.NotifyFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.scanmanmsg.ScanmanMsgFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.use.UseFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.audit.ActionType;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.RoleAdminFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.UserAdminFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.UserGroupAdminFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser.UseUserAdminFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser.UseUserGroupAdminFacadeLocal;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocal;
import de.proveo.wwt.logic.ejb.general.unit.facade.GrouphistoryDAO;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitAlreadyExistsInGroupException;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeRemote;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitIdentityDAO;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitModelDAO;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitPermissionDAO;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitPropertyException;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitTypeIdentityDAO;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitValidationError;
import de.proveo.wwt.logic.ejb.geo.GdataFacadeLocal;
import de.proveo.wwt.logic.ejb.keepalive.KeepAliveInFacadeLocal;
import de.proveo.wwt.logic.ejb.state.CurrentStateFacadeLocal;
import de.proveo.wwt.logic.web.admin.PermissionUpdateNotifyLocal;
import de.proveo.wwt.logic.web.admin.PermissionUpdateToolsLocal;
import de.proveo.wwt.logic.web.admin.dto.grouphistory.GrouphistoryDTO;
import de.proveo.wwt.logic.web.admin.dto.permission.UnitPermissionDTO;
import de.proveo.wwt.logic.web.common.dataSelection.ReportSelectionDTO;
import de.proveo.wwt.logic.web.common.dataSelection.UnitReportSelectionDTO;
import de.proveo.wwt.logic.web.common.dto.DTOFactory;
import de.proveo.wwt.logic.web.common.dto.DTOListBase;
import de.proveo.wwt.logic.web.common.dto.DTOListFactory;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.common.dto.UnitDTOList;
import de.proveo.wwt.logic.web.common.helper.UnitListFactory;
import de.proveo.wwt.logic.web.data.GroupHistoryFastLane;
import de.proveo.wwt.logic.web.data.HistoryFastLaneWriter;
import de.proveo.wwt.logic.web.data.fastlanereader.PermissionFastLaneReader;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.UnitTreeFacadeLocal;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.dto.UnitIdNodeMatcher;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.dto.UnitNodeType;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.dto.UnitTreeNode;
import de.proveo.wwt.logic.web.security.PermissionCheckerLocal;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.CreateException;
import javax.ejb.EJB;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.NonUniqueResultException;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang.mutable.MutableLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.exception.ConstraintViolationException;
import org.jboss.annotation.ejb.PoolClass;
import org.jboss.annotation.ejb.TransactionTimeout;
import org.jboss.ejb3.StrictMaxPool;

@Stateless(name="UnitFacade")
@Remote(value={UnitFacadeRemote.class})
@Local(value={UnitFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/UnitFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/UnitFacade")
@PoolClass(value=StrictMaxPool.class, maxSize=30, timeout=10000L)
public class UnitFacadeBean
implements UnitFacadeLocal,
UnitFacadeRemote {
    @Resource
    private SessionContext sessionContext;
    private static final Log log = LogFactory.getLog(UnitFacadeBean.class);
    public static final long NOTHING_SELECTED = -1L;
    private final PermissionFastLaneReader permissionFastLaneReader = new PermissionFastLaneReader();
    private UseUserAdminFacadeLocal useUserAdminFacade = null;
    private CurrentStateFacadeLocal currentStateFacadeLocal = null;
    private PermissionCheckerLocal permissionCheckerLocal = null;
    private PermissionUpdateNotifyLocal permissionUpdateNotifyBeanLocal = null;
    private PermissionUpdateToolsLocal permissionUpdateToolsLocal = null;
    private RoleAdminFacadeLocal roleAdministrationFacade = null;
    private UserAdminFacadeLocal userAdminFacadeLocal = null;
    private UseUserGroupAdminFacadeLocal useUserGroupAdminFacadeLocal = null;
    private UserGroupAdminFacadeLocal userGroupAdminFacade = null;
    private UnitFacadeLocal unitFacadeLocal = null;
    private UnitTreeFacadeLocal unitTreeFacadeLocal = null;
    private static final long DEFAULT_INFOMAN_REQUEST_TIMEOUT = 600000L;
    private long infomanRequestTimeout;
    private HistoryFastLaneWriter historyFastLaneWriter;
    private InformantClient informantClient = null;
    @PersistenceContext(unitName="rts")
    private EntityManager entityManager = null;
    private GrouphistoryDAO grouphistoryDAO = null;
    private UnitPermissionDAO unitPermissionDAO = null;
    private UnitModelDAO unitModelDAO = null;
    private UnitIdentityDAO unitIdentityDAO = null;
    private UnitTypeIdentityDAO unitTypeIdentityDAO = null;
    @EJB
    private ConfigurationLocal configurationLocal = null;
    @EJB
    private AuditFacadeLocal auditFacadeLocal;

    @PostConstruct
    public void ejbCreate() {
        this.initBeans();
        this.informantClient = new InformantClient();
        this.grouphistoryDAO = GrouphistoryDAO.newInstance(this.entityManager);
        this.unitPermissionDAO = UnitPermissionDAO.newInstance(this.entityManager);
        this.unitModelDAO = UnitModelDAO.newInstance(this.entityManager);
        this.unitIdentityDAO = UnitIdentityDAO.newInstance(this.entityManager);
        this.unitTypeIdentityDAO = UnitTypeIdentityDAO.newInstance(this.entityManager);
        this.infomanRequestTimeout = Long.parseLong(this.configurationLocal.getParameter("infoman.aclupdate.timeout", Long.toString(600000L)));
    }

    private void initBeans() {
        try {
            InitialContext context = new InitialContext();
            this.currentStateFacadeLocal = (CurrentStateFacadeLocal)context.lookup("rts/CurrentStateFacade/local");
            this.permissionCheckerLocal = (PermissionCheckerLocal)context.lookup("rts/PermissionChecker/local");
            this.useUserAdminFacade = (UseUserAdminFacadeLocal)context.lookup("rts/UseUserAdminFacade/local");
            this.permissionUpdateNotifyBeanLocal = (PermissionUpdateNotifyLocal)context.lookup("rts/PermissionUpdateNotify/local");
            this.permissionUpdateToolsLocal = (PermissionUpdateToolsLocal)context.lookup("rts/PermissionUpdateTools/local");
            this.userGroupAdminFacade = (UserGroupAdminFacadeLocal)context.lookup("rts/UserGroupAdminFacade/local");
            this.roleAdministrationFacade = (RoleAdminFacadeLocal)context.lookup("rts/RoleAdminFacade/local");
            this.userAdminFacadeLocal = (UserAdminFacadeLocal)context.lookup("rts/UserAdminFacade/local");
            this.useUserGroupAdminFacadeLocal = (UseUserGroupAdminFacadeLocal)context.lookup("rts/UseUserGroupAdminFacade/local");
            this.unitFacadeLocal = (UnitFacadeLocal)context.lookup("rts/UnitFacade/local");
            this.unitTreeFacadeLocal = (UnitTreeFacadeLocal)context.lookup("rts/UnitTreeFacade/local");
        }
        catch (Exception e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
    }

    private UserGroupAdminFacadeLocal getUserGroupAdminFacade() {
        if (this.userGroupAdminFacade == null) {
            try {
                InitialContext context = new InitialContext();
                this.userGroupAdminFacade = (UserGroupAdminFacadeLocal)context.lookup("rts/UserGroupAdminFacade/local");
                return this.userGroupAdminFacade;
            }
            catch (NamingException e) {
                log.error((Object)"Throws ", (Throwable)e);
            }
        }
        return this.userGroupAdminFacade;
    }

    @Override
    @Business(viewType="both")
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public <T extends EntityBase> void synchronizeUnitPermissions(T permissionOwner, List<UnitPermission> unitPermissions) {
        EntityManager auditEntityManager = JpaUtil.createAuditEntityManager();
        EntityBase oldOwner = (EntityBase)auditEntityManager.find(permissionOwner.getClass(), permissionOwner.getPrimaryKey());
        permissionOwner = (EntityBase)this.entityManager.find(permissionOwner.getClass(), permissionOwner.getPrimaryKey());
        for (UnitPermission unitPermission : unitPermissions) {
            ((IUnitPermissionOwner)permissionOwner).setPermissionOwner(unitPermission);
        }
        List<UnitPermission> oldPermissions = ((IUnitPermissionOwner)oldOwner).getUnitPermissions();
        ArrayList<UnitPermission> remove = new ArrayList<UnitPermission>(oldPermissions);
        ArrayList<UnitPermission> add = new ArrayList<UnitPermission>(unitPermissions);
        remove.removeAll(unitPermissions);
        add.removeAll(oldPermissions);
        for (UnitPermission unitPermission : remove) {
            unitPermission = (UnitPermission)this.unitPermissionDAO.updateEntity(unitPermission);
            permissionOwner.removeRelation((EntityBase)unitPermission, UnitPermission.class);
            this.unitPermissionDAO.removeEntity(unitPermission);
        }
        for (UnitPermission unitPermission : add) {
            this.unitPermissionDAO.createEntity(unitPermission);
            permissionOwner.addRelation((EntityBase)unitPermission, UnitPermission.class);
        }
        this.entityManager.flush();
        this.entityManager.refresh(permissionOwner);
        auditEntityManager.close();
    }

    @Override
    @Business(viewType="both")
    public void setUserPermissions(long userId, List<UnitPermission> newUnitPermissions) {
        Account account = this.userAdminFacadeLocal.getAccount(userId);
        this.setUserPermissions(account, newUnitPermissions);
    }

    @Override
    @Business(viewType="both")
    public void setUserPermissions(String username, List<UnitPermission> newUnitPermissions) {
        Account account = this.userAdminFacadeLocal.getAccountByUsername(username);
        this.setUserPermissions(account, newUnitPermissions);
    }

    @Override
    @Business(viewType="both")
    public void setUserPermissions(Account account, List<UnitPermission> newUnitPermissions) {
        HashSet<Long> currentUnitIDs = this.permissionFastLaneReader.getUnitPermissions(account.getId());
        this.unitFacadeLocal.synchronizeUnitPermissions(account, newUnitPermissions);
        this.permissionCheckerLocal.updateAllUserPermissions();
        HashSet<Long> newUnitIDs = this.unitFacadeLocal._getUnitPermissionsInNewTx(account.getId());
        log.debug((Object)("setUserPermissions(): user permissions for user " + account.getUsername() + " changed from " + currentUnitIDs + " to " + newUnitIDs));
        if (!this.permissionUpdateToolsLocal.getDiffOfCollection(currentUnitIDs, newUnitIDs).isEmpty()) {
            this.permissionUpdateNotifyBeanLocal.sendPermissionChangedJMSMessage(account);
        }
    }

    @Override
    @Business(viewType="both")
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public HashSet<Long> _getUnitPermissionsInNewTx(long accountId) {
        return this.permissionFastLaneReader.getUnitPermissions(accountId);
    }

    @Override
    @Business(viewType="both")
    public void setUseUserPermissions(long useUserId, List<UnitPermission> newUnitPermissions) {
        UseUser useUser = this.useUserAdminFacade.getUseUserById(useUserId);
        ArrayList<UnitPermission> oldPermissions = new ArrayList<UnitPermission>(useUser.getUnitPermissions());
        this.unitFacadeLocal.synchronizeUnitPermissions(useUser, newUnitPermissions);
        this.updateUnitUserRefresh(this.buildUnitUserRefreshList(newUnitPermissions, oldPermissions));
    }

    @Override
    @Business(viewType="both")
    public void setRolePermissions(long roleId, List<UnitPermission> newUnitPermissions) {
        List<Account> accounts = this.roleAdministrationFacade.getAccountsInRoleAndGroupsByRoleID(roleId);
        String[] userNames = this.permissionUpdateToolsLocal.getUserNames(accounts);
        HashMap<String, HashSet<Long>> oldUnitPermissionsOfUsers = new HashMap<String, HashSet<Long>>();
        for (Account account : accounts) {
            oldUnitPermissionsOfUsers.put(account.getUsername(), this.permissionFastLaneReader.getUnitPermissions(account.getId()));
        }
        Role role = this.roleAdministrationFacade.getRole(roleId);
        this.unitFacadeLocal.synchronizeUnitPermissions(role, newUnitPermissions);
        this.permissionCheckerLocal.updateAllUserPermissions();
        HashMap<String, HashSet<Long>> newUnitPermissionsOfUsers = new HashMap<String, HashSet<Long>>();
        for (Account account : accounts) {
            newUnitPermissionsOfUsers.put(account.getUsername(), this.unitFacadeLocal._getUnitPermissionsInNewTx(account.getId()));
        }
        List<String> affectedUsersByVisibleUnitChanges = this.permissionUpdateToolsLocal.getAffectedUsersByVisibleUnitChanges(oldUnitPermissionsOfUsers, newUnitPermissionsOfUsers, userNames);
        if (!affectedUsersByVisibleUnitChanges.isEmpty()) {
            this.permissionUpdateNotifyBeanLocal.sendPermissionChangedJMSMessageByUserNames(affectedUsersByVisibleUnitChanges);
        }
    }

    @Override
    @Business(viewType="both")
    public void setUseGroupPermissions(long useGroupId, List<UnitPermission> newUnitPermissions) {
        UseGroup useGroup = this.useUserGroupAdminFacadeLocal.getUseGroupById(useGroupId);
        ArrayList<UnitPermission> oldUnitPermissions = this.getUnitPermissionsByUseGroupId(useGroupId);
        this.unitFacadeLocal.synchronizeUnitPermissions(useGroup, newUnitPermissions);
        this.updateUnitUserRefresh(this.buildUnitUserRefreshList(newUnitPermissions, oldUnitPermissions));
    }

    @Override
    @Business(viewType="both")
    public void setGroupPermissions(long groupId, List<UnitPermission> newUnitPermissions) {
        UserGroupAdminFacadeLocal userGroupAdminFacade = this.getUserGroupAdminFacade();
        List<Account> accounts = userGroupAdminFacade.getAccountsByGroupID(groupId);
        String[] affectedUserNames = this.permissionUpdateToolsLocal.getUserNames(accounts);
        HashMap<String, HashSet<Long>> oldUnitPermissionsOfUsers = new HashMap<String, HashSet<Long>>();
        for (Account account : accounts) {
            oldUnitPermissionsOfUsers.put(account.getUsername(), this.permissionFastLaneReader.getUnitPermissions(account.getId()));
        }
        GroupIdent groupIdent = userGroupAdminFacade.getGroupIdent(groupId);
        this.unitFacadeLocal.synchronizeUnitPermissions(groupIdent, newUnitPermissions);
        this.permissionCheckerLocal.updateAllUserPermissions();
        HashMap<String, HashSet<Long>> newUnitPermissionsOfUsers = new HashMap<String, HashSet<Long>>();
        for (Account account : accounts) {
            newUnitPermissionsOfUsers.put(account.getUsername(), this.unitFacadeLocal._getUnitPermissionsInNewTx(account.getId()));
        }
        List<String> affectedUsersByVisibleUnitChanges = this.permissionUpdateToolsLocal.getAffectedUsersByVisibleUnitChanges(oldUnitPermissionsOfUsers, newUnitPermissionsOfUsers, affectedUserNames);
        if (!affectedUsersByVisibleUnitChanges.isEmpty()) {
            this.permissionUpdateNotifyBeanLocal.sendPermissionChangedJMSMessageByUserNames(affectedUsersByVisibleUnitChanges);
        }
    }

    @Override
    @Business(viewType="both")
    public void setUseUserPermissions(long useUserId, List<UnitPermission> newUnitPermissions, boolean setUnitUserRefresh, boolean setUnitUserRefreshTMP) {
        ArrayList<UnitPermission> oldUnitPermissions = this.getUnitPermissionsByUseUserId(useUserId);
        UseUser useUser = this.useUserAdminFacade.getUseUserById(useUserId);
        this.unitFacadeLocal.synchronizeUnitPermissions(useUser, newUnitPermissions);
        List<UnitPermission> refreshList = this.buildUnitUserRefreshList(newUnitPermissions, oldUnitPermissions);
        if (setUnitUserRefresh) {
            this.updateUnitUserRefresh(refreshList);
        }
        if (setUnitUserRefreshTMP) {
            this.updateUnitUserRefreshTmp(refreshList);
        }
    }

    @Override
    @Business(viewType="both")
    public UnitDTOList getNonDeletedBasicUnits() {
        return this.getUnits(true, false);
    }

    @Override
    @Business(viewType="both")
    public UnitDTOList getUnits(boolean isBasic, boolean filtered) {
        return this.getUnits(isBasic, filtered, true);
    }

    @Override
    @Business(viewType="both")
    public List<UnitDTO> getBasicUnitsByType(long unitTypeId, boolean filtered) {
        ArrayList<UnitDTO> result = new ArrayList<UnitDTO>();
        UnitDTOList filteredUnits = this.getUnits(true, filtered);
        for (UnitDTO dto : filteredUnits) {
            if (unitTypeId != dto.getUnitTypeIdentity().getId()) continue;
            result.add(dto);
        }
        return result;
    }

    @Override
    @Business(viewType="both")
    public UnitDTOList getUnits(boolean isBasic, boolean filtered, boolean excludeDeleted) {
        List<UnitModel> units = excludeDeleted ? this.unitModelDAO.findByIsBasic(isBasic) : this.unitModelDAO.findAllByIsBasicAlsoDeleted(isBasic);
        UnitDTOList unitDTOList = DTOListFactory.buildUnitDTOList(units);
        if (filtered) {
            this.permissionCheckerLocal.checkDTOList(unitDTOList);
        }
        return unitDTOList;
    }

    @Override
    @Business(viewType="both")
    public UnitDTOList getUnitsByFinder(boolean isBasic, boolean filtered, boolean excludeDeleted) {
        List<UnitModel> units = excludeDeleted ? this.unitModelDAO.findByIsBasicFinder(isBasic) : this.unitModelDAO.findAllByIsBasicAlsoDeletedFinder(isBasic);
        UnitDTOList unitDTOList = DTOListFactory.buildUnitDTOList(units);
        if (filtered) {
            this.permissionCheckerLocal.checkDTOList(unitDTOList);
        }
        return unitDTOList;
    }

    @Override
    @Business(viewType="both")
    public UnitDTOList getDeletedUnits() {
        return DTOListFactory.buildUnitDTOList(this.unitModelDAO.findAllDeletedUnits());
    }

    @Override
    @Business(viewType="both")
    public List<Long> getUnitIds(boolean isBasic) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getUnitsByIsBasic isBasic: " + isBasic));
        }
        List<UnitModel> unitModels = this.unitModelDAO.findByIsBasic(isBasic);
        ArrayList<Long> unitIds = new ArrayList<Long>();
        for (UnitModel unit : unitModels) {
            unitIds.add(unit.getUnitId());
        }
        return unitIds;
    }

    @Override
    @Business(viewType="both")
    public List<UnitDTO> getBasicUnitsByGroupId(long groupId, boolean excludeDeleted) {
        ArrayList<UnitDTO> units = new ArrayList<UnitDTO>();
        UnitDTO unit = this.getUnitDTO(groupId);
        if (unit.isBasic()) {
            if (unit.isDeleted() && excludeDeleted) {
                return units;
            }
            units.add(unit);
            return units;
        }
        for (long unitId : this.getChildrenIdsByParentId(groupId, 2)) {
            units.addAll(this.getBasicUnitsByGroupId(unitId, excludeDeleted));
        }
        return units;
    }

    @Override
    @Business(viewType="both")
    public List<UnitDTO> getBasicUnitsByUnitIds(List<Long> groupIds, boolean excludeDeleted) {
        ArrayList<UnitDTO> units = new ArrayList<UnitDTO>();
        for (Long groupId : groupIds) {
            units.addAll(this.getBasicUnitsByGroupId(groupId, excludeDeleted));
        }
        return units;
    }

    @Override
    @Business(viewType="both")
    public UnitDTO getUnitDTO(long unitId) {
        UnitDTO unitDTO = null;
        if (unitId == -1L) {
            UnitModel umv = new UnitModel();
            umv.setUnitId(-1L);
            umv.setBasic(false);
            UnitIdentity uiv = new UnitIdentity();
            uiv.setUnitId(-1L);
            uiv.setName("unit.noUnitSelected");
            uiv.setImageName("symbol.group.warning");
            unitDTO = DTOFactory.buildUnitDTO(umv, uiv, null);
        } else {
            UnitModel unitModel = (UnitModel)this.unitModelDAO.findByPrimaryKey(unitId);
            unitDTO = DTOFactory.buildUnitDTO(unitModel);
        }
        return unitDTO;
    }

    @Override
    @Business(viewType="both")
    public UnitDTO getUnitDTO(String unitName) throws FinderException {
        List<UnitIdentity> unitList = this.unitIdentityDAO.findByName(unitName);
        if (!unitList.isEmpty()) {
            return DTOFactory.buildUnitDTO(unitList.get(0));
        }
        throw new FinderException("Cannot find unit with unitName = " + unitName);
    }

    @Override
    @Business(viewType="both")
    public List<UnitTypeIdentity> getUnitTypes() {
        return this.unitTypeIdentityDAO.findAll();
    }

    @Override
    @Business(viewType="both")
    public UnitTypeIdentity getUnitTypeById(Long unitTypeId) {
        return (UnitTypeIdentity)this.unitTypeIdentityDAO.findByPrimaryKey(unitTypeId);
    }

    @Override
    @Business(viewType="both")
    public UnitModel getUnitModelByCustomerUnitName(String customerUnitName) {
        UnitModel unitModel = null;
        List<UnitModel> list = this.unitModelDAO.findByCustomerUnitId(customerUnitName);
        if (list.size() != 0) {
            unitModel = list.get(0);
        }
        return unitModel;
    }

    @Override
    @Business(viewType="both")
    public String[] getUnitTypeNames() {
        List<UnitTypeIdentity> unitTypes = this.getUnitTypes();
        int typeCount = unitTypes.size();
        String[] typeNames = new String[typeCount];
        for (int i = 0; i != typeCount; ++i) {
            typeNames[i] = unitTypes.get(i).getName();
        }
        return typeNames;
    }

    private List<UnitPermission> buildUnitUserRefreshList(List<UnitPermission> newPermissions, List<UnitPermission> oldPermissions) {
        ArrayList<UnitPermission> newPermissionsClone = new ArrayList<UnitPermission>(newPermissions);
        ArrayList<UnitPermission> oldPermissionsClone = new ArrayList<UnitPermission>(oldPermissions);
        oldPermissionsClone.removeAll(newPermissionsClone);
        newPermissionsClone.removeAll(oldPermissionsClone);
        newPermissionsClone.addAll(oldPermissionsClone);
        return newPermissionsClone;
    }

    private void finishGroupHistoryDataForBasicUnitIds(long[] basicUnitIds, long time) {
        for (long unitId : basicUnitIds) {
            List<Grouphistory> records = this.grouphistoryDAO.findByBasicUnitId(unitId);
            if (records == null || records.size() == 0) continue;
            records.get(0).setEndTime(time);
        }
    }

    private Set<UnitModel> collectParentUnitGroups(UnitModel childId) {
        TreeSet<UnitModel> unitGroups = new TreeSet<UnitModel>();
        ArrayList<UnitModel> parentIds = new ArrayList<UnitModel>(this.getParentIdsByChildId(childId));
        int size = parentIds.size();
        for (int i = 0; i != size; ++i) {
            UnitModel unitModel = (UnitModel)parentIds.get(i);
            unitGroups.add(unitModel);
            unitGroups.addAll(this.collectParentUnitGroups(unitModel));
        }
        return unitGroups;
    }

    @Override
    @Business(viewType="local")
    public List<UnitModel> getParentIdsByChildId(UnitModel childId) {
        return this.unitModelDAO.findParentsFromChildId(childId.getUnitId());
    }

    @Override
    @Business(viewType="both")
    public boolean assignUnitsToUnitgroup(long groupId, long[] unitIds) {
        if (this.unitFacadeLocal._assignUnitsToUnitgroupInNewTx(groupId, unitIds)) {
            this.permissionUpdateNotifyBeanLocal.sendAirportMapUnitsMovedMessage();
        }
        return true;
    }

    @Override
    @Business(viewType="both")
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public boolean _assignUnitsToUnitgroupInNewTx(long groupId, long[] unitIds) {
        ArrayList<String> newAssignment = new ArrayList<String>();
        ArrayList<UnitModel> newUnits = new ArrayList<UnitModel>();
        EntityManager auditEntityManager = JpaUtil.createAuditEntityManager();
        UnitModel oldGroup = (UnitModel)auditEntityManager.find(UnitModel.class, (Object)groupId);
        List<UnitModel> oldChidUnits = oldGroup.getChildModel();
        ArrayList<Long> oldChildUnitIds = new ArrayList<Long>();
        for (UnitModel oldChild : oldChidUnits) {
            oldChildUnitIds.add(oldChild.getUnitId());
        }
        ArrayList unitIdList = ContainerUtil.asArrayList((Object)unitIds);
        List changeList = ContainerUtil.disjunctList((List)unitIdList, oldChildUnitIds);
        long[] grouphistoryUnits = ContainerUtil.convertToLongArray((List)changeList);
        UnitModel unitModelGroup = (UnitModel)this.unitModelDAO.findByPrimaryKey(groupId);
        ArrayList<String> oldAssignment = new ArrayList<String>();
        List<UnitModel> groupUnits = unitModelGroup.getChildModel();
        for (UnitModel unitModel : groupUnits) {
            oldAssignment.add(unitModel.getUnitIdentity().getName());
            if (!unitModel.getDeleted()) continue;
            newAssignment.add(unitModel.getUnitIdentity().getName());
            newUnits.add(unitModel);
        }
        UnitModel unitModel = null;
        for (long unitId : unitIds) {
            unitModel = (UnitModel)this.unitModelDAO.findByPrimaryKey(unitId);
            if (newAssignment.contains(unitModel.getUnitIdentity().getName())) continue;
            newAssignment.add(unitModel.getUnitIdentity().getName());
            newUnits.add(unitModel);
        }
        Collections.sort(oldAssignment);
        Collections.sort(newAssignment);
        if (((Object)oldAssignment).toString().equals(((Object)newAssignment).toString())) {
            return false;
        }
        HashMap<UnitModel, Integer> unitToUseUsersKeysOld = this.getUnitToUseUsersKeyForChangedAssignment(groupUnits, newUnits, true);
        unitModelGroup.replaceRelations(newUnits, UnitModel.class, "childModel");
        this.entityManager.flush();
        this.permissionCheckerLocal.updateAllUserPermissions();
        HashMap<UnitModel, Integer> unitToUseUsersKeysNew = this.getUnitToUseUsersKeyForChangedAssignment(groupUnits, newUnits, true);
        this.updateUnitUserRefresh(unitToUseUsersKeysOld, unitToUseUsersKeysNew);
        this.refreshGroupHistoryDataForBasicUnitIds(grouphistoryUnits);
        auditEntityManager.close();
        return true;
    }

    private void beginGroupHistoryDataForBasicUnitIds(long[] basicUnitIds, long time) {
        ArrayList<UnitModel> basicUnits = new ArrayList<UnitModel>();
        for (long unitId : basicUnitIds) {
            UnitModel unitModel = (UnitModel)this.unitModelDAO.findByPrimaryKey(unitId);
            if (basicUnits.contains(unitModel) || !unitModel.getBasic()) continue;
            basicUnits.add(unitModel);
        }
        for (UnitModel basicUnit : basicUnits) {
            Grouphistory groupHistory = new Grouphistory();
            groupHistory.setBeginTime(time);
            groupHistory.setUnitId(basicUnit.getUnitId());
            this.grouphistoryDAO.createEntity(groupHistory);
            Set<UnitModel> unitGroups = this.collectParentUnitGroups(basicUnit);
            ArrayList<UnitModel> unitList = new ArrayList<UnitModel>(unitGroups);
            groupHistory.setUnitGroups(unitList);
            List<StateCache> cacheEntries = this.currentStateFacadeLocal.findByUnitId(basicUnit.getUnitId());
            for (StateCache stateCache : cacheEntries) {
                stateCache.setGroupHistoryId(groupHistory.getGroupHistoryId());
                StateHistory stateHistory = this.currentStateFacadeLocal.findByPrimaryKey(stateCache.getHistoryId());
                stateHistory.setGroupHistoryId(groupHistory.getGroupHistoryId());
            }
        }
    }

    private List<UnitModel> getUnitModelsByTypeId(long unitTypeIdentityId) {
        List<UnitModel> result = null;
        UnitTypeIdentity unitIdentity = (UnitTypeIdentity)this.unitTypeIdentityDAO.findByPrimaryKey(unitTypeIdentityId);
        if (unitIdentity != null) {
            result = unitIdentity.getUnitModels();
        }
        return result;
    }

    @Override
    @Business(viewType="both")
    public boolean isUnitTypeIdentityDeletable(long unitTypeIdentityId) {
        List<UnitModel> unitModels = this.getUnitModelsByTypeId(unitTypeIdentityId);
        return unitModels != null && unitModels.isEmpty();
    }

    private UnitTypeIdentity setUnitTypeIdentity(UnitModel unitModel, long unitType) {
        UnitTypeIdentity unitTypeIdentity = (UnitTypeIdentity)this.unitTypeIdentityDAO.findByPrimaryKey(unitType);
        unitModel.setUnitTypeIdentity(unitTypeIdentity);
        return unitTypeIdentity;
    }

    @Override
    @Business(viewType="both")
    public Long insertUnit(UnitDTO unitDTO, long typeId, boolean validateDuplicates) throws CreateException, UnitPropertyException {
        Long id = null;
        HashSet<UnitValidationError> validationErrors = null;
        if (validateDuplicates) {
            validationErrors = this.validateUnit(unitDTO);
        }
        if (validationErrors != null) {
            throw new UnitPropertyException(validationErrors);
        }
        UnitModel unitModel = unitDTO.getUnitModel();
        this.initializeUnitModelData(unitModel, true, true);
        UnitIdentity unitIdentity = unitDTO.getUnitIdentity();
        unitModel.setUnitIdentity(unitIdentity);
        unitIdentity.setUnitModel(unitModel);
        this.unitModelDAO.createEntity(unitModel);
        id = unitModel.getUnitId();
        if (unitModel.getBasic()) {
            this.setUnitTypeIdentity(unitModel, typeId);
        }
        if (unitModel.getBasic()) {
            this.informantClient.notify("", "UnitModelNotifyMessage");
        }
        return id;
    }

    @Override
    @Business(viewType="both")
    public Long insertUnitFlush(UnitDTO unitDTO, long typeId, boolean validateDuplicates) throws CreateException, UnitPropertyException {
        long unitId = this.insertUnit(unitDTO, typeId, validateDuplicates);
        this.entityManager.flush();
        return unitId;
    }

    @Override
    @Business(viewType="both")
    public UnitModel getUnitModelNexTX(long unitId) {
        return this.getUnitModel(unitId);
    }

    private List<UnitDTO> getValidationUnits() {
        UnitDTOList units = this.getUnits(true, false, true);
        units.addAll(this.getUnits(false, false, true));
        return units;
    }

    @Override
    @Business(viewType="both")
    public List<HashSet<UnitValidationError>> validateUnits(List<UnitDTO> units, boolean skipSameUnit) {
        int unitCount = units.size();
        ArrayList<HashSet<UnitValidationError>> errors = new ArrayList<HashSet<UnitValidationError>>(unitCount);
        List<UnitDTO> existingUnits = this.getValidationUnits();
        boolean errorOccured = false;
        for (int i = 0; i != unitCount; ++i) {
            HashSet<UnitValidationError> currentErrors = this.validateUnit(units.get(i), existingUnits, skipSameUnit);
            errors.add(currentErrors);
            if (currentErrors == null) continue;
            errorOccured = true;
        }
        return errorOccured ? errors : null;
    }

    @Override
    @Business(viewType="both")
    public HashSet<UnitValidationError> validateUnit(UnitDTO unitDTO) {
        return this.validateUnit(unitDTO, null, true);
    }

    public HashSet<UnitValidationError> validateUnit(UnitDTO unitDTO, List<UnitDTO> existingUnits, boolean skipSameUnit) {
        HashSet<UnitValidationError> validationErrors = new HashSet<UnitValidationError>();
        if (existingUnits == null) {
            existingUnits = this.getValidationUnits();
        }
        long id = unitDTO.getUnitId();
        String unitName = unitDTO.getUnitName();
        String unitIpAddresse = unitDTO.getUnitModel().getIpAddress();
        String unitSimNumber = unitDTO.getUnitModel().getSimNumber();
        String unitTelephoneNumber = unitDTO.getUnitModel().getTelephoneNumber();
        String infomanSerialNumber = unitDTO.getUnitModel().getSerialNumber();
        int unitCount = existingUnits.size();
        for (int i = 0; i != unitCount; ++i) {
            UnitModel unitModelValue;
            UnitDTO currentUnit = existingUnits.get(i);
            if (skipSameUnit && currentUnit != null && currentUnit.getUnitId() == id) continue;
            boolean deleted = currentUnit.getUnitModel().getDeleted();
            String value = currentUnit.getUnitName();
            if (value != null && !unitName.equals("") && value.equals(unitName)) {
                validationErrors.add(deleted ? UnitValidationError.duplicateNameDeleted : UnitValidationError.duplicateName);
            }
            if ((value = (unitModelValue = currentUnit.getUnitModel()).getIpAddress()) != null && unitIpAddresse != null && !unitIpAddresse.equals("") && value.equals(unitIpAddresse)) {
                validationErrors.add(deleted ? UnitValidationError.duplicateIpAddressDeleted : UnitValidationError.duplicateIpAddress);
            }
            if ((value = unitModelValue.getSimNumber()) != null && unitSimNumber != null && !unitSimNumber.equals("") && value.equals(unitSimNumber)) {
                validationErrors.add(deleted ? UnitValidationError.duplicateSimNumberDeleted : UnitValidationError.duplicateSimNumber);
            }
            if ((value = unitModelValue.getTelephoneNumber()) != null && unitTelephoneNumber != null && !unitTelephoneNumber.equals("") && value.equals(unitTelephoneNumber)) {
                validationErrors.add(deleted ? UnitValidationError.duplicateTelephoneNumberDeleted : UnitValidationError.duplicateTelephoneNumber);
            }
            if ((value = unitModelValue.getSerialNumber()) == null || infomanSerialNumber == null || infomanSerialNumber.equals("") || !value.equals(infomanSerialNumber)) continue;
            validationErrors.add(deleted ? UnitValidationError.duplicateInfomanSerialNumberDeleted : UnitValidationError.duplicateInfomanSerialNumber);
        }
        return validationErrors.isEmpty() ? null : validationErrors;
    }

    @Override
    @Business(viewType="both")
    public boolean restoreUnit(long unitId) throws UnitPropertyException {
        UnitModel unit = (UnitModel)this.unitModelDAO.findByPrimaryKey(unitId);
        UnitDTO unitDTO = DTOFactory.buildUnitDTO(unit);
        unitDTO.getUnitModel().setDeleted(false);
        return this.updateUnit(unitDTO, unitDTO.getUnitTypeIdentity().getId(), true, true);
    }

    @Override
    @Business(viewType="both")
    public boolean updateUnit(UnitDTO unitDTO, long typeId, boolean sendUnitModelNotifyMsg, boolean validateDuplicates) throws UnitPropertyException {
        boolean success = false;
        HashSet<UnitValidationError> validationErrors = null;
        if (validateDuplicates) {
            validationErrors = this.validateUnit(unitDTO);
        }
        if (validationErrors != null) {
            throw new UnitPropertyException(validationErrors);
        }
        UnitModel unitModel = unitDTO.getUnitModel();
        unitModel.setUnitIdentity(unitDTO.getUnitIdentity());
        EntityManager auditEntityManager = JpaUtil.createAuditEntityManager();
        UnitModel oldUnitModel = (UnitModel)auditEntityManager.find(UnitModel.class, unitModel.getPrimaryKey());
        long oldTypeId = 0L;
        if (unitModel.getBasic()) {
            oldTypeId = unitModel.getUnitTypeIdentity().getId();
            if (unitModel.getBasic() && typeId != 0L && oldTypeId != typeId) {
                this.setUnitTypeIdentity(unitModel, typeId);
            }
        }
        if (sendUnitModelNotifyMsg) {
            this.informantClient.notify("", "UnitModelNotifyMessage");
        }
        if (!oldUnitModel.equals(unitModel) || oldUnitModel.getUnitTypeIdentity() != null && !((Object)oldUnitModel.getUnitTypeIdentity()).equals(unitModel.getUnitTypeIdentity())) {
            unitModel = (UnitModel)this.unitModelDAO.updateEntity(unitModel);
            if (oldUnitModel.getDeleted() && !unitModel.getDeleted()) {
                this.initializeUnitModelData(unitModel, true, true);
            }
        }
        success = true;
        this.sendAirportMapUnitChanged(oldTypeId, oldUnitModel, oldUnitModel.getUnitIdentity(), unitModel);
        auditEntityManager.close();
        return success;
    }

    @Override
    @Business(viewType="both")
    public boolean updateUnits(List<UnitDTO> list, boolean sendUnitModelNotifyMsg, boolean validateDuplicates) throws UnitPropertyException {
        boolean success = false;
        for (UnitDTO unitDTO : list) {
            long typeId = unitDTO.getUnitTypeIdentity().getId();
            success = this.updateUnit(unitDTO, typeId, sendUnitModelNotifyMsg, validateDuplicates);
            if (!unitDTO.getUnitModel().getDeleted()) continue;
            log.info((Object)("Deleting Unit: " + unitDTO.getUnitId()));
            success = this.deleteUnit(unitDTO);
        }
        return success;
    }

    @Override
    @Business(viewType="both")
    public void deletePermissionsForUnit(long unitId) {
        if (unitId == 0L) {
            return;
        }
        List<UnitPermission> permissions = this.unitPermissionDAO.findByUnitIdOrGroupId(unitId);
        int size = permissions.size();
        for (int i = 0; i != size; ++i) {
            this.unitPermissionDAO.removeEntity(permissions.get(i));
        }
    }

    @Override
    @Business(viewType="both")
    @TransactionTimeout(value=1500)
    public boolean deleteUnit(long unitId) {
        UnitModel unit = (UnitModel)this.unitModelDAO.findByPrimaryKey(unitId);
        UnitDTO unitDTO = DTOFactory.buildUnitDTO(unit);
        return this.deleteUnit(unitDTO);
    }

    @Override
    @Business(viewType="both")
    @TransactionTimeout(value=1500)
    public boolean deleteUnit(UnitDTO unitDTO) {
        boolean success = false;
        try {
            UnitModel oldUnitModel = this.unitFacadeLocal._deleteUnitInNewTx(unitDTO);
            if (oldUnitModel == null) {
                this.permissionUpdateNotifyBeanLocal.sendAirportMapUnitsMovedMessage();
            }
            success = true;
        }
        catch (Exception e) {
            if (this.containsCause(e, ConstraintViolationException.class)) {
                log.error((Object)"Delete failed, probably FK-constraint violation.");
            }
            log.error((Object)"runs into", (Throwable)e);
        }
        return success;
    }

    private boolean containsCause(Throwable ex, Class<? extends Throwable> cause) {
        while (ex != null) {
            if (ex.getClass().equals(cause)) {
                return true;
            }
            ex = ex.getCause();
        }
        return false;
    }

    @Override
    @Business(viewType="both")
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public UnitModel _deleteUnitInNewTx(UnitDTO unitDTO) throws Exception {
        UnitModel unitModel = (UnitModel)this.unitModelDAO.findByPrimaryKey(unitDTO.getUnitModel().getPrimaryKey());
        if (unitModel.getBasic()) {
            EntityManager auditEntityManager = JpaUtil.createAuditEntityManager();
            UnitModel oldUnitModel = (UnitModel)auditEntityManager.find(UnitModel.class, unitModel.getPrimaryKey());
            unitModel.setDeleted(true);
            unitModel.setDeletedTime(System.currentTimeMillis());
            unitModel.setDeletedByUsername(this.sessionContext.getCallerPrincipal().getName());
            unitModel = (UnitModel)this.unitModelDAO.updateEntity(unitModel);
            this.sendAirportMapUnitChanged(oldUnitModel.getUnitTypeIdentity().getId(), oldUnitModel, oldUnitModel.getUnitIdentity(), unitModel);
            auditEntityManager.close();
            this.moveCacheToHistory(unitModel);
            return oldUnitModel;
        }
        this.unitModelDAO.removeEntity(unitModel);
        return null;
    }

    @Override
    @Business(viewType="both")
    public Long insertUnitType(UnitTypeIdentity unitTypeIdentity) throws CreateException {
        Long id = null;
        if (this.duplicatedUnitKind(unitTypeIdentity.getName(), -1L)) {
            throw new CreateException("update not possible, unitKind already exists");
        }
        this.unitTypeIdentityDAO.createEntity(unitTypeIdentity);
        id = unitTypeIdentity.getId();
        return id;
    }

    @Override
    @Business(viewType="both")
    public Long insertUnitTypeFlush(UnitTypeIdentity unitTypeIdentity) throws CreateException {
        Long ret = this.insertUnitType(unitTypeIdentity);
        this.entityManager.flush();
        return ret;
    }

    @Override
    @Business(viewType="both")
    public void updateUnitType(UnitTypeIdentity newIdentity) {
        long unitId = newIdentity.getId();
        if (!this.duplicatedUnitKind(newIdentity.getName(), unitId)) {
            this.unitFacadeLocal._updateUnitTypeInNewTx(newIdentity);
            this.permissionUpdateNotifyBeanLocal.sendUnitTypeChangedJMSMessage(newIdentity, this.getUnitModelsByTypeId(newIdentity.getId()));
        }
    }

    @Override
    @Business(viewType="both")
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void _updateUnitTypeInNewTx(UnitTypeIdentity newIdentity) {
        long unitId = newIdentity.getId();
        EntityManager auditEntityManager = JpaUtil.createAuditEntityManager();
        UnitTypeIdentity oldIdentity = (UnitTypeIdentity)auditEntityManager.find(UnitTypeIdentity.class, (Object)unitId);
        if (((Object)oldIdentity).equals(newIdentity)) {
            return;
        }
        auditEntityManager.close();
        newIdentity = (UnitTypeIdentity)this.unitTypeIdentityDAO.updateEntity(newIdentity);
    }

    @Override
    @Business(viewType="both")
    public boolean deleteUnitType(long unitTypeIdentityId) {
        UnitTypeIdentity unitIdentity = (UnitTypeIdentity)this.unitTypeIdentityDAO.findByPrimaryKey(unitTypeIdentityId);
        this.unitTypeIdentityDAO.removeEntity(unitIdentity);
        return true;
    }

    private boolean duplicatedUnitKind(String unitKind, long unitTypeId) {
        boolean duplicated = false;
        List<UnitTypeIdentity> collection = this.getUnitTypes();
        for (UnitTypeIdentity value : collection) {
            if (value.getId() == unitTypeId || !value.getName().equals(unitKind)) continue;
            duplicated = true;
            break;
        }
        return duplicated;
    }

    @Override
    @Business(viewType="both")
    public List<UnitPermission> getUnitPermissions(long unitId) {
        return new ArrayList<UnitPermission>(this.unitPermissionDAO.findUnitPermissionByUnitId(unitId));
    }

    @Override
    @Business(viewType="both")
    public ArrayList<UnitPermission> getUnitPermissionsByRoleId(long roleId) {
        Role role = this.roleAdministrationFacade.getRole(roleId);
        return new ArrayList<UnitPermission>(role.getUnitPermissions());
    }

    @Override
    @Business(viewType="both")
    public List<UnitPermission> getUnitPermissionsByAccount(String username) {
        Account account = this.userAdminFacadeLocal.getAccountByUsername(username);
        return account == null ? new ArrayList<UnitPermission>(0) : new ArrayList<UnitPermission>(account.getUnitPermissions());
    }

    @Override
    @Business(viewType="both")
    public List<UseUser> getAllUseUserByUnitId(long unitId) {
        ArrayList<UseUser> list = new ArrayList<UseUser>();
        ArrayList<Object> unitTypeIdUnitIdCheckingList = new ArrayList();
        unitTypeIdUnitIdCheckingList = this.collectParentFolders(unitId);
        unitTypeIdUnitIdCheckingList.add(unitId);
        ArrayList<UnitPermission> collection = new ArrayList<UnitPermission>();
        for (int i = 0; i < unitTypeIdUnitIdCheckingList.size(); ++i) {
            long unitIdNext = (Long)unitTypeIdUnitIdCheckingList.get(i);
            List<UnitPermission> coll = this.unitPermissionDAO.findPermissionsForUseUsersByUnitId(unitIdNext);
            collection.addAll(coll);
        }
        Iterator it = collection.iterator();
        ArrayList<Long> useUserList = new ArrayList<Long>();
        while (it.hasNext()) {
            UnitPermission permission = (UnitPermission)it.next();
            Long permUnitId = permission.getUnitId();
            Long permUnitGroupId = permission.getGroupId();
            if (!unitTypeIdUnitIdCheckingList.contains(permUnitId) && !unitTypeIdUnitIdCheckingList.contains(permUnitGroupId)) continue;
            UseUser useUser = permission.getUseUser();
            if (useUser != null) {
                if (list.contains(useUser) || useUserList.contains(useUser.getId())) continue;
                list.add(useUser);
                useUserList.add(useUser.getId());
                continue;
            }
            UseGroup useGroup = permission.getUseGroup();
            List<UseUser> listUseUsersForGroup = this.useUserAdminFacade.getUseUsersByUseGroupId(useGroup.getId());
            int size = listUseUsersForGroup.size();
            for (int i = 0; i != size; ++i) {
                UseUser value = listUseUsersForGroup.get(i);
                if (list.contains(value) || useUserList.contains(value.getId())) continue;
                list.add(value);
                useUserList.add(value.getId());
            }
        }
        return list;
    }

    @Override
    @Business(viewType="both")
    public ArrayList<UnitPermission> getUnitPermissionsByUseUserId(long useUserId, boolean filterDeleted) {
        ArrayList<UnitPermission> result = new ArrayList<UnitPermission>();
        UseUser useUser = this.useUserAdminFacade.getUseUserById(useUserId);
        for (UnitPermission p : useUser.getUnitPermissions()) {
            long unitId = p.getUnitId() != null ? p.getUnitId() : p.getGroupId();
            if (this.getUnitDTO(unitId).isDeleted() && filterDeleted) continue;
            result.add(p);
        }
        return result;
    }

    @Override
    @Business(viewType="both")
    public ArrayList<UnitPermission> getUnitPermissionsByUseUserId(long useUserId) {
        return this.getUnitPermissionsByUseUserId(useUserId, false);
    }

    @Override
    @Business(viewType="both")
    public ArrayList<UnitPermission> getUnitPermissionsByUseGroupId(long useGroupId, boolean filterDeleted) {
        ArrayList<UnitPermission> result = new ArrayList<UnitPermission>();
        if (useGroupId < 0L) {
            return new ArrayList<UnitPermission>(0);
        }
        UseGroup useGroup = this.useUserGroupAdminFacadeLocal.getUseGroupById(useGroupId);
        for (UnitPermission p : useGroup.getUnitPermissions()) {
            long unitId = p.getUnitId() != null ? p.getUnitId() : p.getGroupId();
            if (this.getUnitDTO(unitId).isDeleted() && filterDeleted) continue;
            result.add(p);
        }
        return result;
    }

    @Override
    @Business(viewType="both")
    public ArrayList<UnitPermission> getUnitPermissionsByUseGroupId(long useGroupId) {
        return this.getUnitPermissionsByUseGroupId(useGroupId, false);
    }

    private void updateUnitUserRefresh(List<UnitPermission> permissionValues) {
        if (permissionValues == null || permissionValues.isEmpty()) {
            return;
        }
        HashSet<Long> set = this.getPermittedUnitIds(permissionValues);
        if (set == null || set.isEmpty()) {
            return;
        }
        List<UnitDTO> list = this.getUnitDTOsForUnitIds(set);
        for (UnitDTO unitDto : list) {
            if (unitDto == null) continue;
            UnitModel unitModelValue = unitDto.getUnitModel();
            unitModelValue.setUnitUserRefresh(true);
            unitModelValue.setUnitUserSyncStartTime(0L);
            unitModelValue.setLoggingEnabled(false);
            if (log.isDebugEnabled()) {
                log.debug((Object)(" ---- set unituserrefresh for unit to true : " + unitDto.getUnitId() + "  " + unitDto.getUnitName()));
            }
            try {
                this.updateUnit(unitDto, 0L, false, false);
            }
            catch (UnitPropertyException e) {}
        }
    }

    @Override
    @Business(viewType="both")
    public void updateUnitUserRefreshTmp(List<UnitPermission> permissionValues) {
        if (permissionValues == null || permissionValues.isEmpty()) {
            return;
        }
        HashSet<Long> set = this.getPermittedUnitIds(permissionValues);
        if (set == null || set.isEmpty()) {
            return;
        }
        List<UnitDTO> list = this.getUnitDTOsForUnitIds(set);
        for (UnitDTO obj : list) {
            UnitDTO unitDto = obj;
            if (unitDto == null) continue;
            UnitModel unitModelValue = unitDto.getUnitModel();
            unitModelValue.setUnitUserRefreshTmp(true);
            try {
                this.updateUnit(unitDto, 0L, false, false);
            }
            catch (UnitPropertyException e) {}
        }
    }

    @Override
    @Business(viewType="both")
    public ArrayList<UnitPermission> getUnitPermissionsByGroupId(long groupId) {
        GroupIdent groupIdent = this.getUserGroupAdminFacade().getGroupIdent(groupId);
        return new ArrayList<UnitPermission>(groupIdent.getUnitPermissions());
    }

    @Override
    @Business(viewType="both")
    public boolean setUnitPermissionForUseUser(long useUserId, long unitId, boolean setUnitUserRefresh, boolean setUnitUserRefreshTMP) throws UnitNotFoundException {
        if (!this.hasUseUserPermissions(unitId, useUserId)) {
            UnitModel unitModel = (UnitModel)this.unitModelDAO.findByPrimaryKey(unitId);
            if (unitModel == null) {
                throw new UnitNotFoundException(unitId);
            }
            UnitPermission unitPermission = new UnitPermission();
            unitPermission.setUnitId(unitId);
            unitPermission.setUseUserId(useUserId);
            this.unitPermissionDAO.createEntity(unitPermission);
            if (setUnitUserRefresh || setUnitUserRefreshTMP) {
                if (setUnitUserRefresh) {
                    unitModel.setUnitUserRefresh(true);
                    unitModel.setUnitUserSyncStartTime(0L);
                }
                if (setUnitUserRefreshTMP) {
                    unitModel.setUnitUserRefreshTmp(true);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    @Business(viewType="both")
    public boolean transferACLFlag() {
        List<UnitModel> coll = this.unitModelDAO.findByIsBasicAndUnitUserRefreshTmp();
        for (UnitModel unitModelLocal : coll) {
            unitModelLocal.setUnitUserRefresh(true);
            unitModelLocal.setUnitUserSyncStartTime(0L);
            unitModelLocal.setUnitUserRefreshTmp(false);
        }
        return true;
    }

    @Override
    @Business(viewType="both")
    public boolean removeUnitPermissionForUseUser(long useUserId, long unitId, boolean setUnitUserRefresh, boolean setUnitUserRefreshTMP) {
        try {
            List<UnitPermission> coll = this.unitPermissionDAO.findByUnitORGroupIdAndUserId(unitId, useUserId);
            Iterator it = coll.iterator();
            if (it.hasNext()) {
                UnitPermission permissionLocal = (UnitPermission)it.next();
                this.unitPermissionDAO.removeEntity(permissionLocal);
                if (setUnitUserRefresh || setUnitUserRefreshTMP) {
                    UnitModel unitModelLocal = (UnitModel)this.unitModelDAO.findByPrimaryKey(unitId);
                    if (setUnitUserRefresh) {
                        unitModelLocal.setUnitUserRefresh(true);
                        unitModelLocal.setUnitUserSyncStartTime(0L);
                    }
                    if (setUnitUserRefreshTMP) {
                        unitModelLocal.setUnitUserRefreshTmp(true);
                    }
                }
                return true;
            }
        }
        catch (EJBException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return false;
    }

    @Override
    @Business(viewType="both")
    public void setUnitPermissions(List<UnitPermission> collUnitPermissions) {
        for (UnitPermission permissionValue : collUnitPermissions) {
            this.unitPermissionDAO.createEntity(permissionValue);
        }
    }

    @Override
    @Business(viewType="both")
    public HashSet<Long> getUnitIdsForPermissionByUsername(String username) {
        List<UnitPermission> permits = this.getUnitPermissionsByAccount(username);
        HashSet<Long> unitIds = this.getPermittedUnitIds(permits);
        return unitIds;
    }

    private HashSet<Long> getUnitIdsForPermissionByGroupId(long groupId) {
        ArrayList<UnitPermission> permits = this.getUnitPermissionsByGroupId(groupId);
        HashSet<Long> unitIds = this.getPermittedUnitIds(permits);
        return unitIds;
    }

    private HashSet<Long> getPermittedUnitIds(Role role) {
        return this.getPermittedUnitIds(role.getUnitPermissions());
    }

    private HashSet<Long> getUnitIdsForPermissionByUseUserId(long useUserId) {
        ArrayList<UnitPermission> permits = this.getUnitPermissionsByUseUserId(useUserId);
        HashSet<Long> unitIds = this.getPermittedUnitIds(permits);
        return unitIds;
    }

    private HashSet<Long> getUnitIdsForPermissionByUseGroupId(Long useGroupId) {
        HashSet<Long> result;
        if (useGroupId == null) {
            result = new HashSet<Long>();
        } else {
            ArrayList<UnitPermission> permits = this.getUnitPermissionsByUseGroupId(useGroupId);
            result = this.getPermittedUnitIds(permits);
        }
        return result;
    }

    private HashSet<Long> getPermittedUnitIds(List<UnitPermission> permissions) {
        Object arr;
        HashSet<Long> unitIds = new HashSet<Long>();
        HashSet<Long> unitGroupIds = new HashSet<Long>();
        for (UnitPermission u : permissions) {
            Long groupId = u.getGroupId();
            if (groupId != null) {
                unitGroupIds.add(groupId);
                continue;
            }
            Long unitId = u.getUnitId();
            if (unitId == null) continue;
            unitIds.add(unitId);
        }
        HashSet<Long> unitGroupIdsSubs = new HashSet<Long>();
        for (Long parentId : unitGroupIds) {
            arr = this.collectFolders(parentId);
            unitGroupIdsSubs.addAll((Collection<Long>)arr);
        }
        unitGroupIds.addAll(unitGroupIdsSubs);
        for (Long parentId : unitGroupIds) {
            arr = this.getChildrenIdsByParentId(parentId, 1);
            for (int i = 0; i < ((Object)arr).length; ++i) {
                unitIds.add((long)arr[i]);
            }
        }
        return unitIds;
    }

    @Override
    @Business(viewType="local")
    public ArrayList<Long> collectParentFolders(long childId) {
        long[] parentIds;
        ArrayList<Long> list = new ArrayList<Long>();
        for (long parentId : parentIds = this.getParentIdsByChildId(childId)) {
            list.add(parentId);
            list.addAll(this.collectParentFolders(parentId));
        }
        return list;
    }

    private ArrayList<Long> collectFolders(long parent) {
        ArrayList<Long> list = new ArrayList<Long>();
        long[] childrenIds = this.getChildrenIdsByParentId(parent, 0);
        if (childrenIds != null) {
            for (long childUnitId : childrenIds) {
                list.add(childUnitId);
                list.addAll(this.collectFolders(childUnitId));
            }
        }
        return list;
    }

    @Override
    @Business(viewType="both")
    public long[] getChildrenIdsByParentId(long parentId, int typeBasic) {
        long[] childrenIds = null;
        List<UnitModel> coll = this.unitModelDAO.findByParentUnitId(parentId);
        ArrayList<UnitModel> requestedColl = new ArrayList<UnitModel>();
        for (UnitModel unitModelCild : coll) {
            if (unitModelCild.getBasic() && typeBasic != 0) {
                requestedColl.add(unitModelCild);
            }
            if (unitModelCild.getBasic() || typeBasic == 1) continue;
            requestedColl.add(unitModelCild);
        }
        childrenIds = new long[requestedColl.size()];
        int i = 0;
        for (UnitModel unitModelCild : requestedColl) {
            long unitId;
            childrenIds[i] = unitId = unitModelCild.getUnitId();
            ++i;
        }
        return childrenIds;
    }

    @Override
    @Business(viewType="both")
    public long[] getParentIdsByChildId(long childId) {
        List<UnitModel> coll = this.unitModelDAO.findParentsFromChildId(childId);
        long[] parentIds = new long[coll.size()];
        int i = 0;
        for (UnitModel unitModelParent : coll) {
            long unitId;
            parentIds[i] = unitId = unitModelParent.getUnitId();
            ++i;
        }
        return parentIds;
    }

    private List<UnitDTO> getUnitDTOsForUnitIds(HashSet<Long> unitIds) {
        ArrayList<UnitDTO> unitDtos = new ArrayList<UnitDTO>();
        Iterator<Long> iterator = unitIds.iterator();
        while (iterator.hasNext()) {
            unitDtos.add(this.getUnitDTO(iterator.next()));
        }
        return unitDtos;
    }

    private ArrayList<UnitPermissionDTO> getUnitPermissionDTOsForUnitIds(HashSet<Long> unitIds, boolean user, boolean group, boolean role) {
        return this.getUnitPermissionDTOsForUnitIds(unitIds, user, group, role, false);
    }

    private ArrayList<UnitPermissionDTO> getUnitPermissionDTOsForUnitIds(HashSet<Long> unitIds, boolean user, boolean group, boolean role, boolean filterDeleted) {
        ArrayList<UnitPermissionDTO> unitPermissionDTOs = new ArrayList<UnitPermissionDTO>();
        for (Long unitId : unitIds) {
            UnitDTO unitDto = this.getUnitDTO(unitId);
            if (filterDeleted && unitDto.isDeleted()) continue;
            UnitPermissionDTO unitPermissionDTO = DTOFactory.buildUnitPermissionDTO(unitDto);
            if (user) {
                unitPermissionDTO.setUserPermission(true);
            }
            if (group) {
                unitPermissionDTO.setGroupPermission(true);
            }
            if (role) {
                unitPermissionDTO.setRolePermission(true);
            }
            unitPermissionDTOs.add(unitPermissionDTO);
        }
        return unitPermissionDTOs;
    }

    @Override
    @Business(viewType="both")
    public ArrayList<UnitPermissionDTO> getUnitPermissionDTOsByUsername(String username) {
        HashSet<Long> unitIds = this.getUnitIdsForPermissionByUsername(username);
        ArrayList<UnitPermissionDTO> unitPermissionDTOs = this.getUnitPermissionDTOsForUnitIds(unitIds, true, false, false);
        return unitPermissionDTOs;
    }

    @Override
    @Business(viewType="both")
    public ArrayList<UnitPermissionDTO> getUnitPermissionDTOsByGroupId(long groupId) {
        HashSet<Long> unitIds = this.getUnitIdsForPermissionByGroupId(groupId);
        ArrayList<UnitPermissionDTO> unitPermissionDTOs = this.getUnitPermissionDTOsForUnitIds(unitIds, false, true, false);
        return unitPermissionDTOs;
    }

    @Override
    @Business(viewType="both")
    public ArrayList<UnitPermissionDTO> getUnitPermissionDTOsByUseGroupId(long useGroupId, boolean filterDeleted) {
        HashSet<Long> unitIds = this.getUnitIdsForPermissionByUseGroupId(useGroupId);
        ArrayList<UnitPermissionDTO> unitPermissionDTOs = this.getUnitPermissionDTOsForUnitIds(unitIds, false, true, false, filterDeleted);
        return unitPermissionDTOs;
    }

    @Override
    @Business(viewType="both")
    public List<UnitPermissionDTO> getUnitPermissionDTOs(long roleId) {
        Role role = this.roleAdministrationFacade.getRole(roleId);
        HashSet<Long> unitIds = this.getPermittedUnitIds(role);
        return this.getUnitPermissionDTOsForUnitIds(unitIds, false, false, true);
    }

    private HashMap<Long, HashSet<String>> buildPermissionMapWithNames(Object obj, HashSet<Long> unitIds, HashMap<Long, HashSet<String>> unitToPermissionNames) {
        AuditEntityBase value;
        String name = "";
        Iterator<Long> it = unitIds.iterator();
        if (obj instanceof GroupIdent) {
            value = (GroupIdent)obj;
            name = ((GroupIdent)value).getGroupName();
        } else if (obj instanceof Role) {
            value = (Role)obj;
            name = ((Role)value).getRoleName();
        }
        while (it.hasNext()) {
            Long unitId = it.next();
            HashSet<String> set = new HashSet<String>();
            if (unitToPermissionNames.containsKey(unitId)) {
                set = unitToPermissionNames.get(unitId);
            }
            set.add(name);
            unitToPermissionNames.put(unitId, set);
        }
        return unitToPermissionNames;
    }

    @Override
    @Business(viewType="both")
    public Map<String, HashSet<Long>> getAllUnitIdsForUsernames(String[] usernames) {
        HashMap<String, HashSet<Long>> unitIDsforUserNames = new HashMap<String, HashSet<Long>>(usernames.length);
        for (int i = 0; i != usernames.length; ++i) {
            unitIDsforUserNames.put(usernames[i], this.getAllUnitIdsForUsername(usernames[i]));
        }
        return unitIDsforUserNames;
    }

    @Override
    @Business(viewType="both")
    public HashSet<Long> getAllUnitIdsForUsername(String username) {
        List<Role> roles;
        HashSet<Long> unitIds;
        HashSet<Long> unitIdsAll = new HashSet<Long>();
        HashSet<Role> allRoles = new HashSet<Role>();
        HashSet<Long> unitIdsGroup = new HashSet<Long>();
        List<GroupIdent> userGroups = this.getUserGroupAdminFacade().getGroupsByUsername(username);
        GroupIdent group = null;
        for (int i = 0; i != userGroups.size(); ++i) {
            group = userGroups.get(i);
            unitIds = this.getUnitIdsForPermissionByGroupId(group.getId());
            unitIdsGroup.addAll(unitIds);
            roles = this.roleAdministrationFacade.getRolesByGroupId(group.getId());
            allRoles.addAll(roles);
        }
        HashSet<Long> unitIdsUser = this.getUnitIdsForPermissionByUsername(username);
        roles = this.roleAdministrationFacade.getRolesByUsername(username);
        if (roles != null) {
            allRoles.addAll(roles);
        }
        HashSet<Long> unitIdsRole = new HashSet<Long>();
        for (Role role : allRoles) {
            unitIds = this.getPermittedUnitIds(role);
            unitIdsRole.addAll(unitIds);
        }
        unitIdsAll.addAll(unitIdsGroup);
        unitIdsAll.addAll(unitIdsRole);
        unitIdsAll.addAll(unitIdsUser);
        return unitIdsAll;
    }

    @Override
    @Business(viewType="both")
    public DTOListBase<UnitPermissionDTO> getAllUnitPermissionDTOsForUsername(String username) {
        DTOListBase<UnitPermissionDTO> unitPermissionDTOs = DTOListFactory.buildDTOListBase(null);
        Account account = this.userAdminFacadeLocal.getAccountByUsername(username);
        if (account != null) {
            ArrayList<UnitPermission> allPermissions = new ArrayList<UnitPermission>();
            allPermissions.addAll(account.getUnitPermissions());
            TreeSet<Role> roles = new TreeSet<Role>();
            roles.addAll(account.getRoles());
            for (GroupIdent group : account.getGroups()) {
                allPermissions.addAll(group.getUnitPermissions());
                roles.addAll(group.getRoles());
            }
            for (Role role : roles) {
                allPermissions.addAll(role.getUnitPermissions());
            }
            UnitTreeNode unitTreeRoot = this.unitTreeFacadeLocal.getTreeViewData(false, false, false);
            TreeSet unitDtoList = new TreeSet();
            HashMap<Long, UnitPermissionDTO> permissionMap = new HashMap<Long, UnitPermissionDTO>();
            UnitIdNodeMatcher nodeMatcher = new UnitIdNodeMatcher();
            for (UnitPermission unitPermission : allPermissions) {
                UnitTreeNode node;
                unitDtoList.clear();
                Long groupId = unitPermission.getGroupId();
                if (groupId == null) {
                    nodeMatcher.unitId = unitPermission.getUnitId();
                    node = (UnitTreeNode)unitTreeRoot.getNode(true, nodeMatcher);
                    unitDtoList.add(node.getData());
                } else {
                    nodeMatcher.unitId = groupId;
                    node = (UnitTreeNode)unitTreeRoot.getNode(true, nodeMatcher);
                    for (UnitTreeNode subnode : node.getSubnodes(UnitNodeType.Unit)) {
                        unitDtoList.add(subnode.getData());
                    }
                }
                for (UnitDTO unitDto : unitDtoList) {
                    UnitPermissionDTO permissionDto = (UnitPermissionDTO)permissionMap.get(unitDto.getUnitId());
                    if (permissionDto == null) {
                        permissionDto = DTOFactory.buildUnitPermissionDTO(unitDto);
                        permissionMap.put(unitDto.getUnitId(), permissionDto);
                    }
                    if (unitPermission.getAccountId() != null) {
                        permissionDto.setUserPermission(true);
                        permissionDto.setUserName(account.getUsername());
                        continue;
                    }
                    if (unitPermission.getGroupIdentId() != null) {
                        permissionDto.setGroupPermission(true);
                        permissionDto.addGroupName(unitPermission.getGroupIdent().getName());
                        continue;
                    }
                    if (unitPermission.getRoleId() == null) continue;
                    permissionDto.setRolePermission(true);
                    permissionDto.addRoleName(unitPermission.getRole().getName());
                }
            }
            unitPermissionDTOs.addAll(permissionMap.values());
        }
        return unitPermissionDTOs;
    }

    @Override
    @Business(viewType="both")
    public DTOListBase<UnitPermissionDTO> getAllUnitPermissionDTOsForGroupId(long groupId) {
        DTOListBase<UnitPermissionDTO> unitPermissionDTOs = DTOListFactory.buildDTOListBase(null);
        HashSet<Long> unitIdsAll = new HashSet<Long>();
        GroupIdent groupIdent = this.getUserGroupAdminFacade().getGroupIdent(groupId);
        String groupName = "";
        if (groupIdent != null) {
            groupName = groupIdent.getGroupName();
        }
        HashSet<Long> unitIdsGroup = this.getUnitIdsForPermissionByGroupId(groupId);
        List<Role> roles = this.roleAdministrationFacade.getRolesByGroupId(groupId);
        HashSet<Long> unitIdsRole = new HashSet<Long>();
        HashMap<Long, HashSet<String>> unitToRolenames = new HashMap<Long, HashSet<String>>();
        for (Role role : roles) {
            HashSet<Long> unitIds = this.getPermittedUnitIds(role);
            unitIdsRole.addAll(unitIds);
            unitToRolenames = this.buildPermissionMapWithNames(role, unitIds, unitToRolenames);
        }
        unitIdsAll.addAll(unitIdsGroup);
        unitIdsAll.addAll(unitIdsRole);
        for (Long unitId : unitIdsAll) {
            UnitDTO unitDto = this.getUnitDTO(unitId);
            UnitPermissionDTO unitPermissionDTO = DTOFactory.buildUnitPermissionDTO(unitDto);
            if (unitIdsGroup.contains(unitId)) {
                unitPermissionDTO.setGroupPermission(true);
                unitPermissionDTO.setGroupNames(groupName);
            }
            if (unitIdsRole.contains(unitId)) {
                unitPermissionDTO.setRolePermission(true);
                HashSet<String> s = unitToRolenames.get(unitId);
                unitPermissionDTO.setRoleNames(s.toString());
            }
            unitPermissionDTOs.add(unitPermissionDTO);
        }
        return unitPermissionDTOs;
    }

    @Override
    @Business(viewType="both")
    public boolean hasUseUserPermissions(long unitId, long useUserId) {
        List<UnitPermission> permissions = this.unitPermissionDAO.findByUnitORGroupIdAndUserId(unitId, useUserId);
        return permissions != null && !permissions.isEmpty();
    }

    @Override
    @Business(viewType="both")
    public List<UnitDTO>[] getAccessLists(ReportSelectionDTO selectionDTO) {
        UnitDTOList positiveList = new ArrayList();
        ArrayList<UnitDTO> negativeList = new ArrayList<UnitDTO>();
        if (this.sessionContext.isCallerInRole("superadmin")) {
            positiveList = this.getUnits(true, false);
            return new List[]{positiveList, negativeList};
        }
        String name = this.sessionContext.getCallerPrincipal().getName();
        Collection<UnitModel> availableUnits = UnitListFactory.generateUnitModelList((UnitReportSelectionDTO)selectionDTO, false);
        DTOListBase<UnitPermissionDTO> permissions = this.getAllUnitPermissionDTOsForUsername(name);
        for (UnitModel availableUnit : availableUnits) {
            boolean hasPermission = false;
            Long availableUnitId = availableUnit.getUnitId();
            for (UnitPermissionDTO permission : permissions) {
                if (!availableUnitId.equals(permission.getUnitId())) continue;
                hasPermission = true;
                break;
            }
            if (hasPermission) {
                positiveList.add(this.getUnitDTO(availableUnitId));
                continue;
            }
            negativeList.add(this.getUnitDTO(availableUnitId));
        }
        return new List[]{positiveList, negativeList};
    }

    @Override
    @Business(viewType="both")
    public boolean hasUserAccessForUnit(Long unitId) {
        if (this.sessionContext.isCallerInRole("superadmin")) {
            return true;
        }
        HashSet<Long> permissions = this.getAllUnitIdsForUsername(this.sessionContext.getCallerPrincipal().getName());
        return permissions.contains(unitId);
    }

    @Override
    @Business(viewType="both")
    public DTOListBase<UnitPermissionDTO> getUnitPermissionDTOsForUseUserValue(UseUser useUser, boolean filterDeleted) {
        DTOListBase<UnitPermissionDTO> unitPermissionDTOs = DTOListFactory.buildDTOListBase(null);
        HashMap<Long, UnitPermissionDTO> unitPermissionMap = new HashMap<Long, UnitPermissionDTO>();
        for (UseGroup g : useUser.getUseGroups()) {
            HashSet<Long> unitIdsUseGroup = this.getUnitIdsForPermissionByUseGroupId(g.getId());
            for (Long unitId : unitIdsUseGroup) {
                UnitPermissionDTO unitPermissionDTO;
                if (!unitPermissionMap.containsKey(unitId)) {
                    UnitDTO unitDto = this.getUnitDTO(unitId);
                    unitPermissionDTO = DTOFactory.buildUnitPermissionDTO(unitDto);
                    unitPermissionDTO.setGroupPermission(true);
                    unitPermissionDTO.addGroupName(g.getName());
                } else {
                    unitPermissionDTO = (UnitPermissionDTO)unitPermissionMap.get(unitId);
                    unitPermissionDTO.addGroupName(g.getName());
                }
                unitPermissionMap.put(unitId, unitPermissionDTO);
            }
        }
        HashSet<Long> unitIdsUseUser = this.getUnitIdsForPermissionByUseUserId(useUser.getId());
        for (Long unitId : unitIdsUseUser) {
            UnitPermissionDTO unitPermissionDTO;
            if (!unitPermissionMap.containsKey(unitId)) {
                UnitDTO unitDto = this.getUnitDTO(unitId);
                unitPermissionDTO = DTOFactory.buildUnitPermissionDTO(unitDto);
                unitPermissionDTO.setUserPermission(true);
                unitPermissionDTO.setUserName(useUser.getName());
            } else {
                unitPermissionDTO = (UnitPermissionDTO)unitPermissionMap.get(unitId);
                unitPermissionDTO.setUserPermission(true);
                unitPermissionDTO.setUserName(useUser.getName());
            }
            unitPermissionMap.put(unitId, unitPermissionDTO);
        }
        unitPermissionDTOs.addAll(unitPermissionMap.values());
        return unitPermissionDTOs;
    }

    @Override
    @Business(viewType="both")
    public Collection<UnitModel> getUnitsWithoutParents(boolean isBasic) {
        ArrayList<UnitModel> coll = new ArrayList<UnitModel>();
        List<UnitModel> unitModels = this.unitModelDAO.findByIsBasic(isBasic);
        for (Object e : unitModels) {
            UnitModel unitModel = (UnitModel)e;
            if (unitModel == null) continue;
            List<Object> parents = new ArrayList();
            parents = this.unitModelDAO.findParentsFromChildId(unitModel.getUnitId());
            if (!parents.isEmpty()) continue;
            coll.add(unitModel);
        }
        return coll;
    }

    @Override
    @Business(viewType="both")
    public boolean saveOperativeTimeOffset(long unitId, long runtime) {
        boolean success = false;
        UnitModel unitModel = (UnitModel)this.unitModelDAO.findByPrimaryKey(unitId);
        unitModel.setOperativeTimeOffset(runtime);
        success = true;
        return success;
    }

    @Override
    @Business(viewType="both")
    public void moveCacheToHistory(UnitModel unitModel) {
        ScanmanMsgFacadeLocal scanmanMsgFacade = null;
        UseFacadeLocal useFacade = null;
        GdataFacadeLocal gdataFacade = null;
        NotifyFacadeLocal notifyFacade = null;
        KeepAliveInFacadeLocal keepAliveInFacade = null;
        CurrentStateFacadeLocal currentStateFacade = null;
        try {
            InitialContext context = new InitialContext();
            scanmanMsgFacade = (ScanmanMsgFacadeLocal)context.lookup("rts/ScanmanMsgFacade/local");
            useFacade = (UseFacadeLocal)context.lookup("rts/UseFacade/local");
            gdataFacade = (GdataFacadeLocal)context.lookup("rts/GdataFacade/local");
            notifyFacade = (NotifyFacadeLocal)context.lookup("rts/NotifyFacade/local");
            keepAliveInFacade = (KeepAliveInFacadeLocal)context.lookup("rts/KeepAliveInFacade/local");
            currentStateFacade = (CurrentStateFacadeLocal)context.lookup("rts/CurrentStateFacade/local");
            if (currentStateFacade != null) {
                currentStateFacade.deleteCache(unitModel);
            }
            if (notifyFacade != null) {
                notifyFacade.deleteCache(unitModel);
            }
            if (keepAliveInFacade != null) {
                keepAliveInFacade.deleteCache(unitModel);
            }
            if (gdataFacade != null) {
                gdataFacade.deleteCache(unitModel);
            }
            if (useFacade != null) {
                useFacade.deleteCache(unitModel);
            }
            if (scanmanMsgFacade != null) {
                scanmanMsgFacade.deleteCache(unitModel);
            }
        }
        catch (NamingException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
    }

    @Override
    @Business(viewType="both")
    public void updateUnitUserRefreshForUseGroup(Long groupId) {
        if (groupId != null) {
            this.updateUnitUserRefresh(this.getUnitPermissionsByUseGroupId(groupId));
        }
    }

    @Override
    @Business(viewType="both")
    public void updateUnitUserRefreshForUseUser(long userId) {
        this.updateUnitUserRefresh(this.getUnitPermissionsByUseUserId(userId));
    }

    @Override
    @Business(viewType="both")
    public boolean saveNextMaintenance(long unitId, int nextMaintenance) {
        boolean success = false;
        UnitModel unitModel = (UnitModel)this.unitModelDAO.findByPrimaryKey(unitId);
        unitModel.setNextMaintenance(nextMaintenance);
        success = true;
        return success;
    }

    @Override
    @Business(viewType="both")
    @TransactionTimeout(value=9000)
    public boolean moveUnit(long unitId, Long fromId, Long toId, boolean updateHistoryDataToCurrentGhID) throws UnitAlreadyExistsInGroupException {
        if (fromId == toId) {
            return false;
        }
        boolean ret = this.unitFacadeLocal._moveUnitInNewTx(unitId, fromId, toId, updateHistoryDataToCurrentGhID);
        this.permissionUpdateNotifyBeanLocal.sendAirportMapUnitsMovedMessage();
        return ret;
    }

    @Override
    @Business(viewType="both")
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public boolean _moveUnitInNewTx(long unitId, Long fromId, Long toId, boolean updateHistoryDataToCurrentGhID) throws UnitAlreadyExistsInGroupException {
        UnitModel affectedUnit = (UnitModel)this.unitModelDAO.findByPrimaryKey(unitId);
        ArrayList<UnitModel> unitBasicModels = new ArrayList<UnitModel>();
        unitBasicModels.addAll(UnitListFactory.generateUnitModelList(unitId));
        long[] unitBasicIds = new long[unitBasicModels.size()];
        for (int i = 0; i < unitBasicModels.size(); ++i) {
            unitBasicIds[i] = ((UnitModel)unitBasicModels.get(i)).getUnitId();
        }
        int oldHashCode = this.getUseUsersKeysHashCode(unitId);
        long[] toChildren = null;
        if (toId != null) {
            toChildren = this.getChildrenIdsByParentId(toId, 2);
        }
        for (long childId : toChildren) {
            if (childId != unitId) continue;
            throw new UnitAlreadyExistsInGroupException(unitId, toId);
        }
        StringBuilder auditChangesBuilder = new StringBuilder("${parentModel}: ");
        boolean auditInfoAdded = false;
        if (fromId != null) {
            auditChangesBuilder.append("-");
            auditChangesBuilder.append(this.getUnitIdentity(fromId).getName());
            auditInfoAdded = true;
            UnitModel sourceGroup = (UnitModel)this.unitModelDAO.findByPrimaryKey(fromId);
            sourceGroup.removeRelation(affectedUnit, UnitModel.class, "childModel");
        }
        if (toId != null) {
            if (auditInfoAdded) {
                auditChangesBuilder.append(", ");
            } else {
                auditInfoAdded = true;
            }
            auditChangesBuilder.append("+");
            auditChangesBuilder.append(this.getUnitIdentity(toId).getName());
            UnitModel targetGroup = (UnitModel)this.unitModelDAO.findByPrimaryKey(toId);
            targetGroup.addRelation(affectedUnit, UnitModel.class, "childModel");
            this.entityManager.flush();
            this.refreshGroupHistoryDataForBasicUnitIds(unitBasicIds);
            if (updateHistoryDataToCurrentGhID) {
                this.updateHistoryDataToCurrentGhID(unitBasicIds);
            }
        }
        if (auditInfoAdded) {
            StringBuilder pkName = new StringBuilder("[");
            pkName.append(unitId);
            pkName.append("] ");
            pkName.append(affectedUnit.getName());
            auditChangesBuilder.append(";");
            this.auditFacadeLocal.logEvent(ModuleType.WEB, ActionType.Update, UnitModel.class.getSimpleName(), pkName.toString(), auditChangesBuilder.toString());
        }
        int newHashCode = this.getUseUsersKeysHashCode(unitId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("oldHashcodeForKeys , newHashcodeForKeys  " + oldHashCode + " , " + newHashCode));
        }
        if (newHashCode != oldHashCode) {
            this.setUnitUserRefresh(true, unitBasicModels);
        }
        return true;
    }

    @Override
    @Business(viewType="both")
    public boolean updateHistoryDataToCurrentGhID(long[] unitBasicIds) {
        this.historyFastLaneWriter = new HistoryFastLaneWriter();
        for (long unitId : unitBasicIds) {
            Grouphistory hLocal = null;
            List<Grouphistory> records = this.grouphistoryDAO.findByBasicUnitId(unitId);
            Iterator it = records.iterator();
            long ghId = 0L;
            if (it.hasNext()) {
                hLocal = (Grouphistory)it.next();
                ghId = hLocal.getGroupHistoryId();
            }
            this.historyFastLaneWriter.updateHistoryTablesSetGroupHistoryId(unitId, ghId);
        }
        return true;
    }

    private void refreshGroupHistoryDataForBasicUnitIds(long[] unitBasicIds) {
        long time = System.currentTimeMillis();
        this.finishGroupHistoryDataForBasicUnitIds(unitBasicIds, time);
        this.beginGroupHistoryDataForBasicUnitIds(unitBasicIds, time);
    }

    private HashMap<UnitModel, Integer> getUnitToUseUsersKeyForChangedAssignment(Collection<UnitModel> oldAssignment, Collection<UnitModel> newAssignment, boolean onlyForAclUpdate) {
        HashMap<UnitModel, Integer> unitToUseUsersKeys = new HashMap<UnitModel, Integer>();
        ArrayList<UnitModel> removedChildren = new ArrayList<UnitModel>();
        removedChildren.addAll(oldAssignment);
        removedChildren.removeAll(newAssignment);
        ArrayList<UnitModel> insertedChildren = new ArrayList<UnitModel>();
        insertedChildren.addAll(newAssignment);
        insertedChildren.removeAll(oldAssignment);
        ArrayList<UnitModel> changedChildren = new ArrayList<UnitModel>();
        changedChildren.addAll(insertedChildren);
        changedChildren.addAll(removedChildren);
        for (Object e : changedChildren) {
            UnitModel unitLocal = (UnitModel)e;
            if (unitLocal == null || (!onlyForAclUpdate || unitLocal.getUnitUserRefresh()) && onlyForAclUpdate) continue;
            int hashcode = this.getUseUsersKeysHashCode(unitLocal.getUnitId());
            unitToUseUsersKeys.put(unitLocal, hashcode);
        }
        return unitToUseUsersKeys;
    }

    private void updateUnitUserRefresh(HashMap<UnitModel, Integer> unitToUseUsersKeysOld, HashMap<UnitModel, Integer> unitToUseUsersKeysNew) {
        block0: for (Map.Entry<UnitModel, Integer> unitToUseUsersOld : unitToUseUsersKeysOld.entrySet()) {
            UnitModel unitLocal = unitToUseUsersOld.getKey();
            int oldHashcodeForKeys = unitToUseUsersOld.getValue();
            if (log.isDebugEnabled()) {
                log.debug((Object)" ---------------------------------------------------------------------- ");
                log.debug((Object)(" ### AclUpdate for unit (getUnitUserRefresh):  " + unitLocal.getUnitId() + "  " + unitLocal.getUnitIdentity().getName() + " (" + unitLocal.getUnitUserRefresh() + ")"));
            }
            for (Map.Entry<UnitModel, Integer> unitToUseUsersNew : unitToUseUsersKeysNew.entrySet()) {
                UnitModel unitLocalTmp = unitToUseUsersNew.getKey();
                if (unitLocal != unitLocalTmp) continue;
                int newHashcodeForKeys = unitToUseUsersNew.getValue();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("###  oldHashcodeForKeys , newHashcodeForKeys  " + oldHashcodeForKeys + " , " + newHashcodeForKeys));
                }
                if (oldHashcodeForKeys == newHashcodeForKeys) continue block0;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"###  setUnitUserRefresh(true)  ");
                }
                this.setUnitUserRefresh(true, unitLocal);
                continue block0;
            }
        }
    }

    private int getUseUsersKeysHashCode(long unitId) {
        List<UseUser> list = this.getAllUseUserByUnitId(unitId);
        ArrayList<String> keys = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            keys.add(list.get(i).getKeyId());
        }
        Collections.sort(keys);
        int hashCode = ((Object)keys).hashCode();
        return hashCode;
    }

    private void setUnitUserRefresh(boolean unitUserRefresh, List<UnitModel> unitBasicModels) {
        int size = unitBasicModels.size();
        for (int i = 0; i != size; ++i) {
            this.setUnitUserRefresh(unitUserRefresh, unitBasicModels.get(i));
        }
    }

    private void setUnitUserRefresh(boolean unitUserRefresh, UnitModel unitModel) {
        if (unitModel != null && !unitModel.getUnitUserRefresh() || !unitUserRefresh) {
            if (log.isDebugEnabled()) {
                log.debug((Object)" ---------------------------------------------------------------------- ");
                log.debug((Object)(" ### AclUpdate for unit (getUnitUserRefresh):  " + unitModel.getUnitId() + "  " + unitModel.getUnitIdentity().getName() + " (" + unitModel.getUnitUserRefresh() + ")"));
            }
            unitModel.setUnitUserRefresh(unitUserRefresh);
            unitModel.setUnitUserSyncStartTime(0L);
        }
    }

    @Override
    @Business(viewType="both")
    public void initializeUnitModelData(UnitModel unitModel, boolean resetDeleted, boolean initializeUnitUserData) {
        if (unitModel != null && unitModel.getBasic()) {
            if (resetDeleted) {
                unitModel.setDeleted(false);
                unitModel.setDeletedByUsername(null);
                unitModel.setDeletedTime(0L);
            }
            if (initializeUnitUserData) {
                unitModel.setUnitUserRefresh(true);
                unitModel.setUnitUserRefreshTmp(false);
                unitModel.setUnitUserSyncDone(false);
                unitModel.setUnitUserSyncEndTime(0L);
                unitModel.setUnitUserSyncError(null);
                unitModel.setUnitUserSyncStartTime(0L);
                unitModel.setUnitUserSyncSuccessful(false);
            }
        }
    }

    @Override
    @Business(viewType="both")
    public UnitModel getUnitModel(long unitId) {
        return (UnitModel)this.unitModelDAO.findByPrimaryKey(unitId);
    }

    @Override
    @Business(viewType="both")
    public UnitModel updateUnitModel(UnitModel unitModel) {
        return (UnitModel)this.unitModelDAO.updateEntity(unitModel);
    }

    @Override
    @Business(viewType="both")
    public List<UnitModel> findyByIsBasic(boolean basic) {
        return this.unitModelDAO.findByIsBasic(basic);
    }

    @Override
    @Business(viewType="both")
    public List<UnitModel> findNonDeletedByIsBasic(boolean basic) {
        return this.unitModelDAO.findNonDeletedByIsBasic(basic);
    }

    @Override
    @Business(viewType="both")
    public List<UnitModel> findyByIsBasicAndUnitUserRefreshTmp() {
        return this.unitModelDAO.findByIsBasicAndUnitUserRefreshTmp();
    }

    @Override
    @Business(viewType="both")
    public List<UnitModel> getUnitModelByUnitIdWithGroupId() {
        return this.unitModelDAO.findByUnitIdWithGroupId();
    }

    @Override
    @Business(viewType="both")
    public List<UnitModel> findyParentsFromChildId(long childId) {
        return this.unitModelDAO.findParentsFromChildId(childId);
    }

    @Override
    @Business(viewType="both")
    public List<UnitModel> findByCustomerUnitId(String customerUnitId) {
        return this.unitModelDAO.findByCustomerUnitId(customerUnitId);
    }

    @Override
    @Business(viewType="both")
    public void removeUnit(UnitModel unitModel) {
        this.unitModelDAO.removeEntity(unitModel);
    }

    @Override
    @Business(viewType="both")
    public List<UnitModel> findyByParentUnitId(long unitId) {
        return this.unitModelDAO.findByParentUnitId(unitId);
    }

    @Override
    @Business(viewType="both")
    public List<UnitModel> findyByParentUnitIdAndFilterStateId(long unitId, long fileterState) {
        return this.unitModelDAO.findByParentUnitIdAndFilterStateId(unitId, fileterState);
    }

    @Override
    @Business(viewType="both")
    public List<UnitModel> findByParentUnitIdFilterByTypeAndPositionAndTrusted(long unitId, String type, String position, Boolean trusted) {
        return this.unitModelDAO.findByParentUnitIdFilterByTypeAndPositionAndTrusted(unitId, type, position, trusted);
    }

    @Override
    @Business(viewType="both")
    public List<Long> findByIMEI(String imei) {
        return this.unitModelDAO.findByIMEI(imei);
    }

    @Override
    @Business(viewType="both")
    public List<Long> findBySerialNumber(String serialNumber) {
        return this.unitModelDAO.findBySerialNumber(serialNumber);
    }

    @Override
    @Business(viewType="local")
    public List<UnitIdentity> findAllUnitIdentity() {
        return this.unitIdentityDAO.findAll();
    }

    @Override
    @Business(viewType="both")
    public UnitTypeIdentity getUnitTypeidentity(long unitId) {
        return (UnitTypeIdentity)this.unitTypeIdentityDAO.findByPrimaryKey(unitId);
    }

    @Override
    @Business(viewType="both")
    public void createNewUnitTypeidentity(UnitTypeIdentity unitTypeidentity) {
        this.unitTypeIdentityDAO.createEntity(unitTypeidentity);
    }

    @Override
    @Business(viewType="both")
    public void updateUnitTypeidentity(UnitTypeIdentity unitTypeidentity) {
        this.unitTypeIdentityDAO.updateEntity(unitTypeidentity);
    }

    @Override
    @Business(viewType="both")
    public void removeUnitTypeidentity(UnitTypeIdentity unitTypeidentity) {
        this.unitTypeIdentityDAO.removeEntity(unitTypeidentity);
    }

    @Override
    @Business(viewType="both")
    public List<UnitTypeIdentity> findAllUnitTypeidentity() {
        return this.unitTypeIdentityDAO.findAll();
    }

    @Override
    @Business(viewType="both")
    public List<UnitIdentity> findAllIncludingDeleted() {
        return this.unitIdentityDAO.findAllIncludingDeleted();
    }

    @Override
    @Business(viewType="both")
    public UnitIdentity getUnitIdentity(long unitId) {
        return (UnitIdentity)this.unitIdentityDAO.findByPrimaryKey(unitId);
    }

    @Override
    @Business(viewType="both")
    public List<UnitModel> getAllUnitModel() {
        return this.unitModelDAO.findAll();
    }

    @Override
    @Business(viewType="both")
    public List<UnitIdentity> getUnitIdentityByName(String unitName) {
        return this.unitIdentityDAO.findByName(unitName);
    }

    @Override
    @Business(viewType="both")
    public Long getUnitIdByName(String unitName) {
        List<UnitIdentity> unitIdentities = this.unitIdentityDAO.findByName(unitName);
        if (unitIdentities.size() != 0) {
            return unitIdentities.get(0).getUnitId();
        }
        return null;
    }

    @Override
    @Business(viewType="both")
    public void removeUnitIdentiy(UnitIdentity unitIdentity) {
        this.unitIdentityDAO.removeEntity(unitIdentity);
    }

    @Override
    @Business(viewType="both")
    public List<GrouphistoryDTO> findGroupHistoryByBasicUnitId(long unitId) {
        ArrayList<GrouphistoryDTO> grouphistoryDTOList = new ArrayList<GrouphistoryDTO>();
        List<Grouphistory> grouphistoryList = this.grouphistoryDAO.findAllByBasicUnitId(unitId);
        for (Grouphistory grouphistory : grouphistoryList) {
            GrouphistoryDTO grouphistoryDTO = new GrouphistoryDTO(grouphistory);
            for (UnitModel unitModel : grouphistory.getUnitGroups()) {
                grouphistoryDTO.addGroupName(unitModel.getUnitIdentity().getName());
            }
            grouphistoryDTOList.add(grouphistoryDTO);
        }
        return grouphistoryDTOList;
    }

    @Override
    @Business(viewType="both")
    public void createNewGroupHistory(Grouphistory grouphistory) {
        this.grouphistoryDAO.createEntity(grouphistory);
    }

    @Override
    @Business(viewType="both")
    public void updateGroupHistoryEntry(Grouphistory grouphistory) {
        this.grouphistoryDAO.updateEntity(grouphistory);
    }

    @Override
    @Business(viewType="both")
    public Long getGrouphistoryId(long unitId, long timestamp) {
        Long id;
        try {
            id = this.grouphistoryDAO.findId(unitId, timestamp);
        }
        catch (NonUniqueResultException e) {
            id = null;
            log.error((Object)("Multiple GroupHistories found for unitId: " + unitId + ", timestamp: " + timestamp));
        }
        return id;
    }

    @Override
    @Business(viewType="both")
    public Collection<Grouphistory> findByBasicUnitId(long unitId) {
        return this.grouphistoryDAO.findByBasicUnitId(unitId);
    }

    @Override
    @Business(viewType="both")
    public List<UnitPermission> findByUnitIdOrGroupId(long unitId) {
        return this.unitPermissionDAO.findByUnitIdOrGroupId(unitId);
    }

    @Override
    @Business(viewType="both")
    @TransactionTimeout(value=900)
    public void removeGroupHistoryEntity(long id) {
        Grouphistory entity = (Grouphistory)this.grouphistoryDAO.findByPrimaryKey(id);
        this.grouphistoryDAO.removeEntity(entity);
    }

    @Override
    @Business(viewType="both")
    @TransactionTimeout(value=900)
    public void deleteUnitPhysical(long unitId) {
        UnitModel unit = (UnitModel)this.unitModelDAO.findByPrimaryKey(unitId);
        this.unitModelDAO.removeEntity(unit);
    }

    @Override
    @Business(viewType="both")
    @TransactionTimeout(value=3600)
    public void mergeGrouphistoryEntries(long targetId, long[] entryIds) {
        GroupHistoryFastLane ghfl = new GroupHistoryFastLane(this.entityManager);
        ghfl.mergeGroupHistoryEntries(targetId, entryIds);
    }

    @Override
    @Business(viewType="both")
    @TransactionTimeout(value=900)
    public void clearUnit(long unitId) {
        UnitModel unit = (UnitModel)this.unitModelDAO.findByPrimaryKey(unitId);
        this.unitModelDAO.removeEntity(unit);
        unit = new UnitModel(unit);
        this.unitModelDAO.createEntity(unit);
        log.debug((Object)"clearUnit() called");
    }

    private void sendAirportMapUnitChanged(long oldTypeId, UnitModel oldUnitValue, UnitIdentity oldIdentityValue, UnitModel newUnitModel) {
        boolean send = false;
        boolean airportmapVisibleHasBeenSet = false;
        if (oldUnitValue.getBasic()) {
            if (newUnitModel.getAirportmapVisible() != oldUnitValue.getAirportmapVisible()) {
                if (newUnitModel.getAirportmapVisible() && !oldUnitValue.getAirportmapVisible()) {
                    airportmapVisibleHasBeenSet = true;
                }
                send = true;
            }
            if (newUnitModel.getUnitTypeIdentity().getId() != oldTypeId) {
                send = true;
            }
            if (oldUnitValue.getDeleted() != newUnitModel.getDeleted()) {
                send = true;
            }
        }
        if (newUnitModel.getUnitIdentity().getImageName() != null && !newUnitModel.getUnitIdentity().getImageName().equals(oldIdentityValue.getImageName())) {
            send = true;
        }
        if (!newUnitModel.getUnitIdentity().getName().equals(oldIdentityValue.getName())) {
            send = true;
        }
        if (send) {
            UnitDTO unitDto = DTOFactory.buildUnitDTO(newUnitModel);
            if (!oldUnitValue.getDeleted() && newUnitModel.getDeleted()) {
                this.permissionUpdateNotifyBeanLocal.sendAirportMapUnitDeletedChangedMessage(unitDto);
            } else {
                this.permissionUpdateNotifyBeanLocal.sendAirportMapUnitChangedMessage(unitDto, airportmapVisibleHasBeenSet);
            }
        }
    }

    @Override
    @Business(viewType="both")
    public boolean isSCLUpdateNecessary(long unitId) {
        UnitModel unitModel = this.unitFacadeLocal.getUnitModel(unitId);
        if (unitModel != null) {
            if (!unitModel.isUnitSclRefresh() && unitModel.getUnitSclValidTime() != 0L && unitModel.getUnitSclValidTime() <= System.currentTimeMillis()) {
                log.trace((Object)("isSCLUpdateNecessary() unitUser (SCL) refresh flag not set, but a new SCL becomes valid " + unitModel.getUnitSclValidTime()));
                return true;
            }
            if (!unitModel.isUnitSclRefresh()) {
                log.trace((Object)"isSCLUpdateNecessary() unitUser (SCL) refresh flag not set, no update necessary");
                return false;
            }
            long delta = System.currentTimeMillis() - unitModel.getUnitSclSyncStartTime();
            if (delta <= this.infomanRequestTimeout) {
                log.trace((Object)"isSCLUpdateNecessary() update is still within timeout, no new update necessary");
                return false;
            }
            log.trace((Object)"isSCLUpdateNecessary() scl update necessary");
            return true;
        }
        return false;
    }

    @Override
    @Business(viewType="both")
    public EventPayload startSCLUpdate(long unitId) {
        UnitModel unitModel = this.unitFacadeLocal.getUnitModel(unitId);
        if (unitModel != null) {
            unitModel.setUnitSclSyncStartTime(System.currentTimeMillis());
            unitModel.setUnitSclSyncDone(false);
            String sclRefreshType = unitModel.getUnitSclRefreshType();
            EventPayload payload = new EventPayload();
            payload.setName("SCL");
            Properties props = new Properties();
            if (sclRefreshType.equals("scl_update")) {
                props.setProperty("scl.action", "scl_update");
            } else if (sclRefreshType.equals("scl_clear")) {
                props.setProperty("scl.action", "scl_clear");
            }
            props.setProperty("token", Long.toString(unitModel.getUnitSclSyncStartTime()));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                props.store(out, "");
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
            payload.setPayload(out.toByteArray());
            return payload;
        }
        return null;
    }

    @Override
    @Business(viewType="both")
    public void updateSCLSuccessful(long unitId) throws UnitNotFoundException {
        try {
            this.updateSCLForUnit(unitId, false, null);
        }
        catch (Exception ex) {
            log.error((Object)"updateSCLSuccessful runs into", (Throwable)ex);
            throw new EJBException("updateSCLSuccessful runs into" + ex.getMessage());
        }
    }

    @Override
    @Business(viewType="both")
    public void updateSCLForUnit(long unitId, boolean refresh, String updateType) throws FinderException {
        UnitModel unitModel;
        if (log.isTraceEnabled()) {
            log.trace((Object)("updateSCLForUnit() untiId: " + unitId + " refresh: " + refresh));
        }
        if ((unitModel = this.unitFacadeLocal.getUnitModel(unitId)) != null) {
            unitModel.setUnitSclRefresh(refresh);
            if (refresh) {
                unitModel.setUnitSclSyncStartTime(0L);
                unitModel.setUnitSclRefreshType(updateType);
            }
        }
    }

    @Override
    @Business(viewType="both")
    public void updateSCLForUnitInFuture(long unitId, long validTime, String updateType) throws FinderException {
        UnitModel unitModel;
        if (log.isTraceEnabled()) {
            log.trace((Object)("updateSCLForUnit() untiId: " + unitId + " with delay"));
        }
        if ((unitModel = this.unitFacadeLocal.getUnitModel(unitId)) != null) {
            unitModel.setUnitSclRefresh(false);
            unitModel.setUnitSclRefreshType(updateType);
            unitModel.setUnitSclValidTime(validTime);
        }
    }

    @Override
    @Business(viewType="both")
    public void updateSCLReport(long unitId, long eventTime, String updateReport) {
        Long token = null;
        String errorMessage = null;
        if (updateReport.startsWith("error")) {
            StringTokenizer tokenizer = new StringTokenizer(updateReport, ";");
            tokenizer.nextToken();
            try {
                token = Long.valueOf(tokenizer.nextToken());
                if (tokenizer.hasMoreTokens()) {
                    errorMessage = tokenizer.nextToken();
                }
            }
            catch (NumberFormatException ex) {
                log.warn((Object)"token for scl update not available");
            }
        } else {
            try {
                token = Long.valueOf(updateReport);
            }
            catch (NumberFormatException ex) {
                log.warn((Object)"token for scl update not available");
            }
        }
        UnitModel unitModel = (UnitModel)this.unitModelDAO.findByPrimaryKey(unitId);
        if (unitModel != null) {
            long activeToken;
            if ((!unitModel.isUnitSclRefresh() || unitModel.isUnitSclSyncDone()) && unitModel.getUnitSclValidTime() == 0L) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("no open scl update found for unitId " + unitId + " and token " + updateReport + " found. unitSCLRefresh: " + unitModel.isUnitSclRefresh() + " unitSCLSyncDone: " + unitModel.isUnitSclSyncDone()));
                }
                return;
            }
            if (token != null && (activeToken = unitModel.getUnitSclSyncStartTime()) != token) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("token no longer active, wait. unitId " + unitId + " infomanToken: " + token + " expectedToken: " + activeToken));
                }
                unitModel.setUnitSclSyncDone(true);
                unitModel.setUnitSclSyncError("invalid token");
                unitModel.setUnitSclSynchEndTime(eventTime);
                unitModel.setUnitSclValidTime(0L);
                return;
            }
            unitModel.setUnitSclRefresh(false);
            unitModel.setUnitSclSyncDone(true);
            unitModel.setUnitSclSyncError(errorMessage);
            unitModel.setUnitSclSynchEndTime(eventTime);
            unitModel.setUnitSclValidTime(0L);
        }
    }

    @Override
    @Business(viewType="both")
    public void scalarTest() {
        StateHistory sh = new StateHistory();
        StateHistory sh2 = new StateHistory();
        log.info((Object)((Object)sh).toString());
        log.info((Object)((Object)sh).hashCode());
        log.info((Object)((Object)sh).equals(sh2));
        sh2.setAreaId(11);
        log.info((Object)((Object)sh).equals(sh2));
    }

    @Override
    @Business(viewType="both")
    public long getLastEventTimestamp(long unitId) {
        UnitModel unitModel = this.getUnitModel(unitId);
        return this.getLastEventTimestamp(unitModel);
    }

    protected long getLastEventTimestamp(UnitModel unitModel) {
        MutableLong lastEventTimestamp = new MutableLong(-1L);
        if (!unitModel.getBasic()) {
            throw new IllegalArgumentException("last timestamp only possible for basic units");
        }
        this.updateLastEventTimestamp(lastEventTimestamp, unitModel.getCurrentStateCaches());
        this.updateLastEventTimestamp(lastEventTimestamp, unitModel.getCurrentGdataCache());
        this.updateLastEventTimestamp(lastEventTimestamp, unitModel.getKeepAliveCache());
        this.updateLastEventTimestamp(lastEventTimestamp, unitModel.getUseCache());
        this.updateLastEventTimestamp(lastEventTimestamp, unitModel.getCurrentNotifyCaches());
        this.updateLastEventTimestamp(lastEventTimestamp, unitModel.getMeasurementCache());
        this.updateLastEventTimestamp(lastEventTimestamp, unitModel.getScanmanMsgCache());
        return lastEventTimestamp.longValue();
    }

    protected void updateLastEventTimestamp(MutableLong lastEventTimestamp, List<? extends IBeginTime> cacheEvents) {
        if (cacheEvents == null) {
            return;
        }
        for (IBeginTime iBeginTime : cacheEvents) {
            this.updateLastEventTimestamp(lastEventTimestamp, iBeginTime);
        }
    }

    protected void updateLastEventTimestamp(MutableLong lastEventTimestamp, IBeginTime cacheEvent) {
        if (cacheEvent == null) {
            return;
        }
        if (cacheEvent.getBeginTime() > lastEventTimestamp.longValue()) {
            lastEventTimestamp.setValue(cacheEvent.getBeginTime());
        }
    }
}

