/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.scheduledReports;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.wwt.datamodel.account.Account;
import de.proveo.wwt.datamodel.scheduledReports.GeneratedReport;
import de.proveo.wwt.datamodel.scheduledReports.ScheduledReport;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.UserAdminFacadeLocal;
import de.proveo.wwt.logic.ejb.general.scheduledReports.GeneratedReportDAO;
import de.proveo.wwt.logic.ejb.general.scheduledReports.ScheduledReportDAO;
import de.proveo.wwt.logic.ejb.general.scheduledReports.ScheduledReportFacadeLocal;
import de.proveo.wwt.logic.ejb.general.scheduledReports.ScheduledReportFacadeRemote;
import de.proveo.wwt.logic.ejb.general.scheduledReports.dto.GeneratedReportDTO;
import de.proveo.wwt.logic.ejb.general.scheduledReports.dto.ScheduledReportDTO;
import de.proveo.wwt.logic.web.common.dto.DTOFactory;
import de.proveo.wwt.logic.web.common.dto.DTOListBase;
import de.proveo.wwt.logic.web.common.dto.DTOListFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Stateless(name="ScheduledReportFacade")
@Remote(value={ScheduledReportFacadeRemote.class})
@Local(value={ScheduledReportFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/ScheduledReportFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/ScheduledReportFacade")
public class ScheduledReportFacadeBean
implements ScheduledReportFacadeLocal,
ScheduledReportFacadeRemote {
    private static final Log logger = LogFactory.getLog(ScheduledReportFacadeBean.class);
    @PersistenceContext(unitName="rts")
    EntityManager entityManager = null;
    @EJB
    private UserAdminFacadeLocal userFacade = null;
    private ScheduledReportDAO scheduledReportDAO = null;
    private GeneratedReportDAO generatedReportDAO = null;

    @PostConstruct
    public void ejbCreate() {
        this.scheduledReportDAO = ScheduledReportDAO.newInstance(this.entityManager);
        this.generatedReportDAO = GeneratedReportDAO.newInstance(this.entityManager);
    }

    @Override
    @Business(viewType="both")
    public DTOListBase<ScheduledReportDTO> getAllScheduledReports() {
        DTOListBase<ScheduledReportDTO> list = DTOListFactory.buildDTOListBase(null);
        List<ScheduledReport> coll = this.scheduledReportDAO.findAll();
        for (ScheduledReport report : coll) {
            list.add(DTOFactory.buildScheduledReportDTO(report));
        }
        return list;
    }

    @Override
    @Business(viewType="both")
    public DTOListBase<ScheduledReportDTO> getScheduledReports() {
        DTOListBase<ScheduledReportDTO> list = DTOListFactory.buildDTOListBase(null);
        List<ScheduledReport> coll = this.scheduledReportDAO.findNotDeleted();
        for (ScheduledReport report : coll) {
            list.add(DTOFactory.buildScheduledReportDTO(report));
        }
        return list;
    }

    @Override
    @Business(viewType="both")
    public Long saveReport(ScheduledReportDTO reportDTO) {
        Long id = null;
        ScheduledReport value = new ScheduledReport();
        value.setEmails(reportDTO.getEmails());
        value.setLocale(reportDTO.getLocale().toString());
        value.setOutputFormat(reportDTO.getOutputFormat().name());
        if (reportDTO.getPageFormat() != null) {
            value.setPageFormat(reportDTO.getPageFormat().name());
        }
        value.setReportDesign(reportDTO.getReportDesign());
        value.setReportName(reportDTO.getReportName());
        value.setCreateTime(reportDTO.getCreateTime());
        value.setReportType(reportDTO.getReportType());
        String parameterString = "";
        for (Map.Entry<String, String> e : reportDTO.getReportParameters().entrySet()) {
            if (!parameterString.equals("")) {
                parameterString = parameterString + ";";
            }
            String paramKey = e.getKey();
            String paramValue = e.getValue();
            parameterString = parameterString + paramKey + "=" + paramValue;
        }
        value.setReportParameters(parameterString);
        value.setTimeInterval(reportDTO.getInterval().name());
        if (reportDTO.getId() != null) {
            ScheduledReport report = (ScheduledReport)this.scheduledReportDAO.findByPrimaryKey(reportDTO.getId());
            value.setAccounts(report.getAccounts());
            value.setId(reportDTO.getId());
            value = (ScheduledReport)this.scheduledReportDAO.updateEntity(value);
            id = value.getId();
        } else {
            this.scheduledReportDAO.createEntity(value);
            id = value.getId();
        }
        ArrayList<Account> accounts = new ArrayList<Account>();
        for (Account a : reportDTO.getAccounts()) {
            accounts.add(this.userFacade.getAccount(a.getId()));
        }
        value.replaceRelations(accounts, Account.class);
        return id;
    }

    @Override
    @Business(viewType="both")
    public void deleteReport(ScheduledReportDTO reportDTO) {
        ScheduledReport reportLocal = (ScheduledReport)this.scheduledReportDAO.findByPrimaryKey(reportDTO.getId());
        reportLocal.setDeleted(true);
    }

    @Override
    @Business(viewType="both")
    public void deleteReportPhysically(ScheduledReportDTO reportDTO) {
        List<GeneratedReportDTO> dtoList = this.getGeneratedReports(reportDTO.getId());
        for (GeneratedReportDTO dto : dtoList) {
            this.deleteGeneratedReport(dto);
        }
        ScheduledReport reportLocal = (ScheduledReport)this.scheduledReportDAO.findByPrimaryKey(reportDTO.getId());
        this.scheduledReportDAO.removeEntity(reportLocal);
    }

    @Override
    @Business(viewType="both")
    public void saveGeneratedReport(ScheduledReportDTO reportDTO, byte[] reportFile, long createTime, int dataSize, long processDuration, Short errorCode, String emails) {
        logger.debug((Object)("generated Report saved" + reportDTO.getReportName()));
        GeneratedReport generatedReportValue = new GeneratedReport();
        generatedReportValue.setScheduledReportId(reportDTO.getId());
        generatedReportValue.setReport(reportFile);
        generatedReportValue.setCreateTime(createTime);
        generatedReportValue.setDataSize(dataSize);
        generatedReportValue.setProcessDuration(processDuration);
        generatedReportValue.setErrorCode(errorCode);
        generatedReportValue.setEmails(emails);
        this.generatedReportDAO.createEntity(generatedReportValue);
    }

    @Override
    @Business(viewType="both")
    public List<GeneratedReportDTO> getGeneratedReports(Long scheduledReportId) {
        ArrayList<GeneratedReportDTO> list = new ArrayList<GeneratedReportDTO>();
        List<GeneratedReport> coll = this.generatedReportDAO.findAll();
        for (GeneratedReport report : coll) {
            ScheduledReport scheduledReport = (ScheduledReport)this.scheduledReportDAO.findByPrimaryKey(report.getScheduledReportId());
            if (scheduledReportId != null && scheduledReport.getId() != scheduledReportId.longValue()) continue;
            list.add(new GeneratedReportDTO(report, scheduledReport));
        }
        return list;
    }

    @Override
    @Business(viewType="both")
    public void deleteGeneratedReport(GeneratedReportDTO reportDTO) {
        GeneratedReport report = (GeneratedReport)this.generatedReportDAO.findByPrimaryKey(reportDTO.getGeneratedReport().getId());
        this.generatedReportDAO.removeEntity(report);
    }
}

