/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.performanceCounter;

import de.proveo.wwt.logic.ejb.general.performanceCounter.PerformanceCounterResultBase;
import de.proveo.wwt.logic.ejb.general.performanceCounter.UnitEventStatisticsDto;
import de.proveo.wwt.logic.ejb.general.tableMappings.readers.PerformanceCounterAnnotationReader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class PerformanceCounterIntervalResult<E extends Enum<E>>
extends PerformanceCounterResultBase<E>
implements Serializable {
    private static final long serialVersionUID = -9121589972527849027L;
    public long timestamp;
    public HashMap<Enum<E>, List<UnitEventStatisticsDto>> unitEventMap;
    public HashMap<Enum<E>, Long> eventSumTotal;

    public PerformanceCounterIntervalResult() {
    }

    public PerformanceCounterIntervalResult(long timestamp, long interval, HashMap<Enum<E>, List<UnitEventStatisticsDto>> unitEventMap, HashMap<Enum<E>, Long> eventSumTotal) {
        this.timestamp = timestamp;
        this.interval = interval;
        this.unitEventMap = unitEventMap;
        this.eventSumTotal = eventSumTotal;
    }

    @Override
    protected Set<Enum<E>> getKeyEnums() {
        return this.unitEventMap.keySet();
    }

    public HashMap<String, Long> generateEventSumTotalDto() {
        if (this.eventSumTotal == null) {
            return null;
        }
        Set<Enum<E>> keySet = this.unitEventMap.keySet();
        Iterator<Enum<E>> keyIterator = keySet.iterator();
        HashMap<String, Long> dtoMap = new HashMap<String, Long>();
        while (keyIterator.hasNext()) {
            Enum<E> currentColumnId = keyIterator.next();
            String counterColumn = PerformanceCounterAnnotationReader.getCounterColumn(currentColumnId);
            dtoMap.put(counterColumn, this.eventSumTotal.get(currentColumnId));
        }
        return dtoMap;
    }
}

