/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.notification;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.wwt.datamodel.notification.Notification;
import de.proveo.wwt.datamodel.stateModel.State;
import de.proveo.wwt.datamodel.stateModel.StateModel;
import de.proveo.wwt.logic.ejb.general.notification.NotificationAdministrationFacadeLocal;
import de.proveo.wwt.logic.ejb.general.notification.NotificationAdministrationFacadeRemote;
import de.proveo.wwt.logic.ejb.general.notification.NotificationDAO;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import de.proveo.wwt.logic.ejb.stateModel.StateModelFacadeLocal;
import de.proveo.wwt.logic.web.common.ParameterDetails;
import de.proveo.wwt.logic.web.common.ParameterInputType;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.common.dto.UnitDTOList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Stateless(name="NotificationAdministrationFacade")
@Remote(value={NotificationAdministrationFacadeRemote.class})
@Local(value={NotificationAdministrationFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/NotificationAdministrationFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/NotificationAdministrationFacade")
public class NotificationAdministrationFacadeBean
implements NotificationAdministrationFacadeLocal,
NotificationAdministrationFacadeRemote {
    private static final Log logger = LogFactory.getLog(NotificationAdministrationFacadeBean.class);
    @EJB
    private UnitFacadeLocal unitFacade = null;
    @EJB
    private StateModelFacadeLocal stateModelFacade;
    @PersistenceContext(unitName="rts")
    private EntityManager em = null;
    private NotificationDAO notificationDAO = null;

    @PostConstruct
    public void ejbCreate() throws CreateException {
        this.notificationDAO = NotificationDAO.newInstance(this.em);
    }

    @Override
    @Business(viewType="both")
    public List<Notification> getAllNotifications() {
        return this.notificationDAO.findAll();
    }

    @Override
    @Business(viewType="both")
    public Notification getNotificationById(long id) {
        return (Notification)this.notificationDAO.findByPrimaryKey(id);
    }

    @Override
    @Business(viewType="both")
    public boolean saveNotification(Notification value) throws DuplicateKeyException {
        if (this.notificationDAO.findByPrimaryKey(value.getId()) != null) {
            throw new DuplicateKeyException("A notification with this id already exists");
        }
        this.notificationDAO.createEntity(value);
        return true;
    }

    @Override
    @Business(viewType="both")
    public boolean updateNotification(Notification value) {
        this.notificationDAO.updateEntity(value);
        return true;
    }

    @Override
    @Business(viewType="both")
    public boolean deleteNotification(long notificationId) {
        this.notificationDAO.removeEntity(this.getNotificationById(notificationId));
        return true;
    }

    @Override
    @Business(viewType="both")
    public String getNotifyRuleParameterValue(String key, String parameter) {
        String value;
        block17: {
            value = "unknown";
            if ("warning".equals(key)) {
                try {
                    int intParam = Integer.parseInt(parameter);
                    Notification notificationValue = this.getNotificationById(intParam);
                    if (notificationValue != null) {
                        value = notificationValue.getDefaultName();
                        break block17;
                    }
                    value = key + "." + parameter;
                }
                catch (NumberFormatException e) {
                    logger.debug((Object)("Integer.parseInt(parameter) runs into" + e.getMessage()));
                    value = key + "." + parameter;
                }
            } else if ("unit".equals(key)) {
                try {
                    int unitId = Integer.parseInt(parameter);
                    UnitDTO unitDTO = this.unitFacade.getUnitDTO(unitId);
                    if (unitDTO != null) {
                        value = unitDTO.getUnitName();
                        break block17;
                    }
                    value = key + "." + parameter;
                }
                catch (NumberFormatException e) {
                    logger.debug((Object)("Integer.parseInt(parameter) runs into" + e.getMessage()));
                    value = key + "." + parameter;
                }
            } else if ("unitGroup".equals(key)) {
                try {
                    int unitId = Integer.parseInt(parameter);
                    UnitDTO unitDTO = this.unitFacade.getUnitDTO(unitId);
                    if (unitDTO != null) {
                        value = unitDTO.getUnitName();
                        break block17;
                    }
                    value = key + "." + parameter;
                }
                catch (NumberFormatException e) {
                    logger.debug((Object)("Integer.parseInt(parameter) runs into" + e.getMessage()));
                    value = key + "." + parameter;
                }
            } else {
                if ("statusModelId".equals(key)) {
                    return "stateModel." + parameter;
                }
                if ("statusId".equals(key)) {
                    return "state." + parameter;
                }
                logger.warn((Object)("unknown key: '" + key + "'"));
                value = key + "." + parameter;
            }
        }
        return value;
    }

    @Override
    @Business(viewType="both")
    public ParameterDetails getNotifyParameterDetails(String key, String initValue) {
        ParameterDetails parameterDetails = new ParameterDetails();
        if ("warning".equals(key)) {
            parameterDetails.setParameterInputType(ParameterInputType.DROPDOWN);
            List<Notification> notificationValues = this.getAllNotifications();
            HashMap<String, Object> defaultValueMap = new HashMap<String, Object>(notificationValues.size());
            for (int i = 0; i < notificationValues.size(); ++i) {
                Notification notificationValue = notificationValues.get(i);
                defaultValueMap.put(notificationValue.getDefaultName(), notificationValue.getId());
            }
            parameterDetails.setDefaultValueMap(defaultValueMap);
            parameterDetails.setUsesDefaultValueMap(true);
        } else if ("unit".equals(key)) {
            parameterDetails.setParameterInputType(ParameterInputType.DROPDOWN);
            UnitDTOList unitDTOList = this.unitFacade.getUnits(true, true);
            HashMap<String, Object> defaultValueMap = new HashMap<String, Object>();
            for (int i = 0; i < unitDTOList.size(); ++i) {
                UnitDTO unitDTO = (UnitDTO)unitDTOList.get(i);
                defaultValueMap.put(unitDTO.getUnitName(), unitDTO.getUnitId());
            }
            parameterDetails.setDefaultValueMap(defaultValueMap);
            parameterDetails.setUsesDefaultValueMap(true);
        } else if ("unitGroup".equals(key)) {
            parameterDetails.setParameterInputType(ParameterInputType.DROPDOWN);
            UnitDTOList unitDTOList = this.unitFacade.getUnits(false, true);
            HashMap<String, Object> defaultValueMap = new HashMap<String, Object>();
            for (int i = 0; i < unitDTOList.size(); ++i) {
                UnitDTO unitDTO = (UnitDTO)unitDTOList.get(i);
                defaultValueMap.put(unitDTO.getUnitName(), unitDTO.getUnitId());
            }
            parameterDetails.setDefaultValueMap(defaultValueMap);
            parameterDetails.setUsesDefaultValueMap(true);
        } else if ("email".equals(key)) {
            parameterDetails.setParameterInputType(ParameterInputType.TEXTBOX);
            parameterDetails.setUsesDefaultValue(true);
        } else if ("statusModelId".equals(key)) {
            parameterDetails.setParameterInputType(ParameterInputType.DROPDOWN);
            HashMap<String, Object> defaultValueMap = new HashMap<String, Object>();
            String stateIdPrefix = "stateModel.";
            List<StateModel> stateModels = this.stateModelFacade.getStateModels();
            for (StateModel stateModel : stateModels) {
                defaultValueMap.put(stateIdPrefix + String.valueOf(stateModel.getId()), stateModel.getId());
            }
            parameterDetails.setDefaultValueMap(defaultValueMap);
            parameterDetails.setUsesDefaultValueMap(true);
            parameterDetails.setUseResourceBundle(true);
        } else if ("statusId".equals(key)) {
            parameterDetails.setParameterInputType(ParameterInputType.DROPDOWN);
            HashMap<String, Object> defaultValueMap = new HashMap<String, Object>();
            String stateIdPrefix = "state.";
            StateModel stateModel = this.stateModelFacade.getStateModel(Integer.parseInt(initValue));
            List<State> states = stateModel.getStates();
            for (State state : states) {
                defaultValueMap.put(stateIdPrefix + String.valueOf(state.getId()), state.getId());
            }
            parameterDetails.setDefaultValueMap(defaultValueMap);
            parameterDetails.setUsesDefaultValueMap(true);
            parameterDetails.setUseResourceBundle(true);
        } else {
            logger.debug((Object)("unknown key: '" + key + "'"));
            parameterDetails.setParameterInputType(ParameterInputType.TEXTBOX);
            parameterDetails.setUsesDefaultValue(true);
        }
        return parameterDetails;
    }
}

