/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.kml.eventCount;

import de.proveo.util.kml.structs.GeoArea;

public class GeoEventCountSqlBuilder {
    private static final String GEO_EVENT_COUNT_STMT = "SELECT FLOOR((lat_msec - %d) / %d) AS lat_idx, FLOOR((long_msec - %d) / %d) AS lon_idx, COUNT(*) AS cnt FROM gdata_history WHERE trusted = 1 AND lat_msec >= %d AND lat_msec <= %d AND long_msec >= %d AND long_msec <= %d AND begin_time >= %d AND begin_time < %d AND begin_receive_time - begin_time >= 0 GROUP BY FLOOR((lat_msec - %d) / %d),FLOOR((long_msec - %d) / %d) ";

    public static String buildSql(long beginTime, long endTime, long resolution) {
        GeoArea geoArea = new GeoArea();
        geoArea.setWholeWorld();
        return GeoEventCountSqlBuilder.buildSql(beginTime, endTime, resolution, geoArea);
    }

    public static String buildSql(long beginTime, long endTime, long resolution, GeoArea geoArea) {
        String sql = String.format(GEO_EVENT_COUNT_STMT, geoArea.minLat, resolution, geoArea.minLon, resolution, geoArea.minLat, geoArea.maxLat, geoArea.minLon, geoArea.maxLon, beginTime, endTime, geoArea.minLat, resolution, geoArea.minLon, resolution);
        return sql;
    }
}

