/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.infoman;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.infoman.config.InfomanConfiguraiton;
import de.proveo.wwt.datamodel.infoman.InfomanConfigTemplate;
import de.proveo.wwt.datamodel.infoman.setup.InfomanSetup;
import de.proveo.wwt.datamodel.infoman.setup.update.InfomanUpdate;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.logic.ejb.general.infoman.InfomanConfigurationUpdateException;
import de.proveo.wwt.logic.ejb.general.infoman.InfomanConfigurationUpdateLocal;
import de.proveo.wwt.logic.ejb.general.infoman.InfomanConfigurationUpdateRemote;
import de.proveo.wwt.logic.ejb.general.infoman.ScheduledInfomanUpdateDAO;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.ejb.CreateException;
import javax.ejb.EJB;
import javax.ejb.EJBException;
import javax.ejb.Local;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Stateless(name="InfomanConfigurationUpdate")
@Remote(value={InfomanConfigurationUpdateRemote.class})
@Local(value={InfomanConfigurationUpdateLocal.class})
@JndiLocalBinding(localJndiBinding="rts/InfomanConfigurationUpdate")
@JndiRemoteBinding(remoteJndiBinding="rts/InfomanConfigurationUpdate")
public class InfomanConfigurationUpdateBean
implements InfomanConfigurationUpdateLocal,
InfomanConfigurationUpdateRemote {
    private static final Log log = LogFactory.getLog(InfomanConfigurationUpdateBean.class);
    @EJB
    private UnitFacadeLocal adminUnitFacade = null;
    @EJB
    private UnitFacadeLocal unitFacadeLocal;
    @PersistenceContext(unitName="rts")
    EntityManager entityManager = null;
    private ScheduledInfomanUpdateDAO infomanUpdateDAO = null;

    @PostConstruct
    public void ejbCreate() {
        this.infomanUpdateDAO = ScheduledInfomanUpdateDAO.newInstance(this.entityManager);
    }

    @Override
    @Business(viewType="remote")
    public InfomanUpdate createUpdate(long unitId, long time, String description, boolean force, Properties updatedKeys, Set<String> keysToRemove) throws InfomanConfigurationUpdateException, ObjectNotFoundException, CreateException {
        if (!this.adminUnitFacade.hasUserAccessForUnit(unitId)) {
            // empty if block
        }
        UnitModel unit = this.unitFacadeLocal.getUnitModel(unitId);
        InfomanUpdate update = this.createUpdate(unit, time, description, force, updatedKeys, keysToRemove);
        return update;
    }

    @Override
    @Business(viewType="remote")
    public Map<Long, InfomanUpdate> createUpdatesRemote(Collection<Long> units, long time, String description, boolean force, Properties updatedKeys, Set<String> keysToRemove) throws InfomanConfigurationUpdateException, CreateException, ObjectNotFoundException {
        HashMap<Long, InfomanUpdate> createdUpdates = new HashMap<Long, InfomanUpdate>();
        for (long unitId : units) {
            InfomanUpdate update = this.createUpdate(unitId, time, description, force, updatedKeys, keysToRemove);
            createdUpdates.put(unitId, update);
        }
        return createdUpdates;
    }

    @Override
    @Business(viewType="local")
    public Map<Long, InfomanUpdate> createUpdates(Collection<UnitModel> units, long time, String description, boolean force, Properties updatedKeys, Set<String> keysToRemove) throws InfomanConfigurationUpdateException, CreateException {
        HashMap<Long, InfomanUpdate> createdUpdates = new HashMap<Long, InfomanUpdate>();
        for (UnitModel unit : units) {
            InfomanUpdate update = this.createUpdate(unit, time, description, force, updatedKeys, keysToRemove);
            createdUpdates.put(unit.getUnitId(), update);
        }
        return createdUpdates;
    }

    @Override
    @Business(viewType="local")
    public InfomanUpdate createUpdate(UnitModel unit, long time, String description, boolean force, Properties updatedKeys, Set<String> keysToRemove) throws InfomanConfigurationUpdateException, CreateException {
        byte[] updatedConfiguration = this.updateConfiguration(unit, force, updatedKeys, keysToRemove);
        InfomanSetup currentSetup = unit.getInfomanSetup();
        InfomanUpdate updateValue = new InfomanUpdate();
        updateValue.setScheduledTime(time);
        updateValue.setConfiguration(updatedConfiguration);
        updateValue.setConfigurationName(currentSetup.getConfigurationName());
        this.infomanUpdateDAO.createEntity(updateValue);
        updateValue.setUnitId(unit.getUnitId());
        return updateValue;
    }

    @Override
    @Business(viewType="both")
    public Properties parseKeysToUpdate(byte[] templateContent) {
        Properties properties = new Properties();
        if (templateContent != null) {
            try {
                properties.load(new ByteArrayInputStream(templateContent));
            }
            catch (IOException ex) {
                throw new EJBException((Exception)ex);
            }
        }
        return properties;
    }

    @Override
    @Business(viewType="both")
    public Set<String> parseKeysToRemove(byte[] templateContent) {
        Properties properties = this.parseKeysToUpdate(templateContent);
        HashSet<String> keySet = new HashSet<String>();
        Iterator<Object> it = properties.keySet().iterator();
        while (it.hasNext()) {
            keySet.add((String)it.next());
        }
        return keySet;
    }

    @Override
    @Business(viewType="local")
    public Set<String> parseKeysToRemove(InfomanConfigTemplate template) {
        return this.parseKeysToRemove(template.getKeysToRemove());
    }

    @Override
    @Business(viewType="local")
    public Properties parseKeysToUpdate(InfomanConfigTemplate template) {
        return this.parseKeysToUpdate(template.getConfiguration());
    }

    @Override
    @Business(viewType="local")
    public byte[] updateConfiguration(UnitModel unit, boolean force, Properties updatedKeys, Set<String> keysToRemove) throws InfomanConfigurationUpdateException {
        InfomanSetup currentSetup = unit.getInfomanSetup();
        if (currentSetup == null) {
            throw new InfomanConfigurationUpdateException("setup not found");
        }
        if (!force && !currentSetup.getConfigurationUpToDate()) {
            throw new InfomanConfigurationUpdateException("configuration is not up to date");
        }
        byte[] rawConfiguration = currentSetup.getConfiguration();
        if (rawConfiguration == null || rawConfiguration.length == 0) {
            throw new InfomanConfigurationUpdateException("configuration is not available");
        }
        InfomanConfiguraiton configuration = new InfomanConfiguraiton();
        configuration.setConfiguration(rawConfiguration);
        configuration.merge(updatedKeys, keysToRemove);
        return configuration.getConfiguration();
    }
}

