/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.infoman;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.wwt.datamodel.account.Account;
import de.proveo.wwt.datamodel.infoman.setup.InfomanSetupHistory;
import de.proveo.wwt.datamodel.infoman.setup.update.InfomanUpdate;
import de.proveo.wwt.datamodel.infoman.software.InfomanSoftware;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.UserAdminFacadeLocal;
import de.proveo.wwt.logic.ejb.general.infoman.AdminInfomanSetupFacadeLocal;
import de.proveo.wwt.logic.ejb.general.infoman.AdminInfomanSetupFacadeRemote;
import de.proveo.wwt.logic.ejb.general.infoman.InfomanSetupFacadeLocal;
import de.proveo.wwt.logic.ejb.general.infoman.InfomanSoftwareDAO;
import de.proveo.wwt.logic.ejb.general.infoman.ScheduledInfomanUpdateDAO;
import de.proveo.wwt.logic.ejb.general.infoman.setup.InfomanSetupDTO;
import de.proveo.wwt.logic.ejb.general.infoman.setup.InfomanSetupHistoryDTO;
import de.proveo.wwt.logic.ejb.general.infoman.setup.ScheduledInfomanUpdateDTO;
import de.proveo.wwt.logic.ejb.general.infoman.software.InfomanSoftwareDTO;
import de.proveo.wwt.logic.ejb.general.infoman.software.InfomanSoftwareDescriptionDTO;
import de.proveo.wwt.logic.ejb.general.infoman.software.InfomanSoftwareDescriptionValue;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import de.proveo.wwt.logic.web.common.dataSelection.ReportSelectionDTO;
import de.proveo.wwt.logic.web.common.dataSelection.UnitReportSelectionDTO;
import de.proveo.wwt.logic.web.common.dto.DTOFactory;
import de.proveo.wwt.logic.web.common.dto.DTOListBase;
import de.proveo.wwt.logic.web.common.dto.DTOListFactory;
import de.proveo.wwt.logic.web.common.dto.ReportDTOListBase;
import de.proveo.wwt.logic.web.common.dto.UnitContainerListBase;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.common.helper.UnitListFactory;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.UnitTreeFacadeLocal;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.dto.UnitIdNodeMatcher;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.dto.UnitNodeType;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.dto.UnitTreeNode;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.annotation.PostConstruct;
import javax.ejb.CreateException;
import javax.ejb.EJB;
import javax.ejb.FinderException;
import javax.ejb.Local;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.Remote;
import javax.ejb.RemoveException;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.hibernate.Hibernate;

@Stateless(name="AdminInfomanSetupFacade")
@Remote(value={AdminInfomanSetupFacadeRemote.class})
@Local(value={AdminInfomanSetupFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/AdminInfomanSetupFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/AdminInfomanSetupFacade")
public class AdminInfomanSetupFacadeBean
implements AdminInfomanSetupFacadeLocal,
AdminInfomanSetupFacadeRemote {
    @PersistenceContext(unitName="rts")
    private EntityManager entityManager = null;
    @EJB
    private UserAdminFacadeLocal userFacade = null;
    @EJB
    private InfomanSetupFacadeLocal infomanSetupFacade;
    @EJB
    private UnitTreeFacadeLocal unitTreeFacadeLocal;
    @EJB
    private UnitFacadeLocal unitFacadeLocal;
    private ScheduledInfomanUpdateDAO infomanUpdateDAO = null;
    private InfomanSoftwareDAO infomanSoftwareDAO = null;

    @PostConstruct
    public void ejbCreate() {
        this.infomanUpdateDAO = ScheduledInfomanUpdateDAO.newInstance(this.entityManager);
        this.infomanSoftwareDAO = InfomanSoftwareDAO.newInstance(this.entityManager);
    }

    @Override
    @Business(viewType="both")
    public UnitContainerListBase<InfomanSetupDTO> getCurrentInfomanSetups(ReportSelectionDTO selectionDTO) {
        Collection<UnitModel> unitBasicModels = UnitListFactory.generateUnitModelList((UnitReportSelectionDTO)selectionDTO);
        UnitContainerListBase<InfomanSetupDTO> list = DTOListFactory.buildUnitContainerListBase(selectionDTO);
        for (UnitModel childUnitModel : unitBasicModels) {
            if (childUnitModel.getInfomanSetup() == null || childUnitModel.getDeleted()) continue;
            InfomanSetupDTO dto = DTOFactory.buildInfomanSetupDTO(childUnitModel, childUnitModel.getInfomanSetup());
            list.add(dto);
        }
        return list;
    }

    @Override
    @Business(viewType="both")
    public ReportDTOListBase<InfomanSetupHistoryDTO> getConfigurationHistory(ReportSelectionDTO selectionDTO) throws FinderException {
        Collection<UnitModel> unitBasicModels = UnitListFactory.generateUnitModelList((UnitReportSelectionDTO)selectionDTO);
        ReportDTOListBase<InfomanSetupHistoryDTO> list = DTOListFactory.buildReportDTOListBase(selectionDTO);
        long beginTime = selectionDTO.getBeginTime() == null ? 0L : selectionDTO.getBeginTime();
        long endTime = selectionDTO.getEndTime() == null ? System.currentTimeMillis() : selectionDTO.getEndTime();
        for (UnitModel childUnitModel : unitBasicModels) {
            List<InfomanSetupHistory> versions = this.infomanSetupFacade.getConfigurationHistory(childUnitModel.getUnitId(), beginTime, endTime);
            Iterator<InfomanSetupHistory> iterator = versions.iterator();
            while (iterator.hasNext()) {
                InfomanSetupHistoryDTO dto = DTOFactory.buildInfomanSetupHistoryDTO(childUnitModel, iterator.next());
                list.add(dto);
            }
        }
        return list;
    }

    @Override
    @Business(viewType="both")
    public void resetUpToDateFlag(long unitId) {
        this.infomanSetupFacade.resetUpToDateFlag(unitId);
    }

    @Override
    @Business(viewType="both")
    public void deleteInfomanSoftware(long softwareId) throws ObjectNotFoundException, RemoveException {
        this.infomanSetupFacade.deleteInfomanSoftware(softwareId);
    }

    @Override
    @Business(viewType="both")
    public DTOListBase<InfomanSoftwareDescriptionDTO> getAvailableInfomanSoftwareDTOs() {
        DTOListBase<InfomanSoftwareDescriptionDTO> list = DTOListFactory.buildDTOListBase(null);
        List<InfomanSoftwareDescriptionValue> infomanSoftwareDescriptionValue = this.infomanSetupFacade.getAvailableInfomanSoftwareValues();
        Iterator<InfomanSoftwareDescriptionValue> iterator = infomanSoftwareDescriptionValue.iterator();
        while (iterator.hasNext()) {
            list.add(new InfomanSoftwareDescriptionDTO(iterator.next()));
        }
        return list;
    }

    @Override
    @Business(viewType="both")
    public InfomanSoftwareDTO createInfomanSoftware(InfomanSoftwareDTO dto) throws CreateException {
        InfomanSoftware infomanSoftware = dto.getInfomanSoftware();
        this.infomanSoftwareDAO.createEntity(infomanSoftware);
        return new InfomanSoftwareDTO(infomanSoftware);
    }

    @Override
    @Business(viewType="both")
    public InfomanSoftwareDTO getInfomanSoftware(long softwareId) throws ObjectNotFoundException {
        InfomanSoftware infomanSoftware = (InfomanSoftware)this.infomanSoftwareDAO.findByPrimaryKey(softwareId);
        return new InfomanSoftwareDTO(infomanSoftware);
    }

    @Override
    @Business(viewType="both")
    public void updateInfomanSoftware(InfomanSoftwareDTO dto) throws ObjectNotFoundException {
        this.infomanSoftwareDAO.updateEntity(dto.getInfomanSoftware());
    }

    @Override
    @Business(viewType="both")
    public void setSoftwareArchive(long softwareId, byte[] softwareArchive) throws ObjectNotFoundException {
        InfomanSoftware infomanSoftware = (InfomanSoftware)this.infomanSoftwareDAO.findByPrimaryKey(softwareId);
        infomanSoftware.setSoftware(softwareArchive);
    }

    @Override
    @Business(viewType="both")
    public byte[] getSoftwareArchive(long softwareId) throws ObjectNotFoundException {
        InfomanSoftware infomanSoftware = (InfomanSoftware)this.infomanSoftwareDAO.findByPrimaryKey(softwareId);
        return infomanSoftware.getSoftware();
    }

    @Override
    @Business(viewType="both")
    public UnitContainerListBase<ScheduledInfomanUpdateDTO> getScheduledInfomanUpdates(ReportSelectionDTO selectionDTO) {
        Collection<UnitModel> unitBasicModels = UnitListFactory.generateUnitModelList((UnitReportSelectionDTO)selectionDTO);
        UnitContainerListBase<ScheduledInfomanUpdateDTO> list = DTOListFactory.buildUnitContainerListBase(selectionDTO);
        for (UnitModel childUnitModel : unitBasicModels) {
            if (childUnitModel.getInfomanUpdates() == null || childUnitModel.getDeleted()) continue;
            for (InfomanUpdate infomanUpdate : childUnitModel.getInfomanUpdates()) {
                InfomanSoftware infomanSoftware = infomanUpdate.getInfomanSoftware();
                Hibernate.initialize((Object)((Object)infomanSoftware));
                ScheduledInfomanUpdateDTO dto = DTOFactory.buildScheduledInfomanUpdateDTO(childUnitModel, infomanUpdate, infomanSoftware);
                Account account = infomanUpdate.getAccount();
                if (account != null) {
                    Hibernate.initialize((Object)account);
                    dto.setAccount(account);
                }
                list.add(dto);
            }
        }
        return list;
    }

    @Override
    @Business(viewType="both")
    public void createScheduledInfomanUpdate(ScheduledInfomanUpdateDTO dto, long softwareId) throws CreateException, FinderException {
        Long accountId;
        InfomanUpdate update = dto.getInfomanUpdate();
        UnitModel unitModel = this.unitFacadeLocal.getUnitModel(dto.getUnitId());
        Account account = this.userFacade.getAccountByUsername(dto.getUserName());
        Long l = accountId = account != null ? Long.valueOf(account.getId()) : null;
        if (unitModel.getBasic()) {
            update.setUnitId(unitModel.getUnitId());
            update.setInfomanSoftwareId(softwareId);
            update.setAccountId(accountId);
            this.infomanUpdateDAO.createEntity(update);
        } else {
            UnitIdNodeMatcher nodeMatcher = new UnitIdNodeMatcher(unitModel.getUnitId());
            UnitTreeNode unitTreeRoot = this.unitTreeFacadeLocal.getTreeViewData(false, false, false);
            UnitTreeNode groupNode = (UnitTreeNode)unitTreeRoot.getNode(true, nodeMatcher);
            List<UnitTreeNode> nodes = groupNode.getSubnodes(UnitNodeType.Unit);
            TreeSet<Long> unitSet = new TreeSet<Long>();
            for (UnitTreeNode node : nodes) {
                unitSet.add(((UnitDTO)node.getData()).getUnitId());
            }
            for (Long unitId : unitSet) {
                InfomanUpdate currentUpdate = new InfomanUpdate(update);
                currentUpdate.setUnitId(unitId);
                currentUpdate.setInfomanSoftwareId(softwareId);
                currentUpdate.setAccountId(accountId);
                this.infomanUpdateDAO.createEntity(currentUpdate);
            }
        }
    }

    @Override
    @Business(viewType="both")
    public void setConfiguration(long updateId, byte[] configuration) throws ObjectNotFoundException {
        InfomanUpdate update = (InfomanUpdate)this.infomanUpdateDAO.findByPrimaryKey(updateId);
        update.setConfiguration(configuration);
    }

    @Override
    @Business(viewType="both")
    public byte[] getConfiguration(long updateId) throws ObjectNotFoundException {
        InfomanUpdate update = (InfomanUpdate)this.infomanUpdateDAO.findByPrimaryKey(updateId);
        return update.getConfiguration();
    }

    @Override
    @Business(viewType="both")
    public void removeScheduledInfomanUpdate(long updateId) throws RemoveException, ObjectNotFoundException {
        InfomanUpdate update = (InfomanUpdate)this.infomanUpdateDAO.findByPrimaryKey(updateId);
        this.infomanUpdateDAO.removeEntity(update);
    }
}

