/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.geofencing;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.eventbase.EventPayload;
import de.proveo.wwt.datamodel.area.Area;
import de.proveo.wwt.datamodel.area.AreaPoints;
import de.proveo.wwt.datamodel.geofencing.GeofGroup;
import de.proveo.wwt.datamodel.geofencing.GeofUnitModel;
import de.proveo.wwt.datamodel.geofencing.GeofZone;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.logic.app.unit.exception.UnitNotFoundException;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationClient;
import de.proveo.wwt.logic.ejb.general.geofencing.GeofGroupDAO;
import de.proveo.wwt.logic.ejb.general.geofencing.GeofUnitModelDAO;
import de.proveo.wwt.logic.ejb.general.geofencing.GeofencingUpdateFacadeLocal;
import de.proveo.wwt.logic.ejb.general.geofencing.GeofencingUpdateFacadeRemote;
import de.proveo.wwt.logic.ejb.general.geofencing.exception.GeofUnitGroupNotFoundException;
import de.proveo.wwt.logic.ejb.general.geofencing.exception.GeofUnitNotFoundException;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.EJBException;
import javax.ejb.Local;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Stateless(name="GeofencingUpdateFacade")
@Remote(value={GeofencingUpdateFacadeRemote.class})
@Local(value={GeofencingUpdateFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/GeofencingUpdateFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/GeofencingUpdateFacade")
public class GeofencingUpdateFacadeBean
implements GeofencingUpdateFacadeLocal,
GeofencingUpdateFacadeRemote {
    private static final Log log = LogFactory.getLog(GeofencingUpdateFacadeBean.class);
    @PersistenceContext(unitName="rts")
    private EntityManager em = null;
    private GeofGroupDAO geofGroupDAO;
    private GeofUnitModelDAO geofUnitModelDAO;
    @EJB
    private UnitFacadeLocal unitfacade;
    private static final long DEFAULT_INFOMAN_REQUEST_TIMEOUT = 600000L;
    private long infomanRequestTimeout;

    @PostConstruct
    public void ejbCreate() {
        this.geofGroupDAO = GeofGroupDAO.newInstance(this.em);
        this.geofUnitModelDAO = GeofUnitModelDAO.newInstance(this.em);
        this.configure();
    }

    protected void configure() {
        try {
            this.infomanRequestTimeout = Long.parseLong(new ConfigurationClient().getParameter("infoman.aclupdate.timeout", Long.toString(600000L)));
        }
        catch (Exception ex) {
            log.error((Object)"runs during configure infoman.update.timeout into", (Throwable)ex);
            this.infomanRequestTimeout = 600000L;
        }
    }

    @Override
    @Business(viewType="both")
    public void updateGeofAreasSuccessful(long unitId) throws UnitNotFoundException {
        try {
            this.updateGeofUnitModel(unitId, false);
        }
        catch (ObjectNotFoundException ex) {
            log.error((Object)("updateGeofAreasSuccessful: can't find unit (id:" + unitId + ")"), (Throwable)ex);
            throw new UnitNotFoundException(unitId, (Exception)((Object)ex));
        }
        catch (Exception ex) {
            log.error((Object)"updateGeofAreasSuccessful runs into", (Throwable)ex);
            throw new EJBException("updateGeofAreasSuccessful runs into" + ex.getMessage());
        }
    }

    @Override
    @Business(viewType="both")
    public void updateGeofUnitModel(long unitId, boolean refresh) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)("updateUnitModel() untiId: " + unitId + " refresh: " + refresh));
        }
        GeofUnitModel geofUnitModel = (GeofUnitModel)this.geofUnitModelDAO.findByPrimaryKey(unitId);
        geofUnitModel.setUnitGeofAreasRefresh(refresh);
        if (refresh) {
            geofUnitModel.setUnitGeofAreasSyncStartTime(0L);
        }
        this.geofUnitModelDAO.updateEntity(geofUnitModel);
    }

    @Override
    @Business(viewType="both")
    public void updateGeofUnitModelByGroupId(long groupId, boolean refresh) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)("updateUnitModel() groupId: " + groupId + " refresh: " + refresh));
        }
        List<GeofGroup> colGeofGroup = this.geofGroupDAO.findByGeofGroupId(groupId);
        for (GeofGroup geofGroup : colGeofGroup) {
            List<GeofUnitModel> colGeofUnitModel = geofGroup.getGeofUnitModels();
            for (GeofUnitModel geofUnitModel : colGeofUnitModel) {
                geofUnitModel.setUnitGeofAreasRefresh(refresh);
                if (refresh) {
                    geofUnitModel.setUnitGeofAreasSyncStartTime(0L);
                }
                this.geofUnitModelDAO.updateEntity(geofUnitModel);
            }
        }
    }

    @Override
    @Business(viewType="local")
    public boolean isGeofAreasUpdateNecessary(GeofUnitModel geofUnitModel) {
        if (!geofUnitModel.isUnitGeofAreasRefresh()) {
            return false;
        }
        long delta = System.currentTimeMillis() - geofUnitModel.getUnitGeofAreasSyncStartTime();
        if (delta <= this.infomanRequestTimeout) {
            return false;
        }
        log.debug((Object)"geofUpdateIsnecessary");
        return true;
    }

    @Override
    @Business(viewType="local")
    public EventPayload startGeofAreasUpdate(GeofUnitModel geofUnitModel) {
        log.debug((Object)("startGeofAreasUpdate for" + geofUnitModel.getUnitId()));
        geofUnitModel.setUnitGeofAreasSyncStartTime(System.currentTimeMillis());
        geofUnitModel.setUnitGeofAreasSyncDone(false);
        EventPayload payload = new EventPayload();
        payload.setName("GeofUpdate");
        payload.setPayload(Long.toString(geofUnitModel.getUnitGeofAreasSyncStartTime()).getBytes());
        this.geofUnitModelDAO.updateEntity(geofUnitModel);
        return payload;
    }

    @Override
    @Business(viewType="both")
    public void updateGeofReport(long unitId, long eventTime, String updateReport) {
        boolean succesful;
        log.trace((Object)("updateGeofReport for " + unitId));
        log.trace((Object)("updateReport " + updateReport));
        Long token = null;
        String errorMessage = null;
        if (updateReport.startsWith("error")) {
            StringTokenizer tokenizer = new StringTokenizer(updateReport, ";");
            tokenizer.nextToken();
            succesful = false;
            log.trace((Object)"not successfull");
            try {
                token = Long.valueOf(tokenizer.nextToken());
                if (tokenizer.hasMoreTokens()) {
                    errorMessage = tokenizer.nextToken();
                }
            }
            catch (NumberFormatException ex) {
                log.warn((Object)"token for geof update not available");
            }
        } else {
            succesful = true;
            try {
                token = Long.valueOf(updateReport);
            }
            catch (NumberFormatException ex) {
                log.warn((Object)"token for geof update not available");
            }
        }
        GeofUnitModel geofUnitModel = (GeofUnitModel)this.geofUnitModelDAO.findByPrimaryKey(unitId);
        if (geofUnitModel != null) {
            long activeToken;
            log.debug((Object)"GeofAreaUpdateDone");
            if (!geofUnitModel.isUnitGeofAreasRefresh() || geofUnitModel.isUnitGeofAreasSyncDone()) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("no open geof update found for unitId " + unitId + " and token " + updateReport + " found. unitGeofAreasRefresh: " + geofUnitModel.isUnitGeofAreasRefresh() + " unitGeofAreasSyncDone: " + geofUnitModel.isUnitGeofAreasSyncDone()));
                }
                return;
            }
            if (token != null && (activeToken = geofUnitModel.getUnitGeofAreasSyncStartTime()) != token) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("geof token no longer active, wait. unitId " + unitId + " infomanToken: " + token + " expectedToken: " + activeToken));
                }
                geofUnitModel.setUnitGeofAreasSyncSuccessful(false);
                geofUnitModel.setUnitGeofAreasSyncError("invalid token");
                geofUnitModel.setUnitGeofAreasSyncEndTime(eventTime);
                return;
            }
        } else {
            throw new EJBException("geof update report for unkown unit unitID: " + unitId);
        }
        log.trace((Object)"token is not given from infoman or token is still active close geof areas update");
        geofUnitModel.setUnitGeofAreasRefresh(false);
        geofUnitModel.setUnitGeofAreasSyncDone(true);
        geofUnitModel.setUnitGeofAreasSyncSuccessful(succesful);
        geofUnitModel.setUnitGeofAreasSyncError(errorMessage);
        geofUnitModel.setUnitGeofAreasSyncEndTime(eventTime);
        this.geofUnitModelDAO.updateEntity(geofUnitModel);
    }

    @Override
    @Business(viewType="both")
    public String getUnitGeofAreasCsvV2(long unitId) throws Exception {
        StringBuilder areaBuffer = new StringBuilder();
        StringBuilder zoneBuffer = new StringBuilder();
        StringBuilder areaPointsBuffer = new StringBuilder();
        UnitModel unitModel = this.unitfacade.getUnitModel(unitId);
        if (unitModel == null) {
            throw new UnitNotFoundException(unitId);
        }
        GeofUnitModel geofUnitModel = unitModel.getGeofUnitModel();
        if (geofUnitModel == null) {
            throw new GeofUnitNotFoundException(unitId, "no geof unit found");
        }
        GeofGroup geofGroupLocal = geofUnitModel.getGeofGroup();
        if (geofGroupLocal == null) {
            throw new GeofUnitGroupNotFoundException(unitId, "no geof Group found");
        }
        List<GeofZone> colGeofZone = geofGroupLocal.getGeofZones();
        Iterator itGeofZone = colGeofZone.iterator();
        GeofZone geofZone = null;
        while (itGeofZone.hasNext()) {
            geofZone = (GeofZone)((Object)itGeofZone.next());
            List<Area> colAreas = geofZone.getAreas();
            zoneBuffer.append(geofZone.getZoneId() + ",");
            zoneBuffer.append(geofZone.getZone() + ",");
            zoneBuffer.append(geofZone.getZoneEntryNotificationId() + ",");
            zoneBuffer.append(geofZone.getZoneExitNotificationId() + ",");
            zoneBuffer.append(geofZone.isZoneEntry() ? 1 : 0);
            zoneBuffer.append(",");
            zoneBuffer.append(geofZone.isZoneExit() ? 1 : 0);
            zoneBuffer.append(",");
            zoneBuffer.append(geofZone.getBlackBoardItem() + ",");
            zoneBuffer.append("\n");
            Iterator itAreas = colAreas.iterator();
            Area area = null;
            while (itAreas.hasNext()) {
                area = (Area)itAreas.next();
                areaBuffer.append(area.getAreaId() + ",");
                areaBuffer.append(geofZone.getZoneId());
                areaBuffer.append(area.getPriority() + ",");
                areaBuffer.append("\n");
                List<AreaPoints> areaPoints = area.getAreaPoints();
                Iterator<AreaPoints> itAreaPoints = areaPoints.iterator();
                while (itAreaPoints.hasNext()) {
                    int nextPoint = 0;
                    AreaPoints areaPointsValue = itAreaPoints.next();
                    areaPointsBuffer.append(areaPointsValue.getAreaId() + ",");
                    areaPointsBuffer.append(areaPointsValue.getPoint() + ",");
                    nextPoint = itAreaPoints.hasNext() ? areaPointsValue.getPoint() + 1 : 1;
                    areaPointsBuffer.append(nextPoint + ",");
                    areaPointsBuffer.append(areaPointsValue.getLongMsec());
                    areaPointsBuffer.append(areaPointsValue.getLatMsec() + ",");
                    areaPointsBuffer.append("\n");
                }
            }
        }
        areaBuffer.append((CharSequence)zoneBuffer);
        areaBuffer.append((CharSequence)areaPointsBuffer);
        return areaBuffer.toString();
    }

    @Override
    @Business(viewType="both")
    public String getUnitGeofAreasCsvV1(long unitId) throws Exception {
        StringBuilder areaBuffer = new StringBuilder();
        StringBuilder areaPointsBuffer = new StringBuilder();
        UnitModel unitModel = this.unitfacade.getUnitModel(unitId);
        if (unitModel == null) {
            throw new UnitNotFoundException(unitId);
        }
        GeofUnitModel geofUnitModelLocal = unitModel.getGeofUnitModel();
        if (geofUnitModelLocal == null) {
            throw new GeofUnitNotFoundException(unitId, "no geof unit found");
        }
        GeofGroup geofGroupLocal = geofUnitModelLocal.getGeofGroup();
        if (geofGroupLocal == null) {
            throw new GeofUnitGroupNotFoundException(unitId, "no geof Group found");
        }
        List<GeofZone> colGeofZone = geofGroupLocal.getGeofZones();
        Iterator itGeofZone = colGeofZone.iterator();
        GeofZone geofZone = null;
        while (itGeofZone.hasNext()) {
            geofZone = (GeofZone)((Object)itGeofZone.next());
            if ("outside".equals(geofZone.getZone())) {
                areaBuffer.append(geofZone.getZone());
                areaBuffer.append(",");
                areaBuffer.append(geofZone.getZoneId());
                areaBuffer.append(",");
                areaBuffer.append(-1);
                areaBuffer.append(",");
                areaBuffer.append(geofZone.getZoneEntryNotificationId());
                areaBuffer.append(",");
                areaBuffer.append(geofZone.getZoneExitNotificationId());
                areaBuffer.append(",");
                areaBuffer.append(geofZone.isZoneEntry() ? 1 : 0);
                areaBuffer.append(",");
                areaBuffer.append(geofZone.isZoneExit() ? 1 : 0);
                if (StringUtils.trimToNull((String)geofZone.getBlackBoardItem()) != null) {
                    areaBuffer.append(",");
                    areaBuffer.append(geofZone.getBlackBoardItem());
                }
                areaBuffer.append("\n");
            }
            List<Area> colAreas = geofZone.getAreas();
            Iterator itAreas = colAreas.iterator();
            Area area = null;
            while (itAreas.hasNext()) {
                area = (Area)itAreas.next();
                areaBuffer.append(area.getAreaId());
                areaBuffer.append(",");
                areaBuffer.append(geofZone.getZoneId());
                areaBuffer.append(",");
                areaBuffer.append(area.getPriority());
                areaBuffer.append(",");
                areaBuffer.append(geofZone.getZoneEntryNotificationId());
                areaBuffer.append(",");
                areaBuffer.append(geofZone.getZoneExitNotificationId());
                areaBuffer.append(",");
                areaBuffer.append(geofZone.isZoneEntry() ? 1 : 0);
                areaBuffer.append(",");
                areaBuffer.append(geofZone.isZoneExit() ? 1 : 0);
                if (StringUtils.trimToNull((String)geofZone.getBlackBoardItem()) != null) {
                    areaBuffer.append(",");
                    areaBuffer.append(geofZone.getBlackBoardItem());
                }
                areaBuffer.append("\n");
                List<AreaPoints> areaPoints = area.getAreaPoints();
                Iterator<AreaPoints> itAreaPoints = areaPoints.iterator();
                while (itAreaPoints.hasNext()) {
                    int nextPoint = 0;
                    AreaPoints areaPointsValue = itAreaPoints.next();
                    areaPointsBuffer.append(areaPointsValue.getAreaId() + ",");
                    areaPointsBuffer.append(areaPointsValue.getPoint() + ",");
                    nextPoint = itAreaPoints.hasNext() ? areaPointsValue.getPoint() + 1 : 1;
                    areaPointsBuffer.append(nextPoint + ",");
                    areaPointsBuffer.append(areaPointsValue.getLongMsec() + ",");
                    areaPointsBuffer.append(areaPointsValue.getLatMsec());
                    areaPointsBuffer.append("\n");
                }
            }
        }
        areaBuffer.append((CharSequence)areaPointsBuffer);
        return areaBuffer.toString();
    }
}

