/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.custom;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.wwt.datamodel.custom.CustomScript;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.logic.ejb.dataIn.observable.ObservableFacadeLocal;
import de.proveo.wwt.logic.ejb.general.custom.CustomScriptDAO;
import de.proveo.wwt.logic.ejb.general.custom.CustomScriptFacadeLocal;
import de.proveo.wwt.logic.ejb.general.custom.CustomScriptFacadeRemote;
import de.proveo.wwt.logic.ejb.general.custom.CustomScriptOrderComparator;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.ejb.CreateException;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.PoolClass;
import org.jboss.ejb3.StrictMaxPool;

@Stateless(name="CustomScriptFacade")
@Remote(value={CustomScriptFacadeRemote.class})
@Local(value={CustomScriptFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/CustomScriptFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/CustomScriptFacade")
@PoolClass(value=StrictMaxPool.class, maxSize=30, timeout=10000L)
public class CustomScriptFacadeBean
implements CustomScriptFacadeLocal,
CustomScriptFacadeRemote {
    private static final Log log = LogFactory.getLog(CustomScriptFacadeBean.class);
    @PersistenceContext(unitName="rts")
    private EntityManager em;
    private CustomScriptDAO customScriptDAO;
    @EJB
    UnitFacadeLocal unitFacade;
    @EJB
    private ObservableFacadeLocal observableFacadeLocal = null;

    @PostConstruct
    public void ejbCreate() throws CreateException {
        this.customScriptDAO = CustomScriptDAO.newInstance(this.em);
    }

    @Override
    @Business(viewType="both")
    public void updateCustomScript(CustomScript script) {
        this.customScriptDAO.updateEntity(script);
        this.observableFacadeLocal.notifyClients(Integer.toString(script.getScriptId()), "customScriptMessage");
    }

    @Override
    @Business(viewType="both")
    public void saveCustomScript(CustomScript script) {
        this.updateCustomScript(script);
    }

    @Override
    @Business(viewType="both")
    public List<CustomScript> getScriptsByEntryPointForAllUnits(String entryPoint) {
        return this.customScriptDAO.findScriptsByEntryPointForAllUnits(entryPoint);
    }

    @Override
    @Business(viewType="both")
    public List<CustomScript> getActiveScriptsByEntryPointForAllUnits(String entryPoint) {
        return this.customScriptDAO.findActiveScriptsByEntryPointForAllUnits(entryPoint);
    }

    @Override
    @Business(viewType="both")
    public List<CustomScript> getAllScripts() {
        return this.customScriptDAO.findAll();
    }

    @Override
    @Business(viewType="local")
    public CustomScript getCustomScript(int scriptId) {
        return (CustomScript)this.customScriptDAO.findByPrimaryKey(scriptId);
    }

    @Override
    @Business(viewType="local")
    public void removeCustomScript(int scriptId) {
        CustomScript script = (CustomScript)this.customScriptDAO.findByPrimaryKey(scriptId);
        this.customScriptDAO.removeEntity(script);
        this.observableFacadeLocal.notifyClients(Integer.toString(scriptId), "customScriptMessage");
    }

    @Override
    @Business(viewType="local")
    public int createCustomScript(CustomScript script) {
        this.customScriptDAO.createEntity(script);
        int id = script.getScriptId();
        return id;
    }

    @Override
    @Business(viewType="both")
    public List<CustomScript> getScriptsByEntryPointAndUnit(String entryPoint, long unitId) {
        List<Long> unitIds = this.getUnitIdTree(unitId);
        HashMap<Long, List<CustomScript>> filteredScripts = new HashMap<Long, List<CustomScript>>();
        for (Long uId : unitIds) {
            List<CustomScript> scripts = this.customScriptDAO.findScriptsByEntryPointAndUnit(entryPoint, uId);
            this.filterScripts(unitId, filteredScripts, uId, scripts);
        }
        List<CustomScript> scripts = this.customScriptDAO.findScriptsByEntryPointForAllUnits(entryPoint);
        filteredScripts.put(0L, scripts);
        return this.concatScripts(filteredScripts);
    }

    protected List<Long> getUnitIdTree(long unitId) {
        ArrayList<Long> unitIds = new ArrayList<Long>();
        unitIds.add(unitId);
        UnitModel unitModel = this.unitFacade.getUnitModel(unitId);
        List<UnitModel> parents = unitModel.getParentModel();
        for (UnitModel parent : parents) {
            unitIds.addAll(this.getUnitIdTree(parent.getUnitId()));
        }
        return unitIds;
    }

    protected List<CustomScript> concatScripts(Map<Long, List<CustomScript>> filteredScripts) {
        ArrayList<CustomScript> returnedScripts = new ArrayList<CustomScript>();
        for (List<CustomScript> scripts : filteredScripts.values()) {
            returnedScripts.addAll(scripts);
        }
        Collections.sort(returnedScripts, new CustomScriptOrderComparator());
        return returnedScripts;
    }

    protected void filterScripts(long requestedUnitId, Map<Long, List<CustomScript>> filteredScripts, long scriptUnitId, List<CustomScript> scripts) {
        Iterator<CustomScript> it = scripts.iterator();
        while (it.hasNext()) {
            CustomScript script = it.next();
            if (scriptUnitId == requestedUnitId || script.isChildUnitEnabled()) continue;
            it.remove();
        }
        if (!scripts.isEmpty()) {
            filteredScripts.put(scriptUnitId, scripts);
        }
    }

    @Override
    @Business(viewType="both")
    public List<CustomScript> getActiveScriptsByEntryPointAndUnit(String entryPoint, long unitId) {
        List<Long> unitIds = this.getUnitIdTree(unitId);
        HashMap<Long, List<CustomScript>> filteredScripts = new HashMap<Long, List<CustomScript>>();
        for (Long uId : unitIds) {
            List<CustomScript> scripts = this.customScriptDAO.findActiveScriptsByEntryPointAndUnit(entryPoint, uId);
            this.filterScripts(unitId, filteredScripts, uId, scripts);
        }
        List<CustomScript> scripts = this.customScriptDAO.findActiveScriptsByEntryPointForAllUnits(entryPoint);
        filteredScripts.put(0L, scripts);
        return this.concatScripts(filteredScripts);
    }
}

