/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.config;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.rts.configuration.RTSConfiguration;
import de.proveo.rts.configuration.infoman.InfomanConfigurationServiceMBean;
import de.proveo.rts.configuration.infoman.InfomanEventInterfaceMBean;
import de.proveo.rts.configuration.infoman.InfomanEventServiceMBean;
import de.proveo.rts.configuration.interfaces.aci.ACIConfigurationServiceMBean;
import de.proveo.rts.configuration.interfaces.ai.AIConfigurationServiceMBean;
import de.proveo.rts.configuration.interfaces.mi.MIConfigurationServiceMBean;
import de.proveo.rts.configuration.interfaces.telemetryData.TelemetryDataConfigurationServiceMBean;
import de.proveo.rts.configuration.map.AirportMapGeneratorMBean;
import de.proveo.rts.configuration.map.AirportMapMBean;
import de.proveo.rts.configuration.web.WebUIMBean;
import de.proveo.util.service.ServiceFactory;
import de.proveo.util.service.ServiceInstantiationException;
import de.proveo.util.service.ServiceNotFoundException;
import de.proveo.wwt.datamodel.configuration.ConfigurationParameter;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocal;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationParameterDAO;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationParameterNotFoundException;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationRemote;
import de.proveo.wwt.logic.ejb.interfaces.accessControl.ACIConfiguration;
import de.proveo.wwt.logic.ejb.interfaces.assignment.AIConfiguration;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.MIConfiguration;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.TDIConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.annotation.PostConstruct;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.PoolClass;
import org.jboss.ejb3.StrictMaxPool;

@Stateless(name="Configuration")
@Remote(value={ConfigurationRemote.class})
@Local(value={ConfigurationLocal.class})
@JndiLocalBinding(localJndiBinding="rts/Configuration")
@JndiRemoteBinding(remoteJndiBinding="rts/Configuration")
@PoolClass(value=StrictMaxPool.class, maxSize=100, timeout=10000L)
public class ConfigurationBean
implements ConfigurationLocal,
ConfigurationRemote {
    private static final Log log = LogFactory.getLog(ConfigurationBean.class);
    protected static final String DEFAULT_PROPERTIES = "/config/default-application.properties";
    private Properties defaultProperties;
    private final Collection<RTSConfiguration> configurationMBeans = new ArrayList<RTSConfiguration>();
    @PersistenceContext(unitName="rts")
    private EntityManager em = null;
    private ConfigurationParameterDAO configurationParameterDAO = null;

    @PostConstruct
    public void ejbCreate() throws CreateException {
        this.configurationParameterDAO = ConfigurationParameterDAO.newInstance(this.em);
        this.defaultProperties = new Properties();
        try {
            InputStream in = this.getClass().getResourceAsStream(DEFAULT_PROPERTIES);
            if (in != null) {
                this.defaultProperties.load(in);
            } else {
                log.warn((Object)"no default properties found");
            }
        }
        catch (IOException ex) {
            throw new EJBException("runs during load default values into", (Exception)ex);
        }
        try {
            this.configurationMBeans.add((RTSConfiguration)ServiceFactory.getInstance().getService(InfomanEventInterfaceMBean.class));
            this.configurationMBeans.add((RTSConfiguration)ServiceFactory.getInstance().getService(InfomanEventServiceMBean.class));
            this.configurationMBeans.add((RTSConfiguration)ServiceFactory.getInstance().getService(InfomanConfigurationServiceMBean.class));
            this.configurationMBeans.add((RTSConfiguration)ServiceFactory.getInstance().getService(AirportMapGeneratorMBean.class));
            this.configurationMBeans.add((RTSConfiguration)ServiceFactory.getInstance().getService(AirportMapMBean.class));
            this.configurationMBeans.add((RTSConfiguration)ServiceFactory.getInstance().getService(WebUIMBean.class));
            this.configurationMBeans.add((RTSConfiguration)ServiceFactory.getInstance().getService(TelemetryDataConfigurationServiceMBean.class));
            this.configurationMBeans.add((RTSConfiguration)ServiceFactory.getInstance().getService(MIConfigurationServiceMBean.class));
            this.configurationMBeans.add((RTSConfiguration)ServiceFactory.getInstance().getService(AIConfigurationServiceMBean.class));
            this.configurationMBeans.add((RTSConfiguration)ServiceFactory.getInstance().getService(ACIConfigurationServiceMBean.class));
        }
        catch (ServiceNotFoundException ex) {
            log.error((Object)"runs during get configuration MBeans into", (Throwable)ex);
            throw new EJBException((Exception)((Object)ex));
        }
        catch (ServiceInstantiationException ex) {
            log.error((Object)"runs during get configuration MBeans into", (Throwable)ex);
            throw new EJBException((Exception)((Object)ex));
        }
    }

    @Override
    @Business(viewType="both")
    public void initMBeans() {
        Properties properties = this.getProperties();
        Iterator<RTSConfiguration> it = this.configurationMBeans.iterator();
        while (it.hasNext()) {
            it.next().configurationInit(properties);
        }
    }

    protected void updateMBeans(String key, String value) {
        Iterator<RTSConfiguration> it = this.configurationMBeans.iterator();
        while (it.hasNext()) {
            it.next().configuraitonUpdate(key, value);
        }
    }

    protected void updateMBeansKeyRemoved(String key) {
        Iterator<RTSConfiguration> it = this.configurationMBeans.iterator();
        while (it.hasNext()) {
            it.next().configurationRemove(key);
        }
    }

    @Override
    @Business(viewType="both")
    public String getParameter(String key) throws ConfigurationParameterNotFoundException {
        ConfigurationParameter configParam = (ConfigurationParameter)this.configurationParameterDAO.findByPrimaryKey(key);
        if (configParam != null) {
            return configParam.getParameterValue();
        }
        String value = this.defaultProperties.getProperty(key);
        if (value != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getParameter(): key '" + key + "' not found, use default value '" + value + "'."));
            }
        } else {
            if (log.isErrorEnabled()) {
                log.error((Object)("getParameter(): key '" + key + "' not found and no default value defined!"));
            }
            throw new ConfigurationParameterNotFoundException(key);
        }
        return value;
    }

    @Override
    @Business(viewType="both")
    public String getParameter(String key, String defaultValue) {
        ConfigurationParameter configParam = (ConfigurationParameter)this.configurationParameterDAO.findByPrimaryKey(key);
        if (configParam != null) {
            return configParam.getParameterValue();
        }
        return defaultValue;
    }

    @Override
    @Business(viewType="both")
    public boolean getBoolean(String key) throws ConfigurationParameterNotFoundException {
        return Boolean.parseBoolean(this.getParameter(key));
    }

    @Override
    @Business(viewType="both")
    public boolean getBoolean(String key, boolean defaultValue) {
        return Boolean.parseBoolean(this.getParameter(key, new Boolean(defaultValue).toString()));
    }

    @Override
    @Business(viewType="both")
    public int getInteger(String key) throws ConfigurationParameterNotFoundException {
        return Integer.parseInt(this.getParameter(key));
    }

    @Override
    @Business(viewType="both")
    public long getLong(String key) throws ConfigurationParameterNotFoundException {
        return Long.parseLong(this.getParameter(key));
    }

    @Override
    @Business(viewType="both")
    public InetAddress getInetAddress(String key) throws ConfigurationParameterNotFoundException, UnknownHostException {
        return InetAddress.getByName(this.getParameter(key));
    }

    @Override
    @Business(viewType="both")
    public long[] getLongArray(String key) throws ConfigurationParameterNotFoundException {
        StringTokenizer tokenizer = new StringTokenizer(this.getParameter(key));
        long[] elementArray = new long[tokenizer.countTokens()];
        for (int index = 0; index < elementArray.length; ++index) {
            elementArray[index] = Long.parseLong(tokenizer.nextToken());
        }
        return elementArray;
    }

    @Override
    @Business(viewType="both")
    public String[] getParameterArray(String key) throws ConfigurationParameterNotFoundException {
        StringTokenizer tokenizer = new StringTokenizer(this.getParameter(key));
        String[] elementArray = new String[tokenizer.countTokens()];
        for (int index = 0; index < elementArray.length; ++index) {
            elementArray[index] = tokenizer.nextToken();
        }
        return elementArray;
    }

    @Override
    @Business(viewType="both")
    public boolean isConfigured(String key) {
        try {
            String value = this.getParameter(key);
            return value != null && !value.trim().equals("");
        }
        catch (ConfigurationParameterNotFoundException ex) {
            return false;
        }
    }

    @Override
    @Business(viewType="both")
    public void setParameter(String key, String value) {
        ConfigurationParameter parameter = (ConfigurationParameter)this.configurationParameterDAO.findByPrimaryKey(key);
        if (parameter == null) {
            this.configurationParameterDAO.createEntity(new ConfigurationParameter(key, value));
        } else {
            parameter.setParameterValue(value);
        }
        this.updateMBeans(key, value);
        ACIConfiguration.getInstance().updateProperty(key, value);
        AIConfiguration.getInstance().updateProperty(key, value);
        MIConfiguration.getInstance().updateProperty(key, value);
        TDIConfiguration.getInstance().updateProperty(key, value);
    }

    @Override
    @Business(viewType="both")
    public void removeParameter(String key) {
        ConfigurationParameter parameter = (ConfigurationParameter)this.configurationParameterDAO.findByPrimaryKey(key);
        this.configurationParameterDAO.removeEntity(parameter);
        if (this.isConfigured(key)) {
            try {
                this.updateMBeans(key, this.getParameter(key));
            }
            catch (ConfigurationParameterNotFoundException ex) {
                log.error((Object)"removeParameter() runs during notify MBeans into", (Throwable)ex);
                this.updateMBeansKeyRemoved(key);
            }
        } else {
            this.updateMBeansKeyRemoved(key);
        }
    }

    @Override
    @Business(viewType="both")
    public boolean deleteConfigurationParameter(ConfigurationParameter value) {
        try {
            this.configurationParameterDAO.removeEntity(value);
            return true;
        }
        catch (Exception e) {
            log.debug((Object)"runs into", (Throwable)e);
            return false;
        }
    }

    @Override
    @Business(viewType="both")
    public Properties getProperties() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultProperties);
        Object[] configParameters = this.configurationParameterDAO.findAll().toArray();
        for (int i = 0; i != configParameters.length; ++i) {
            ConfigurationParameter parameter = (ConfigurationParameter)((Object)configParameters[i]);
            String key = parameter.getId();
            String val = parameter.getParameterValue();
            if (key != null && val != null) {
                properties.put(key, val);
                continue;
            }
            log.error((Object)("getProperties() found NULL value: key='" + key + "', value='" + val + "'. Check content of table CONFIGURATION_PARAMETER!"));
        }
        return properties;
    }

    @Override
    @Business(viewType="both")
    public List<ConfigurationParameter> getAllConfigurationParameters() {
        ArrayList<ConfigurationParameter> list = new ArrayList<ConfigurationParameter>();
        Properties props = this.getProperties();
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            String value = (String)props.get(string);
            ConfigurationParameter configValue = new ConfigurationParameter(string, value);
            list.add(configValue);
        }
        return list;
    }

    @Override
    @Business(viewType="both")
    public Properties getDefaultProperties() {
        return this.defaultProperties;
    }
}

