/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.area.adjustment;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.util.geo.GPSPosition;
import de.proveo.util.jpa.JpaUtil;
import de.proveo.wwt.datamodel.area.AdjustmentArea;
import de.proveo.wwt.datamodel.geo.GdataCache;
import de.proveo.wwt.datamodel.module.ModuleType;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.logic.ejb.dataIn.event.EventFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditFacadeLocal;
import de.proveo.wwt.logic.ejb.general.area.adjustment.AdjustmentAreaDAO;
import de.proveo.wwt.logic.ejb.general.area.adjustment.AdjustmentFacadeLocal;
import de.proveo.wwt.logic.ejb.general.area.adjustment.AdjustmentFacadeRemote;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocal;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import de.proveo.wwt.logic.ejb.geo.GeoStruct;
import de.proveo.wwt.logic.ejb.state.CurrentStateFacadeLocal;
import de.proveo.wwt.logic.ejb.state.CurrentStateFacadeStruct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import javax.annotation.PostConstruct;
import javax.ejb.CreateException;
import javax.ejb.EJB;
import javax.ejb.EJBException;
import javax.ejb.Local;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.Remote;
import javax.ejb.RemoveException;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Stateless(name="AdjustmentFacade")
@Remote(value={AdjustmentFacadeRemote.class})
@Local(value={AdjustmentFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/AdjustmentFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/AdjustmentFacade")
public class AdjustmentFacadeBean
implements AdjustmentFacadeLocal,
AdjustmentFacadeRemote {
    private static final Log log = LogFactory.getLog(AdjustmentFacadeBean.class);
    private static final Random random = new Random(System.currentTimeMillis());
    private static final ModuleType AUDIT_APPLICATION = ModuleType.WEB;
    @EJB
    private CurrentStateFacadeLocal currentStateFacade = null;
    @EJB
    private ConfigurationLocal configuration = null;
    @EJB
    private AuditFacadeLocal auditFacadeLocal = null;
    @EJB
    private UnitFacadeLocal unitFacadeLocal = null;
    @PersistenceContext(unitName="rts")
    private EntityManager entityManager = null;
    @EJB
    private AdjustmentFacadeLocal adjustmentFacadeLocal;
    private AdjustmentAreaDAO adjustmentAreaDAO = null;
    @EJB
    private EventFacadeLocal eventFacadeLocal = null;

    @PostConstruct
    public void initImpl() {
        this.adjustmentAreaDAO = AdjustmentAreaDAO.newInstance(this.entityManager);
    }

    protected CurrentStateFacadeLocal getCurrentStateFacade() {
        if (this.currentStateFacade == null) {
            try {
                InitialContext context = new InitialContext();
                this.currentStateFacade = (CurrentStateFacadeLocal)context.lookup("rts/CurrentStateFacade/local");
            }
            catch (NamingException ex) {
                throw new EJBException("runs during creating currentStateFacadeBean into ", (Exception)ex);
            }
        }
        return this.currentStateFacade;
    }

    @Override
    @Business(viewType="both")
    public void adjust(long unitId, int adjustmentAreaId) throws IllegalStateException, ObjectNotFoundException {
        UnitModel unitModel = this.unitFacadeLocal.getUnitModel(unitId);
        if (!unitModel.getBasic()) {
            throw new IllegalArgumentException("adjustment is only available for basic units");
        }
        if (this.configuration.getBoolean("adjustment.checkState", false)) {
            this.getCurrentStateFacade();
            CurrentStateFacadeStruct currentState = this.currentStateFacade.getCurrentState(unitId, 2050);
            if (currentState == null || currentState.getStateId() != 2051) {
                throw new IllegalStateException("adjustment is only supprted in state OufOfService");
            }
        }
        GdataCache oldGdataCacheValue = (GdataCache)this.entityManager.find(GdataCache.class, unitModel.getPrimaryKey());
        Position position = this.calculatePosition(this.getAdjustmentArea(adjustmentAreaId));
        long timestamp = System.currentTimeMillis();
        GeoStruct geoEvent = new GeoStruct(unitId, timestamp, timestamp, position.y, position.x, true, "adjust: " + adjustmentAreaId);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("time", Long.toString(timestamp));
        params.put("longitude", Long.toString(position.x));
        params.put("latitude", Long.toString(position.y));
        params.put("quality", "1");
        String record = GPSPosition.createNMEArecord((String)"GGA", params);
        geoEvent.setGgaRec(record);
        params = new HashMap();
        params.put("time", Long.toString(timestamp));
        params.put("status", "A");
        params.put("longitude", Long.toString(position.x));
        params.put("latitude", Long.toString(position.y));
        record = GPSPosition.createNMEArecord((String)"RMC", params);
        geoEvent.setRmcRec(record);
        this.eventFacadeLocal.handleEvent(geoEvent.generateEventProperties());
        this.adjustmentFacadeLocal.logAdjustement(unitId, oldGdataCacheValue);
    }

    @Override
    @Business(viewType="both")
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void logAdjustement(long unitId, GdataCache oldGdataCacheValue) {
        EntityManager auditEntityManager = JpaUtil.createAuditEntityManager();
        GdataCache newGdataCacheValue = (GdataCache)auditEntityManager.find(GdataCache.class, (Object)new Long(unitId));
        this.auditFacadeLocal.logUpdate(AUDIT_APPLICATION, oldGdataCacheValue, newGdataCacheValue);
    }

    protected Position calculatePosition(AdjustmentArea area) {
        Position position = new Position();
        position.x = this.getRandomBetween(area.getX1(), area.getX2());
        position.y = this.getRandomBetween(area.getY1(), area.getY2());
        return position;
    }

    protected int getRandomBetween(int n1, int n2) {
        int min = Math.min(n1, n2);
        int max = Math.max(n1, n2);
        return min + random.nextInt(max - min);
    }

    @Override
    @Business(viewType="both")
    public Collection<AdjustmentArea> getAdjustmentAreas() {
        ArrayList<AdjustmentArea> areas = new ArrayList<AdjustmentArea>();
        Iterator<AdjustmentArea> it = this.adjustmentAreaDAO.findAll().iterator();
        while (it.hasNext()) {
            areas.add(it.next());
        }
        return areas;
    }

    @Override
    @Business(viewType="both")
    public AdjustmentArea getAdjustmentArea(int adjustmentAreaId) throws ObjectNotFoundException {
        return (AdjustmentArea)this.adjustmentAreaDAO.findByPrimaryKey(adjustmentAreaId);
    }

    @Override
    @Business(viewType="both")
    public AdjustmentArea createAdjustmentArea(AdjustmentArea adjustmentArea) throws CreateException {
        this.adjustmentAreaDAO.createEntity(adjustmentArea);
        return adjustmentArea;
    }

    @Override
    @Business(viewType="both")
    public void deleteAdjustmentArea(int adjustmentAreaId) throws RemoveException, ObjectNotFoundException {
        AdjustmentArea adjustmentArea = (AdjustmentArea)this.adjustmentAreaDAO.findByPrimaryKey(adjustmentAreaId);
        this.adjustmentAreaDAO.removeEntity(adjustmentArea);
    }

    @Override
    @Business(viewType="both")
    public void updateAdjustmentArea(AdjustmentArea value) throws ObjectNotFoundException {
        EntityManager auditEntityManager = JpaUtil.createAuditEntityManager();
        AdjustmentArea oldAdjustmentArea = (AdjustmentArea)auditEntityManager.find(AdjustmentArea.class, value.getPrimaryKey());
        if (!oldAdjustmentArea.equals(value)) {
            this.adjustmentAreaDAO.updateEntity(value);
        }
        auditEntityManager.close();
    }

    protected class Position {
        int x;
        int y;

        protected Position() {
        }
    }
}

