/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.area;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.wwt.datamodel.area.Area;
import de.proveo.wwt.datamodel.area.AreaPoints;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.logic.ejb.general.area.AreaDAO;
import de.proveo.wwt.logic.ejb.general.area.AreaData;
import de.proveo.wwt.logic.ejb.general.area.AreaInFacadeLocal;
import de.proveo.wwt.logic.ejb.general.area.AreaInFacadeRemote;
import de.proveo.wwt.logic.ejb.general.area.AreaPointsDAO;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.PoolClass;
import org.jboss.ejb3.StrictMaxPool;

@Stateless(name="AreaInFacade")
@Remote(value={AreaInFacadeRemote.class})
@Local(value={AreaInFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/AreaInFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/AreaInFacade")
@PoolClass(value=StrictMaxPool.class, maxSize=100, timeout=10000L)
public class AreaInFacadeBean
implements AreaInFacadeLocal,
AreaInFacadeRemote {
    private static final Log log = LogFactory.getLog(AreaInFacadeBean.class);
    @PersistenceContext(unitName="rts")
    private EntityManager entityManager = null;
    private AreaDAO areaDAO = null;
    private AreaPointsDAO areaPointsDAO = null;
    private UnitFacadeLocal unitFacade;

    @PostConstruct
    public void ejbCreate() {
        this.areaDAO = AreaDAO.newInstance(this.entityManager);
        this.areaPointsDAO = AreaPointsDAO.newInstance(this.entityManager);
    }

    private UnitFacadeLocal getUnitFacade() {
        if (this.unitFacade == null) {
            try {
                InitialContext context = new InitialContext();
                this.unitFacade = (UnitFacadeLocal)context.lookup("rts/UnitFacade/local");
            }
            catch (NamingException e) {
                log.error((Object)"runs into ", (Throwable)e);
            }
        }
        return this.unitFacade;
    }

    @Override
    @Business(viewType="both")
    public void setAreaValue(Area area, Collection<AreaPoints> points, Long airportId) {
        if (points.size() == 0) {
            throw new EJBException("cannot create an area with an empty point list");
        }
        log.debug((Object)("points size: " + points.size()));
        Iterator<AreaPoints> it = points.iterator();
        AreaPoints areaPointsStruct = null;
        int minLong = 0;
        int maxLong = 0;
        int minLat = 0;
        int maxLat = 0;
        if (it.hasNext()) {
            areaPointsStruct = it.next();
            minLong = areaPointsStruct.getLongMsec();
            maxLong = areaPointsStruct.getLongMsec();
            minLat = areaPointsStruct.getLatMsec();
            maxLat = areaPointsStruct.getLatMsec();
        }
        while (it.hasNext()) {
            areaPointsStruct = it.next();
            if (areaPointsStruct.getLongMsec() < minLong) {
                minLong = areaPointsStruct.getLongMsec();
            }
            if (areaPointsStruct.getLongMsec() > maxLong) {
                maxLong = areaPointsStruct.getLongMsec();
            }
            if (areaPointsStruct.getLatMsec() < minLat) {
                minLat = areaPointsStruct.getLatMsec();
            }
            if (areaPointsStruct.getLatMsec() <= maxLat) continue;
            maxLat = areaPointsStruct.getLatMsec();
        }
        area.setMaxLongMsec(maxLong);
        area.setMinLongMsec(minLong);
        area.setMaxLatMsec(maxLat);
        area.setMinLatMsec(minLat);
        if (log.isDebugEnabled()) {
            log.debug((Object)("MaxLong Value: " + area.getMaxLongMsec()));
            log.debug((Object)("MinLong Value: " + area.getMinLongMsec()));
            log.debug((Object)("MaxLat Value:  " + area.getMaxLatMsec()));
            log.debug((Object)("MinLat Value:  " + area.getMinLatMsec()));
            if (areaPointsStruct != null) {
                log.debug((Object)("GetLatitude Value:  " + areaPointsStruct.getLatMsec()));
            }
        }
        this.saveAreaDatas(area, points, airportId);
    }

    @Override
    @Business(viewType="both")
    public Area getAreaValue(int areaId) {
        Area area = (Area)this.areaDAO.findByPrimaryKey(areaId);
        if (area == null) {
            throw new EJBException("Area with areaId '" + areaId + "' not found");
        }
        return area;
    }

    @Override
    @Business(viewType="both")
    public String getAreaDescription(int areaId) {
        Area area = (Area)this.areaDAO.findByPrimaryKey(areaId);
        if (area == null) {
            throw new EJBException("Area with areaId '" + areaId + "' not found");
        }
        return area.getDescription();
    }

    @Override
    @Business(viewType="both")
    public Collection<AreaData> getAreaListData() {
        log.debug((Object)"getAreaListData() begin");
        List<Area> remotes = this.areaDAO.findAll();
        ArrayList<AreaData> areaDatas = new ArrayList<AreaData>(remotes.size());
        for (Area area : remotes) {
            AreaData areaData = new AreaData(area);
            areaData.setAreaPointDatas(area.getAreaPoints());
            areaDatas.add(areaData);
        }
        return areaDatas;
    }

    @Override
    @Business(viewType="both")
    public Collection<Area> getAreaList() {
        ArrayList<Area> structs = null;
        List<Area> remotes = this.areaDAO.findAll();
        Iterator it = remotes.iterator();
        structs = new ArrayList<Area>(remotes.size());
        while (it.hasNext()) {
            Area remote = (Area)it.next();
            structs.add(remote);
        }
        return structs;
    }

    @Override
    @Business(viewType="local")
    public void point(Area area, Collection<AreaPoints> points) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("point('" + area + "," + points + "')"));
        }
        int areaId = area.getAreaId();
        AreaPoints areaPointsStruct = null;
        Iterator<AreaPoints> it = points.iterator();
        log.debug((Object)("Amount of points from area '" + areaId + "' :" + points.size()));
        int i = 1;
        while (it.hasNext()) {
            areaPointsStruct = it.next();
            areaPointsStruct.setAreaId(areaId);
            areaPointsStruct.setPoint(i);
            AreaPoints areaPoint = (AreaPoints)this.areaPointsDAO.findByPrimaryKey(new AreaPoints.AreaPK(areaId, areaPointsStruct.getPoint()));
            if (areaPoint == null) {
                this.areaPointsDAO.createEntity(areaPointsStruct);
            } else {
                areaPointsStruct = (AreaPoints)this.areaPointsDAO.updateEntity(areaPointsStruct);
            }
            ++i;
        }
        List<AreaPoints> areaPoints = this.areaPointsDAO.findByAreaIdMissingPoints(areaId, areaPointsStruct.getPoint());
        if (areaPoints != null) {
            for (AreaPoints areaPoint : areaPoints) {
                this.areaPointsDAO.removeEntity(areaPoint);
            }
        }
    }

    @Override
    @Business(viewType="local")
    public void saveAreaDatas(Area area, Collection<AreaPoints> points, Long airportId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("saveAreaDatas('" + area + "," + points + "')"));
        }
        Object areaId = area.getPrimaryKey();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Searching for area with id '" + areaId + "' ..."));
        }
        Area areaTemp = null;
        if (areaId != null) {
            areaTemp = (Area)this.areaDAO.findByPrimaryKey(areaId);
        }
        if (areaTemp != null) {
            log.debug((Object)"Area already exists, changing it ...");
            areaTemp = (Area)this.areaDAO.updateEntity(area);
        } else {
            log.debug((Object)"Area doesn't exist, create a new one ...");
            this.areaDAO.createEntity(area);
            areaTemp = area;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Area with ID '" + areaTemp.getAreaId() + "' created: " + areaTemp));
            }
        }
        areaTemp.setUnitId(airportId);
        log.debug((Object)"Area saved, trying to update points ...");
        this.point(areaTemp, points);
        log.debug((Object)"Points updated.");
    }

    @Override
    @Business(viewType="both")
    public void createArea(String areaId, String areaDescription, int prio) {
        Area areaValue = new Area();
        areaValue.setArea(areaId);
        areaValue.setDescription(areaDescription);
        areaValue.setDeleted(false);
        areaValue.setPriority(prio);
        this.areaDAO.createEntity(areaValue);
    }

    @Override
    @Business(viewType="both")
    public void updateAllAreas(HashMap<Object, Area> newAreas, HashMap<Object, ArrayList<AreaPoints>> newPoints, Long airportId) {
        boolean errorsHappenedWhileUpdating = false;
        try {
            log.info((Object)"Write new areas to database...");
            if (newAreas != null) {
                UnitModel unitModelLocal = null;
                if (airportId != null) {
                    unitModelLocal = this.getUnitFacade().getUnitModel(airportId);
                    if (unitModelLocal.getDeleted()) {
                        throw new FinderException("unit with id = '" + airportId + "' is deleted, can not save areas to a deleted unit");
                    }
                    if (unitModelLocal.getBasic()) {
                        throw new FinderException("unit with id = '" + airportId + "' is a basic unit, can not save areas to a basic unit");
                    }
                }
                for (Object key : newAreas.keySet()) {
                    Area area = newAreas.get(key);
                    try {
                        this.setAreaValue(area, (Collection<AreaPoints>)newPoints.get(key), airportId);
                    }
                    catch (Throwable ex) {
                        errorsHappenedWhileUpdating = true;
                        String areaName = "UNKNOWN";
                        if (area != null) {
                            areaName = area.getArea();
                        }
                        log.error((Object)("Error while updating area: " + areaName), ex);
                    }
                }
            }
        }
        catch (Exception ex) {
            errorsHappenedWhileUpdating = true;
            throw new EJBException("Error while updating areas", ex);
        }
        if (!errorsHappenedWhileUpdating) {
            log.info((Object)"New areas succussfully written to database.");
        }
    }

    @Override
    @Business(viewType="both")
    public Area findByName(String name) {
        return this.areaDAO.findByName(name);
    }

    @Override
    @Business(viewType="both")
    public Area findById(int id) {
        return this.areaDAO.findById(id);
    }

    @Override
    @Business(viewType="both")
    public List<Area> findAllForAirportmap() {
        return this.areaDAO.findAllForAirportmap();
    }

    @Override
    @Business(viewType="both")
    public List<Area> findOrderedByPriorityByAirport(long unitId) {
        return this.areaDAO.findOrderedByPriorityByAirport(unitId);
    }

    @Override
    @Business(viewType="both")
    public List<Area> findOrderedByPriority() {
        return this.areaDAO.findOrderedByPriority();
    }

    @Override
    @Business(viewType="both")
    public List<Area> findAll() {
        return this.areaDAO.findAll();
    }

    @Override
    @Business(viewType="both")
    public List<Area> findAllWithPoints() {
        return this.areaDAO.findAllWithPoints();
    }

    @Override
    @Business(viewType="both")
    public List<AreaPoints> findAreaPointsByArea(int areaId) {
        return this.areaPointsDAO.findByArea(areaId);
    }

    @Override
    @Business(viewType="both")
    public List<Area> findAreasNotAllocatedToUnit() {
        return this.areaDAO.findAreasNotAllocatedToUnit();
    }

    @Override
    @Business(viewType="both")
    public List<Area> findAreasAllocatedToUnit() {
        return this.areaDAO.findAreasAllocatedToUnit();
    }

    @Override
    @Business(viewType="both")
    public List<Area> findAreaByVicinity(int positionLongMsec, int positionLatMsec) {
        return this.areaDAO.findByVicinity(positionLongMsec, positionLatMsec);
    }
}

