/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser.unituser;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.eventbase.EventPayload;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.datamodel.unit.permission.UnitPermission;
import de.proveo.wwt.datamodel.use.user.UseUser;
import de.proveo.wwt.logic.app.unit.exception.UnitNotFoundException;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser.UseUserAdminFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser.unituser.UnitUserLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser.unituser.UnitUserRemote;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationClient;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.annotation.PostConstruct;
import javax.ejb.CreateException;
import javax.ejb.EJB;
import javax.ejb.EJBException;
import javax.ejb.Local;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.PoolClass;
import org.jboss.ejb3.StrictMaxPool;

@Stateless(name="UnitUser")
@Remote(value={UnitUserRemote.class})
@Local(value={UnitUserLocal.class})
@JndiLocalBinding(localJndiBinding="rts/UnitUser")
@JndiRemoteBinding(remoteJndiBinding="rts/UnitUser")
@PoolClass(value=StrictMaxPool.class, maxSize=100, timeout=10000L)
public class UnitUserBean
implements UnitUserLocal,
UnitUserRemote {
    private static final Log log = LogFactory.getLog(UnitUserBean.class);
    @EJB
    private UnitFacadeLocal unitFacade = null;
    @EJB
    private UseUserAdminFacadeLocal useUserAdminFacade = null;
    private static final long DEFAULT_INFOMAN_REQUEST_TIMEOUT = 600000L;
    private long infomanRequestTimeout;

    @PostConstruct
    public void ejbCreate() throws CreateException {
        this.configure();
    }

    @Override
    @Business(viewType="both")
    public Set<String> getUserKeys(long unitId, boolean getMechanic) throws UnitNotFoundException {
        HashSet<String> userKeys = new HashSet<String>();
        ArrayList<Long> unitIds = this.unitFacade.collectParentFolders(unitId);
        unitIds.add(unitId);
        Iterator unitIdIt = unitIds.iterator();
        while (unitIdIt.hasNext()) {
            long uId = (Long)unitIdIt.next();
            List<UnitPermission> permissions = this.unitFacade.findByUnitIdOrGroupId(uId);
            for (UnitPermission permission : permissions) {
                if (permission.getUseUser() != null) {
                    String gseUser = permission.getUseUser().getKeyId().trim();
                    if (getMechanic && permission.getUseUser().getMechanic()) {
                        gseUser = gseUser + " {mechanic}";
                    }
                    userKeys.add(gseUser);
                    continue;
                }
                if (permission.getUseGroup() == null) continue;
                long useGroupId = permission.getUseGroup().getId();
                for (UseUser user : this.useUserAdminFacade.getUseUsersByUseGroupId(useGroupId)) {
                    String gseUser = user.getKeyId().trim();
                    if (getMechanic && user.getMechanic()) {
                        gseUser = gseUser + " {mechanic}";
                    }
                    userKeys.add(gseUser);
                }
            }
        }
        return userKeys;
    }

    @Override
    @Business(viewType="both")
    public boolean isUnitUserDataModified(long unitId) throws UnitNotFoundException {
        UnitModel unitModel = this.unitFacade.getUnitModel(unitId);
        return unitModel.getUnitUserRefresh();
    }

    @Override
    @Business(viewType="both")
    public void updateSuccessful(long unitId) throws UnitNotFoundException {
        try {
            this.updateUnitModel(unitId, false);
        }
        catch (ObjectNotFoundException ex) {
            log.error((Object)("updateSuccessful: can't find unit (id:" + unitId + ")"), (Throwable)ex);
            throw new UnitNotFoundException(unitId, (Exception)((Object)ex));
        }
        catch (Exception ex) {
            log.error((Object)"updateSuccessful runs into", (Throwable)ex);
            throw new EJBException("updateSuccessful runs into" + ex.getMessage());
        }
    }

    @Override
    @Business(viewType="both")
    public void updateUnitModel(long unitId, boolean refresh) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)("updateUnitModel() untiId: " + unitId + " refresh: " + refresh));
        }
        UnitModel unitModel = this.unitFacade.getUnitModel(unitId);
        unitModel.setUnitUserRefresh(refresh);
        if (refresh) {
            unitModel.setUnitUserSyncStartTime(0L);
        }
    }

    protected void configure() {
        try {
            this.infomanRequestTimeout = Long.parseLong(new ConfigurationClient().getParameter("infoman.aclupdate.timeout", Long.toString(600000L)));
        }
        catch (Exception ex) {
            log.error((Object)"runs during configure infoman.update.timeout into", (Throwable)ex);
            this.infomanRequestTimeout = 600000L;
        }
    }

    @Override
    @Business(viewType="local")
    public boolean isACLUpdateNecessary(UnitModel unitModel) {
        if (!unitModel.getUnitUserRefresh()) {
            log.trace((Object)"isACLUpdateNecessary() unitUser (ACL) refresh flag not set, no update necessary");
            return false;
        }
        long delta = System.currentTimeMillis() - unitModel.getUnitUserSyncStartTime();
        if (delta <= this.infomanRequestTimeout) {
            log.trace((Object)"isACLUpdateNecessary() update is still within timeout, no new update necessary");
            return false;
        }
        log.trace((Object)"isACLUpdateNecessary() acl update necessary");
        return true;
    }

    @Override
    @Business(viewType="local")
    public EventPayload startACLUpdate(UnitModel unitModel) {
        unitModel.setUnitUserSyncStartTime(System.currentTimeMillis());
        unitModel.setUnitUserSyncDone(false);
        EventPayload payload = new EventPayload();
        payload.setName("ACLUpdate");
        payload.setPayload(Long.toString(unitModel.getUnitUserSyncStartTime()).getBytes());
        return payload;
    }

    @Override
    @Business(viewType="both")
    public void updateReport(long unitId, long eventTime, String updateReport) {
        long activeToken;
        boolean succesful;
        Long token = null;
        String errorMessage = null;
        if (updateReport.startsWith("error")) {
            StringTokenizer tokenizer = new StringTokenizer(updateReport, ";");
            tokenizer.nextToken();
            succesful = false;
            try {
                token = Long.valueOf(tokenizer.nextToken());
                if (tokenizer.hasMoreTokens()) {
                    errorMessage = tokenizer.nextToken();
                }
            }
            catch (NumberFormatException ex) {
                log.warn((Object)"token for acl update not available");
            }
        } else {
            succesful = true;
            try {
                token = Long.valueOf(updateReport);
            }
            catch (NumberFormatException ex) {
                log.warn((Object)"token for acl update not available");
            }
        }
        UnitModel unitModel = this.unitFacade.getUnitModel(unitId);
        if (!unitModel.getUnitUserRefresh() || unitModel.getUnitUserSyncDone()) {
            if (log.isErrorEnabled()) {
                log.error((Object)("no open acl update found for unitId " + unitId + " and token " + updateReport + " found. unitUserRefresh: " + unitModel.getUnitUserRefresh() + " unitUserSyncDone: " + unitModel.getUnitUserSyncDone()));
            }
            return;
        }
        if (token != null && (activeToken = unitModel.getUnitUserSyncStartTime()) != token) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("token no longer active, wait. unitId " + unitId + " infomanToken: " + token + " expectedToken: " + activeToken));
            }
            unitModel.setUnitUserSyncSuccessful(false);
            unitModel.setUnitUserSyncError("invalid token");
            unitModel.setUnitUserSyncEndTime(eventTime);
            return;
        }
        if (errorMessage != null && !errorMessage.contains("ACLNotConfiguredException")) {
            unitModel.setUnitUserRefresh(true);
            unitModel.setUnitUserSyncDone(false);
        } else {
            unitModel.setUnitUserRefresh(false);
            unitModel.setUnitUserSyncDone(true);
        }
        unitModel.setUnitUserSyncSuccessful(succesful);
        unitModel.setUnitUserSyncError(errorMessage);
        unitModel.setUnitUserSyncEndTime(eventTime);
    }
}

