/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.wwt.datamodel.module.ModuleType;
import de.proveo.wwt.datamodel.unit.permission.UnitPermission;
import de.proveo.wwt.datamodel.use.group.UseGroup;
import de.proveo.wwt.datamodel.use.user.UseUser;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser.UseGroupDAO;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser.UseUserAdminFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser.UseUserGroupAdminFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser.UseUserGroupAdminFacadeRemote;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import de.proveo.wwt.logic.web.admin.dto.useUser.UseUserDTO;
import de.proveo.wwt.logic.web.common.dto.DTOListBase;
import de.proveo.wwt.logic.web.common.dto.DTOListFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Stateless(name="UseUserGroupAdminFacade")
@Remote(value={UseUserGroupAdminFacadeRemote.class})
@Local(value={UseUserGroupAdminFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/UseUserGroupAdminFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/UseUserGroupAdminFacade")
public class UseUserGroupAdminFacadeBean
implements UseUserGroupAdminFacadeLocal,
UseUserGroupAdminFacadeRemote {
    private static final Log logger = LogFactory.getLog(UseUserGroupAdminFacadeBean.class);
    private static final ModuleType AUDIT_APPLICATION = ModuleType.WEB;
    @EJB
    private AuditFacadeLocal auditFacadeLocal = null;
    @EJB
    private UseUserAdminFacadeLocal useUserAdministrationFacade = null;
    @EJB
    private UnitFacadeLocal unitFacadeLocal = null;
    private UseGroupDAO useGroupDAO = null;
    @PersistenceContext(unitName="rts")
    private EntityManager entityManager = null;

    @PostConstruct
    public void ejbCreate() {
        this.useGroupDAO = UseGroupDAO.newInstance(this.entityManager);
    }

    @Override
    @Business(viewType="both")
    public List<UseGroup> getAllUseGroups() {
        return new ArrayList<UseGroup>(this.useGroupDAO.findAll());
    }

    @Override
    @Business(viewType="both")
    public Long insertUseGroup(UseGroup useGroup) throws CreateException, DuplicateKeyException {
        Long id = null;
        String validation = this.validateUseGroup(useGroup, -99L);
        if (validation != null) {
            throw new DuplicateKeyException(validation);
        }
        this.useGroupDAO.createEntity(useGroup);
        id = useGroup.getId();
        return id;
    }

    @Override
    @Business(viewType="both")
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public boolean updateUseGroup(UseGroup useGroup) throws DuplicateKeyException {
        boolean success = false;
        String validation = this.validateUseGroup(useGroup, useGroup.getId());
        if (validation != null) {
            throw new DuplicateKeyException(validation);
        }
        useGroup = (UseGroup)this.useGroupDAO.updateEntity(useGroup);
        success = true;
        return success;
    }

    @Override
    @Business(viewType="both")
    public String duplicatedUseGroupName(String name, long id) {
        List<UseGroup> collection = this.getAllUseGroupsIncludeDeleted();
        for (UseGroup value : collection) {
            String valueName;
            if (value.getId() == id || (valueName = value.getName()) == null || name.equals("") || !valueName.equals(name)) continue;
            if (value.getDeleted()) {
                return "nameDeleted";
            }
            return "name";
        }
        return null;
    }

    @Override
    @Business(viewType="both")
    public String validateUseGroup(UseGroup value, long id) {
        String validation = "";
        validation = this.duplicatedUseGroupName(value.getName(), id);
        if (validation != null) {
            return validation;
        }
        return null;
    }

    @Override
    @Business(viewType="both")
    public void deleteUseGroup(long id, ModuleType module) {
        this.unitFacadeLocal.updateUnitUserRefreshForUseGroup(id);
        UseGroup useGroup = (UseGroup)this.useGroupDAO.findByPrimaryKey(id);
        useGroup.setModule(module);
        useGroup.clearRelations(UseUser.class);
        useGroup.clearRelations(UnitPermission.class);
        useGroup.setDeleted(true);
        this.useGroupDAO.updateEntity(useGroup);
    }

    @Override
    @Business(viewType="both")
    public void deleteUseGroup(long id) {
        this.deleteUseGroup(id, ModuleType.WEB);
    }

    @Override
    @Business(viewType="both")
    public boolean setUseGroupsByUseUserId(long userId, long[] useGroupIds) {
        boolean success = false;
        UseUser useUser = this.useUserAdministrationFacade.getUseUserById(userId);
        List<UseGroup> oldUseGroups = useUser.getUseGroups();
        ArrayList<String> oldAssignment = new ArrayList<String>();
        for (int i = 0; i != oldUseGroups.size(); ++i) {
            oldAssignment.add(oldUseGroups.get(i).getName());
        }
        HashSet<Long> permissionsOfUseGroups = new HashSet<Long>();
        ArrayList<UseGroup> newUseGroups = new ArrayList<UseGroup>();
        ArrayList<String> newAssignment = new ArrayList<String>();
        for (long useGroupId : useGroupIds) {
            try {
                UseGroup useGroup = this.getUseGroupById(useGroupId);
                permissionsOfUseGroups.add(useGroupId);
                newAssignment.add(useGroup.getName());
                newUseGroups.add(useGroup);
            }
            catch (Exception e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
        }
        Collections.sort(oldAssignment);
        Collections.sort(newAssignment);
        if (((Object)oldAssignment).toString().equals(((Object)newAssignment).toString())) {
            return true;
        }
        try {
            useUser.replaceRelations(newUseGroups, UseGroup.class);
            success = true;
        }
        catch (Exception e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        for (Long permOfUseGroup : permissionsOfUseGroups) {
            this.unitFacadeLocal.updateUnitUserRefreshForUseGroup((long)permOfUseGroup);
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)(" ---- unituserrefresh for operatorgroup : " + permOfUseGroup));
        }
        return success;
    }

    @Override
    @Business(viewType="both")
    public boolean setUseUsersByUseGroupId(long groupId, long[] useUserIds) {
        boolean success = false;
        UseGroup useGroup = (UseGroup)this.useGroupDAO.findByPrimaryKey(groupId);
        List<UseUser> oldUseUsers = this.useUserAdministrationFacade.getUseUsersByUseGroupId(groupId);
        ArrayList<String> oldAssignment = new ArrayList<String>();
        for (int i = 0; i != oldUseUsers.size(); ++i) {
            oldAssignment.add(oldUseUsers.get(i).getName());
        }
        useGroup.clearRelations(UseUser.class);
        ArrayList<UseUser> newUseUsers = new ArrayList<UseUser>();
        ArrayList<String> newAssignment = new ArrayList<String>();
        for (long useUserId : useUserIds) {
            try {
                UseUser useUser = this.useUserAdministrationFacade.getUseUserById(useUserId);
                newUseUsers.add(useUser);
                newAssignment.add(useUser.getName());
            }
            catch (Exception e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
        }
        Collections.sort(oldAssignment);
        Collections.sort(newAssignment);
        if (((Object)oldAssignment).toString().equals(((Object)newAssignment).toString())) {
            return true;
        }
        try {
            useGroup.replaceRelations(newUseUsers, UseUser.class);
            success = true;
        }
        catch (Exception e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        this.unitFacadeLocal.updateUnitUserRefreshForUseGroup(groupId);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(" ---- unituserrefresh for operatorgroup : " + groupId));
        }
        return success;
    }

    @Override
    @Business(viewType="both")
    public List<UseGroup> getAllUseGroupsIncludeDeleted() {
        return this.useGroupDAO.findAllIncludeDeleted();
    }

    @Override
    @Business(viewType="both")
    public UseGroup getUseGroupById(long useGroupId) {
        return (UseGroup)this.useGroupDAO.findByPrimaryKey(useGroupId);
    }

    private HashMap<Long, UseGroup> getUseGroupMap() {
        HashMap<Long, UseGroup> groupMap = new HashMap<Long, UseGroup>();
        List<UseGroup> useGroupList = this.getAllUseGroups();
        for (int i = 0; i != useGroupList.size(); ++i) {
            UseGroup groupValue = useGroupList.get(i);
            groupMap.put(groupValue.getId(), groupValue);
        }
        return groupMap;
    }

    @Override
    @Business(viewType="both")
    public DTOListBase<UseUserDTO> getAllUseUserDTOs() {
        DTOListBase<UseUserDTO> dtoList = DTOListFactory.buildDTOListBase(null);
        HashMap<Long, UseGroup> groupMap = this.getUseGroupMap();
        List<UseUser> useUserList = this.useUserAdministrationFacade.getAllUseUsers();
        for (int i = 0; i != useUserList.size(); ++i) {
            UseUser useUser = useUserList.get(i);
            UseUserDTO dto = new UseUserDTO(useUser, useUser.getUseGroups());
            dtoList.add(dto);
        }
        return dtoList;
    }

    @Override
    @Business(viewType="both")
    public DTOListBase<UseUserDTO> getAllUseUserDTOByUnitId(long unitId) {
        DTOListBase<UseUserDTO> dtoList = DTOListFactory.buildDTOListBase(null);
        HashMap<Long, UseGroup> groupMap = this.getUseGroupMap();
        List<UseUser> useUserList = this.unitFacadeLocal.getAllUseUserByUnitId(unitId);
        for (int i = 0; i != useUserList.size(); ++i) {
            UseUser useUser = useUserList.get(i);
            UseUserDTO dto = new UseUserDTO(useUser, useUser.getUseGroups());
            dtoList.add(dto);
        }
        return dtoList;
    }

    @Override
    @Business(viewType="both")
    public DTOListBase<UseUserDTO> getAllDeletedUseUserDTOs() {
        DTOListBase<UseUserDTO> list = DTOListFactory.buildDTOListBase(null);
        HashMap<Long, UseGroup> groupMap = this.getUseGroupMap();
        List<UseUser> useUserList = this.useUserAdministrationFacade.getAllDeletedUseUsers();
        for (int i = 0; i != useUserList.size(); ++i) {
            UseUser useUserValue = useUserList.get(i);
            UseUserDTO dto = new UseUserDTO(useUserValue, useUserValue.getUseGroups());
            list.add(dto);
        }
        return list;
    }

    @Override
    @Business(viewType="both")
    public void removeUseGroup(UseGroup useGroup) {
        this.useGroupDAO.removeEntity(useGroup);
    }

    @Override
    @Business(viewType="both")
    public UseGroup getUseGroupByName(String name) {
        List<UseGroup> col = this.useGroupDAO.findByName(name);
        Iterator<UseGroup> iterator = col.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    @Override
    @Business(viewType="both")
    public UseGroup getUseGroupByNameIncludeDeleted(String name) {
        List<UseGroup> col = this.useGroupDAO.findByNameIncludeDeleted(name);
        Iterator<UseGroup> iterator = col.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }
}

