/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataOut.useradministration.facade;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.util.DataConverter;
import de.proveo.wwt.datamodel.account.Account;
import de.proveo.wwt.datamodel.groupIdent.GroupIdent;
import de.proveo.wwt.datamodel.role.Role;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.GroupIdentDAO;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.RoleAdminFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.UserAdminFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.UserGroupAdminFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.UserGroupAdminFacadeRemote;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import de.proveo.wwt.logic.web.admin.PermissionUpdateNotifyLocal;
import de.proveo.wwt.logic.web.admin.PermissionUpdateToolsLocal;
import de.proveo.wwt.logic.web.data.fastlanereader.PermissionFastLaneReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.ejb.CreateException;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;

@Stateless(name="UserGroupAdminFacade")
@Remote(value={UserGroupAdminFacadeRemote.class})
@Local(value={UserGroupAdminFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/UserGroupAdminFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/UserGroupAdminFacade")
public class UserGroupAdminFacadeBean
implements UserGroupAdminFacadeLocal,
UserGroupAdminFacadeRemote {
    private static final Log logger = LogFactory.getLog(UserGroupAdminFacadeBean.class);
    private final PermissionFastLaneReader permissionFastLaneReader = new PermissionFastLaneReader();
    @PersistenceContext(unitName="rts")
    private EntityManager entityManager = null;
    private GroupIdentDAO groupIdentDAO;
    @EJB
    private PermissionUpdateNotifyLocal permissionUpdateNotifyLocal = null;
    private RoleAdminFacadeLocal roleAdminFacadeLocal = null;
    private UserAdminFacadeLocal userAdminFacadeLocal = null;
    @EJB
    private PermissionUpdateToolsLocal permissionUpdateToolsLocal = null;
    @EJB
    private UnitFacadeLocal unitFacadeLocal = null;
    @EJB
    private UserGroupAdminFacadeLocal userGroupAdminFacadeLocal;

    @PostConstruct
    public void ejbCreate() {
        this.groupIdentDAO = GroupIdentDAO.newInstance(this.entityManager);
    }

    private RoleAdminFacadeLocal getRoleAdminFacade() {
        if (this.roleAdminFacadeLocal == null) {
            try {
                InitialContext context = new InitialContext();
                this.roleAdminFacadeLocal = (RoleAdminFacadeLocal)context.lookup("rts/RoleAdminFacade/local");
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
        }
        return this.roleAdminFacadeLocal;
    }

    private UserAdminFacadeLocal getUserAdminFacade() {
        if (this.userAdminFacadeLocal == null) {
            try {
                InitialContext context = new InitialContext();
                this.userAdminFacadeLocal = (UserAdminFacadeLocal)context.lookup("rts/UserAdminFacade/local");
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
        }
        return this.userAdminFacadeLocal;
    }

    @Override
    @Business(viewType="both")
    public List<GroupIdent> getAllUserGroups() {
        return this.groupIdentDAO.findAll();
    }

    @Override
    @Business(viewType="both")
    public GroupIdent getGroupIdent(long seletedGroupIdent) {
        return (GroupIdent)this.groupIdentDAO.findByPrimaryKey(seletedGroupIdent);
    }

    @Override
    @Business(viewType="both")
    public boolean deleteUserGroup(long groupId) {
        boolean success = false;
        try {
            HashMap<String, String[]> oldAccountPermissions = new HashMap<String, String[]>();
            Map<String, String[]> newAccountPermissions = null;
            HashMap<String, HashSet<Long>> oldUnitPermissions = new HashMap<String, HashSet<Long>>();
            Map<String, HashSet<Long>> newUnitPermissions = null;
            String[] usernames = this.userGroupAdminFacadeLocal._deleteUserGroupInNewTx(groupId, oldAccountPermissions, oldUnitPermissions);
            if (usernames == null || usernames.length == 0) {
                return true;
            }
            newAccountPermissions = this.getRoleAdminFacade().getSectionRolesForUsers(usernames);
            newUnitPermissions = this.unitFacadeLocal.getAllUnitIdsForUsernames(usernames);
            List<String> affectedUsersByAirportmapRoleChanges = this.permissionUpdateToolsLocal.getAffectedUsersByRolesChanges(oldAccountPermissions, newAccountPermissions, usernames);
            List<String> affectedUsersByVisibleUnitChanges = this.permissionUpdateToolsLocal.getAffectedUsersByVisibleUnitChanges(oldUnitPermissions, newUnitPermissions, usernames);
            if (!affectedUsersByAirportmapRoleChanges.isEmpty()) {
                this.permissionUpdateNotifyLocal.sendRoleChangedJMSMessageByUserNames(affectedUsersByAirportmapRoleChanges);
            }
            if (!affectedUsersByVisibleUnitChanges.isEmpty()) {
                this.permissionUpdateNotifyLocal.sendPermissionChangedJMSMessageByUserNames(affectedUsersByVisibleUnitChanges);
            }
            success = true;
        }
        catch (Exception e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return success;
    }

    @Override
    @Business(viewType="both")
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public String[] _deleteUserGroupInNewTx(long groupId, Map<String, String[]> oldAccountPermissions, Map<String, HashSet<Long>> oldUnitPermissions) {
        GroupIdent group = (GroupIdent)this.groupIdentDAO.findByPrimaryKey(groupId);
        List<Account> accounts = group.getAccounts();
        List<Role> roles = group.getRoles();
        for (Role role : roles) {
            List<Account> roleAccounts = role.getAccounts();
            for (Account a : roleAccounts) {
                if (accounts.contains(a)) continue;
                accounts.add(a);
            }
        }
        String[] usernames = new String[accounts.size()];
        for (int i = 0; i < accounts.size(); ++i) {
            usernames[i] = accounts.get(i).getUsername();
        }
        Map<String, String[]> tmpOldAccountPermissions = this.getRoleAdminFacade().getSectionRolesForUsers(usernames);
        oldAccountPermissions.putAll(tmpOldAccountPermissions);
        Map<String, HashSet<Long>> tmpOldUnitPermissions = this.unitFacadeLocal.getAllUnitIdsForUsernames(usernames);
        oldUnitPermissions.putAll(tmpOldUnitPermissions);
        this.groupIdentDAO.removeEntity(group);
        this.entityManager.flush();
        for (Account a : accounts) {
            this.entityManager.refresh((Object)a);
        }
        return usernames;
    }

    @Override
    @Business(viewType="both")
    public boolean duplicatedUserGroupName(String name, long Id2) {
        boolean duplicated = false;
        List<GroupIdent> collection = this.getAllUserGroups();
        for (GroupIdent groupIdentValue : collection) {
            if (groupIdentValue.getId() == Id2 || !groupIdentValue.getGroupName().equals(name)) continue;
            duplicated = true;
            break;
        }
        return duplicated;
    }

    @Override
    @Business(viewType="both")
    public Long insertUserGroup(GroupIdent group) throws CreateException {
        Long id = null;
        try {
            if (this.duplicatedUserGroupName(group.getGroupName(), -1L)) {
                throw new CreateException("No creation possible, Usergroup already exists");
            }
            this.groupIdentDAO.createEntity(group);
            id = group.getId();
        }
        catch (CreateException e) {
            logger.error((Object)"runs into", (Throwable)e);
            throw new CreateException("No creation possible, Usergroup already exists");
        }
        return id;
    }

    @Override
    @Business(viewType="both")
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public boolean updateUserGroup(GroupIdent group) {
        boolean success = false;
        if (this.duplicatedUserGroupName(group.getGroupName(), group.getId())) {
            success = false;
        } else {
            group = (GroupIdent)this.groupIdentDAO.updateEntity(group);
            success = true;
        }
        return success;
    }

    @Override
    @Business(viewType="both")
    public List<GroupIdent> getGroupsByUsername(String seletedUsername) {
        List<GroupIdent> list;
        Account account = this.getUserAdminFacade().getAccountByUsername(seletedUsername);
        if (account != null) {
            list = account.getGroups();
            Hibernate.initialize(list);
        } else {
            list = new ArrayList<GroupIdent>();
        }
        return list;
    }

    @Override
    @Business(viewType="both")
    public boolean setUsernamesByGroupId(long groupId, String[] usernames) {
        HashMap<String, String[]> oldAccountPermissions = new HashMap<String, String[]>();
        HashMap<String, String[]> newAccountPermissions = new HashMap();
        HashMap<String, HashSet<Long>> oldUnitPermissions = new HashMap<String, HashSet<Long>>();
        HashMap<String, HashSet<Long>> newUnitPermissions = new HashMap();
        String[] affectedUserNames = this.userGroupAdminFacadeLocal._setUsernamesByGroupIdInNewTx(groupId, usernames, oldAccountPermissions, oldUnitPermissions);
        if (affectedUserNames == null || affectedUserNames.length == 0) {
            return true;
        }
        newAccountPermissions = this.getRoleAdminFacade().getSectionRolesForUsers(affectedUserNames);
        newUnitPermissions = this.unitFacadeLocal.getAllUnitIdsForUsernames(affectedUserNames);
        List<String> affectedUsersByAirportmapRoleChanges = this.permissionUpdateToolsLocal.getAffectedUsersByRolesChanges(oldAccountPermissions, newAccountPermissions, affectedUserNames);
        List<String> affectedUsersByVisibleUnitChanges = this.permissionUpdateToolsLocal.getAffectedUsersByVisibleUnitChanges(oldUnitPermissions, newUnitPermissions, affectedUserNames);
        if (!affectedUsersByAirportmapRoleChanges.isEmpty()) {
            this.permissionUpdateNotifyLocal.sendRoleChangedJMSMessageByUserNames(affectedUsersByAirportmapRoleChanges);
        }
        if (!affectedUsersByVisibleUnitChanges.isEmpty()) {
            this.permissionUpdateNotifyLocal.sendPermissionChangedJMSMessageByUserNames(affectedUsersByVisibleUnitChanges);
        }
        return true;
    }

    @Override
    @Business(viewType="both")
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public String[] _setUsernamesByGroupIdInNewTx(long groupId, String[] usernames, Map<String, String[]> oldAccountPermissions, Map<String, HashSet<Long>> oldUnitPermissions) {
        String[] affectedUserNames = this.permissionUpdateToolsLocal.getDifferentUsers(this.getUserAdminFacade().getAccountsByUsername(groupId), usernames);
        Map<String, String[]> tmpOldAccountPermissions = this.getRoleAdminFacade().getSectionRolesForUsers(affectedUserNames);
        oldAccountPermissions.putAll(tmpOldAccountPermissions);
        Map<String, HashSet<Long>> tmpOldUnitPermissions = this.unitFacadeLocal.getAllUnitIdsForUsernames(affectedUserNames);
        oldUnitPermissions.putAll(tmpOldUnitPermissions);
        GroupIdent group = (GroupIdent)this.groupIdentDAO.findByPrimaryKey(groupId);
        ArrayList<Account> newUsers = new ArrayList<Account>();
        ArrayList<String> newAssignment = new ArrayList<String>();
        for (String username : usernames) {
            Account account = this.getUserAdminFacade().getAccountByUsername(username);
            newAssignment.add(account.getUsername());
            newUsers.add(account);
        }
        List<Account> oldUsers = group.getAccounts();
        ArrayList<String> oldAssignment = new ArrayList<String>();
        for (Account account : oldUsers) {
            oldAssignment.add(account.getUsername());
        }
        Collections.sort(oldAssignment);
        Collections.sort(newAssignment);
        if (((Object)oldAssignment).toString().equals(((Object)newAssignment).toString())) {
            return new String[0];
        }
        group.replaceRelations(newUsers, Account.class);
        this.entityManager.flush();
        this.entityManager.refresh((Object)group);
        return affectedUserNames;
    }

    @Override
    @Business(viewType="both")
    public boolean setGroupsByUsername(String username, long[] groupIds) {
        boolean success = false;
        Account account = this.getUserAdminFacade().getAccountByUsername(username);
        if (account != null) {
            success = this.setGroupsByUserId(account.getId(), groupIds);
        }
        return success;
    }

    @Override
    @Business(viewType="both")
    public boolean setGroupsByUserId(long accountId, long[] groupIds) {
        ArrayList<Account> accounts;
        ArrayList<String> currentRoles = new ArrayList<String>();
        HashSet<Long> currentUnitIDs = new HashSet<Long>();
        Account account = this.userGroupAdminFacadeLocal._setGroupsByUserIdInNewTx(accountId, groupIds, currentRoles, currentUnitIDs);
        if (account == null) {
            return true;
        }
        ArrayList<String> newRoles = new ArrayList<String>(DataConverter.arrayAsList((String[])this.getRoleAdminFacade().getSectionRolesForUser(account.getUsername())));
        HashSet<Long> newUnitIDs = this.permissionFastLaneReader.getUnitPermissions(accountId);
        if (this.permissionUpdateToolsLocal.isAirportMapRoleAffected(newRoles, currentRoles)) {
            accounts = new ArrayList<Account>();
            accounts.add(account);
            this.permissionUpdateNotifyLocal.sendRoleChangedJMSMessage(accounts);
        }
        if (!this.permissionUpdateToolsLocal.getDiffOfCollection(currentUnitIDs, newUnitIDs).isEmpty()) {
            accounts = new ArrayList();
            accounts.add(account);
            this.permissionUpdateNotifyLocal.sendPermissionChangedJMSMessage(accounts);
        }
        return true;
    }

    @Override
    @Business(viewType="both")
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public Account _setGroupsByUserIdInNewTx(long accountId, long[] groupIds, List<String> currentRoles, HashSet<Long> currentUnitIDs) {
        Account account = this.getUserAdminFacade().getAccount(accountId);
        String userName = account.getUsername();
        ArrayList tmpCurrentRoles = new ArrayList(DataConverter.arrayAsList((String[])this.getRoleAdminFacade().getSectionRolesForUser(userName)));
        currentRoles.addAll(tmpCurrentRoles);
        HashSet<Long> tmpCurrentUnitIDs = this.unitFacadeLocal.getAllUnitIdsForUsername(userName);
        currentUnitIDs.addAll(tmpCurrentUnitIDs);
        ArrayList<GroupIdent> newGroups = new ArrayList<GroupIdent>();
        ArrayList<String> newAssignment = new ArrayList<String>();
        GroupIdent groupIdent2 = null;
        for (long groupId : groupIds) {
            groupIdent2 = (GroupIdent)this.groupIdentDAO.findByPrimaryKey(groupId);
            newGroups.add(groupIdent2);
            newAssignment.add(groupIdent2.getGroupName());
        }
        List<GroupIdent> oldGroups = account.getGroups();
        ArrayList<String> oldAssignment = new ArrayList<String>();
        for (GroupIdent groupIdent2 : oldGroups) {
            oldAssignment.add(groupIdent2.getGroupName());
        }
        Collections.sort(oldAssignment);
        Collections.sort(newAssignment);
        if (((Object)oldAssignment).toString().equals(((Object)newAssignment).toString())) {
            return null;
        }
        account.replaceRelations(newGroups, GroupIdent.class);
        this.entityManager.flush();
        this.entityManager.refresh((Object)account);
        return account;
    }

    @Override
    @Deprecated
    @Business(viewType="both")
    public List<GroupIdent> getGroupsByUserId(long accountId) {
        List<GroupIdent> list = new ArrayList<GroupIdent>();
        Account account = this.getUserAdminFacade().getAccount(accountId);
        if (account != null) {
            list = account.getGroups();
        }
        return list;
    }

    @Override
    @Business(viewType="both")
    public List<GroupIdent> getGroupsByRoleId(long roleId) {
        Role role = this.getRoleAdminFacade().getRole(roleId);
        return new ArrayList<GroupIdent>(role.getGroups());
    }

    @Override
    @Business(viewType="both")
    public List<Account> getAccountsByGroupID(long groupId) {
        GroupIdent groupIdent = (GroupIdent)this.groupIdentDAO.findByPrimaryKey(groupId);
        return new ArrayList<Account>(groupIdent.getAccounts());
    }

    @Override
    @Business(viewType="both")
    public List<Account> getAccountsByGroupIDs(List<Long> groupIDs) {
        ArrayList<Account> accounts = new ArrayList<Account>();
        for (Long id : groupIDs) {
            List<Account> accountList = this.getAccountsByGroupID(id);
            accounts.addAll(accountList);
        }
        return accounts;
    }

    @Override
    @Business(viewType="both")
    public List<Account> getAccountsByGroupIDs(long[] groupIDs) {
        ArrayList<Long> groupIDList = new ArrayList<Long>(groupIDs.length);
        for (int i = 0; i < groupIDs.length; ++i) {
            groupIDList.add(groupIDs[i]);
        }
        return this.getAccountsByGroupIDs(groupIDList);
    }
}

