/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataOut.useradministration.facade;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.util.container.ContainerUtil;
import de.proveo.wwt.datamodel.account.Account;
import de.proveo.wwt.datamodel.groupIdent.GroupIdent;
import de.proveo.wwt.datamodel.role.IRoleOwner;
import de.proveo.wwt.datamodel.role.Role;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.AccountDAO;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.GroupIdentDAO;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.RoleAdminFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.RoleAdminFacadeRemote;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.RoleDAO;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.UserAdminFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.UserGroupAdminFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.dto.SectionRoleDTO;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.dto.SectionRoleNode;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import de.proveo.wwt.logic.web.admin.PermissionUpdateNotifyLocal;
import de.proveo.wwt.logic.web.admin.PermissionUpdateToolsLocal;
import de.proveo.wwt.logic.web.data.fastlanereader.MasterDataFastLaneReader;
import de.proveo.wwt.logic.web.data.fastlanereader.PermissionFastLaneReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.PostConstruct;
import javax.ejb.CreateException;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Stateless(name="RoleAdminFacade")
@Remote(value={RoleAdminFacadeRemote.class})
@Local(value={RoleAdminFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/RoleAdminFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/RoleAdminFacade")
public class RoleAdminFacadeBean
implements RoleAdminFacadeLocal,
RoleAdminFacadeRemote {
    private static final long serialVersionUID = -5466790817769050409L;
    private static final Log log = LogFactory.getLog(RoleAdminFacadeBean.class);
    private static final String RESOURCE_ENTRY_FOR_SECTIONROLES = "section.";
    private final PermissionFastLaneReader permissionFastLaneReader = new PermissionFastLaneReader();
    @EJB
    private UserGroupAdminFacadeLocal userGroupAdminFacade = null;
    @EJB
    private PermissionUpdateNotifyLocal permissionUpdateNotifyLocal = null;
    @EJB
    private PermissionUpdateToolsLocal permissionUpdateToolsLocal = null;
    @EJB
    private UserAdminFacadeLocal userAdminFacadeLocal;
    @EJB
    private RoleAdminFacadeLocal roleAdminFacadeLocal;
    private UnitFacadeLocal unitFacadeLocal = null;
    private GroupIdentDAO groupIdentDAO = null;
    private RoleDAO roleDAO = null;
    private AccountDAO accountDAO = null;
    @PersistenceContext(unitName="rts")
    private EntityManager entityManager = null;

    @PostConstruct
    private void initImpl() {
        this.roleDAO = RoleDAO.newInstance(this.entityManager);
        this.accountDAO = AccountDAO.newInstance(this.entityManager);
        this.groupIdentDAO = GroupIdentDAO.newInstance(this.entityManager);
    }

    private UnitFacadeLocal getUnitFacade() {
        try {
            InitialContext context = new InitialContext();
            this.unitFacadeLocal = (UnitFacadeLocal)context.lookup("rts/UnitFacade/local");
        }
        catch (Exception e) {
            log.error((Object)"runs into ", (Throwable)e);
        }
        return this.unitFacadeLocal;
    }

    @Override
    @Business(viewType="both")
    public Role getRole(long roleId) {
        return (Role)this.roleDAO.findByPrimaryKey(roleId);
    }

    @Override
    @Business(viewType="both")
    public List<Role> getRoles() {
        return this.roleDAO.findAll();
    }

    @Override
    @Business(viewType="both")
    public Long insertRole(Role role) throws CreateException {
        if (this.duplicateRolename(role.getRoleName(), -1L)) {
            throw new CreateException("No creation possible, rolename already exists");
        }
        this.roleDAO.createEntity(role);
        long id = role.getId();
        return id != 0L ? Long.valueOf(id) : null;
    }

    private boolean duplicateRolename(String roleName, long roleId) {
        boolean duplicate = false;
        List<Role> allRoles = this.getRoles();
        for (Role role : allRoles) {
            if (role.getId() == roleId || !role.getRoleName().equals(roleName)) continue;
            duplicate = true;
            break;
        }
        return duplicate;
    }

    @Override
    @Business(viewType="both")
    public void deleteRole(long roleId) {
        HashMap<String, String[]> oldAccountPermissions = new HashMap<String, String[]>();
        Map<String, String[]> newAccountPermissions = null;
        HashMap<String, HashSet<Long>> oldUnitPermissions = new HashMap<String, HashSet<Long>>();
        Map<String, HashSet<Long>> newUnitPermissions = null;
        String[] usernames = this.roleAdminFacadeLocal._deleteRoleInNewTx(roleId, oldAccountPermissions, oldUnitPermissions);
        if (usernames == null || usernames.length == 0) {
            return;
        }
        newAccountPermissions = this.getSectionRolesForUsers(usernames);
        newUnitPermissions = this.getUnitFacade().getAllUnitIdsForUsernames(usernames);
        List<String> affectedUsersByAirportmapRoleChanges = this.permissionUpdateToolsLocal.getAffectedUsersByRolesChanges(oldAccountPermissions, newAccountPermissions, usernames);
        List<String> affectedUsersByVisibleUnitChanges = this.permissionUpdateToolsLocal.getAffectedUsersByVisibleUnitChanges(oldUnitPermissions, newUnitPermissions, usernames);
        if (!affectedUsersByAirportmapRoleChanges.isEmpty()) {
            this.permissionUpdateNotifyLocal.sendRoleChangedJMSMessageByUserNames(affectedUsersByAirportmapRoleChanges);
        }
        if (!affectedUsersByVisibleUnitChanges.isEmpty()) {
            this.permissionUpdateNotifyLocal.sendPermissionChangedJMSMessageByUserNames(affectedUsersByVisibleUnitChanges);
        }
    }

    @Override
    @Business(viewType="both")
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public String[] _deleteRoleInNewTx(long roleId, Map<String, String[]> oldAccountPermissions, Map<String, HashSet<Long>> oldUnitPermissions) {
        Role role = (Role)this.roleDAO.findByPrimaryKey(roleId);
        if (role == null) {
            return new String[0];
        }
        List<Account> accounts = role.getAccounts();
        List<GroupIdent> groups = role.getGroups();
        for (GroupIdent group : groups) {
            List<Account> groupAccounts = group.getAccounts();
            for (Account a : groupAccounts) {
                if (accounts.contains(a)) continue;
                accounts.add(a);
            }
        }
        String[] usernames = new String[accounts.size()];
        for (int i = 0; i < accounts.size(); ++i) {
            usernames[i] = accounts.get(i).getUsername();
        }
        Map<String, String[]> tmpOldAccountPermissions = this.getSectionRolesForUsers(usernames);
        oldAccountPermissions.putAll(tmpOldAccountPermissions);
        Map<String, HashSet<Long>> tmpOldUnitPermissions = this.getUnitFacade().getAllUnitIdsForUsernames(usernames);
        oldUnitPermissions.putAll(tmpOldUnitPermissions);
        this.roleDAO.removeEntity(role);
        this.entityManager.flush();
        for (Account a : accounts) {
            this.entityManager.refresh((Object)a);
        }
        return usernames;
    }

    @Override
    @Business(viewType="both")
    public Map<String, String[]> getSectionRolesForUsers(String[] usernames) {
        HashMap<String, String[]> userRoles = new HashMap<String, String[]>();
        for (int i = 0; i < usernames.length; ++i) {
            userRoles.put(usernames[i], this.getSectionRolesForUser(usernames[i]));
        }
        return userRoles;
    }

    @Override
    @Business(viewType="both")
    public String[] getSectionRolesForUser(String username) {
        List<Role> roles;
        Account account = this.accountDAO.findByUsername(username);
        if (account == null) {
            return new String[0];
        }
        TreeSet<Role> assignedRoles = new TreeSet<Role>();
        List<GroupIdent> userGroups = account.getGroups();
        List<Role> userRoles = account.getRoles();
        assignedRoles.addAll(userRoles);
        if (userGroups != null) {
            for (GroupIdent group : userGroups) {
                roles = (group = (GroupIdent)this.groupIdentDAO.findByPrimaryKey(group.getPrimaryKey())).getRoles();
                if (roles == null) continue;
                for (Role role : roles) {
                    role = (Role)this.roleDAO.findByPrimaryKey(role.getPrimaryKey());
                    assignedRoles.add(role);
                }
            }
        }
        if (userRoles != null) {
            for (Role role : userRoles) {
                roles = (role = (Role)this.roleDAO.findByPrimaryKey(role.getPrimaryKey())).getRoles();
                if (roles == null) continue;
                for (Role sRole : roles) {
                    sRole = (Role)this.roleDAO.findByPrimaryKey(sRole.getPrimaryKey());
                    assignedRoles.add(sRole);
                }
            }
        }
        TreeSet<Role> roles2 = new TreeSet<Role>();
        this.findSubroles(roles2, assignedRoles);
        List<Role> result = this.filterRoles(new ArrayList<Role>(roles2), false, true);
        String[] roleStrings = new String[result.size()];
        for (int i = 0; i != result.size(); ++i) {
            roleStrings[i] = result.get(i).getRoleName();
        }
        return roleStrings;
    }

    private void findSubroles(Set<Role> result, Set<Role> sourceRoles) {
        List<Role> roles;
        ArrayList<Role> source = new ArrayList<Role>(sourceRoles);
        for (Role role : source) {
            roles = role.getRoles();
            if (roles != null && roles.size() != 0) continue;
            result.add(role);
        }
        source.removeAll(result);
        for (Role role : source) {
            roles = role.getRoles();
            if (roles == null || roles.size() == 0) continue;
            this.findSubroles(result, new TreeSet<Role>(roles));
        }
    }

    @Override
    @Business(viewType="both")
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public boolean updateRole(Role role) {
        boolean successful = false;
        long roleId = role.getId();
        if (this.duplicateRolename(role.getRoleName(), roleId)) {
            successful = false;
        } else {
            role = (Role)this.roleDAO.updateEntity(role);
            successful = true;
        }
        return successful;
    }

    @Override
    @Business(viewType="both")
    public Role getRoleByName(String rolename) {
        return this.roleDAO.findByRolename(rolename);
    }

    @Override
    @Deprecated
    @Business(viewType="both")
    public List<Role> getRolesByUserId(long accountId) {
        Account account = (Account)this.accountDAO.findByPrimaryKey(accountId);
        return account.getRoles();
    }

    @Override
    @Business(viewType="both")
    public List<Role> getRoles(IRoleOwner roleOwner, boolean removeSectionRoles, boolean removeNonSectionRoles) {
        roleOwner = (IRoleOwner)this.entityManager.find(roleOwner.getClass(), roleOwner.getPrimaryKey());
        return this.filterRoles(roleOwner.getRoles(), removeSectionRoles, removeNonSectionRoles);
    }

    @Override
    @Business(viewType="both")
    public List<Role> getRoles(boolean removeSectionRoles, boolean removeNonSectionRoles) {
        return this.filterRoles(this.roleDAO.findAll(), removeSectionRoles, removeNonSectionRoles);
    }

    private List<Role> filterRoles(List<Role> list, boolean removeSectionRoles, boolean removeNonSectionRoles) {
        ArrayList<Role> roles = new ArrayList<Role>();
        for (Role role : list) {
            boolean startsWith = role.getRoleName().startsWith(RESOURCE_ENTRY_FOR_SECTIONROLES);
            if (removeSectionRoles && startsWith || removeNonSectionRoles && !startsWith) continue;
            roles.add(role);
        }
        return roles;
    }

    @Override
    @Business(viewType="both")
    public SectionRoleNode getSectionRoleNodeTree(String sectionIdentifier) {
        SectionRoleDTO dto = this.getSectionRoleData(sectionIdentifier);
        return dto.getRoot();
    }

    @Override
    @Business(viewType="both")
    public SectionRoleDTO getSectionRoleData(String sectionIdentifier) {
        Role sectionRole = new Role();
        sectionRole.setRoleName(sectionIdentifier);
        SectionRoleDTO dto = new SectionRoleDTO(sectionRole);
        SectionRoleNode rootNode = dto.getRoot();
        this.iterateSectionNodes(sectionRole, rootNode, true);
        return dto;
    }

    private void iterateSectionNodes(Role role, SectionRoleNode node, boolean test) {
        List<Role> roles = this.getRoles();
        ArrayList<Role> childs = new ArrayList<Role>();
        String rolePrefix = role.getRoleName();
        if (!rolePrefix.endsWith(".")) {
            rolePrefix = rolePrefix + ".";
        }
        for (Role value : roles) {
            if (!value.getRoleName().startsWith(rolePrefix) || value.getRoleName().split("[.]").length != role.getRoleName().split("[.]").length + 1) continue;
            childs.add(value);
        }
        for (Role roleValue : childs) {
            try {
                SectionRoleNode roleNode = node.addRoleNode(roleValue);
                if (!test) continue;
                this.iterateSectionNodes(roleValue, roleNode, true);
            }
            catch (Exception e) {
                log.error((Object)"runs into", (Throwable)e);
            }
        }
    }

    @Override
    @Business(viewType="both")
    public boolean setRolesByAccountId(long accountId, long[] roleIds, boolean sendJMSMessage) {
        ArrayList<String> currentRolesList = new ArrayList<String>();
        HashSet<Long> currentUnitIDs = new HashSet<Long>();
        Account account = this.roleAdminFacadeLocal._setRolesByAccountIdInNewTx(accountId, roleIds, currentRolesList, currentUnitIDs);
        if (account == null) {
            return true;
        }
        String userName = account.getUsername();
        ArrayList newRolesList = ContainerUtil.asArrayList((Object[])this.getSectionRolesForUser(userName));
        HashSet<Long> newUnitIDs = this.permissionFastLaneReader.getUnitPermissions(accountId);
        log.debug((Object)("setUserPermissions(): user permissions for user " + userName + " changed from " + currentUnitIDs + " to " + newUnitIDs));
        if (sendJMSMessage) {
            ArrayList<Account> accounts;
            if (this.permissionUpdateToolsLocal.isAirportMapRoleAffected(newRolesList, currentRolesList)) {
                accounts = new ArrayList<Account>();
                accounts.add(account);
                this.permissionUpdateNotifyLocal.sendRoleChangedJMSMessage(accounts);
            }
            if (!this.permissionUpdateToolsLocal.getDiffOfCollection(currentUnitIDs, newUnitIDs).isEmpty()) {
                accounts = new ArrayList();
                accounts.add(account);
                this.permissionUpdateNotifyLocal.sendPermissionChangedJMSMessage(accounts);
            }
        }
        return true;
    }

    @Override
    @Business(viewType="both")
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public Account _setRolesByAccountIdInNewTx(long accountId, long[] roleIds, List<String> currentRolesList, HashSet<Long> currentUnitIDs) {
        Role roleLocal2 = null;
        Account account = (Account)this.accountDAO.findByPrimaryKey(accountId);
        String userName = account.getUsername();
        ArrayList tmpCurrentRolesList = ContainerUtil.asArrayList((Object[])this.getSectionRolesForUser(userName));
        currentRolesList.addAll(tmpCurrentRolesList);
        HashSet<Long> tmpCurrentUnitIDs = this.getUnitFacade().getAllUnitIdsForUsername(userName);
        currentUnitIDs.addAll(tmpCurrentUnitIDs);
        ArrayList<Role> newRoles = new ArrayList<Role>();
        ArrayList<String> newAssignment = new ArrayList<String>();
        for (long roleId : roleIds) {
            roleLocal2 = (Role)this.roleDAO.findByPrimaryKey(roleId);
            newRoles.add(roleLocal2);
            newAssignment.add(roleLocal2.getRoleName());
        }
        List<Role> actRoles = account.getRoles();
        ArrayList<String> oldAssignment = new ArrayList<String>();
        for (Role roleLocal2 : actRoles) {
            oldAssignment.add(roleLocal2.getRoleName());
        }
        Collections.sort(oldAssignment);
        Collections.sort(newAssignment);
        if (((Object)oldAssignment).toString().equals(((Object)newAssignment).toString())) {
            return null;
        }
        account.replaceRelations(newRoles, Role.class);
        this.entityManager.flush();
        this.entityManager.refresh((Object)account);
        return account;
    }

    @Override
    @Business(viewType="both")
    public boolean setRoleIdsByGroupId(long userGroupId, long[] roleIds) {
        HashMap<String, String[]> oldAccountPermissions = new HashMap<String, String[]>();
        HashMap<String, String[]> newAccountPermissions = new HashMap();
        HashMap<String, HashSet<Long>> oldUnitPermissions = new HashMap<String, HashSet<Long>>();
        HashMap<String, HashSet<Long>> newUnitPermissions = new HashMap();
        String[] affectedUserNames = this.roleAdminFacadeLocal._setRoleIdsByGroupIdInNewTx(userGroupId, roleIds, oldAccountPermissions, oldUnitPermissions);
        if (affectedUserNames == null || affectedUserNames.length == 0) {
            return true;
        }
        newAccountPermissions = this.getSectionRolesForUsers(affectedUserNames);
        newUnitPermissions = this.getUnitFacade().getAllUnitIdsForUsernames(affectedUserNames);
        List<String> affectedUsersByAirportmapRoleChanges = this.permissionUpdateToolsLocal.getAffectedUsersByRolesChanges(oldAccountPermissions, newAccountPermissions, affectedUserNames);
        List<String> affectedUsersByVisibleUnitChanges = this.permissionUpdateToolsLocal.getAffectedUsersByVisibleUnitChanges(oldUnitPermissions, newUnitPermissions, affectedUserNames);
        if (!affectedUsersByAirportmapRoleChanges.isEmpty()) {
            this.permissionUpdateNotifyLocal.sendRoleChangedJMSMessageByUserNames(affectedUsersByAirportmapRoleChanges);
        }
        if (!affectedUsersByVisibleUnitChanges.isEmpty()) {
            this.permissionUpdateNotifyLocal.sendPermissionChangedJMSMessageByUserNames(affectedUsersByVisibleUnitChanges);
        }
        return true;
    }

    @Override
    @Business(viewType="both")
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public String[] _setRoleIdsByGroupIdInNewTx(long userGroupId, long[] roleIds, Map<String, String[]> oldAccountPermissions, Map<String, HashSet<Long>> oldUnitPermissions) {
        List<Account> accounts = this.userGroupAdminFacade.getAccountsByGroupID(userGroupId);
        String[] affectedUserNames = this.permissionUpdateToolsLocal.getUserNames(accounts);
        Map<String, String[]> tmpOldAccountPermissions = this.getSectionRolesForUsers(affectedUserNames);
        oldAccountPermissions.putAll(tmpOldAccountPermissions);
        Map<String, HashSet<Long>> tmpOldUnitPermissions = this.getUnitFacade().getAllUnitIdsForUsernames(affectedUserNames);
        oldUnitPermissions.putAll(tmpOldUnitPermissions);
        Role roleLocal2 = null;
        GroupIdent group = (GroupIdent)this.groupIdentDAO.findByPrimaryKey(userGroupId);
        ArrayList<Role> newRoles = new ArrayList<Role>();
        ArrayList<String> newAssignment = new ArrayList<String>();
        for (long roleId : roleIds) {
            roleLocal2 = (Role)this.roleDAO.findByPrimaryKey(roleId);
            newRoles.add(roleLocal2);
            newAssignment.add(roleLocal2.getRoleName());
        }
        List<Role> actRoles = group.getRoles();
        ArrayList<Role> oldRoles = new ArrayList<Role>();
        ArrayList<String> oldAssignment = new ArrayList<String>();
        for (Role roleLocal2 : actRoles) {
            oldRoles.add(roleLocal2);
            oldAssignment.add(roleLocal2.getRoleName());
        }
        Collections.sort(oldAssignment);
        Collections.sort(newAssignment);
        if (((Object)oldAssignment).toString().equals(((Object)newAssignment).toString())) {
            return new String[0];
        }
        group.replaceRelations(newRoles, Role.class);
        this.entityManager.flush();
        this.entityManager.refresh((Object)group);
        return affectedUserNames;
    }

    @Override
    @Business(viewType="both")
    public boolean setRolesByRoleId(long parentRoleId, long[] roles) {
        HashMap<String, String[]> oldAccountPermissions = new HashMap<String, String[]>();
        Map<Object, Object> newAccountPermissions = new HashMap();
        String[] affectedUserNames = this.roleAdminFacadeLocal._setRolesByRoleIdInNewTx(parentRoleId, roles, oldAccountPermissions);
        if (affectedUserNames == null || affectedUserNames.length == 0) {
            return true;
        }
        newAccountPermissions = this.getSectionRolesForUsers(affectedUserNames);
        List<String> affectedUsersByAirportmapRoleChanges = this.permissionUpdateToolsLocal.getAffectedUsersByRolesChanges(oldAccountPermissions, newAccountPermissions, affectedUserNames);
        if (!affectedUsersByAirportmapRoleChanges.isEmpty()) {
            this.permissionUpdateNotifyLocal.sendRoleChangedJMSMessageByUserNames(affectedUsersByAirportmapRoleChanges);
        }
        return true;
    }

    @Override
    @Business(viewType="both")
    public void setParentRolesByRoleId(long childRoleId, long[] roles) {
    }

    @Override
    @Business(viewType="both")
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public String[] _setRolesByRoleIdInNewTx(long parentRoleId, long[] roles, Map<String, String[]> oldAccountPermissions) {
        ArrayList<String> oldAssignment = new ArrayList<String>();
        ArrayList<String> newAssignment = new ArrayList<String>();
        Role role2 = null;
        Role parentRole = (Role)this.roleDAO.findByPrimaryKey(parentRoleId);
        ArrayList<Account> accounts = new ArrayList<Account>(parentRole.getAccounts());
        ArrayList<Role> newRoles = new ArrayList<Role>(roles.length);
        for (int i = 0; i != roles.length; ++i) {
            role2 = (Role)this.roleDAO.findByPrimaryKey(roles[i]);
            newRoles.add(role2);
            accounts.addAll(role2.getAccounts());
            newAssignment.add(role2.getRoleName());
        }
        List<Role> oldRolesCollection = parentRole.getRoles();
        for (Role role2 : oldRolesCollection) {
            accounts.addAll(role2.getAccounts());
            oldAssignment.add(role2.getRoleName());
        }
        String[] affectedUserNames = this.permissionUpdateToolsLocal.getUserNames(accounts);
        Map<String, String[]> tmpOldAccountPermissions = this.getSectionRolesForUsers(affectedUserNames);
        oldAccountPermissions.putAll(tmpOldAccountPermissions);
        Collections.sort(oldAssignment);
        Collections.sort(newAssignment);
        if (((Object)oldAssignment).toString().equals(((Object)newAssignment).toString())) {
            return new String[0];
        }
        parentRole.replaceRelations(newRoles, Role.class, "childSectionRoles");
        this.entityManager.flush();
        this.entityManager.refresh((Object)parentRole);
        return affectedUserNames;
    }

    @Override
    @Business(viewType="both")
    public List<Role> getRolesByUsername(String username) {
        Account account = this.accountDAO.findByUsername(username);
        List<Role> roles = account.getRoles();
        ArrayList<Role> ret = new ArrayList<Role>();
        if (roles != null) {
            for (int i = 0; i < roles.size(); ++i) {
                Role role = (Role)this.roleDAO.findByPrimaryKey(roles.get(i).getPrimaryKey());
                ret.add(role);
            }
        }
        return ret;
    }

    @Override
    @Business(viewType="both")
    public List<Account> getAccountsInRoleAndGroupsByRoleID(long roleID) {
        ArrayList<Account> accounts = new ArrayList<Account>();
        Role roleLocal = (Role)this.roleDAO.findByPrimaryKey(roleID);
        for (GroupIdent groupIdent : roleLocal.getGroups()) {
            Long groupId = groupIdent.getId();
            List<Account> accountList = this.userGroupAdminFacade.getAccountsByGroupID(groupId);
            accounts.addAll(accountList);
        }
        accounts.addAll(this.getAccountsbyRoleID(roleID));
        return accounts;
    }

    @Override
    @Business(viewType="both")
    public List<Role> getRolesByGroupId(long groupId) {
        GroupIdent group = (GroupIdent)this.groupIdentDAO.findByPrimaryKey(groupId);
        List<Role> roles = group.getRoles();
        ArrayList<Role> ret = new ArrayList<Role>();
        if (roles != null) {
            for (int i = 0; i < roles.size(); ++i) {
                Role role = (Role)this.roleDAO.findByPrimaryKey(roles.get(i).getPrimaryKey());
                ret.add(role);
            }
        }
        return roles;
    }

    @Override
    @Business(viewType="both")
    public List<Role> getRolesByRoleId(long roleId) {
        Role role = (Role)this.roleDAO.findByPrimaryKey(roleId);
        return new ArrayList<Role>(role.getRoles());
    }

    @Override
    @Business(viewType="both")
    public boolean setUsernamesByRoleId(long roleId, String[] usernames) {
        HashMap<String, String[]> oldAccounts = new HashMap<String, String[]>();
        HashMap<String, String[]> newAccounts = new HashMap();
        HashMap<String, HashSet<Long>> oldUnitPermissions = new HashMap<String, HashSet<Long>>();
        HashMap<String, HashSet<Long>> newUnitPermissions = new HashMap();
        String[] affectedUserNames = this.roleAdminFacadeLocal._setUsernamesByRoleIdInNewTx(roleId, usernames, oldAccounts, oldUnitPermissions);
        if (affectedUserNames == null || affectedUserNames.length == 0) {
            return true;
        }
        newAccounts = this.getSectionRolesForUsers(affectedUserNames);
        newUnitPermissions = this.getUnitFacade().getAllUnitIdsForUsernames(affectedUserNames);
        List<String> affectedUsersByAirportmapRoleChanges = this.permissionUpdateToolsLocal.getAffectedUsersByRolesChanges(oldAccounts, newAccounts, affectedUserNames);
        List<String> affectedUsersByVisibleUnitChanges = this.permissionUpdateToolsLocal.getAffectedUsersByVisibleUnitChanges(oldUnitPermissions, newUnitPermissions, affectedUserNames);
        if (!affectedUsersByAirportmapRoleChanges.isEmpty()) {
            this.permissionUpdateNotifyLocal.sendRoleChangedJMSMessageByUserNames(affectedUsersByAirportmapRoleChanges);
        }
        if (!affectedUsersByVisibleUnitChanges.isEmpty()) {
            this.permissionUpdateNotifyLocal.sendPermissionChangedJMSMessageByUserNames(affectedUsersByVisibleUnitChanges);
        }
        return true;
    }

    @Override
    @Business(viewType="both")
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public String[] _setUsernamesByRoleIdInNewTx(long roleId, String[] usernames, Map<String, String[]> oldAccounts, Map<String, HashSet<Long>> oldUnitPermissions) {
        String[] affectedUserNames = this.permissionUpdateToolsLocal.getDifferentUsers(this.userAdminFacadeLocal.getUsernamesByRoleId(roleId), usernames);
        Map<String, HashSet<Long>> tmpOldUnitPermissions = this.getUnitFacade().getAllUnitIdsForUsernames(affectedUserNames);
        oldUnitPermissions.putAll(tmpOldUnitPermissions);
        Map<String, String[]> tmpOldAccounts = this.getSectionRolesForUsers(affectedUserNames);
        oldAccounts.putAll(tmpOldAccounts);
        Role role = (Role)this.roleDAO.findByPrimaryKey(roleId);
        ArrayList<Account> newUsersList = new ArrayList<Account>();
        ArrayList<String> newAssignment = new ArrayList<String>();
        Account account2 = null;
        for (String username : usernames) {
            account2 = this.accountDAO.findByUsername(username);
            newAssignment.add(account2.getUsername());
            newUsersList.add(account2);
        }
        List<Account> users = role.getAccounts();
        ArrayList<Account> oldUsersList = new ArrayList<Account>();
        ArrayList<String> oldAssignment = new ArrayList<String>();
        for (Account account2 : users) {
            oldAssignment.add(account2.getUsername());
            oldUsersList.add(account2);
        }
        Collections.sort(oldAssignment);
        Collections.sort(newAssignment);
        if (((Object)oldAssignment).toString().equals(((Object)newAssignment).toString())) {
            return new String[0];
        }
        role.replaceRelations(newUsersList, Account.class);
        this.entityManager.flush();
        this.entityManager.refresh((Object)role);
        return affectedUserNames;
    }

    @Override
    @Business(viewType="both")
    public void removeSectionRoleRelations(long roleId) {
        HashSet<Account> accounts = new HashSet<Account>();
        this.roleAdminFacadeLocal._removeSectionRoleRelations(roleId, accounts);
        if (!accounts.isEmpty()) {
            this.permissionUpdateNotifyLocal.sendRoleChangedJMSMessage(new ArrayList<Account>(accounts));
        }
    }

    @Override
    @Business(viewType="both")
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void _removeSectionRoleRelations(long roleId, Set<Account> accounts) {
        Role sectionRole = this.getRole(roleId);
        if (!sectionRole.getAccounts().isEmpty()) {
            accounts.addAll(sectionRole.getAccounts());
            sectionRole.replaceRelations(new ArrayList(0), Account.class);
        }
        if (!sectionRole.getGroups().isEmpty()) {
            for (GroupIdent group : sectionRole.getGroups()) {
                accounts.addAll(group.getAccounts());
            }
            sectionRole.replaceRelations(new ArrayList(0), GroupIdent.class);
        }
        if (!sectionRole.getParentRoles().isEmpty()) {
            for (Role role : sectionRole.getParentRoles()) {
                accounts.addAll(role.getAccounts());
                for (GroupIdent group : role.getGroups()) {
                    accounts.addAll(group.getAccounts());
                }
            }
            sectionRole.replaceRelations(new ArrayList(0), Role.class, "parentSectionRoles");
        }
        this.entityManager.flush();
        this.entityManager.refresh((Object)sectionRole);
    }

    @Override
    @Business(viewType="both")
    public boolean setGroupsByRoleId(long roleId, long[] groupIds) {
        HashMap<String, String[]> oldAccountPermissions = new HashMap<String, String[]>();
        HashMap<String, String[]> newAccountPermissions = new HashMap();
        HashMap<String, HashSet<Long>> oldUnitPermissions = new HashMap<String, HashSet<Long>>();
        HashMap<String, HashSet<Long>> newUnitPermissions = new HashMap();
        String[] affectedUserNames = this.roleAdminFacadeLocal._setGroupsByRoleIdInNewTx(roleId, groupIds, oldAccountPermissions, oldUnitPermissions);
        if (affectedUserNames == null || affectedUserNames.length == 0) {
            return true;
        }
        newAccountPermissions = this.getSectionRolesForUsers(affectedUserNames);
        newUnitPermissions = this.getUnitFacade().getAllUnitIdsForUsernames(affectedUserNames);
        List<String> affectedUsersByAirportmapRoleChanges = this.permissionUpdateToolsLocal.getAffectedUsersByRolesChanges(oldAccountPermissions, newAccountPermissions, affectedUserNames);
        List<String> affectedUsersByVisibleUnitChanges = this.permissionUpdateToolsLocal.getAffectedUsersByVisibleUnitChanges(oldUnitPermissions, newUnitPermissions, affectedUserNames);
        if (!affectedUsersByAirportmapRoleChanges.isEmpty()) {
            this.permissionUpdateNotifyLocal.sendRoleChangedJMSMessageByUserNames(affectedUsersByAirportmapRoleChanges);
        }
        if (!affectedUsersByVisibleUnitChanges.isEmpty()) {
            this.permissionUpdateNotifyLocal.sendPermissionChangedJMSMessageByUserNames(affectedUsersByVisibleUnitChanges);
        }
        return true;
    }

    @Override
    @Business(viewType="both")
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public String[] _setGroupsByRoleIdInNewTx(long roleId, long[] groupIds, Map<String, String[]> oldAccountPermissions, Map<String, HashSet<Long>> oldUnitPermissions) {
        List<Account> newAccounts = this.userGroupAdminFacade.getAccountsByGroupIDs(groupIds);
        List<Account> currentAccounts = this.getAccountsInRoleAndGroupsByRoleID(roleId);
        String[] affectedUserNames = this.permissionUpdateToolsLocal.getDifferentUsersByAccountValueList(currentAccounts, newAccounts);
        Map<String, String[]> tmpOldAccountPermissions = this.getSectionRolesForUsers(affectedUserNames);
        oldAccountPermissions.putAll(tmpOldAccountPermissions);
        Map<String, HashSet<Long>> tmpOldUnitPermissions = this.getUnitFacade().getAllUnitIdsForUsernames(affectedUserNames);
        oldUnitPermissions.putAll(tmpOldUnitPermissions);
        GroupIdent groupIdent2 = null;
        ArrayList<Long> newGroupIDs = new ArrayList<Long>();
        Role role = (Role)this.roleDAO.findByPrimaryKey(roleId);
        ArrayList<GroupIdent> newGroups = new ArrayList<GroupIdent>();
        ArrayList<String> newAssignment = new ArrayList<String>();
        for (long groupId : groupIds) {
            groupIdent2 = (GroupIdent)this.groupIdentDAO.findByPrimaryKey(groupId);
            newGroups.add(groupIdent2);
            newGroupIDs.add(groupId);
            newAssignment.add(groupIdent2.getGroupName());
        }
        List<GroupIdent> oldGroups = role.getGroups();
        ArrayList<Long> oldGroupIDs = new ArrayList<Long>();
        ArrayList<String> oldAssignment = new ArrayList<String>();
        for (GroupIdent groupIdent2 : oldGroups) {
            oldAssignment.add(groupIdent2.getGroupName());
            oldGroupIDs.add(groupIdent2.getId());
        }
        Collections.sort(oldAssignment);
        Collections.sort(newAssignment);
        if (((Object)oldAssignment).toString().equals(((Object)newAssignment).toString())) {
            return new String[0];
        }
        role.replaceRelations(newGroups, GroupIdent.class);
        this.entityManager.flush();
        this.entityManager.refresh((Object)role);
        return affectedUserNames;
    }

    @Override
    @Business(viewType="both")
    public SectionRoleNode getSectionRolesTreeByGroupId(long groupId, String sectionIdentifier) {
        if (groupId == 0L) {
            return this.getSectionRoleNodeTree(sectionIdentifier);
        }
        List<Role> userRoles = this.getRolesByGroupId(groupId);
        ArrayList<Role> directRoles = new ArrayList<Role>();
        ArrayList<Role> roleRoles = new ArrayList<Role>();
        this.splitRoles(userRoles, directRoles, roleRoles, sectionIdentifier);
        return this.getSectionRolesTreeByRoles(sectionIdentifier, directRoles, null, roleRoles);
    }

    @Override
    @Business(viewType="both")
    public SectionRoleNode getSectionRolesTreeByUserId(long userId, String sectionIdentifier) {
        if (userId == 0L) {
            return this.getSectionRoleNodeTree(sectionIdentifier);
        }
        ArrayList<Role> groupRoles = new ArrayList<Role>();
        List<GroupIdent> memberGroups = this.userGroupAdminFacade.getGroupsByUserId(userId);
        for (int i = 0; i != memberGroups.size(); ++i) {
            List<Role> currentRoles = this.getRolesByGroupId(memberGroups.get(i).getId());
            for (int j = 0; j != currentRoles.size(); ++j) {
                groupRoles.addAll(this.getRolesByRoleId(currentRoles.get(j).getId()));
            }
            groupRoles.addAll(currentRoles);
        }
        List<Role> userRoles = this.getRolesByUserId(userId);
        ArrayList<Role> directRoles = new ArrayList<Role>();
        ArrayList<Role> roleRoles = new ArrayList<Role>();
        this.splitRoles(userRoles, directRoles, roleRoles, sectionIdentifier);
        return this.getSectionRolesTreeByRoles(sectionIdentifier, directRoles, groupRoles, roleRoles);
    }

    private void splitRoles(List<Role> allRoles, List<Role> directRoles, List<Role> roleRoles, String sectionIdentifier) {
        directRoles.clear();
        roleRoles.clear();
        for (int i = 0; i != allRoles.size(); ++i) {
            Role currentRole = allRoles.get(i);
            if (currentRole.getRoleName().startsWith(sectionIdentifier)) {
                directRoles.add(currentRole);
                continue;
            }
            List<Role> sectionRoles = this.getRolesByRoleId(currentRole.getId());
            for (int j = 0; j != sectionRoles.size(); ++j) {
                roleRoles.add(sectionRoles.get(j));
            }
        }
    }

    @Override
    @Business(viewType="both")
    public SectionRoleNode getSectionRolesTreeByRoleId(long roleId, String sectionIdentifier) {
        if (roleId == 0L) {
            return this.getSectionRoleNodeTree(sectionIdentifier);
        }
        return this.getSectionRolesTreeByRoles(sectionIdentifier, this.getRolesByRoleId(roleId), null, null);
    }

    @Override
    @Business(viewType="both")
    public SectionRoleNode getSectionRolesTreeByRoles(String sectionIdentifier, List<Role> userRoles, List<Role> groupRoles, List<Role> roleRoles) {
        SectionRoleNode root = this.getSectionRoleNodeTree(sectionIdentifier);
        if (groupRoles != null) {
            root.setGroupSelectionsByRole(groupRoles, false, true);
        }
        if (roleRoles != null) {
            root.setRoleSelectionsByRole(roleRoles, false, true);
        }
        if (userRoles != null) {
            root.setUserSelectionsByRole(userRoles, false, true);
        }
        return root;
    }

    @Override
    @Business(viewType="both")
    public List<Account> getAccountsbyRoleID(long roleID) {
        Role roleLocal = (Role)this.roleDAO.findByPrimaryKey(roleID);
        return roleLocal.getAccounts();
    }

    @Override
    @Business(viewType="both")
    public List<Role> getAllRolesForUser(String username) {
        MasterDataFastLaneReader masterDataFastLaneReader = new MasterDataFastLaneReader();
        List<Role> roles = masterDataFastLaneReader.getAllRolesForUser(username);
        return roles;
    }

    @Override
    @Business(viewType="both")
    public void sychronizeSectionRolesWithWebConfigFile(Collection<Role> rolesFromConfig) {
        HashMap<String, Role> roleMapDB = new HashMap<String, Role>();
        List<Role> existingRolesFromDB = this.getSectionRoles();
        for (Role value : existingRolesFromDB) {
            roleMapDB.put(value.getRoleName(), value);
        }
        HashMap<String, Role> roleMapConfig = new HashMap<String, Role>();
        for (Role value : rolesFromConfig) {
            if (!value.getRoleName().startsWith(RESOURCE_ENTRY_FOR_SECTIONROLES)) continue;
            roleMapConfig.put(value.getRoleName(), value);
        }
        rolesFromConfig = roleMapConfig.values();
        for (Role roleFromConfig : rolesFromConfig) {
            if (roleMapDB.get(roleFromConfig.getRoleName()) != null) continue;
            this.roleDAO.createEntity(roleFromConfig);
        }
        for (Role roleFromDB : existingRolesFromDB) {
            if (roleMapConfig.get(roleFromDB.getRoleName()) != null) continue;
            this.roleDAO.removeEntity(roleFromDB);
        }
    }

    @Override
    @Business(viewType="both")
    public List<Role> getSectionRoles() {
        List<Role> allRoles = this.getRoles();
        ArrayList<Role> sectionRoles = new ArrayList<Role>();
        for (Role value : allRoles) {
            if (!value.getRoleName().startsWith(RESOURCE_ENTRY_FOR_SECTIONROLES)) continue;
            sectionRoles.add(value);
        }
        return sectionRoles;
    }
}

