/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataOut.replay;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.wwt.datamodel.area.Area;
import de.proveo.wwt.datamodel.unit.identity.UnitIdentity;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.datamodel.unit.typeIdentity.UnitTypeIdentity;
import de.proveo.wwt.logic.app.util.Stopwatch;
import de.proveo.wwt.logic.ejb.dataOut.mapclient.MapClientFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.replay.ReplayDataFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.replay.ReplayDataFacadeRemote;
import de.proveo.wwt.logic.ejb.general.area.AreaInFacadeLocal;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocal;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.data.fastlanereader.base.ReplayFastLaneBase;
import de.proveo.wwt.logic.web.data.fastlanereader.replay.FisReplayFastLaneReader;
import de.proveo.wwt.logic.web.data.fastlanereader.replay.GdataReplayFastLaneReader;
import de.proveo.wwt.logic.web.data.fastlanereader.replay.KeepAliveReplayFastLaneReader;
import de.proveo.wwt.logic.web.data.fastlanereader.replay.MeasurementReplayFastLaneReader;
import de.proveo.wwt.logic.web.data.fastlanereader.replay.NotificationReplayFastLaneReader;
import de.proveo.wwt.logic.web.data.fastlanereader.replay.ScanmanMessageReplayFastLaneReader;
import de.proveo.wwt.logic.web.data.fastlanereader.replay.StateReplayFastLaneReader;
import de.proveo.wwt.logic.web.data.fastlanereader.replay.UseReplayFastLaneReader;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.UnitTreeFacadeLocal;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.dto.UnitTreeNode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.PostConstruct;
import javax.ejb.CreateException;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Stateless(name="ReplayDataFacade")
@Remote(value={ReplayDataFacadeRemote.class})
@Local(value={ReplayDataFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/ReplayDataFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/ReplayDataFacade")
public class ReplayDataFacadeBean
implements ReplayDataFacadeLocal,
ReplayDataFacadeRemote {
    private static final long serialVersionUID = -981298534634801580L;
    private static final Log log = LogFactory.getLog(ReplayDataFacadeBean.class);
    @EJB
    private ConfigurationLocal configurationLocal = null;
    @EJB
    private UnitFacadeLocal unitFacade = null;
    @EJB
    private MapClientFacadeLocal mapClientFacade = null;
    @EJB
    private UnitTreeFacadeLocal unitTreeFacade = null;
    @EJB
    private AreaInFacadeLocal areaInFacadeBean = null;
    private GdataReplayFastLaneReader gDataFastLane;
    private StateReplayFastLaneReader stateFastLane;
    private MeasurementReplayFastLaneReader measurementFastLane;
    private KeepAliveReplayFastLaneReader keepAliveFastLane;
    private NotificationReplayFastLaneReader notificationFastLaneReader;
    private UseReplayFastLaneReader useFastLaneReader;
    private ScanmanMessageReplayFastLaneReader scanmanMessageFastLaneReader;
    private FisReplayFastLaneReader fisFastLaneReader;

    @PostConstruct
    public void ejbCreate() throws CreateException {
        this.gDataFastLane = new GdataReplayFastLaneReader();
        this.stateFastLane = new StateReplayFastLaneReader();
        this.measurementFastLane = new MeasurementReplayFastLaneReader();
        this.keepAliveFastLane = new KeepAliveReplayFastLaneReader();
        this.notificationFastLaneReader = new NotificationReplayFastLaneReader();
        this.useFastLaneReader = new UseReplayFastLaneReader();
        this.scanmanMessageFastLaneReader = new ScanmanMessageReplayFastLaneReader();
        this.fisFastLaneReader = new FisReplayFastLaneReader();
    }

    private HashMap<Long, HashMap> getUnitIdentities(long unitGroupId, HashSet<Long> unitPermissions) {
        long unitId;
        String method = "getUnitIdentities(): ";
        HashMap<Long, HashMap> unitIdents = new HashMap<Long, HashMap>();
        if (unitGroupId > -1L) {
            UnitTreeNode unitGroupNode = null;
            try {
                UnitTreeNode unitTree = this.unitTreeFacade.getAirportMapTreeModel(unitPermissions);
                if (unitTree != null) {
                    unitGroupNode = this.findUnitGroupNode((UnitTreeNode)unitTree.getRoot(), unitGroupId);
                }
            }
            catch (Exception ex) {
                log.error((Object)"getAirportMapTreeModel() runs into", (Throwable)ex);
            }
            if (unitGroupNode != null) {
                HashSet<Long> tmpUnitPermissions = new HashSet<Long>(unitPermissions);
                for (Long next : unitPermissions) {
                    unitId = Long.valueOf(((Object)next).toString());
                    if (this.isUnitIdInGroup(unitGroupNode, unitId)) continue;
                    tmpUnitPermissions.remove(next);
                }
                unitPermissions.clear();
                unitPermissions.addAll(tmpUnitPermissions);
            }
        }
        List<UnitIdentity> colUnitIdentity = null;
        try {
            colUnitIdentity = this.unitFacade.findAllUnitIdentity();
        }
        catch (Exception ex) {
            log.error((Object)(method + "runs into"), (Throwable)ex);
        }
        if (colUnitIdentity != null && colUnitIdentity.size() > 0) {
            for (UnitIdentity local : colUnitIdentity) {
                UnitModel unitModelValue;
                UnitIdentity value;
                if (local == null || (value = local) == null || !unitPermissions.contains(value.getUnitId())) continue;
                unitId = value.getUnitId();
                boolean airportMapVisible = false;
                boolean basicUnit = true;
                UnitModel unitModelLocal = local.getUnitModel();
                if (unitModelLocal != null && (unitModelValue = unitModelLocal) != null) {
                    airportMapVisible = unitModelLocal.getAirportmapVisible();
                    basicUnit = unitModelValue.getBasic();
                }
                if (!airportMapVisible || !basicUnit) {
                    unitPermissions.remove(unitId);
                    continue;
                }
                String unitTypeName = null;
                String unitSymbolName = null;
                UnitTypeIdentity unitTypeIdentityValue = null;
                try {
                    unitTypeIdentityValue = this.unitFacade.getUnitDTO(unitId).getUnitTypeIdentity();
                }
                catch (Throwable ex) {
                    log.error((Object)(method + "Could not get unitType for unit " + unitId), ex);
                }
                if (unitTypeIdentityValue != null) {
                    String tmp = unitTypeIdentityValue.getImageType().getName();
                    if (tmp != null && tmp.trim().length() > 0) {
                        unitSymbolName = tmp;
                    }
                    if ((tmp = unitTypeIdentityValue.getName()) != null && tmp.trim().length() > 0) {
                        unitTypeName = tmp;
                    }
                }
                HashMap<String, String> values = new HashMap<String, String>();
                values.put("UnitName", value.getName());
                values.put("UnitType", unitTypeName);
                values.put("UnitKind", unitSymbolName);
                unitIdents.put(unitId, values);
            }
        }
        return unitIdents;
    }

    private HashMap<Integer, Map<String, String>> getAreas(long unitGroupId) {
        String method = "getAreas(): ";
        List<Area> colArea = null;
        HashMap<Integer, Map<String, String>> areas = new HashMap<Integer, Map<String, String>>();
        try {
            if (unitGroupId != -1L) {
                colArea = this.areaInFacadeBean.findOrderedByPriorityByAirport(unitGroupId);
            }
            if (colArea == null || colArea.size() <= 0) {
                colArea = this.areaInFacadeBean.findOrderedByPriority();
            }
        }
        catch (Exception ex) {
            log.error((Object)(method + "runs into"), (Throwable)ex);
        }
        if (colArea != null && colArea.size() > 0) {
            for (Area value : colArea) {
                if (value == null) continue;
                HashMap<String, String> values = new HashMap<String, String>();
                values.put("Area", value.getArea());
                values.put("AreaName", value.getDescription());
                areas.put(value.getAreaId(), values);
            }
        }
        return areas;
    }

    private HashMap<Long, HashMap> getInitialGdataHistory(HashSet<Long> unitPermissions, TreeMap<Long, HashMap> replayDataMap, TreeMap<Long, HashMap> tmpGeoReplayMap, long fromTime) {
        HashMap<Long, HashMap> gdataInitialHistoryMap = new HashMap<Long, HashMap>();
        TreeMap<Long, HashMap> clonedTmpGeoReplayMap = new TreeMap<Long, HashMap>((SortedMap<Long, HashMap>)tmpGeoReplayMap);
        Object[] geoBeginTimes = clonedTmpGeoReplayMap.keySet().toArray();
        int geoBeginTimesLength = geoBeginTimes.length;
        for (int i = 0; i < geoBeginTimesLength; ++i) {
            long beginTime = (Long)geoBeginTimes[i];
            HashMap event = clonedTmpGeoReplayMap.get(beginTime);
            long unitId = (Long)event.get("UnitId");
            if (!unitPermissions.contains(unitId)) {
                replayDataMap.remove(beginTime);
                tmpGeoReplayMap.remove(beginTime);
                continue;
            }
            if (beginTime > fromTime || gdataInitialHistoryMap.containsKey(unitId)) continue;
            gdataInitialHistoryMap.put(unitId, replayDataMap.remove(beginTime));
        }
        return gdataInitialHistoryMap;
    }

    private HashMap<Long, HashMap<Long, HashMap>> getInitialStateHistory(HashSet<Long> unitPermissions, TreeMap<Long, HashMap> replayDataMap, TreeMap<Long, HashMap> tmpStateReplayMap, long fromTime) {
        HashMap<Long, HashMap<Long, HashMap>> stateInitialHistoryMap = new HashMap<Long, HashMap<Long, HashMap>>();
        TreeMap<Long, HashMap> clonedTmpStateReplayMap = new TreeMap<Long, HashMap>((SortedMap<Long, HashMap>)tmpStateReplayMap);
        Object[] stateBeginTimes = clonedTmpStateReplayMap.keySet().toArray();
        int stateBeginTimesLength = stateBeginTimes.length;
        for (int i = 0; i < stateBeginTimesLength; ++i) {
            HashMap stateModelMap;
            long currentBeginTime;
            HashMap<Object, Object> stateMap;
            long beginTime = (Long)stateBeginTimes[i];
            HashMap event = clonedTmpStateReplayMap.get(beginTime);
            long unitId = (Long)event.get("UnitId");
            long stateModelId = (Long)event.get("StateModelID");
            if (!unitPermissions.contains(unitId)) {
                replayDataMap.remove(beginTime);
                tmpStateReplayMap.remove(beginTime);
                continue;
            }
            if (beginTime > fromTime) continue;
            if (!stateInitialHistoryMap.containsKey(unitId)) {
                stateMap = new HashMap<Long, HashMap>();
                stateMap.put(stateModelId, replayDataMap.remove(beginTime));
                stateInitialHistoryMap.put(unitId, stateMap);
                continue;
            }
            stateMap = stateInitialHistoryMap.get(unitId);
            if (stateMap.containsKey(stateModelId) && (currentBeginTime = ((Long)(stateModelMap = (HashMap)stateMap.get(stateModelId)).get("ServerTime")).longValue()) > beginTime) continue;
            stateMap.put(stateModelId, replayDataMap.remove(beginTime));
            stateInitialHistoryMap.put(unitId, stateMap);
        }
        return stateInitialHistoryMap;
    }

    @Override
    @Business(viewType="both")
    public HashMap<String, Map> getReplayData(long unitGroupId, long fromTime, long toTime, String username, boolean admin, boolean superAdmin, boolean sendUnitsData, boolean sendNotifiesData, boolean sendUseMsgsData, boolean sendInfomanMsgsData, boolean sendStandsData) {
        Stopwatch stopwatch = new Stopwatch(ReplayDataFacadeBean.class, "getReplayData");
        stopwatch.start("Overall");
        String method = "getReplayData(): ";
        int maximumNotifiesPerDay = 0;
        if (this.configurationLocal.isConfigured("observable.notifies.maximumPerUnitPerDay")) {
            try {
                maximumNotifiesPerDay = this.configurationLocal.getInteger("observable.notifies.maximumPerUnitPerDay");
            }
            catch (Throwable ex) {
                log.error((Object)(method + "Could not get property \"observable.notifies.maximumPerUnitPerDay\""), ex);
            }
        }
        if (!sendUnitsData) {
            if (sendNotifiesData) {
                log.warn((Object)(method + "Missing selector for units: can not send notifies without units data!"));
            }
            if (sendUseMsgsData) {
                log.warn((Object)(method + "Missing selector for units: can not send use messages without units data!"));
            }
            if (sendInfomanMsgsData) {
                log.warn((Object)(method + "Missing selector for units: can not send Infoman messages without units data!"));
            }
        }
        long serverInfomanKeepaliveTimeout = 180L;
        try {
            serverInfomanKeepaliveTimeout = Long.valueOf(this.configurationLocal.getParameter("infoman.keepalive.timeout", "300"));
        }
        catch (Throwable ex) {
            serverInfomanKeepaliveTimeout = 180L;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(method + "start."));
        }
        HashMap<String, Map> completeMap = new HashMap<String, Map>();
        int initialUnitsDataSize = 0;
        HashMap initialUnitsCollector = new HashMap();
        TreeMap<Long, HashMap> replayDataMap = new TreeMap<Long, HashMap>();
        if (sendUnitsData) {
            HashSet<Long> unitPermissions = this.mapClientFacade.getUnitPermissions(username, superAdmin, unitGroupId);
            HashMap<Long, HashMap> unitIdents = this.getUnitIdentities(unitGroupId, unitPermissions);
            if (unitIdents.size() > 0) {
                initialUnitsCollector.put("unitIdentityValues", unitIdents);
                HashMap<Integer, Map<String, String>> areas = this.getAreas(unitGroupId);
                initialUnitsCollector.put("areaValues", areas);
                HashMap<Long, HashMap> gdataInitialCacheMap = this.gDataFastLane.getCacheInitialForReplay(unitPermissions, fromTime);
                HashMap<Long, HashMap<Long, HashMap>> stateInitialCacheMap = this.stateFastLane.getCacheInitialForReplay(unitPermissions, fromTime);
                TreeMap<Long, HashMap> tmpGeoReplayMap = this.gDataFastLane.getReplayData(unitPermissions, replayDataMap, fromTime, toTime, ReplayFastLaneBase.DataType.HISTORY);
                HashMap<Long, HashMap> gdataInitialHistoryMap = this.getInitialGdataHistory(unitPermissions, replayDataMap, tmpGeoReplayMap, fromTime);
                TreeMap<Long, HashMap> tmpStateReplayMap = this.stateFastLane.getReplayData(unitPermissions, replayDataMap, fromTime, toTime, ReplayFastLaneBase.DataType.HISTORY);
                HashMap<Long, HashMap<Long, HashMap>> stateInitialHistoryMap = this.getInitialStateHistory(unitPermissions, replayDataMap, tmpStateReplayMap, fromTime);
                TreeMap<Long, HashMap> geoCacheReplayMap = this.gDataFastLane.getReplayData(unitPermissions, replayDataMap, fromTime, toTime, ReplayFastLaneBase.DataType.CACHE);
                TreeMap<Long, HashMap> stateCacheReplayMap = this.stateFastLane.getReplayData(unitPermissions, replayDataMap, fromTime, toTime, ReplayFastLaneBase.DataType.CACHE);
                TreeMap<Long, HashMap> keepAliveCacheReplayMap = this.keepAliveFastLane.getReplayData(unitPermissions, replayDataMap, fromTime, toTime, ReplayFastLaneBase.DataType.CACHE);
                TreeMap<Long, HashMap> keepAliveHistoryReplayMap = this.keepAliveFastLane.getReplayData(unitPermissions, replayDataMap, fromTime, toTime, ReplayFastLaneBase.DataType.HISTORY);
                HashMap<Long, HashMap> keepAliveCacheInitMap = this.keepAliveFastLane.getCacheInitialForReplay(unitPermissions, fromTime);
                HashSet<Long> keepAliveHistoryUnitIds = new HashSet<Long>(unitPermissions);
                keepAliveHistoryUnitIds.removeAll(keepAliveCacheInitMap.keySet());
                HashMap<Long, HashMap> keepAliveHistoryInitMap = this.keepAliveFastLane.getHistoryInitialForReplay(keepAliveHistoryUnitIds, fromTime, serverInfomanKeepaliveTimeout);
                TreeMap<Long, HashMap> measurementHistoryMap = this.measurementFastLane.getReplayDataHistory(unitPermissions, replayDataMap, fromTime, toTime);
                HashMap<Long, HashMap<Integer, HashMap>> measurementInitialMap = this.measurementFastLane.getReplayDataInitial(unitPermissions, fromTime);
                TreeMap<Long, HashMap> notifyCacheReplayMap = null;
                TreeMap<Long, HashMap> notifyHistoryReplayMap = null;
                HashMap<Long, TreeMap> notifyInitMap = null;
                if (sendNotifiesData) {
                    notifyCacheReplayMap = this.notificationFastLaneReader.getReplayData(unitPermissions, replayDataMap, fromTime, toTime, ReplayFastLaneBase.DataType.CACHE);
                    notifyHistoryReplayMap = this.notificationFastLaneReader.getReplayData(unitPermissions, replayDataMap, fromTime, toTime, ReplayFastLaneBase.DataType.HISTORY);
                    notifyInitMap = this.notificationFastLaneReader.getCacheInitialForReplay(unitPermissions, fromTime, maximumNotifiesPerDay);
                    notifyInitMap = this.notificationFastLaneReader.getHistoryInitialForReplay(unitPermissions, fromTime, notifyInitMap, maximumNotifiesPerDay);
                }
                TreeMap<Long, HashMap> useCacheReplayMap = null;
                TreeMap<Long, HashMap> useHistoryReplayMap = null;
                HashMap<Long, HashMap> useCacheInitMap = null;
                HashMap<Long, HashMap> useHistoryInitMap = null;
                if (sendUseMsgsData) {
                    useCacheReplayMap = this.useFastLaneReader.getReplayData(unitPermissions, replayDataMap, fromTime, toTime, ReplayFastLaneBase.DataType.CACHE);
                    useHistoryReplayMap = this.useFastLaneReader.getReplayData(unitPermissions, replayDataMap, fromTime, toTime, ReplayFastLaneBase.DataType.HISTORY);
                    useCacheInitMap = this.useFastLaneReader.getCacheInitialForReplay(unitPermissions, fromTime);
                    useHistoryInitMap = this.useFastLaneReader.getHistoryInitialForReplay(unitPermissions, fromTime);
                }
                TreeMap<Long, HashMap> infomanMsgCacheReplayMap = null;
                TreeMap<Long, HashMap> infomanMsgHistoryReplayMap = null;
                HashMap infomanMsgCacheInitMap = null;
                HashMap infomanMsgHistoryInitMap = null;
                if (sendInfomanMsgsData) {
                    infomanMsgCacheReplayMap = this.scanmanMessageFastLaneReader.getReplayData(unitPermissions, replayDataMap, fromTime, toTime, ReplayFastLaneBase.DataType.CACHE);
                    infomanMsgHistoryReplayMap = this.scanmanMessageFastLaneReader.getReplayData(unitPermissions, replayDataMap, fromTime, toTime, ReplayFastLaneBase.DataType.HISTORY);
                    HashMap<Long, HashMap> infomanMsgErrorCacheInitMap = this.scanmanMessageFastLaneReader.getCacheInitialErrorMsgForReplay(unitPermissions, fromTime);
                    HashMap<Long, HashMap> infomanMsgIPCacheInitMap = this.scanmanMessageFastLaneReader.getCacheInitialIPMsgForReplay(unitPermissions, fromTime);
                    HashMap<Long, HashMap> infomanMsgBootCacheInitMap = this.scanmanMessageFastLaneReader.getCacheInitialBootMsgForReplay(unitPermissions, fromTime);
                    HashSet<Long> everyMsgFoundInCache = new HashSet<Long>();
                    HashSet<Long> infomanErrorMsgCacheUnitIds = new HashSet<Long>();
                    HashSet<Long> infomanIPMsgCacheUnitIds = new HashSet<Long>();
                    HashSet<Long> infomanBootMsgCacheUnitIds = new HashSet<Long>();
                    infomanMsgCacheInitMap = new HashMap();
                    for (long unitId : unitPermissions) {
                        HashMap completeValueMap = new HashMap();
                        HashMap errorValueMap = infomanMsgErrorCacheInitMap.get(unitId);
                        HashMap ipValueMap = infomanMsgIPCacheInitMap.get(unitId);
                        HashMap bootValueMap = infomanMsgBootCacheInitMap.get(unitId);
                        boolean add = false;
                        boolean foundEverything = false;
                        if (errorValueMap != null && errorValueMap.size() > 0) {
                            completeValueMap.putAll(errorValueMap);
                            infomanErrorMsgCacheUnitIds.add(unitId);
                            add = true;
                            foundEverything = true;
                        }
                        if (ipValueMap != null && ipValueMap.size() > 0) {
                            completeValueMap.putAll(ipValueMap);
                            infomanIPMsgCacheUnitIds.add(unitId);
                            add = true;
                        } else {
                            foundEverything = false;
                        }
                        if (bootValueMap != null && bootValueMap.size() > 0) {
                            completeValueMap.putAll(bootValueMap);
                            infomanBootMsgCacheUnitIds.add(unitId);
                            add = true;
                        } else {
                            foundEverything = false;
                        }
                        if (!add) continue;
                        infomanMsgCacheInitMap.put(unitId, completeValueMap);
                        if (!foundEverything) continue;
                        everyMsgFoundInCache.add(unitId);
                    }
                    HashSet<Long> infomanMsgHistoryUnitIds = new HashSet<Long>(unitPermissions);
                    infomanMsgHistoryUnitIds.removeAll(everyMsgFoundInCache);
                    HashSet<Long> infomanMsgErrorHistoryUnitIds = new HashSet<Long>(infomanMsgHistoryUnitIds);
                    infomanMsgErrorHistoryUnitIds.removeAll(infomanErrorMsgCacheUnitIds);
                    HashSet<Long> infomanMsgIPHistoryUnitIds = new HashSet<Long>(infomanMsgHistoryUnitIds);
                    infomanMsgIPHistoryUnitIds.removeAll(infomanIPMsgCacheUnitIds);
                    HashSet<Long> infomanMsgBootHistoryUnitIds = new HashSet<Long>(infomanMsgHistoryUnitIds);
                    infomanMsgBootHistoryUnitIds.removeAll(infomanBootMsgCacheUnitIds);
                    HashMap<Long, HashMap> infomanMsgErrorHistoryInitMap = this.scanmanMessageFastLaneReader.getHistoryInitialErrorMsgForReplay(infomanMsgErrorHistoryUnitIds, fromTime, serverInfomanKeepaliveTimeout);
                    HashMap<Long, HashMap> infomanMsgIPHistoryInitMap = this.scanmanMessageFastLaneReader.getHistoryInitialIPMsgForReplay(infomanMsgIPHistoryUnitIds, fromTime, serverInfomanKeepaliveTimeout);
                    HashMap<Long, HashMap> infomanMsgBootHistoryInitMap = this.scanmanMessageFastLaneReader.getHistoryInitialBootMsgForReplay(infomanMsgBootHistoryUnitIds, fromTime, serverInfomanKeepaliveTimeout);
                    HashSet<Long> historyUnitIds = new HashSet<Long>();
                    historyUnitIds.addAll(infomanMsgErrorHistoryInitMap.keySet());
                    historyUnitIds.addAll(infomanMsgIPHistoryInitMap.keySet());
                    historyUnitIds.addAll(infomanMsgBootHistoryInitMap.keySet());
                    infomanMsgHistoryInitMap = new HashMap();
                    for (long unitId : historyUnitIds) {
                        HashMap completeValueMap = new HashMap();
                        HashMap errorValueMap = infomanMsgErrorHistoryInitMap.get(unitId);
                        HashMap ipValueMap = infomanMsgIPHistoryInitMap.get(unitId);
                        HashMap bootValueMap = infomanMsgBootHistoryInitMap.get(unitId);
                        if (errorValueMap != null) {
                            completeValueMap.putAll(errorValueMap);
                        }
                        if (ipValueMap != null) {
                            completeValueMap.putAll(ipValueMap);
                        }
                        if (bootValueMap != null) {
                            completeValueMap.putAll(bootValueMap);
                        }
                        infomanMsgHistoryInitMap.put(unitId, completeValueMap);
                    }
                }
                if (log.isDebugEnabled()) {
                    if (unitGroupId > -1L) {
                        log.debug((Object)(method + "Replay data overview for airport id '" + unitGroupId + "':"));
                    }
                    initialUnitsDataSize = unitPermissions.size() + unitIdents.size() + areas.size() + gdataInitialCacheMap.size() + stateInitialCacheMap.size() + keepAliveCacheInitMap.size() + gdataInitialHistoryMap.size() + stateInitialHistoryMap.size() + measurementInitialMap.size() + keepAliveHistoryInitMap.size();
                    log.debug((Object)(method + "Collection size unitPermissions: " + unitPermissions.size()));
                    log.debug((Object)(method + "Collection size UnitIdentity: " + unitIdents.size()));
                    log.debug((Object)(method + "Collection size Area: " + areas.size()));
                    log.debug((Object)(method + "Size for initial GdataCache: " + gdataInitialCacheMap.size()));
                    log.debug((Object)(method + "Size for initial StateCache: " + stateInitialCacheMap.size()));
                    log.debug((Object)(method + "Size for initial KeepAliveCache: " + keepAliveCacheInitMap.size()));
                    log.debug((Object)(method + "Size for initial GdataHistory: " + gdataInitialHistoryMap.size()));
                    log.debug((Object)(method + "Size for initial StateHistory: " + stateInitialHistoryMap.size()));
                    log.debug((Object)(method + "Size for initial KeepAliveHistory: " + keepAliveHistoryInitMap.size()));
                    log.debug((Object)(method + "Size for initial Measurement Data: " + measurementInitialMap.size()));
                    if (sendNotifiesData) {
                        log.debug((Object)(method + "Size for initial Notify (cache and history): " + notifyInitMap.size()));
                        initialUnitsDataSize += notifyInitMap.size();
                    }
                    if (sendUseMsgsData) {
                        log.debug((Object)(method + "Size for initial UseCache: " + useCacheInitMap.size()));
                        log.debug((Object)(method + "Size for initial UseHistory: " + useHistoryInitMap.size()));
                        initialUnitsDataSize = initialUnitsDataSize + useCacheInitMap.size() + useHistoryInitMap.size();
                    }
                    if (sendInfomanMsgsData) {
                        log.debug((Object)(method + "Size for initial InfomanMsgCache: " + infomanMsgCacheInitMap.size()));
                        log.debug((Object)(method + "Size for initial InfomanMsgHistory: " + infomanMsgHistoryInitMap.size()));
                        initialUnitsDataSize = initialUnitsDataSize + infomanMsgCacheInitMap.size() + infomanMsgHistoryInitMap.size();
                    }
                    log.debug((Object)(method + "Size of complete initial units data: " + initialUnitsDataSize));
                    log.debug((Object)(method + "Size for replay data of GdataCache: " + geoCacheReplayMap.size()));
                    log.debug((Object)(method + "Size for replay data of StateCache: " + stateCacheReplayMap.size()));
                    log.debug((Object)(method + "Size for replay data of KeepAliveCache: " + keepAliveCacheReplayMap.size()));
                    log.debug((Object)(method + "Size for replay data of GdataHistory: " + tmpGeoReplayMap.size()));
                    log.debug((Object)(method + "Size for replay data of StateHistory: " + tmpStateReplayMap.size()));
                    log.debug((Object)(method + "Size for replay data of MeasurementHistory: " + measurementHistoryMap.size()));
                    log.debug((Object)(method + "Size for replay data of KeepAliveHistory: " + keepAliveHistoryReplayMap.size()));
                    if (sendNotifiesData) {
                        log.debug((Object)(method + "Size for replay data of NotifyCache: " + notifyCacheReplayMap.size()));
                        log.debug((Object)(method + "Size for replay data of NotifyHistory: " + notifyHistoryReplayMap.size()));
                    }
                    if (sendUseMsgsData) {
                        log.debug((Object)(method + "Size for replay data of UseCache: " + useCacheReplayMap.size()));
                        log.debug((Object)(method + "Size for replay data of UseHistory: " + useHistoryReplayMap.size()));
                    }
                    if (sendInfomanMsgsData) {
                        log.debug((Object)(method + "Size for replay data of InfomanMsgCache: " + infomanMsgCacheReplayMap.size()));
                        log.debug((Object)(method + "Size for replay data of InfomanMsgHistory: " + infomanMsgHistoryReplayMap.size()));
                    }
                }
                HashMap<Long, HashMap> gdataInitialMap = new HashMap<Long, HashMap>(gdataInitialCacheMap);
                gdataInitialMap.putAll(gdataInitialHistoryMap);
                HashMap<Long, HashMap<Long, HashMap>> stateInitialMap = new HashMap<Long, HashMap<Long, HashMap>>();
                for (long unitId : stateInitialCacheMap.keySet()) {
                    HashMap<Long, HashMap> statesCacheMap = stateInitialCacheMap.get(unitId);
                    HashMap<Long, HashMap> statesHistoryMap = stateInitialHistoryMap.remove(unitId);
                    if (statesHistoryMap != null) {
                        statesCacheMap.putAll(statesHistoryMap);
                    }
                    stateInitialMap.put(unitId, statesCacheMap);
                }
                stateInitialMap.putAll(stateInitialHistoryMap);
                HashMap<Long, HashMap> keepAliveInitMap = new HashMap<Long, HashMap>(keepAliveCacheInitMap);
                keepAliveInitMap.putAll(keepAliveHistoryInitMap);
                initialUnitsCollector.put("initGdata", gdataInitialMap);
                initialUnitsCollector.put("initState", stateInitialMap);
                initialUnitsCollector.put("initMeasurement", measurementInitialMap);
                initialUnitsCollector.put("initKeepAlive", keepAliveInitMap);
                if (sendNotifiesData) {
                    initialUnitsCollector.put("initNotify", notifyInitMap);
                }
                if (sendUseMsgsData) {
                    HashMap<Long, HashMap> useInitMap = new HashMap<Long, HashMap>(useCacheInitMap);
                    useInitMap.putAll(useHistoryInitMap);
                    initialUnitsCollector.put("initUse", useInitMap);
                }
                if (sendInfomanMsgsData) {
                    HashMap infomanMsgInitMap = new HashMap();
                    Iterator icIte = infomanMsgCacheInitMap.keySet().iterator();
                    while (icIte.hasNext()) {
                        long unitId = (Long)icIte.next();
                        HashMap infMsgCacheMap = (HashMap)infomanMsgCacheInitMap.get(unitId);
                        HashMap infMsgHistoryMap = (HashMap)infomanMsgHistoryInitMap.remove(unitId);
                        if (infMsgHistoryMap != null) {
                            infMsgCacheMap.putAll(infMsgHistoryMap);
                        }
                        infomanMsgInitMap.put(unitId, infMsgCacheMap);
                    }
                    infomanMsgInitMap.putAll(infomanMsgHistoryInitMap);
                    initialUnitsCollector.put("initInfomanMsg", infomanMsgInitMap);
                }
            } else {
                log.warn((Object)"User has no unit permissions! Replay for units not possible without unit permissions!");
            }
            completeMap.put("InitialContext", initialUnitsCollector);
        }
        int initialStandsDataSize = 0;
        if (sendStandsData) {
            TreeMap<Long, HashMap> tmpFisReplayMap = this.fisFastLaneReader.getReplayData(replayDataMap, fromTime, toTime);
            HashMap<String, HashMap> fisInitialHistoryMap = this.getInitialFisHistory(replayDataMap, tmpFisReplayMap, fromTime);
            completeMap.put("InitialStandsContext", fisInitialHistoryMap);
        }
        completeMap.put("ReplayData", replayDataMap);
        if (log.isDebugEnabled()) {
            if (sendUnitsData && sendStandsData) {
                log.debug((Object)(method + "Size of complete replay data (units and stands): " + replayDataMap.size()));
            } else if (sendUnitsData) {
                log.debug((Object)(method + "Size of complete unit replay data: " + replayDataMap.size()));
            } else if (sendStandsData) {
                log.debug((Object)(method + "Size of complete stands replay data: " + replayDataMap.size()));
            } else {
                log.debug((Object)(method + "Size of complete replay data: " + replayDataMap.size()));
            }
        }
        stopwatch.stop("Overall", true, initialStandsDataSize + initialUnitsDataSize + replayDataMap.size());
        return completeMap;
    }

    private HashMap<String, HashMap> getInitialFisHistory(TreeMap<Long, HashMap> replayDataMap, TreeMap<Long, HashMap> tmpFisReplayMap, long fromTime) {
        HashMap<String, HashMap> fisInitialHistoryMap = new HashMap<String, HashMap>();
        TreeMap<Long, HashMap> clonedTmpFisReplayMap = new TreeMap<Long, HashMap>((SortedMap<Long, HashMap>)tmpFisReplayMap);
        Object[] fisBeginTimes = clonedTmpFisReplayMap.keySet().toArray();
        int fisBeginTimesLength = fisBeginTimes.length;
        for (int i = 0; i < fisBeginTimesLength; ++i) {
            long beginTime = (Long)fisBeginTimes[i];
            HashMap event = clonedTmpFisReplayMap.get(beginTime);
            String standId = (String)event.get("fstd");
            if (beginTime > fromTime) continue;
            HashMap standMap = fisInitialHistoryMap.get(standId);
            if (standMap == null) {
                standMap = new HashMap();
            }
            standMap.putAll(replayDataMap.remove(beginTime));
            fisInitialHistoryMap.put(standId, standMap);
        }
        return fisInitialHistoryMap;
    }

    private UnitTreeNode findUnitGroupNode(UnitTreeNode unitNode, long unitGroupId) {
        List children;
        if (unitNode == null) {
            return null;
        }
        UnitTreeNode ret = null;
        UnitModel unitModelValue = ((UnitDTO)unitNode.getData()).getUnitModel();
        long unitId = unitModelValue.getUnitId();
        if (unitId == unitGroupId) {
            return unitNode;
        }
        if (unitNode.hasChildren() && (children = unitNode.getChildren()) != null) {
            for (UnitTreeNode childUnitNode : children) {
                ret = this.findUnitGroupNode(childUnitNode, unitGroupId);
                if (ret == null) continue;
                return ret;
            }
        }
        return ret;
    }

    private boolean isUnitIdInGroup(UnitTreeNode unitNode, long unitId) {
        List children;
        boolean ret = false;
        if (unitNode == null) {
            return ret;
        }
        UnitModel unitModelValue = ((UnitDTO)unitNode.getData()).getUnitModel();
        long thisUnitId = unitModelValue.getUnitId();
        if (thisUnitId == unitId) {
            ret = true;
            return ret;
        }
        if (!unitModelValue.getBasic() && (children = unitNode.getChildren()) != null) {
            for (UnitTreeNode childUnitNode : children) {
                ret = this.isUnitIdInGroup(childUnitNode, unitId);
                if (!ret) continue;
                return ret;
            }
        }
        return ret;
    }
}

