/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataOut.monitoring;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.wwt.datamodel.notify.NotifyCache;
import de.proveo.wwt.logic.ejb.dataIn.notify.NotifyFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.monitoring.MonitoringFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.monitoring.MonitoringFacadeRemote;
import de.proveo.wwt.logic.ejb.general.notification.NotificationAdministrationFacadeLocal;
import de.proveo.wwt.logic.ejb.keepalive.KeepAliveOutFacadeLocal;
import de.proveo.wwt.logic.ejb.keepalive.KeepAliveStamp;
import de.proveo.wwt.logic.ejb.state.CurrentStateFacadeLocal;
import de.proveo.wwt.logic.ejb.state.CurrentStateFacadeStruct;
import de.proveo.wwt.logic.ejb.state.exception.StatesForUnitNotFoundException;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.UnitTreeFacadeLocal;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.dto.UnitTreeNode;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.ejb.CreateException;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Stateless(name="MonitoringFacade")
@Remote(value={MonitoringFacadeRemote.class})
@Local(value={MonitoringFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/MonitoringFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/MonitoringFacade")
public class MonitoringFacadeBean
implements MonitoringFacadeLocal,
MonitoringFacadeRemote {
    private static final Log log = LogFactory.getLog(MonitoringFacadeBean.class);
    @EJB
    private CurrentStateFacadeLocal currentStateFacadeHome = null;
    @EJB
    private UnitTreeFacadeLocal unitTreeFacadeHome = null;
    @EJB
    private KeepAliveOutFacadeLocal keepAliveOutFacadeHome = null;
    @EJB
    private NotificationAdministrationFacadeLocal notificationAdminFacade = null;
    @EJB
    private NotifyFacadeLocal notifyFacadeLocal = null;

    @PostConstruct
    public void ejbCreate() throws CreateException {
        log.debug((Object)"ejbCreate()");
        this.init();
    }

    private void init() throws CreateException {
    }

    @Override
    @Business(viewType="both")
    public void doVoid() {
        log.debug((Object)"doVoid()");
    }

    @Override
    @Business(viewType="both")
    public Map<Integer, CurrentStateFacadeStruct> getCurrentUnitStates(long unitId) {
        Map<Integer, CurrentStateFacadeStruct> stateMap = null;
        try {
            stateMap = this.currentStateFacadeHome.getCurrentState(unitId);
        }
        catch (StatesForUnitNotFoundException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return stateMap;
    }

    @Override
    @Business(viewType="both")
    public int getNotifyCount(long unitId, long messageId, long since, long until) {
        int count = 0;
        count = this.notifyFacadeLocal.findHistoryCountByUnitIdNotifyId(unitId, messageId, since, until, true).size();
        return count;
    }

    @Override
    @Business(viewType="both")
    public NotifyCache getLastNotifyEntryFromCache(long unitId) {
        return this.notifyFacadeLocal.findLastCacheByUnitId(unitId);
    }

    @Override
    @Business(viewType="both")
    public long getLastKeepAliveTimestamp(long unitId) {
        long timestamp = 0L;
        long currentTime = System.currentTimeMillis();
        Set messages = this.keepAliveOutFacadeHome.getKeepAliveMessages(unitId, currentTime, currentTime);
        if (messages.size() > 1) {
            log.warn((Object)"more than one keep alive messages when asking for online data?");
        } else if (messages.size() < 1) {
            log.warn((Object)"no keep alive message for unit?");
        }
        Iterator iter = messages.iterator();
        if (iter.hasNext()) {
            KeepAliveStamp stamp = (KeepAliveStamp)iter.next();
            timestamp = stamp.getTimeStamp();
        }
        return timestamp;
    }

    @Override
    @Business(viewType="both")
    public long getAggregatedStateDuration(long unitId, long stateId, long beginTime, long endTime, int periodType) {
        long duration = 0L;
        return duration;
    }

    @Override
    @Business(viewType="both")
    public UnitTreeNode getUnitTreeDTO() {
        UnitTreeNode unitTreeDTO = null;
        unitTreeDTO = this.unitTreeFacadeHome.getTreeViewData(false, false, true);
        return unitTreeDTO;
    }

    @Override
    @Business(viewType="both")
    public String getNotifyRuleParameterValue(String key, String parameter) {
        return this.notificationAdminFacade.getNotifyRuleParameterValue(key, parameter);
    }
}

