/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataOut.audit;

import de.proveo.util.jpa.entity.EntityBase;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditAddOrRemoveInfo;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditUpdateInfo;
import java.util.HashMap;
import java.util.Map;

public class AuditInfo {
    private static final String EMPTY = "${empty}";
    public Map<String, AuditAddOrRemoveInfo> addedOrRemoved;
    public Map<String, AuditUpdateInfo> updated;
    public Map<String, String> direct;

    public AuditInfo() {
        this.addedOrRemoved = new HashMap<String, AuditAddOrRemoveInfo>();
        this.updated = new HashMap<String, AuditUpdateInfo>();
        this.direct = new HashMap<String, String>();
    }

    public AuditInfo(Map<String, AuditAddOrRemoveInfo> addedOrRemoved, Map<String, AuditUpdateInfo> updated, Map<String, String> direct) {
        this.addedOrRemoved = addedOrRemoved;
        this.updated = updated;
        this.direct = direct;
    }

    public boolean hasChanges() {
        boolean hasChanges = false;
        if (this.addedOrRemoved != null && this.addedOrRemoved.size() != 0) {
            hasChanges = true;
        }
        if (!hasChanges && this.updated != null && this.updated.size() != 0) {
            hasChanges = true;
        }
        if (!hasChanges && this.direct != null && this.direct.size() != 0) {
            hasChanges = true;
        }
        return hasChanges;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int updatedSize = this.updated.size();
        int addedSize = this.addedOrRemoved.size();
        int directSize = this.direct.size();
        if (updatedSize == 0 && addedSize == 0 && directSize == 0) {
            return null;
        }
        if (updatedSize != 0) {
            this.generateUpdatedString(sb);
        }
        if (addedSize != 0) {
            this.generateAddedOrRemovedString(sb);
        }
        if (directSize != 0) {
            this.generateDirectString(sb);
        }
        return sb.toString();
    }

    private void generateDirectString(StringBuilder sb) {
        for (Map.Entry<String, String> entry : this.direct.entrySet()) {
            sb.append("(");
            sb.append(entry.getKey());
            sb.append(": ");
            sb.append(entry.getValue().trim());
            sb.append("); ");
        }
    }

    private void generateUpdatedString(StringBuilder sb) {
        for (Map.Entry<String, AuditUpdateInfo> entry : this.updated.entrySet()) {
            sb.append(entry.getKey());
            AuditUpdateInfo info = entry.getValue();
            if (info.oldValue != null || info.newValue != null) {
                String value;
                sb.append(": ");
                if (info.oldValue != null) {
                    value = info.oldValue.toString();
                    if (value.length() == 0) {
                        value = EMPTY;
                    }
                    sb.append("-");
                    sb.append(value);
                }
                if (info.newValue != null) {
                    if (info.oldValue != null) {
                        sb.append(", ");
                    }
                    if ((value = info.newValue.toString()).length() == 0) {
                        value = EMPTY;
                    }
                    sb.append("+");
                    sb.append(value);
                }
            }
            sb.append("; ");
        }
    }

    private void generateAddedOrRemovedString(StringBuilder sb) {
        for (Map.Entry<String, AuditAddOrRemoveInfo> entry : this.addedOrRemoved.entrySet()) {
            sb.append(entry.getKey());
            sb.append(":");
            AuditAddOrRemoveInfo info = entry.getValue();
            boolean first = true;
            if (info.removed.size() != 0) {
                for (EntityBase entityBase : info.removed) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(",");
                    }
                    sb.append(" -");
                    sb.append(entityBase.toAuditString());
                }
            }
            if (info.added.size() == 0) continue;
            for (EntityBase entityBase : info.added) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(" +");
                sb.append(entityBase.toAuditString());
            }
        }
        sb.append("; ");
    }
}

