/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.scanmanmsg;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.wwt.datamodel.scanmanmsg.ScanmanMsgCache;
import de.proveo.wwt.datamodel.scanmanmsg.ScanmanMsgHistory;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.logic.ejb.dataIn.scanmanmsg.ScanmanMsgCacheDAO;
import de.proveo.wwt.logic.ejb.dataIn.scanmanmsg.ScanmanMsgFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.scanmanmsg.ScanmanMsgFacadeRemote;
import de.proveo.wwt.logic.ejb.dataIn.scanmanmsg.ScanmanMsgHistoryDAO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.ejb.EJBException;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Stateless(name="ScanmanMsgFacade")
@Remote(value={ScanmanMsgFacadeRemote.class})
@Local(value={ScanmanMsgFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/ScanmanMsgFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/ScanmanMsgFacade")
public class ScanmanMsgFacadeBean
implements ScanmanMsgFacadeLocal,
ScanmanMsgFacadeRemote {
    private static final transient Log log = LogFactory.getLog(ScanmanMsgFacadeBean.class);
    @PersistenceContext(unitName="rts")
    private EntityManager entityManager = null;
    private ScanmanMsgCacheDAO scanmanMsgCacheDAO;
    private ScanmanMsgHistoryDAO scanmanMsgHistoryDAO;

    @PostConstruct
    public void ejbCreate() {
        this.scanmanMsgCacheDAO = ScanmanMsgCacheDAO.newInstance(this.entityManager);
        this.scanmanMsgHistoryDAO = ScanmanMsgHistoryDAO.newInstance(this.entityManager);
    }

    @Override
    @Business(viewType="both")
    public void resetUnit(long unitId) {
        try {
            this.removeCacheEntries(unitId);
            List<ScanmanMsgHistory> historyEntries = this.scanmanMsgHistoryDAO.findByUnitId(unitId);
            for (ScanmanMsgHistory historyEntry : historyEntries) {
                this.scanmanMsgHistoryDAO.removeEntity(historyEntry);
            }
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
    }

    @Override
    @Business(viewType="both")
    public List<ScanmanMsgHistory> getMessages(long unitId, long since, long until) {
        try {
            List<ScanmanMsgHistory> result = this.getHistoryValueObjectsFromCache(this.scanmanMsgCacheDAO.findByUnitTime(unitId, since, until));
            result.addAll(this.scanmanMsgHistoryDAO.findByUnit(unitId, since, until));
            return result;
        }
        catch (Exception ex) {
            log.error((Object)"getMessages() runs into", (Throwable)ex);
            throw new EJBException(ex);
        }
    }

    @Override
    @Business(viewType="both")
    public List<ScanmanMsgHistory> getMessages(int type, long since, long until) {
        try {
            List<ScanmanMsgHistory> result = this.getHistoryValueObjectsFromCache(this.scanmanMsgCacheDAO.findByTypeTime(type, since, until));
            result.addAll(this.scanmanMsgHistoryDAO.findAllByTimeAndType(since, until, type));
            return result;
        }
        catch (Exception ex) {
            log.error((Object)"getMessages() runs into", (Throwable)ex);
            throw new EJBException(ex);
        }
    }

    @Override
    @Business(viewType="both")
    public List<ScanmanMsgHistory> getMessages(int type, long unitId, long since, long until) {
        try {
            List<ScanmanMsgHistory> result = this.getHistoryValueObjectsFromCache(this.scanmanMsgCacheDAO.findByUnitTypeTime(type, unitId, since, until));
            result.addAll(this.scanmanMsgHistoryDAO.findByTypeAndUnit(type, unitId, since, until));
            return result;
        }
        catch (Exception ex) {
            log.error((Object)"getMessages() runs into", (Throwable)ex);
            throw new EJBException(ex);
        }
    }

    @Override
    @Business(viewType="both")
    public ScanmanMsgHistory getLastMessage(int type, long unitId) {
        ScanmanMsgCache.PK cachePK = new ScanmanMsgCache.PK(unitId, type);
        ScanmanMsgCache cache = (ScanmanMsgCache)this.scanmanMsgCacheDAO.findByPrimaryKey(cachePK);
        if (cache == null) {
            return null;
        }
        return new ScanmanMsgHistory(cache);
    }

    protected ScanmanMsgCache getCacheValueFromHistory(ScanmanMsgHistory history) {
        ScanmanMsgCache cache = new ScanmanMsgCache();
        cache.setUnitId(history.getUnitId());
        cache.setType(history.getType());
        cache.setCreateTime(history.getCreateTime());
        cache.setMessage(history.getMessage());
        cache.setReceiveTime(history.getReceiveTime());
        return cache;
    }

    protected List<ScanmanMsgHistory> getHistoryValueObjectsFromCache(Collection<ScanmanMsgCache> entities) {
        ArrayList<ScanmanMsgHistory> valueObjects = new ArrayList<ScanmanMsgHistory>(entities.size());
        for (ScanmanMsgCache msgEntity : entities) {
            valueObjects.add(new ScanmanMsgHistory(msgEntity));
        }
        return valueObjects;
    }

    @Override
    @Business(viewType="both")
    public void deleteCache(UnitModel unitModel) {
        List<ScanmanMsgCache> cacheEntries = this.scanmanMsgCacheDAO.findByUnit(unitModel.getUnitId());
        for (ScanmanMsgCache cacheEntry : cacheEntries) {
            if (cacheEntry == null) continue;
            this.scanmanMsgCacheDAO.removeEntity(cacheEntry);
        }
    }

    @Override
    @Business(viewType="both")
    public Collection<ScanmanMsgCache> findCacheByTime(long beginTime, long endTime) {
        return this.scanmanMsgCacheDAO.findAllByTime(beginTime, endTime);
    }

    @Override
    @Business(viewType="both")
    public Collection<ScanmanMsgCache> findCacheByUnitGroupId(long unitGroupId, long beginTime, long endTime) {
        return this.scanmanMsgCacheDAO.findByUnitGroupId(unitGroupId, beginTime, endTime);
    }

    @Override
    @Business(viewType="both")
    public Collection<ScanmanMsgCache> findCacheByUnitTime(long unitId, long beginTime, long endTime) {
        return this.scanmanMsgCacheDAO.findByUnitTime(unitId, beginTime, endTime);
    }

    @Override
    @Business(viewType="both")
    public Collection<ScanmanMsgHistory> findHistoryByTime(long beginTime, long endTime) {
        return this.scanmanMsgHistoryDAO.findAllByTime(beginTime, endTime);
    }

    @Override
    @Business(viewType="both")
    public Collection<ScanmanMsgHistory> findHistoryByUnitGroupId(long unitGroupId, long beginTime, long endTime) {
        return this.scanmanMsgHistoryDAO.findByUnitGroupId(unitGroupId, beginTime, endTime);
    }

    @Override
    @Business(viewType="both")
    public Collection<ScanmanMsgHistory> findHistoryByUnitTime(long unitId, long beginTime, long endTime) {
        return this.scanmanMsgHistoryDAO.findByUnit(unitId, beginTime, endTime);
    }

    @Override
    @Business(viewType="both")
    public void removeCacheEntries(long unitId) {
        List<ScanmanMsgCache> cacheEntries = this.scanmanMsgCacheDAO.findByUnit(unitId);
        for (ScanmanMsgCache cacheEntry : cacheEntries) {
            this.scanmanMsgCacheDAO.removeEntity(cacheEntry);
        }
    }

    @Override
    @Business(viewType="both")
    public Collection<ScanmanMsgCache> findCacheByUnit(long unitId) {
        return this.scanmanMsgCacheDAO.findScanmanMsgCacheByUnit(unitId);
    }

    @Override
    @Business(viewType="both")
    public Collection<ScanmanMsgCache> findCacheByUnitGroup(long unitId) {
        return this.scanmanMsgCacheDAO.findScanmanMsgCacheByUnitGroup(unitId);
    }

    @Override
    @Business(viewType="both")
    public Collection<ScanmanMsgCache> findCacheAll() {
        return this.scanmanMsgCacheDAO.findScanmanMsgCacheAll();
    }
}

