/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.rfid;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.util.geo.GPSPosition;
import de.proveo.wwt.datamodel.rfid.TagPositionMapping;
import de.proveo.wwt.logic.app.rfid.RFIDValue;
import de.proveo.wwt.logic.ejb.dataIn.event.EventFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.rfid.TagEventFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.rfid.TagEventFacadeRemote;
import de.proveo.wwt.logic.ejb.dataIn.rfid.TagPositionMappingDAO;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocal;
import de.proveo.wwt.logic.ejb.geo.GeoStruct;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.PostConstruct;
import javax.ejb.CreateException;
import javax.ejb.EJB;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.Local;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.Remote;
import javax.ejb.RemoveException;
import javax.ejb.Stateless;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Stateless(name="TagEventFacade")
@Remote(value={TagEventFacadeRemote.class})
@Local(value={TagEventFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/TagEventFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/TagEventFacade")
public class TagEventFacadeBean
implements TagEventFacadeLocal,
TagEventFacadeRemote {
    @EJB
    private ConfigurationLocal config;
    private static final Log log = LogFactory.getLog(TagEventFacadeBean.class);
    @PersistenceContext(unitName="rts")
    private EntityManager em = null;
    private TagPositionMappingDAO tagPositionMappingDAO;
    private static final Random random = new Random(System.currentTimeMillis());
    private EventFacadeLocal eventFacadeLocal = null;
    protected static final String CONFIG_TAG_RANDOM_RANGE = "locationService.randomRange";
    protected static final int DEFAUL_CONFIG_TAG_RANDOM_RANGE = 300;
    private int tagRandomRange;

    @PostConstruct
    public void initImpl() {
        this.tagPositionMappingDAO = TagPositionMappingDAO.newInstance(this.em);
        try {
            this.tagRandomRange = Integer.parseInt(this.config.getParameter(CONFIG_TAG_RANDOM_RANGE, Integer.toString(300)));
        }
        catch (NumberFormatException ex) {
            log.error((Object)"de.proveo.wwt.logic.ejb.dataIn.rfid.locationService.randomRange runs into:", (Throwable)ex);
            this.tagRandomRange = 300;
        }
    }

    @Override
    @Business(viewType="both")
    public void handleEvent(RFIDValue event) {
        this.createPositionEvent(event);
    }

    @Override
    @Business(viewType="local")
    public void createPositionEvent(RFIDValue event) {
        try {
            long timestamp = System.currentTimeMillis();
            TagPositionMapping tagPositionMapping = this.getTagPositionMappingByTagName(event.getTagName());
            if (tagPositionMapping == null) {
                log.warn((Object)("No TagPositionMapping found for tagName:" + event.getTagName()));
                return;
            }
            int lat = tagPositionMapping.getLatMsec();
            int lng = tagPositionMapping.getLongMsec();
            lat = random.nextBoolean() ? (lat += random.nextInt(this.tagRandomRange)) : (lat -= random.nextInt(this.tagRandomRange));
            lng = random.nextBoolean() ? (lng += random.nextInt(this.tagRandomRange)) : (lng -= random.nextInt(this.tagRandomRange));
            GeoStruct geoEvent = new GeoStruct(event.getUnitID(), event.getTimeStamp(), timestamp, lat, lng, true, event.getTagName());
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("time", Long.toString(timestamp));
            params.put("longitude", Long.toString(lng));
            params.put("latitude", Long.toString(lat));
            params.put("quality", "1");
            String record = GPSPosition.createNMEArecord((String)"GGA", params);
            geoEvent.setGgaRec(record);
            params = new HashMap();
            params.put("time", Long.toString(timestamp));
            params.put("status", "A");
            params.put("longitude", Long.toString(lng));
            params.put("latitude", Long.toString(lat));
            record = GPSPosition.createNMEArecord((String)"RMC", params);
            geoEvent.setRmcRec(record);
            if (this.eventFacadeLocal == null) {
                InitialContext context = new InitialContext();
                this.eventFacadeLocal = (EventFacadeLocal)context.lookup("rts/EventFacade/local");
            }
            this.eventFacadeLocal.handleEvent(geoEvent.generateEventProperties());
        }
        catch (ObjectNotFoundException ex) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("createPositionEvent() no position mapping defined for " + event));
            }
        }
        catch (FinderException ex) {
            log.error((Object)"createPositionEvent() runs into", (Throwable)ex);
            throw new EJBException("finder problem", (Exception)((Object)ex));
        }
        catch (Exception ex) {
            log.error((Object)"createPositionEvent() runs into", (Throwable)ex);
        }
    }

    @Override
    @Business(viewType="both")
    public void addTagPositionMapping(TagPositionMapping mapping) throws CreateException {
        this.tagPositionMappingDAO.createEntity(mapping);
    }

    @Override
    @Business(viewType="both")
    public void removeTagPositionMapping(long rfidTagId) throws FinderException, RemoveException {
        this.tagPositionMappingDAO.removeEntity(this.tagPositionMappingDAO.findByPrimaryKey(rfidTagId));
    }

    @Override
    @Business(viewType="both")
    public TagPositionMapping getTagPositionMapping(long rfidTagId) throws FinderException {
        return (TagPositionMapping)this.tagPositionMappingDAO.findByPrimaryKey(rfidTagId);
    }

    @Override
    @Business(viewType="both")
    public TagPositionMapping getTagPositionMappingByTagName(String tagName) throws FinderException {
        List<TagPositionMapping> tagMappings = this.tagPositionMappingDAO.findTagPositionMappingByName(tagName);
        Iterator<TagPositionMapping> tagMapping = tagMappings.iterator();
        if (tagMapping.hasNext()) {
            return tagMapping.next();
        }
        return null;
    }

    @Override
    @Business(viewType="both")
    public void saveTagPositionMapping(TagPositionMapping value) throws FinderException {
        this.tagPositionMappingDAO.updateEntity(value);
    }

    @Override
    @Business(viewType="both")
    public Collection<TagPositionMapping> getTagPositionMappings() throws FinderException {
        return this.tagPositionMappingDAO.findAll();
    }
}

