/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.observable;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.logic.ejb.dataIn.observable.ObservableFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.observable.ObservableFacadeRemote;
import de.proveo.wwt.logic.ejb.dataIn.observable.ObservableJMSSender;
import javax.annotation.PostConstruct;
import javax.ejb.CreateException;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.PoolClass;
import org.jboss.ejb3.StrictMaxPool;

@Stateless(name="ObservableFacade")
@Remote(value={ObservableFacadeRemote.class})
@Local(value={ObservableFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/ObservableFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/ObservableFacade")
@PoolClass(value=StrictMaxPool.class, maxSize=100, timeout=10000L)
public class ObservableFacadeBean
implements ObservableFacadeLocal,
ObservableFacadeRemote {
    private static final Log log = LogFactory.getLog(ObservableFacadeBean.class);
    private ObservableJMSSender observableJMSSender;

    @PostConstruct
    public void ejbCreate() throws CreateException {
        try {
            this.observableJMSSender = new ObservableJMSSender();
            this.observableJMSSender.initialize();
        }
        catch (Exception e) {
            log.error((Object)"runs into: ", (Throwable)e);
            throw new CreateException();
        }
    }

    public void ejbRemove() {
        try {
            if (this.observableJMSSender != null) {
                this.observableJMSSender.closeConnection();
                this.observableJMSSender = null;
            }
        }
        catch (Exception ex) {
            log.error((Object)"runs into ", (Throwable)ex);
        }
    }

    @Override
    @Business(viewType="both")
    public void notifyClients(String msg, String kindOfEvent) {
        if (msg != null) {
            this.observableJMSSender.sendMessage(msg, kindOfEvent);
        } else {
            log.warn((Object)"msg is null, nothing to send!!!");
        }
    }

    @Override
    @Business(viewType="both")
    public void notifyClients(SerializableEventWrapper wrapper, String kindOfEvent) {
        if (wrapper != null) {
            this.observableJMSSender.sendMessage(wrapper, kindOfEvent);
        } else {
            log.warn((Object)"wrapper is null, nothing to send!!!");
        }
    }
}

