/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.notify;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.wwt.datamodel.notification.Notification;
import de.proveo.wwt.datamodel.notify.NotifyCache;
import de.proveo.wwt.datamodel.notify.NotifyHistory;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.logic.ejb.dataIn.notify.CurrentNotifyCacheDAO;
import de.proveo.wwt.logic.ejb.dataIn.notify.NotificationDAO;
import de.proveo.wwt.logic.ejb.dataIn.notify.NotifyFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.notify.NotifyFacadeRemote;
import de.proveo.wwt.logic.ejb.dataIn.notify.NotifyHistoryDAO;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

@Stateless(name="NotifyFacade")
@Remote(value={NotifyFacadeRemote.class})
@Local(value={NotifyFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/NotifyFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/NotifyFacade")
public class NotifyFacadeBean
implements NotifyFacadeLocal,
NotifyFacadeRemote {
    private NotificationDAO notificationDAO = null;
    private CurrentNotifyCacheDAO currentNotifyCacheDAO = null;
    private NotifyHistoryDAO notifyHistoryDAO = null;
    @PersistenceContext(unitName="rts")
    private EntityManager entityManager = null;

    @PostConstruct
    private void initImpl() {
        this.notificationDAO = NotificationDAO.newInstance(this.entityManager);
        this.currentNotifyCacheDAO = CurrentNotifyCacheDAO.newInstance(this.entityManager);
        this.notifyHistoryDAO = NotifyHistoryDAO.newInstance(this.entityManager);
    }

    @Override
    @Business(viewType="both")
    public NotifyHistory getNotifyHistoryValue(long historyId) {
        return (NotifyHistory)this.notifyHistoryDAO.findByPrimaryKey(historyId);
    }

    @Override
    @Business(viewType="both")
    public void deleteCache(UnitModel unitModel) {
        List<NotifyCache> currentNotifyCaches = unitModel.getCurrentNotifyCaches();
        for (NotifyCache notifyCache : currentNotifyCaches) {
            if (notifyCache == null) continue;
            this.currentNotifyCacheDAO.removeEntity(notifyCache);
        }
    }

    @Override
    @Business(viewType="both")
    public List<NotifyCache> getAllUnitEventsFromCacheSortedByHistoryId() {
        return this.currentNotifyCacheDAO.findAllSortedByHistoryId();
    }

    @Override
    @Business(viewType="both")
    public String getNotificationTextById(long id) {
        Notification value = null;
        value = (Notification)this.notificationDAO.findByPrimaryKey(id);
        if (value != null) {
            return value.getDefaultName();
        }
        return null;
    }

    @Override
    @Business(viewType="both")
    public long findNotifyHistoryMaxHistoryId() {
        return this.notifyHistoryDAO.findNotifyHistoryMaxHistoryId();
    }

    @Override
    @Business(viewType="both")
    public NotifyHistory findByPrimaryKey(long id) {
        return (NotifyHistory)this.notifyHistoryDAO.findByPrimaryKey(id);
    }

    @Override
    @Business(viewType="both")
    public List<NotifyHistory> findHistoryAll() {
        return this.notifyHistoryDAO.findAll();
    }

    @Override
    @Business(viewType="both")
    public List<NotifyCache> findCacheAll() {
        return this.currentNotifyCacheDAO.findAll();
    }

    @Override
    @Business(viewType="both")
    public List<NotifyCache> findCacheByMessageId(long messageId) {
        return this.currentNotifyCacheDAO.findByMessageId(messageId);
    }

    @Override
    @Business(viewType="both")
    public List<NotifyCache> findCacheByUnitGroupId(long unitGroupId) {
        return this.currentNotifyCacheDAO.findByUnitGroupId(unitGroupId);
    }

    @Override
    @Business(viewType="both")
    public List<NotifyCache> findCacheByUnitId(long unitId) {
        return this.currentNotifyCacheDAO.findByUnitId(unitId);
    }

    @Override
    @Business(viewType="both")
    public List<NotifyCache> findCacheByUnitGroupIdAndMessageId(long unitGroupId, long messageId) {
        return this.currentNotifyCacheDAO.findByUnitGroupIdAndMessageId(unitGroupId, messageId);
    }

    @Override
    @Business(viewType="both")
    public List<NotifyCache> findCacheByUnitIdAndMessageId(long unitId, long messageId) {
        return this.currentNotifyCacheDAO.findByUnitIdAndMessageId(unitId, messageId);
    }

    @Override
    @Business(viewType="both")
    public List<NotifyHistory> findHistoryByUnitIdSorted(long unitId, long since, long until, boolean entry) {
        return this.notifyHistoryDAO.findByUnitIdSorted(unitId, since, until, entry);
    }

    @Override
    @Business(viewType="both")
    public List<NotifyCache> findCacheByUnitIdSorted(long unitId, long since, long until, boolean entry) {
        return this.currentNotifyCacheDAO.findByUnitIdSorted(unitId, since, until, entry);
    }

    @Override
    @Business(viewType="both")
    public NotifyCache findLastCacheByUnitId(long unitId) {
        return this.currentNotifyCacheDAO.findLastByUnitId(unitId);
    }

    @Override
    @Business(viewType="both")
    public List<NotifyHistory> findHistoryCountByUnitIdNotifyId(long unitId, long messageId, long since, long until, boolean entry) {
        return this.notifyHistoryDAO.findByUnitIdNotifyId(unitId, messageId, since, until, entry);
    }

    @Override
    @Business(viewType="both")
    public List<NotifyHistory> findAllOlderThanGivenTimestamp(long timestamp) {
        return this.notifyHistoryDAO.findAllOlderThanGivenTimestamp(timestamp);
    }

    @Override
    @Business(viewType="both")
    public List<NotifyHistory> findNotifyHistoryAllOlderThanGivenTimestampByUnitId(long unitId, long timestamp) {
        return this.notifyHistoryDAO.findNotifyHistoryAllOlderThanGivenTimestampByUnitId(unitId, timestamp);
    }

    @Override
    @Business(viewType="both")
    public List<NotifyHistory> findByUnitIdSorted(long unitId, long since, long until, boolean entry) {
        return this.notifyHistoryDAO.findByUnitIdSorted(unitId, since, until, entry);
    }

    @Override
    @Business(viewType="both")
    public void removeNotifyCacheFromUnit(long unitId) {
        List<NotifyCache> list = this.currentNotifyCacheDAO.findByUnitId(unitId);
        for (NotifyCache currentNotifyCache : list) {
            this.currentNotifyCacheDAO.removeEntity(currentNotifyCache);
        }
    }
}

