/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.informant;

import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.logic.ejb.dataIn.informant.InformantFacadeRemote;
import java.io.Serializable;
import java.rmi.RemoteException;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InformantClient {
    private static final Log log = LogFactory.getLog(InformantClient.class);
    private static InformantFacadeRemote informantFacade;

    public void notify(SerializableEventWrapper wrapper, String kindOfEvent) {
        try {
            this.init();
            informantFacade.notify(wrapper, kindOfEvent);
        }
        catch (RemoteException e) {
            log.error((Object)"notify() runs into RemoteException: ", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"notify() runs into Exception: ", (Throwable)e);
        }
    }

    public void notify(String message, String kindOfEvent) {
        SerializableEventWrapper wrapper = new SerializableEventWrapper((Serializable)((Object)message));
        wrapper.set_typeOfEvent(kindOfEvent);
        try {
            this.init();
            informantFacade.notify(wrapper, kindOfEvent);
        }
        catch (RemoteException e) {
            log.error((Object)"notify() runs into RemoteException: ", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"notify() runs into Exception: ", (Throwable)e);
        }
    }

    private void init() throws RemoteException {
        if (informantFacade == null) {
            try {
                InitialContext ctx = new InitialContext();
                informantFacade = (InformantFacadeRemote)ctx.lookup("rts/InformantFacade/remote");
                log.info((Object)("New informantFacadeRemote " + informantFacade));
            }
            catch (Exception ex) {
                log.trace((Object)"no Configuration EJB Refernce found. Use physical lookup");
            }
        }
    }
}

