/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.event.triggers.measurment.frames;

import de.proveo.wwt.datamodel.measurement.MeasurementInterval;
import de.proveo.wwt.datamodel.measurement.MeasurementIntervalDefn;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.datamodel.use.user.UseUser;
import de.proveo.wwt.logic.ejb.general.measurement.MeasurementEvent;
import de.proveo.wwt.logic.ejb.general.measurement.MeasurementFacadeLocal;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import de.proveo.wwt.logic.web.common.dataSelection.UnitReportSelectionDTO;
import de.proveo.wwt.logic.web.common.dto.ReportDTOListBase;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.historyData.dto.MeasurementDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.Interval;

public class MeasurementIntervalFrame {
    private static final Log log = LogFactory.getLog(MeasurementIntervalFrame.class);
    private List<MeasurementEvent> events = null;
    private long unitId = 0L;
    private MeasurementIntervalDefn intervalDefn = null;
    private MeasurementFacadeLocal measurementFacade = null;
    private UnitFacadeLocal unitFacade = null;
    private UnitModel unitModel = null;
    private int measurementDefnId = 0;

    public MeasurementIntervalFrame(long id, MeasurementIntervalDefn interval) {
        this.unitId = id;
        this.intervalDefn = interval;
        this.events = new ArrayList<MeasurementEvent>();
        try {
            InitialContext context = new InitialContext();
            this.measurementFacade = (MeasurementFacadeLocal)context.lookup("rts/MeasurementFacade/local");
            this.unitFacade = (UnitFacadeLocal)context.lookup("rts/UnitFacade/local");
            this.measurementDefnId = interval.getMeasurementDefnId();
        }
        catch (NamingException e) {
            log.error((Object)"NamingException() runs into", (Throwable)e);
        }
        this.fillFrame();
    }

    public MeasurementInterval addnewEvent(MeasurementEvent event) {
        long frameDuration = this.intervalDefn.getThreshold_duration_min() * 1000;
        long deadline = event.getCreateTime() - frameDuration;
        log.debug((Object)("Consideration frame: " + deadline));
        this.purgeFrame(deadline);
        log.debug((Object)("Adding new measurement event at index 0: " + event));
        this.events.add(0, event);
        if (event.hasStatisticCache()) {
            this.events.add(0, event.getCachedMeasurementEvent());
            event.setCachedMeasurementEvent(null);
            this.sortFrame();
        }
        if (this.checkInterval()) {
            MeasurementEvent oldestElement = this.events.get(this.events.size() - 1);
            this.purgeFrame(event.getCreateTime());
            log.debug((Object)("Threshold reached - Fire event " + event));
            return this.triggerIntervalEvent(oldestElement, event);
        }
        return null;
    }

    public boolean checkInterval() {
        for (MeasurementEvent event : this.events) {
            log.debug((Object)("checkInterval() - check interval: " + event));
        }
        double threshold = this.intervalDefn.getThreshold();
        double pivot = 0.0;
        double lastElement = 0.0;
        double temp = 0.0;
        boolean isFirstElement = true;
        boolean thresholdExceeded = false;
        for (int eventsSize = this.events.size() - 1; eventsSize >= 0; --eventsSize) {
            MeasurementEvent event = this.events.get(eventsSize);
            if (isFirstElement) {
                lastElement = event.getValue();
                isFirstElement = false;
            }
            if (lastElement == (double)event.getValue()) continue;
            temp = (double)event.getValue() - lastElement;
            lastElement = event.getValue();
            log.debug((Object)("Current threshold: " + (pivot += temp)));
            if (!(threshold >= 0.0 && pivot >= threshold) && (!(threshold < 0.0) || !(pivot < threshold))) continue;
            thresholdExceeded = true;
        }
        log.debug((Object)("Pivot level: " + pivot));
        return thresholdExceeded;
    }

    private void fillFrame() {
        long currentTime = System.currentTimeMillis();
        Interval interval = new Interval(currentTime - (long)(this.intervalDefn.getThreshold_duration_min() * 1000), currentTime);
        this.unitModel = this.unitFacade.getUnitModel(this.unitId);
        UnitDTO unit = new UnitDTO(this.unitModel, this.unitModel.getUnitIdentity(), this.unitModel.getUnitTypeIdentity());
        ArrayList<UnitDTO> unitDTOs = new ArrayList<UnitDTO>();
        unitDTOs.add(unit);
        UnitReportSelectionDTO selectionDTO = new UnitReportSelectionDTO(interval, unitDTOs, false);
        ReportDTOListBase<MeasurementDTO> measurements = this.measurementFacade.getMeasurementHistory(selectionDTO, null);
        for (MeasurementDTO measurementDTO : measurements) {
            if (measurementDTO.getMeasurementDefinitionId() != this.measurementDefnId) continue;
            MeasurementEvent measurementEvent = new MeasurementEvent(this.unitId, measurementDTO.getMeasurementDefinitionId(), measurementDTO.getCreateTime(), measurementDTO.getReceiveTime(), measurementDTO.getValue().floatValue());
            this.events.add(measurementEvent);
        }
        this.sortFrame();
        for (MeasurementEvent event : this.events) {
            log.info((Object)("fillFrame() - after sort: " + event));
        }
    }

    private void purgeFrame(long deadline) {
        int purgeCounter = 0;
        Iterator<MeasurementEvent> iterator = this.events.iterator();
        while (iterator.hasNext()) {
            MeasurementEvent measurementEvent = iterator.next();
            if (measurementEvent.getCreateTime() >= deadline || measurementEvent.hasStatisticCache()) continue;
            log.debug((Object)("purgeFrame() - Purge old event from compare list: " + measurementEvent + " time diff to considered event: " + (deadline - measurementEvent.getCreateTime())));
            iterator.remove();
            ++purgeCounter;
        }
    }

    private MeasurementInterval triggerIntervalEvent(MeasurementEvent startEvent, MeasurementEvent endEvent) {
        MeasurementInterval interval = new MeasurementInterval();
        interval.setBeginTime(startEvent.getCreateTime());
        interval.setEndTime(endEvent.getCreateTime());
        interval.setMeasurementFrom(startEvent.getValue());
        interval.setMeasurementIntervalDefn(this.intervalDefn);
        interval.setMeasurementTo(endEvent.getValue());
        interval.setMeasuremrentTo(endEvent.getMeasurementHistory());
        interval.setMesurementFrom(startEvent.getMeasurementHistory());
        Long grouphistoryId = this.unitFacade.getGrouphistoryId(startEvent.getUnitId(), startEvent.getCreateTime());
        interval.setGroupHistoryId(grouphistoryId);
        interval.setUnitId(endEvent.getUnitId());
        interval.setAreaId(endEvent.getAreaId());
        UseUser user = endEvent.getUser();
        if (user != null) {
            interval.setUseUserId(user.getId());
        }
        interval.setGdataHistoryId(endEvent.getGdataHistoryId());
        return interval;
    }

    private void sortFrame() {
        Collections.sort(this.events, new Comparator<MeasurementEvent>(){

            @Override
            public int compare(MeasurementEvent a, MeasurementEvent b) {
                return (int)(b.getCreateTime() - a.getCreateTime());
            }
        });
    }

    public long getUnitId() {
        return this.unitId;
    }
}

