/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.event.mapper;

import de.proveo.datasync.ejb.TaskExecutionFacadeLocal;
import de.proveo.datasync.ejb.TaskManagementFacadeLocal;
import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.eventbase.EventResponse;
import de.proveo.rts.configuration.interfaces.event.DeviceTemporarilyBlockedException;
import de.proveo.rts.configuration.interfaces.event.EventInterfaceMBean;
import de.proveo.rts.configuration.monitor.MonitoringMBean;
import de.proveo.util.service.ServiceFactory;
import de.proveo.wwt.datamodel.custom.CustomScript;
import de.proveo.wwt.logic.ejb.dataIn.event.EventFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.event.EventInfo;
import de.proveo.wwt.logic.ejb.dataIn.event.mapper.EventMapper;
import de.proveo.wwt.logic.ejb.dataIn.event.mapper.EventMappingLocal;
import de.proveo.wwt.logic.ejb.dataIn.event.mapper.EventMappingRemote;
import de.proveo.wwt.logic.ejb.dataIn.event.mapper.FacadeWrapper;
import de.proveo.wwt.logic.ejb.dataIn.notify.NotifyFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.use.UseFacadeLocal;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocal;
import de.proveo.wwt.logic.ejb.general.custom.CustomScriptFacadeLocal;
import de.proveo.wwt.logic.ejb.general.custom.ScriptLoader;
import de.proveo.wwt.logic.ejb.general.measurement.MeasurementFacadeLocal;
import de.proveo.wwt.logic.ejb.geo.GdataFacadeLocal;
import de.proveo.wwt.logic.ejb.keepalive.KeepAliveOutFacadeLocal;
import de.proveo.wwt.logic.ejb.state.CurrentStateFacadeLocal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.EJBException;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.PoolClass;
import org.jboss.ejb3.StrictMaxPool;

@Stateless(name="EventMapping")
@Remote(value={EventMappingRemote.class})
@Local(value={EventMappingLocal.class})
@JndiLocalBinding(localJndiBinding="rts/EventMapping")
@JndiRemoteBinding(remoteJndiBinding="rts/EventMapping")
@PoolClass(value=StrictMaxPool.class, maxSize=100, timeout=10000L)
public class EventMappingBean
implements EventMappingRemote,
EventMappingLocal {
    private static final Log log = LogFactory.getLog(EventMappingBean.class);
    private static final String DEFAULT_EVENT_MAPPER_ENTRY_POINT = "infoman.event.3rdparty.eventMapper";
    private static final String DEFAULT_EVENT_MAPPER_LIBRARY_ENTRY_POINT = "infoman.event.3rdparty.eventMapper.lib";
    private static final ScriptLoader<EventMapper> eventMapperScriptLoader = new ScriptLoader();
    @EJB
    private EventFacadeLocal eventFacade;
    @EJB
    private CustomScriptFacadeLocal customScriptFacade;
    @EJB
    private CurrentStateFacadeLocal currentStateFacade;
    @EJB
    private KeepAliveOutFacadeLocal keepAliveOutFacade;
    @EJB
    private UseFacadeLocal useFacade;
    @EJB
    private MeasurementFacadeLocal measurementFacade;
    @EJB
    private TaskManagementFacadeLocal taskManagementFacade;
    @EJB
    private TaskExecutionFacadeLocal taskExecutionFacade;
    @EJB
    private GdataFacadeLocal gdataFacade;
    @EJB
    private ConfigurationLocal configurationLocal;
    @EJB
    private NotifyFacadeLocal notifyFacade;
    FacadeWrapper facadeWrapper;
    private MonitoringMBean groovyFailuresMontoringMBean;
    private EventInterfaceMBean eventInterfaceMBean;

    @Override
    @Business(viewType="both")
    public List<EventResponse> handleRawEvent(List<Long> unitIds, Map<String, Object> parsedEventParameters, Map<String, Object> eventMetaInfo) throws DeviceTemporarilyBlockedException {
        if (this.eventInterfaceMBean.isEventInterfaceDisabled() || this.eventInterfaceMBean.isEventInterfaceDisabled((String)eventMetaInfo.get("device.identification"))) {
            throw new DeviceTemporarilyBlockedException();
        }
        List<Properties> efmEvents = this.callMapperEntryPoint(unitIds, parsedEventParameters, eventMetaInfo);
        return this.processEFMEvents(efmEvents, eventMetaInfo);
    }

    @PostConstruct
    public void initialize() {
        this.facadeWrapper = new FacadeWrapper();
        this.facadeWrapper.currentStateFacade = this.currentStateFacade;
        this.facadeWrapper.keepAliveOutFacade = this.keepAliveOutFacade;
        this.facadeWrapper.useFacade = this.useFacade;
        this.facadeWrapper.measurementFacade = this.measurementFacade;
        this.facadeWrapper.gdataFacade = this.gdataFacade;
        this.facadeWrapper.notifyFacade = this.notifyFacade;
        this.facadeWrapper.taskExecutionFacade = this.taskExecutionFacade;
        this.facadeWrapper.taskManagementFacade = this.taskManagementFacade;
        try {
            this.groovyFailuresMontoringMBean = (MonitoringMBean)ServiceFactory.getInstance().getService(MonitoringMBean.class, "MappingGroovyFailures");
            this.eventInterfaceMBean = (EventInterfaceMBean)ServiceFactory.getInstance().getService(EventInterfaceMBean.class, "EventMappingInterface");
            this.eventInterfaceMBean.setAcceptFaultyEventsPersistent(this.configurationLocal.getBoolean("infoman.event.mapping.acceptFaultyEvents"));
        }
        catch (Exception ex) {
            throw new EJBException("mbean reference problem", ex);
        }
    }

    protected List<Properties> callMapperEntryPoint(List<Long> unitIds, Map<String, Object> parsedEventParameters, Map<String, Object> metaInfo) {
        List<CustomScript> scripts;
        ArrayList<Properties> efmEvents = new ArrayList<Properties>();
        for (Long unitId : unitIds) {
            scripts = this.customScriptFacade.getActiveScriptsByEntryPointAndUnit(DEFAULT_EVENT_MAPPER_LIBRARY_ENTRY_POINT, unitId);
            if (log.isTraceEnabled()) {
                log.trace((Object)("infoman.event.3rdparty.eventMapper.lib scripts: " + scripts.size()));
            }
            for (CustomScript script : scripts) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("infoman.event.3rdparty.eventMapper.lib load " + script));
                }
                try {
                    eventMapperScriptLoader.loadLib(script);
                }
                catch (Exception ex) {
                    if (this.groovyFailuresMontoringMBean != null) {
                        this.groovyFailuresMontoringMBean.increment();
                    }
                    if (log.isErrorEnabled()) {
                        log.error((Object)("libEntryPoint: infoman.event.3rdparty.eventMapper.lib " + script), (Throwable)ex);
                    }
                    if (this.eventInterfaceMBean == null || this.eventInterfaceMBean.isAcceptFaultyEvents() != this.eventInterfaceMBean.isAcceptFaultyEventsException((String)metaInfo.get("device.identification"))) continue;
                    throw new IllegalStateException("libEntryPoint: infoman.event.3rdparty.eventMapper.lib " + script, ex);
                }
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("unitIds:" + unitIds));
        }
        for (Long unitId : unitIds) {
            scripts = this.customScriptFacade.getActiveScriptsByEntryPointAndUnit(DEFAULT_EVENT_MAPPER_ENTRY_POINT, unitId);
            if (log.isTraceEnabled()) {
                log.trace((Object)("infoman.event.3rdparty.eventMapper unitId: " + unitId + " scripts: " + scripts.size()));
            }
            for (CustomScript script : scripts) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("infoman.event.3rdparty.eventMapper execute script: " + script.getScriptId() + " for unit: " + unitId));
                }
                try {
                    EventMapper parser = eventMapperScriptLoader.loadScript(script);
                    List<Properties> events = parser.createEFMevents(parsedEventParameters, metaInfo, this.facadeWrapper);
                    if (events != null) {
                        efmEvents.addAll(events);
                    }
                    if (!log.isTraceEnabled()) continue;
                    int eventsCreated = events == null ? 0 : events.size();
                    log.trace((Object)("infoman.event.3rdparty.eventMapper executed script: " + script.getScriptId() + " for unit: " + unitId + " eventsCreated:" + eventsCreated));
                }
                catch (Exception ex) {
                    if (this.groovyFailuresMontoringMBean != null) {
                        this.groovyFailuresMontoringMBean.increment();
                    }
                    if (log.isErrorEnabled()) {
                        log.error((Object)("entryPoint: infoman.event.3rdparty.eventMapper " + script), (Throwable)ex);
                    }
                    if (this.eventInterfaceMBean == null || this.eventInterfaceMBean.isAcceptFaultyEvents() != this.eventInterfaceMBean.isAcceptFaultyEventsException((String)metaInfo.get("device.identification"))) continue;
                    throw new IllegalStateException("entryPoint: infoman.event.3rdparty.eventMapper " + script, ex);
                }
            }
        }
        return efmEvents;
    }

    protected List<EventResponse> processEFMEvents(List<Properties> efmEvents, Map<String, Object> eventMetaInfo) {
        ArrayList<EventResponse> eventResponses = null;
        if (efmEvents != null) {
            for (Properties efmEvent : efmEvents) {
                EventResponse response = this.processEFMevent(efmEvent, eventMetaInfo);
                if (response == null) continue;
                if (eventResponses == null) {
                    eventResponses = new ArrayList<EventResponse>();
                }
                eventResponses.add(response);
            }
        }
        return eventResponses;
    }

    @Override
    @Business(viewType="both")
    public EventResponse processEFMevent(Properties event, Map<String, Object> eventMetaInfo) {
        EventResponse eventResponse;
        String remoteAddr = (String)eventMetaInfo.get("remoteAddr");
        if (event.size() > 0) {
            String ping;
            if (log.isDebugEnabled()) {
                log.debug((Object)("processEvent() " + event + " from " + remoteAddr));
            }
            if ((ping = event.getProperty("p")) != null && ping.equals("servlet")) {
                eventResponse = new EventResponse();
                eventResponse.setEventResponse(true);
            } else {
                EventInfo eventInfo = new EventInfo();
                eventInfo.receiveTime = (Long)eventMetaInfo.get("efm.receiveTime");
                eventInfo.deviceType = (String)eventMetaInfo.get("hwType");
                eventInfo.serialNumber = (String)eventMetaInfo.get("hwsn");
                try {
                    eventResponse = this.eventFacade.handleEvent(event, eventInfo);
                }
                catch (Exception e) {
                    log.error((Object)"processEvent() EventFacade.handleEvent() runs into", (Throwable)e);
                    eventResponse = new EventResponse();
                    eventResponse.setEventResponse(false);
                }
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("processEvent() illegel request " + event + " from " + remoteAddr));
            }
            eventResponse = new EventResponse();
            eventResponse.setEventResponse(false);
        }
        return eventResponse;
    }
}

