/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.event.handlers;

import de.proveo.eventbase.EventResponse;
import de.proveo.rts.configuration.infoman.InfomanEventServiceMBean;
import de.proveo.rts.configuration.monitor.MonitoringMBean;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.util.service.ServiceFactory;
import de.proveo.util.string.StringUtil;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.datamodel.use.UseCache;
import de.proveo.wwt.datamodel.use.UseHistory;
import de.proveo.wwt.datamodel.use.user.UseUser;
import de.proveo.wwt.logic.app.use.event.UseEvent;
import de.proveo.wwt.logic.ejb.dataIn.event.EventInfo;
import de.proveo.wwt.logic.ejb.dataIn.event.EventResult;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.IEventHandler;
import de.proveo.wwt.logic.ejb.dataIn.event.history.EventPersisterFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.event.history.EventPersisterResult;
import de.proveo.wwt.logic.ejb.dataIn.use.UseFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser.UseUserAdminFacadeLocal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import javax.ejb.EJBException;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UseEventHandler
implements IEventHandler {
    private static final Log log = LogFactory.getLog(UseEventHandler.class);
    private MonitoringMBean useEventCounter;
    private UseUserAdminFacadeLocal useUserFacade;
    private UseFacadeLocal useFacade;
    private EventPersisterFacadeLocal eventPersisterFacade = null;
    private InfomanEventServiceMBean infomanEventService;

    @Override
    public EventResult handleEvent(Properties event, EventResponse eventResponse, EventInfo eventInfo, ArrayList<SerializableEventWrapper> eventWrappers) {
        if (event.containsKey("uu") || event.containsKey("nuu")) {
            int numUnits = eventInfo.unitIds.length;
            for (int i = 0; i != numUnits; ++i) {
                eventInfo.useUser = this.handleUseEvent(event, eventInfo.unitIds[i], eventInfo, eventWrappers);
            }
        }
        return EventResult.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UseUser handleUseEvent(Properties event, long unitId, EventInfo eventInfo, ArrayList<SerializableEventWrapper> eventWrappers) {
        EventPersisterResult<UseCache, UseHistory> result;
        this.useEventCounter.increment();
        UseHistory useHistory = new UseHistory();
        useHistory.setBeginTime(Long.parseLong(event.getProperty("t")));
        useHistory.setBeginReceiveTime(eventInfo.receiveTime);
        useHistory.setUnitId(unitId);
        useHistory.setGdataHistoryId(eventInfo.gdataHistoryId);
        String userKey = event.getProperty("uu");
        if (userKey == null) {
            userKey = event.getProperty("nuu");
        }
        boolean isLogin = event.containsKey("ul") ? Integer.parseInt(event.getProperty("ul")) == 1 : userKey != null;
        UseUser useUser = null;
        if (userKey != null) {
            String encodedUserKey = StringUtil.escapeNonLatin1Characters((String)userKey);
            useUser = this.useUserFacade.getUseUserByKey(encodedUserKey);
            if (useUser != null) {
                useHistory.setUseUserId(useUser.getId());
            } else if (this.infomanEventService.isLazyCreateOfMasterdataByEvents()) {
                try {
                    this.useUserFacade.insertUseUserFlush(this.createUseUser(encodedUserKey));
                    useUser = this.useUserFacade.getUseUserByKey(encodedUserKey);
                }
                catch (Exception ex) {
                    log.error((Object)"Can't create UseUser", (Throwable)ex);
                }
                finally {
                    useHistory.setUseUserId(useUser.getId());
                }
            } else if (log.isWarnEnabled()) {
                log.warn((Object)("unitId:" + unitId + " received unkown userId:'" + encodedUserKey + "' " + event));
            }
        }
        if (event.containsKey("uu") && (result = isLogin ? this.handleLogin(useUser, useHistory, event, eventInfo.areaId) : this.handleLogoff(useUser, useHistory, eventInfo.areaId, false)) != null) {
            UseEvent useEvent = this.getUseEvent(event, unitId);
            SerializableEventWrapper wrapper = new SerializableEventWrapper();
            wrapper.set_historyValue((Serializable)((Object)useHistory));
            wrapper.set_cacheValue((Serializable)useEvent);
            wrapper.set_typeOfEvent("UseEvent");
            eventWrappers.add(wrapper);
        }
        return useUser;
    }

    private UseEvent getUseEvent(Properties event, long unitId) {
        UseEvent useEvent = new UseEvent();
        useEvent.setReceiveTime(System.currentTimeMillis());
        useEvent.setUnitId(unitId);
        useEvent.setUserKey(event.getProperty("uu"));
        useEvent.setTimestamp(Long.parseLong(event.getProperty("t")));
        if (event.containsKey("ul")) {
            if (Integer.parseInt(event.getProperty("ul")) == 1) {
                useEvent.setLogin(true);
            } else {
                useEvent.setLogin(false);
            }
        } else {
            useEvent.setLogin(useEvent.getUserKey() != null);
        }
        if (useEvent.getUserKey() == null) {
            useEvent.setUserKey(event.getProperty("nuu"));
        }
        UseUser useUser = null;
        if (useEvent.getUserKey() != null) {
            useUser = this.useUserFacade.getUseUserByKey(useEvent.getUserKey());
            if (useUser != null) {
                useEvent.setUserName(useUser.getName());
                useEvent.setPersonalNumber(useUser.getPersonalNumber());
            } else {
                log.warn((Object)"handleUseEvent() cannot get use user");
            }
        }
        return useEvent;
    }

    protected EventPersisterResult<UseCache, UseHistory> handleLogin(UseUser useUser, UseHistory useHistory, Properties rawEvent, Integer areaId) {
        Long userId = useUser != null ? Long.valueOf(useUser.getId()) : null;
        useHistory.setBeginAreaId(areaId);
        UseCache cachedLogin = this.useFacade.getCache(useHistory.getUnitId());
        if (cachedLogin != null) {
            if (cachedLogin.getBeginTime() > useHistory.getBeginTime()) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("incoming event '" + useHistory + "' is older then current login"));
                }
                return null;
            }
            if (cachedLogin.getUseUserId() != null && cachedLogin.getUseUserId().equals(userId)) {
                return null;
            }
            this.handleLogoff(cachedLogin.getUseUser(), useHistory, areaId, true);
        }
        return this.eventPersisterFacade.persist(useHistory);
    }

    protected EventPersisterResult<UseCache, UseHistory> handleLogoff(UseUser useUser, UseHistory useHistory, Integer areaId, boolean implicitLogoff) {
        EventPersisterResult result = null;
        UseCache dirtyCache = this.useFacade.getCache(useHistory.getUnitId());
        if (dirtyCache != null) {
            UnitModel unitModel = dirtyCache.getUnitModel();
            if (unitModel != null) {
                unitModel.setUseCache(null);
            }
            Long cacheUserId = dirtyCache.getUseUserId();
            if (useUser != null && cacheUserId != null && cacheUserId.longValue() == useUser.getId() || implicitLogoff) {
                useHistory.setBeginAreaId(areaId);
                result = this.eventPersisterFacade.persistHistoryOnly(useHistory);
            } else {
                log.error((Object)("logoff doesn't match login. dismiss user session. login: " + ((Object)dirtyCache).toString() + " logoff: " + ((Object)useHistory).toString()));
                this.eventPersisterFacade.remove(dirtyCache);
            }
        } else {
            log.error((Object)"logoff doesn't match login. No entity for current use found.");
        }
        return result;
    }

    @Override
    public void initialize() {
        try {
            this.useEventCounter = (MonitoringMBean)ServiceFactory.getInstance().getService(MonitoringMBean.class, "UseEvents");
            InitialContext context = new InitialContext();
            this.useUserFacade = (UseUserAdminFacadeLocal)context.lookup("rts/UseUserAdminFacade/local");
            this.useFacade = (UseFacadeLocal)context.lookup("rts/UseFacade/local");
            this.eventPersisterFacade = (EventPersisterFacadeLocal)context.lookup("rts/EventPersisterFacade/local");
            this.infomanEventService = (InfomanEventServiceMBean)ServiceFactory.getInstance().getService(InfomanEventServiceMBean.class);
        }
        catch (Exception e) {
            log.error((Object)"UseEventHandler() runs into", (Throwable)e);
            throw new EJBException("EJB reference problem", e);
        }
    }

    private UseUser createUseUser(String userKey) {
        UseUser use = new UseUser();
        use.setKeyId(userKey);
        use.setUseGroups(Collections.EMPTY_LIST);
        use.setId(0L);
        return use;
    }
}

