/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.event.handlers;

import de.proveo.eventbase.EventResponse;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.datamodel.scanmanmsg.ScanmanMsgHistory;
import de.proveo.wwt.logic.ejb.dataIn.event.EventInfo;
import de.proveo.wwt.logic.ejb.dataIn.event.EventResult;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.IEventHandler;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.InfomanMessageEventHandler;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocal;
import java.util.ArrayList;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TimestampEventHandler
implements IEventHandler {
    private static final Log log = LogFactory.getLog(TimestampEventHandler.class);
    private boolean eventTimestampFix;
    private long eventTimestampFixMaxFuture;
    private ConfigurationLocal configuration;

    @Override
    public EventResult handleEvent(Properties event, EventResponse eventResponse, EventInfo eventInfo, ArrayList<SerializableEventWrapper> eventWrappers) {
        if (!event.containsKey("t")) {
            log.debug((Object)"handleEvent() add timestamp for timeless (simulated) events");
            event.setProperty("t", Long.toString(eventInfo.receiveTime));
        }
        if (!this.isInsideTimeframe(event, eventInfo)) {
            this.fixTimestamp(event, eventInfo, eventWrappers);
            if (log.isTraceEnabled()) {
                log.trace((Object)("handleEvent() timestamp fixed. event: " + event));
            }
        }
        return EventResult.SUCCESS;
    }

    protected boolean isInsideTimeframe(Properties event, EventInfo eventInfo) {
        if (this.eventTimestampFix) {
            String timstampString = event.getProperty("t");
            if (timstampString != null) {
                try {
                    long timestamp = Long.parseLong(timstampString);
                    long timeDiff = timestamp - eventInfo.receiveTime;
                    return timeDiff < this.eventTimestampFixMaxFuture;
                }
                catch (NumberFormatException ex) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)("isInsideTimeframe() timestamp is not a number" + event), (Throwable)ex);
                    }
                    return true;
                }
            }
            if (log.isWarnEnabled()) {
                log.warn((Object)("isInsideTimeframe() cannot check timeframe. Event has no timeframe: " + event));
            }
            return true;
        }
        return true;
    }

    protected void fixTimestamp(Properties event, EventInfo eventInfo, ArrayList<SerializableEventWrapper> eventWrappers) {
        event.setProperty("oldTimestamp", event.getProperty("t"));
        event.setProperty("t", Long.toString(eventInfo.receiveTime));
        ScanmanMsgHistory scanmanMsgHistory = new ScanmanMsgHistory();
        if (eventInfo.unitIds.length > 0) {
            scanmanMsgHistory.setUnitId(eventInfo.unitIds[0]);
        }
        scanmanMsgHistory.setCreateTime(eventInfo.receiveTime);
        scanmanMsgHistory.setType(70);
        scanmanMsgHistory.setMessage(event.toString());
        InfomanMessageEventHandler imeh = new InfomanMessageEventHandler();
        imeh.initialize();
        imeh.persistEvent(scanmanMsgHistory, eventWrappers);
    }

    @Override
    public void initialize() {
        try {
            InitialContext context = new InitialContext();
            this.configuration = (ConfigurationLocal)context.lookup("rts/Configuration/local");
        }
        catch (NamingException e) {
            log.error((Object)"Runs into ", (Throwable)e);
        }
        try {
            this.eventTimestampFix = Boolean.parseBoolean(this.configuration.getParameter("events.timestamp.fix"));
            if (this.eventTimestampFix) {
                this.eventTimestampFixMaxFuture = Long.parseLong(this.configuration.getParameter("events.timestamp.fix.maxFuture"));
            }
        }
        catch (Exception ex) {
            this.eventTimestampFix = false;
            log.error((Object)"runs into", (Throwable)ex);
        }
    }
}

