/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.event.handlers;

import de.proveo.eventbase.EventPayload;
import de.proveo.eventbase.EventResponse;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.logic.app.unit.exception.UnitNotFoundException;
import de.proveo.wwt.logic.ejb.dataIn.event.EventInfo;
import de.proveo.wwt.logic.ejb.dataIn.event.EventResult;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.EventHandlerUtil;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.IEventHandler;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser.unituser.UnitUserLocal;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import java.util.ArrayList;
import java.util.Properties;
import javax.ejb.EJBException;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SCLEventHandler
implements IEventHandler {
    private static final Log log = LogFactory.getLog(SCLEventHandler.class);
    private UnitUserLocal unitUserFacade;
    private UnitFacadeLocal unitFacade;

    @Override
    public EventResult handleEvent(Properties event, EventResponse eventResponse, EventInfo eventInfo, ArrayList<SerializableEventWrapper> eventWrappers) {
        EventResult result = EventResult.SUCCESS;
        if (event.containsKey("req") && event.getProperty("req").equals("scl")) {
            int numUnits = eventInfo.unitIds.length;
            for (int i = 0; i != numUnits; ++i) {
                if (this.handleSCLRequest(eventInfo.unitIds[i])) continue;
                result = EventResult.ERROR;
                break;
            }
            if (numUnits != 0 && EventHandlerUtil.isTestEvent(event) && this.unitFacade.isSCLUpdateNecessary(eventInfo.unitIds[0])) {
                EventPayload payload = this.unitFacade.startSCLUpdate(eventInfo.unitIds[0]);
                eventResponse.addPayload(payload);
            }
        }
        return result;
    }

    protected boolean handleSCLRequest(long unitId) {
        log.trace((Object)"handleSCLRequest()");
        try {
            this.unitFacade.updateSCLForUnit(unitId, true, "scl_update");
            this.unitUserFacade.updateUnitModel(unitId, true);
        }
        catch (UnitNotFoundException ex) {
            log.error((Object)"handleSCLRequest() runs into", (Throwable)ex);
        }
        catch (Exception ex) {
            log.error((Object)"handleSCLRequest() runs into", (Throwable)ex);
        }
        return true;
    }

    @Override
    public void initialize() {
        try {
            InitialContext context = new InitialContext();
            this.unitUserFacade = (UnitUserLocal)context.lookup("rts/UnitUser/local");
            this.unitFacade = (UnitFacadeLocal)context.lookup("rts/UnitFacade/local");
        }
        catch (Exception e) {
            log.error((Object)"SCLEventHandler() runs into", (Throwable)e);
            throw new EJBException("EJB reference problem", e);
        }
    }
}

