/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.event.handlers;

import de.proveo.eventbase.EventResponse;
import de.proveo.rts.configuration.monitor.MonitoringMBean;
import de.proveo.util.events.NotifyEvent;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.util.service.ServiceFactory;
import de.proveo.util.string.StringUtil;
import de.proveo.wwt.datamodel.area.Area;
import de.proveo.wwt.datamodel.notification.Notification;
import de.proveo.wwt.datamodel.notify.NotifyHistory;
import de.proveo.wwt.datamodel.use.user.UseUser;
import de.proveo.wwt.logic.ejb.dataIn.event.EventInfo;
import de.proveo.wwt.logic.ejb.dataIn.event.EventResult;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.IEventHandler;
import de.proveo.wwt.logic.ejb.dataIn.event.history.EventPersisterFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.event.history.EventPersisterResult;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser.UseUserAdminFacadeLocal;
import de.proveo.wwt.logic.ejb.general.area.AreaInFacadeLocal;
import de.proveo.wwt.logic.ejb.general.notification.NotificationAdministrationFacadeLocal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;
import javax.ejb.EJBException;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NotifyEventHandler
implements IEventHandler {
    private static final Log log = LogFactory.getLog(NotifyEventHandler.class);
    private MonitoringMBean notifyEventCounter;
    private EventPersisterFacadeLocal eventPersisterFacade = null;
    private AreaInFacadeLocal areaInFacade;
    private NotificationAdministrationFacadeLocal notificationFacade;
    private UseUserAdminFacadeLocal useUserAdminFacade;

    @Override
    public EventResult handleEvent(Properties event, EventResponse eventResponse, EventInfo eventInfo, ArrayList<SerializableEventWrapper> eventWrappers) {
        EventResult result = EventResult.SUCCESS;
        if (event.containsKey("nm")) {
            int numUnits = eventInfo.unitIds.length;
            for (int i = 0; i != numUnits; ++i) {
                this.handleNotifyEvent(event, eventInfo, eventInfo.unitIds[i], eventWrappers);
            }
        }
        return result;
    }

    private void handleNotifyEvent(Properties event, EventInfo eventInfo, long unitId, ArrayList<SerializableEventWrapper> eventWrappers) {
        log.debug((Object)"handleNotifyEvent() new event of type 'notify'");
        this.notifyEventCounter.increment();
        NotifyHistory notifyHistory = new NotifyHistory();
        notifyHistory.setMessageId(Long.parseLong(event.getProperty("nm")));
        notifyHistory.setEntry(Integer.parseInt(event.getProperty("ne")) == 1);
        notifyHistory.setCreateTime(Long.parseLong(event.getProperty("t")));
        notifyHistory.setReceiveTime(eventInfo.receiveTime);
        notifyHistory.setUnitId(unitId);
        notifyHistory.setGdataHistoryId(eventInfo.gdataHistoryId);
        this.parseUseUser(event, notifyHistory);
        Integer areaId = this.getAreaId(event, eventInfo.areaId);
        notifyHistory.setAreaId(areaId);
        this.persistEvent(notifyHistory, eventWrappers);
    }

    private void persistEvent(NotifyHistory notifyHistory, ArrayList<SerializableEventWrapper> eventWrappers) {
        EventPersisterResult result = this.eventPersisterFacade.persist(notifyHistory);
        if (result != null) {
            Notification notification = this.notificationFacade.getNotificationById((int)notifyHistory.getMessageId());
            String message = notification != null ? notification.getDefaultName() : "";
            NotifyEvent notifyEvent = new NotifyEvent(notifyHistory.getUnitId(), notifyHistory.getMessageId(), message, notifyHistory.getEntry(), notifyHistory.getCreateTime(), notifyHistory.getReceiveTime());
            SerializableEventWrapper wrapper = new SerializableEventWrapper((Serializable)notifyEvent, (Serializable)((Object)notifyHistory));
            wrapper.set_notifyHistoryId(notifyHistory.getId());
            wrapper.set_typeOfEvent("InfomanNotifyMessages");
            eventWrappers.add(wrapper);
        }
    }

    private void parseUseUser(Properties event, NotifyHistory notifyHistory) {
        String userKey = event.getProperty("nuu");
        if (userKey != null) {
            notifyHistory.setRemark(StringUtil.escapeNonLatin1Characters((String)userKey));
            UseUser user = this.useUserAdminFacade.getUseUserByKey(userKey);
            if (user != null) {
                notifyHistory.setUseUserId(user.getId());
            }
        }
    }

    private Integer getAreaId(Properties event, Integer areaId) {
        String areaValue = event.getProperty("areaId");
        if (areaValue != null) {
            try {
                areaId = Integer.parseInt(areaValue);
            }
            catch (Exception e) {
                log.error((Object)"Runs into", (Throwable)e);
            }
        }
        Integer areaID = null;
        Area area = null;
        if (areaId != null) {
            if (areaId != 0) {
                areaID = areaId;
            }
            if (areaId == 0 && event.getProperty("area") != null) {
                try {
                    area = this.areaInFacade.findByName(event.getProperty("area"));
                    if (area != null) {
                        areaID = area.getAreaId();
                    }
                }
                catch (Exception ex) {
                    log.error((Object)"runs during guess area into", (Throwable)ex);
                }
            } else if (areaId != 0) {
                try {
                    area = this.areaInFacade.getAreaValue(areaId);
                    if (area != null) {
                        areaID = area.getAreaId();
                    }
                }
                catch (Exception ex) {
                    throw new EJBException(ex);
                }
            }
        }
        return areaID;
    }

    @Override
    public void initialize() {
        try {
            this.notifyEventCounter = (MonitoringMBean)ServiceFactory.getInstance().getService(MonitoringMBean.class, "NotifyEvents");
            InitialContext context = new InitialContext();
            this.eventPersisterFacade = (EventPersisterFacadeLocal)context.lookup("rts/EventPersisterFacade/local");
            this.areaInFacade = (AreaInFacadeLocal)context.lookup("rts/AreaInFacade/local");
            this.notificationFacade = (NotificationAdministrationFacadeLocal)context.lookup("rts/NotificationAdministrationFacade/local");
            this.useUserAdminFacade = (UseUserAdminFacadeLocal)context.lookup("rts/UseUserAdminFacade/local");
        }
        catch (Exception e) {
            log.error((Object)"NotifyEventHandler() runs into", (Throwable)e);
            throw new EJBException("EJB reference problem", e);
        }
    }
}

